/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.utils;

import com.intellij.docker.utils.LoggedInputStream;
import com.intellij.docker.utils.LoggedOutputStream;
import com.intellij.openapi.diagnostic.Logger;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.text.HexExtensionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 $2\u00020\u0001:\u0001$B1\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001dH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020 H\u0016J\b\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0011\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0017\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0011\u001a\u0004\b\u0018\u0010\u0015\u00a8\u0006%"}, d2={"Lcom/intellij/docker/utils/LoggedProcess;", "Ljava/lang/Process;", "originalProcess", "commandLine", "", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "logPrefix", "<init>", "(Ljava/lang/Process;Ljava/util/List;Lcom/intellij/openapi/diagnostic/Logger;Ljava/lang/String;)V", "processId", "_outputStream", "Lcom/intellij/docker/utils/LoggedOutputStream;", "get_outputStream", "()Lcom/intellij/docker/utils/LoggedOutputStream;", "_outputStream$delegate", "Lkotlin/Lazy;", "_inputStream", "Lcom/intellij/docker/utils/LoggedInputStream;", "get_inputStream", "()Lcom/intellij/docker/utils/LoggedInputStream;", "_inputStream$delegate", "_errorStream", "get_errorStream", "_errorStream$delegate", "getOutputStream", "Ljava/io/OutputStream;", "getInputStream", "Ljava/io/InputStream;", "getErrorStream", "waitFor", "", "exitValue", "destroy", "", "Companion", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nLoggedProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoggedProcess.kt\ncom/intellij/docker/utils/LoggedProcess\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,179:1\n69#2,4:180\n15#2:184\n*S KotlinDebug\n*F\n+ 1 LoggedProcess.kt\ncom/intellij/docker/utils/LoggedProcess\n*L\n31#1:180,4\n47#1:184\n*E\n"})
public final class LoggedProcess
extends Process {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Process originalProcess;
    @NotNull
    private final List<String> commandLine;
    @NotNull
    private final Logger logger;
    @NotNull
    private final String processId;
    @NotNull
    private final Lazy _outputStream$delegate;
    @NotNull
    private final Lazy _inputStream$delegate;
    @NotNull
    private final Lazy _errorStream$delegate;
    @NotNull
    private static final Logger LOG;

    public LoggedProcess(@NotNull Process originalProcess, @NotNull List<String> commandLine, @NotNull Logger logger, @NotNull String logPrefix) {
        Intrinsics.checkNotNullParameter((Object)originalProcess, (String)"originalProcess");
        Intrinsics.checkNotNullParameter(commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)logPrefix, (String)"logPrefix");
        this.originalProcess = originalProcess;
        this.commandLine = commandLine;
        this.logger = logger;
        this.processId = logPrefix + "-" + LoggedProcess.Companion.generateShortHash();
        this._outputStream$delegate = LazyKt.lazy(() -> LoggedProcess._outputStream_delegate$lambda$0(this));
        this._inputStream$delegate = LazyKt.lazy(() -> LoggedProcess._inputStream_delegate$lambda$1(this));
        this._errorStream$delegate = LazyKt.lazy(() -> LoggedProcess._errorStream_delegate$lambda$2(this));
        Logger $this$trace$iv = this.logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger2 = $this$trace$iv;
            boolean bl = false;
            logger2.trace("[" + this.processId + "] Starting logging process: " + this.commandLine);
        }
    }

    public /* synthetic */ LoggedProcess(Process process2, List list2, Logger logger, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            logger = LOG;
        }
        if ((n & 8) != 0) {
            String string2 = (String)CollectionsKt.firstOrNull((List)list2);
            if (string2 == null) {
                string2 = "process";
            }
            string = string2;
        }
        this(process2, list2, logger, string);
    }

    private final LoggedOutputStream get_outputStream() {
        Lazy lazy = this._outputStream$delegate;
        return (LoggedOutputStream)lazy.getValue();
    }

    private final LoggedInputStream get_inputStream() {
        Lazy lazy = this._inputStream$delegate;
        return (LoggedInputStream)lazy.getValue();
    }

    private final LoggedInputStream get_errorStream() {
        Lazy lazy = this._errorStream$delegate;
        return (LoggedInputStream)lazy.getValue();
    }

    @Override
    @NotNull
    public OutputStream getOutputStream() {
        return this.get_outputStream();
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        return this.get_inputStream();
    }

    @Override
    @NotNull
    public InputStream getErrorStream() {
        return this.get_errorStream();
    }

    @Override
    public int waitFor() {
        return this.originalProcess.waitFor();
    }

    @Override
    public int exitValue() {
        return this.originalProcess.exitValue();
    }

    @Override
    public void destroy() {
        this.originalProcess.destroy();
    }

    private static final LoggedOutputStream _outputStream_delegate$lambda$0(LoggedProcess this$0) {
        OutputStream outputStream = this$0.originalProcess.getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
        return new LoggedOutputStream(outputStream, this$0.processId, this$0.logger);
    }

    private static final LoggedInputStream _inputStream_delegate$lambda$1(LoggedProcess this$0) {
        InputStream inputStream = this$0.originalProcess.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        return new LoggedInputStream(inputStream, this$0.processId, "STDOUT", this$0.logger);
    }

    private static final LoggedInputStream _errorStream_delegate$lambda$2(LoggedProcess this$0) {
        InputStream inputStream = this$0.originalProcess.getErrorStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getErrorStream(...)");
        return new LoggedInputStream(inputStream, this$0.processId, "STDERR", this$0.logger);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LoggedProcess.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/docker/utils/LoggedProcess$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "generateShortHash", "", "intellij.clouds.docker"})
    public static final class Companion {
        private Companion() {
        }

        private final String generateShortHash() {
            return HexExtensionsKt.toHexString$default((int)Random.Default.nextInt(), null, (int)1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

