/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.colorspace;

import androidx.annotation.Size;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.colorspace.Adaptation;
import androidx.compose.ui.graphics.colorspace.ColorModel;
import androidx.compose.ui.graphics.colorspace.ColorSpace;
import androidx.compose.ui.graphics.colorspace.ColorSpaceKt;
import androidx.compose.ui.graphics.colorspace.Illuminant;
import androidx.compose.ui.graphics.colorspace.RenderIntent;
import androidx.compose.ui.graphics.colorspace.Rgb;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB\u001f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B9\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015H\u0007J\u0012\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u0018\u001a\u00020\fH\u0017J\u001a\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0010\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\n\u001a\u00020\u0006\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006 "}, d2={"Landroidx/compose/ui/graphics/colorspace/Connector;", "", "source", "Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "destination", "intent", "Landroidx/compose/ui/graphics/colorspace/RenderIntent;", "(Landroidx/compose/ui/graphics/colorspace/ColorSpace;Landroidx/compose/ui/graphics/colorspace/ColorSpace;ILkotlin/jvm/internal/DefaultConstructorMarker;)V", "transformSource", "transformDestination", "renderIntent", "transform", "", "(Landroidx/compose/ui/graphics/colorspace/ColorSpace;Landroidx/compose/ui/graphics/colorspace/ColorSpace;Landroidx/compose/ui/graphics/colorspace/ColorSpace;Landroidx/compose/ui/graphics/colorspace/ColorSpace;I[FLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getDestination", "()Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "getRenderIntent-uksYyKA", "()I", "I", "getSource", "r", "", "g", "b", "v", "transformToColor", "Landroidx/compose/ui/graphics/Color;", "color", "transformToColor-l2rxGTc$ui_graphics", "(J)J", "Companion", "RgbConnector", "ui-graphics"})
@SourceDebugExtension(value={"SMAP\nConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Connector.kt\nandroidx/compose/ui/graphics/colorspace/Connector\n+ 2 Color.kt\nandroidx/compose/ui/graphics/Color\n+ 3 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 4 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n*L\n1#1,328:1\n219#2:329\n221#2,5:330\n60#3:335\n70#3:337\n22#4:336\n22#4:338\n*S KotlinDebug\n*F\n+ 1 Connector.kt\nandroidx/compose/ui/graphics/colorspace/Connector\n*L\n-1#1:329\n147#1:330,5\n149#1:335\n150#1:337\n149#1:336\n150#1:338\n*E\n"})
public class Connector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ColorSpace source;
    @NotNull
    private final ColorSpace destination;
    @NotNull
    private final ColorSpace transformSource;
    @NotNull
    private final ColorSpace transformDestination;
    private final int renderIntent;
    @Nullable
    private final float[] transform;

    private Connector(ColorSpace source, ColorSpace destination, ColorSpace transformSource, ColorSpace transformDestination, int renderIntent, float[] transform2) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)transformSource, (String)"transformSource");
        Intrinsics.checkNotNullParameter((Object)transformDestination, (String)"transformDestination");
        this.source = source;
        this.destination = destination;
        this.transformSource = transformSource;
        this.transformDestination = transformDestination;
        this.renderIntent = renderIntent;
        this.transform = transform2;
    }

    @NotNull
    public final ColorSpace getSource() {
        return this.source;
    }

    @NotNull
    public final ColorSpace getDestination() {
        return this.destination;
    }

    public final int getRenderIntent-uksYyKA() {
        return this.renderIntent;
    }

    private Connector(ColorSpace source, ColorSpace destination, int intent) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        this(source, destination, ColorModel.equals-impl0(source.getModel-xdoWZVw(), ColorModel.Companion.getRgb-xdoWZVw()) ? ColorSpaceKt.adapt$default(source, Illuminant.INSTANCE.getD50(), null, 2, null) : source, ColorModel.equals-impl0(destination.getModel-xdoWZVw(), ColorModel.Companion.getRgb-xdoWZVw()) ? ColorSpaceKt.adapt$default(destination, Illuminant.INSTANCE.getD50(), null, 2, null) : destination, intent, Connector.Companion.computeTransform-YBCOT_4(source, destination, intent), null);
    }

    @Size(value=3L)
    @NotNull
    public final float[] transform(float r, float g, float b) {
        float[] fArray = new float[]{r, g, b};
        return this.transform(fArray);
    }

    @Size(min=3L)
    @NotNull
    public float[] transform(@Size(min=3L) @NotNull float[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        float[] xyz = this.transformSource.toXyz(v);
        if (this.transform != null) {
            xyz[0] = xyz[0] * this.transform[0];
            xyz[1] = xyz[1] * this.transform[1];
            xyz[2] = xyz[2] * this.transform[2];
        }
        return this.transformDestination.fromXyz(xyz);
    }

    public long transformToColor-l2rxGTc$ui_graphics(long color) {
        boolean bl = false;
        float r = Color.getRed-impl(color);
        boolean bl2 = false;
        float g = Color.getGreen-impl(color);
        boolean bl3 = false;
        float b = Color.getBlue-impl(color);
        boolean bl4 = false;
        float a = Color.getAlpha-impl(color);
        long packed = this.transformSource.toXy$ui_graphics(r, g, b);
        boolean $i$f$unpackFloat1 = false;
        int bits$iv$iv = (int)(packed >> 32);
        boolean $i$f$floatFromBits = false;
        float x = Float.intBitsToFloat(bits$iv$iv);
        boolean $i$f$unpackFloat2 = false;
        int bits$iv$iv2 = (int)(packed & 0xFFFFFFFFL);
        boolean $i$f$floatFromBits2 = false;
        float y = Float.intBitsToFloat(bits$iv$iv2);
        float z = this.transformSource.toZ$ui_graphics(r, g, b);
        if (this.transform != null) {
            x *= this.transform[0];
            y *= this.transform[1];
            z *= this.transform[2];
        }
        return this.transformDestination.xyzaToColor-JlNiLsg$ui_graphics(x, y, z, a, this.destination);
    }

    public /* synthetic */ Connector(ColorSpace source, ColorSpace destination, ColorSpace transformSource, ColorSpace transformDestination, int renderIntent, float[] transform2, DefaultConstructorMarker $constructor_marker) {
        this(source, destination, transformSource, transformDestination, renderIntent, transform2);
    }

    public /* synthetic */ Connector(ColorSpace source, ColorSpace destination, int intent, DefaultConstructorMarker $constructor_marker) {
        this(source, destination, intent);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u000e\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u000f"}, d2={"Landroidx/compose/ui/graphics/colorspace/Connector$Companion;", "", "()V", "computeTransform", "", "source", "Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "destination", "intent", "Landroidx/compose/ui/graphics/colorspace/RenderIntent;", "computeTransform-YBCOT_4", "(Landroidx/compose/ui/graphics/colorspace/ColorSpace;Landroidx/compose/ui/graphics/colorspace/ColorSpace;I)[F", "identity", "Landroidx/compose/ui/graphics/colorspace/Connector;", "identity$ui_graphics", "ui-graphics"})
    public static final class Companion {
        private Companion() {
        }

        private final float[] computeTransform-YBCOT_4(ColorSpace source, ColorSpace destination, int intent) {
            if (!RenderIntent.equals-impl0(intent, RenderIntent.Companion.getAbsolute-uksYyKA())) {
                return null;
            }
            boolean srcRGB = ColorModel.equals-impl0(source.getModel-xdoWZVw(), ColorModel.Companion.getRgb-xdoWZVw());
            boolean dstRGB = ColorModel.equals-impl0(destination.getModel-xdoWZVw(), ColorModel.Companion.getRgb-xdoWZVw());
            if (srcRGB && dstRGB) {
                return null;
            }
            if (srcRGB || dstRGB) {
                ColorSpace colorSpace = srcRGB ? source : destination;
                Intrinsics.checkNotNull((Object)colorSpace, (String)"null cannot be cast to non-null type androidx.compose.ui.graphics.colorspace.Rgb");
                Rgb rgb = (Rgb)colorSpace;
                float[] srcXYZ = srcRGB ? rgb.getWhitePoint().toXyz$ui_graphics() : Illuminant.INSTANCE.getD50Xyz$ui_graphics();
                float[] dstXYZ = dstRGB ? rgb.getWhitePoint().toXyz$ui_graphics() : Illuminant.INSTANCE.getD50Xyz$ui_graphics();
                float[] fArray = new float[]{srcXYZ[0] / dstXYZ[0], srcXYZ[1] / dstXYZ[1], srcXYZ[2] / dstXYZ[2]};
                return fArray;
            }
            return null;
        }

        @NotNull
        public final Connector identity$ui_graphics(@NotNull ColorSpace source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            int n = RenderIntent.Companion.getRelative-uksYyKA();
            return new Connector(source, n){

                public float[] transform(float[] v) {
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                    return v;
                }

                public long transformToColor-l2rxGTc$ui_graphics(long color) {
                    return color;
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J*\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0010\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0016"}, d2={"Landroidx/compose/ui/graphics/colorspace/Connector$RgbConnector;", "Landroidx/compose/ui/graphics/colorspace/Connector;", "mSource", "Landroidx/compose/ui/graphics/colorspace/Rgb;", "mDestination", "intent", "Landroidx/compose/ui/graphics/colorspace/RenderIntent;", "(Landroidx/compose/ui/graphics/colorspace/Rgb;Landroidx/compose/ui/graphics/colorspace/Rgb;ILkotlin/jvm/internal/DefaultConstructorMarker;)V", "mTransform", "", "computeTransform", "source", "destination", "computeTransform-YBCOT_4", "(Landroidx/compose/ui/graphics/colorspace/Rgb;Landroidx/compose/ui/graphics/colorspace/Rgb;I)[F", "transform", "v", "transformToColor", "Landroidx/compose/ui/graphics/Color;", "color", "transformToColor-l2rxGTc$ui_graphics", "(J)J", "ui-graphics"})
    @SourceDebugExtension(value={"SMAP\nConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Connector.kt\nandroidx/compose/ui/graphics/colorspace/Connector$RgbConnector\n+ 2 Color.kt\nandroidx/compose/ui/graphics/Color\n+ 3 ColorSpace.kt\nandroidx/compose/ui/graphics/colorspace/ColorSpaceKt\n*L\n1#1,328:1\n219#2:329\n221#2,5:330\n638#3:335\n653#3:336\n668#3:337\n*S KotlinDebug\n*F\n+ 1 Connector.kt\nandroidx/compose/ui/graphics/colorspace/Connector$RgbConnector\n*L\n-1#1:329\n185#1:330,5\n189#1:335\n190#1:336\n191#1:337\n*E\n"})
    public static final class RgbConnector
    extends Connector {
        @NotNull
        private final Rgb mSource;
        @NotNull
        private final Rgb mDestination;
        @NotNull
        private final float[] mTransform;

        private RgbConnector(Rgb mSource, Rgb mDestination, int intent) {
            Intrinsics.checkNotNullParameter((Object)mSource, (String)"mSource");
            Intrinsics.checkNotNullParameter((Object)mDestination, (String)"mDestination");
            super(mSource, mDestination, mSource, mDestination, intent, null, null);
            this.mSource = mSource;
            this.mDestination = mDestination;
            this.mTransform = this.computeTransform-YBCOT_4(this.mSource, this.mDestination, intent);
        }

        @Override
        @NotNull
        public float[] transform(@NotNull float[] v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            v[0] = (float)this.mSource.getEotfFunc$ui_graphics().invoke(v[0]);
            v[1] = (float)this.mSource.getEotfFunc$ui_graphics().invoke(v[1]);
            v[2] = (float)this.mSource.getEotfFunc$ui_graphics().invoke(v[2]);
            ColorSpaceKt.mul3x3Float3(this.mTransform, v);
            v[0] = (float)this.mDestination.getOetfFunc$ui_graphics().invoke(v[0]);
            v[1] = (float)this.mDestination.getOetfFunc$ui_graphics().invoke(v[1]);
            v[2] = (float)this.mDestination.getOetfFunc$ui_graphics().invoke(v[2]);
            return v;
        }

        @Override
        public long transformToColor-l2rxGTc$ui_graphics(long color) {
            boolean bl = false;
            float r = Color.getRed-impl(color);
            boolean bl2 = false;
            float g = Color.getGreen-impl(color);
            boolean bl3 = false;
            float b = Color.getBlue-impl(color);
            boolean bl4 = false;
            float a = Color.getAlpha-impl(color);
            float v0 = (float)this.mSource.getEotfFunc$ui_graphics().invoke(r);
            float v1 = (float)this.mSource.getEotfFunc$ui_graphics().invoke(g);
            float v2 = (float)this.mSource.getEotfFunc$ui_graphics().invoke(b);
            float[] lhs$iv = this.mTransform;
            boolean $i$f$mul3x3Float3_0 = false;
            float v01 = lhs$iv[0] * v0 + lhs$iv[3] * v1 + lhs$iv[6] * v2;
            float[] lhs$iv2 = this.mTransform;
            boolean $i$f$mul3x3Float3_1 = false;
            float v11 = lhs$iv2[1] * v0 + lhs$iv2[4] * v1 + lhs$iv2[7] * v2;
            float[] lhs$iv3 = this.mTransform;
            boolean $i$f$mul3x3Float3_2 = false;
            float v21 = lhs$iv3[2] * v0 + lhs$iv3[5] * v1 + lhs$iv3[8] * v2;
            float v02 = (float)this.mDestination.getOetfFunc$ui_graphics().invoke(v01);
            float v12 = (float)this.mDestination.getOetfFunc$ui_graphics().invoke(v11);
            float v22 = (float)this.mDestination.getOetfFunc$ui_graphics().invoke(v21);
            return ColorKt.Color(v02, v12, v22, a, this.mDestination);
        }

        private final float[] computeTransform-YBCOT_4(Rgb source, Rgb destination, int intent) {
            if (ColorSpaceKt.compare(source.getWhitePoint(), destination.getWhitePoint())) {
                return ColorSpaceKt.mul3x3(destination.getInverseTransform$ui_graphics(), source.getTransform$ui_graphics());
            }
            float[] transform2 = source.getTransform$ui_graphics();
            float[] inverseTransform = destination.getInverseTransform$ui_graphics();
            float[] srcXYZ = source.getWhitePoint().toXyz$ui_graphics();
            float[] dstXYZ = destination.getWhitePoint().toXyz$ui_graphics();
            if (!ColorSpaceKt.compare(source.getWhitePoint(), Illuminant.INSTANCE.getD50())) {
                float[] srcAdaptation = ColorSpaceKt.chromaticAdaptation(Adaptation.Companion.getBradford().getTransform$ui_graphics(), srcXYZ, Illuminant.INSTANCE.newD50Xyz$ui_graphics());
                transform2 = ColorSpaceKt.mul3x3(srcAdaptation, source.getTransform$ui_graphics());
            }
            if (!ColorSpaceKt.compare(destination.getWhitePoint(), Illuminant.INSTANCE.getD50())) {
                float[] dstAdaptation = ColorSpaceKt.chromaticAdaptation(Adaptation.Companion.getBradford().getTransform$ui_graphics(), dstXYZ, Illuminant.INSTANCE.newD50Xyz$ui_graphics());
                inverseTransform = ColorSpaceKt.inverse3x3(ColorSpaceKt.mul3x3(dstAdaptation, destination.getTransform$ui_graphics()));
            }
            if (RenderIntent.equals-impl0(intent, RenderIntent.Companion.getAbsolute-uksYyKA())) {
                float[] fArray = new float[]{srcXYZ[0] / dstXYZ[0], srcXYZ[1] / dstXYZ[1], srcXYZ[2] / dstXYZ[2]};
                transform2 = ColorSpaceKt.mul3x3Diag(fArray, transform2);
            }
            return ColorSpaceKt.mul3x3(inverseTransform, transform2);
        }

        public /* synthetic */ RgbConnector(Rgb mSource, Rgb mDestination, int intent, DefaultConstructorMarker $constructor_marker) {
            this(mSource, mDestination, intent);
        }
    }
}

