/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.bridge;

import java.awt.RenderingHints;
import org.jetbrains.relocated.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.jetbrains.relocated.apache.batik.bridge.BridgeContext;
import org.jetbrains.relocated.apache.batik.bridge.CSSUtilities;
import org.jetbrains.relocated.apache.batik.bridge.PaintServer;
import org.jetbrains.relocated.apache.batik.css.engine.CSSEngineEvent;
import org.jetbrains.relocated.apache.batik.gvt.GraphicsNode;
import org.jetbrains.relocated.apache.batik.gvt.ShapeNode;
import org.jetbrains.relocated.apache.batik.gvt.ShapePainter;
import org.w3c.dom.Element;

public abstract class SVGShapeElementBridge
extends AbstractGraphicsNodeBridge {
    protected boolean hasNewShapePainter;

    protected SVGShapeElementBridge() {
    }

    @Override
    public GraphicsNode createGraphicsNode(BridgeContext ctx2, Element e) {
        ShapeNode shapeNode = (ShapeNode)super.createGraphicsNode(ctx2, e);
        if (shapeNode == null) {
            return null;
        }
        this.associateSVGContext(ctx2, e, shapeNode);
        this.buildShape(ctx2, e, shapeNode);
        RenderingHints hints = null;
        hints = CSSUtilities.convertColorRendering(e, hints);
        hints = CSSUtilities.convertShapeRendering(e, hints);
        if (hints != null) {
            shapeNode.setRenderingHints(hints);
        }
        return shapeNode;
    }

    @Override
    protected GraphicsNode instantiateGraphicsNode() {
        return new ShapeNode();
    }

    @Override
    public void buildGraphicsNode(BridgeContext ctx2, Element e, GraphicsNode node) {
        ShapeNode shapeNode = (ShapeNode)node;
        shapeNode.setShapePainter(this.createShapePainter(ctx2, e, shapeNode));
        super.buildGraphicsNode(ctx2, e, node);
    }

    protected ShapePainter createShapePainter(BridgeContext ctx2, Element e, ShapeNode shapeNode) {
        return PaintServer.convertFillAndStroke(e, shapeNode, ctx2);
    }

    protected abstract void buildShape(BridgeContext var1, Element var2, ShapeNode var3);

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    protected void handleGeometryChanged() {
        super.handleGeometryChanged();
        ShapeNode shapeNode = (ShapeNode)this.node;
        shapeNode.setShapePainter(this.createShapePainter(this.ctx, this.e, shapeNode));
    }

    @Override
    public void handleCSSEngineEvent(CSSEngineEvent evt) {
        this.hasNewShapePainter = false;
        super.handleCSSEngineEvent(evt);
    }

    @Override
    protected void handleCSSPropertyChanged(int property2) {
        switch (property2) {
            case 15: 
            case 16: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                if (this.hasNewShapePainter) break;
                this.hasNewShapePainter = true;
                ShapeNode shapeNode = (ShapeNode)this.node;
                shapeNode.setShapePainter(this.createShapePainter(this.ctx, this.e, shapeNode));
                break;
            }
            case 42: {
                RenderingHints hints = this.node.getRenderingHints();
                hints = CSSUtilities.convertShapeRendering(this.e, hints);
                if (hints == null) break;
                this.node.setRenderingHints(hints);
                break;
            }
            case 9: {
                RenderingHints hints = this.node.getRenderingHints();
                hints = CSSUtilities.convertColorRendering(this.e, hints);
                if (hints == null) break;
                this.node.setRenderingHints(hints);
                break;
            }
            default: {
                super.handleCSSPropertyChanged(property2);
            }
        }
    }
}

