/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.temporal.CalendarMethodsRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class TemporalUnbalanceDateDurationRelativeNode
extends JavaScriptBaseNode {
    @Node.Child
    private JSFunctionCallNode callDateAddNode;
    @Node.Child
    private JSFunctionCallNode callDateUntilNode;

    protected TemporalUnbalanceDateDurationRelativeNode() {
    }

    public abstract JSTemporalDurationRecord execute(double var1, double var3, double var5, double var7, TemporalUtil.Unit var9, JSTemporalPlainDateObject var10, CalendarMethodsRecord var11);

    @Specialization
    protected JSTemporalDurationRecord unbalanceDurationRelative(double years, double months, double weeks, double days, TemporalUtil.Unit largestUnit, JSTemporalPlainDateObject plainRelativeTo, CalendarMethodsRecord calendarRec, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile unitIsYear, @Cached InlinedConditionProfile unitIsWeek, @Cached InlinedConditionProfile unitIsMonth) {
        assert (plainRelativeTo == null || calendarRec != null);
        if (unitIsYear.profile(this, TemporalUtil.Unit.YEAR == largestUnit)) {
            return JSTemporalDurationRecord.createWeeks(years, months, weeks, days, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        JSContext ctx = this.getLanguage().getJSContext();
        JSRealm realm = this.getRealm();
        if (unitIsMonth.profile(this, TemporalUtil.Unit.MONTH == largestUnit)) {
            return this.unitIsMonth(ctx, realm, years, months, weeks, days, plainRelativeTo, calendarRec, this, errorBranch);
        }
        if (unitIsWeek.profile(this, TemporalUtil.Unit.WEEK == largestUnit)) {
            return this.unitIsWeek(ctx, realm, years, months, weeks, days, plainRelativeTo, calendarRec, this, errorBranch);
        }
        return this.unitIsDay(ctx, realm, years, months, weeks, days, plainRelativeTo, calendarRec, this, errorBranch);
    }

    private JSTemporalDurationRecord unitIsDay(JSContext ctx, JSRealm realm, double years, double months, double weeks, double days, JSTemporalPlainDateObject plainRelativeTo, CalendarMethodsRecord calendarRec, Node node, InlinedBranchProfile errorBranch) {
        if (years == 0.0 && months == 0.0 && weeks == 0.0) {
            return JSTemporalDurationRecord.createWeeks(0.0, 0.0, 0.0, days, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        TemporalUnbalanceDateDurationRelativeNode.checkCalendar(calendarRec, this, errorBranch);
        assert (calendarRec.dateAdd() != null);
        JSTemporalDurationObject yearsMonthsWeeksDuration = JSTemporalDuration.createTemporalDuration(ctx, realm, years, months, weeks, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, this, errorBranch);
        JSTemporalPlainDateObject later = this.calendarDateAdd(calendarRec, plainRelativeTo, yearsMonthsWeeksDuration, node, errorBranch);
        double yearsMonthsWeeksInDays = TemporalUtil.daysUntil(plainRelativeTo, later);
        return JSTemporalDurationRecord.createWeeks(0.0, 0.0, 0.0, days + yearsMonthsWeeksInDays, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    private JSTemporalDurationRecord unitIsWeek(JSContext ctx, JSRealm realm, double years, double months, double weeks, double days, JSTemporalPlainDateObject plainRelativeTo, CalendarMethodsRecord calendarRec, Node node, InlinedBranchProfile errorBranch) {
        if (years == 0.0 && months == 0.0) {
            return JSTemporalDurationRecord.createWeeks(0.0, 0.0, weeks, days, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        TemporalUnbalanceDateDurationRelativeNode.checkCalendar(calendarRec, this, errorBranch);
        assert (calendarRec.dateAdd() != null);
        JSTemporalDurationObject yearsMonthsDuration = JSTemporalDuration.createTemporalDuration(ctx, realm, years, months, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, this, errorBranch);
        JSTemporalPlainDateObject later = this.calendarDateAdd(calendarRec, plainRelativeTo, yearsMonthsDuration, node, errorBranch);
        double yearsMonthsInDays = TemporalUtil.daysUntil(plainRelativeTo, later);
        return JSTemporalDurationRecord.createWeeks(0.0, 0.0, weeks, days + yearsMonthsInDays, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    private JSTemporalDurationRecord unitIsMonth(JSContext ctx, JSRealm realm, double years, double months, double weeks, double days, JSTemporalPlainDateObject plainRelativeTo, CalendarMethodsRecord calendarRec, Node node, InlinedBranchProfile errorBranch) {
        if (years == 0.0) {
            return JSTemporalDurationRecord.createWeeks(0.0, months, weeks, days, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        TemporalUnbalanceDateDurationRelativeNode.checkCalendar(calendarRec, this, errorBranch);
        assert (calendarRec.dateAdd() != null && calendarRec.dateUntil() != null);
        JSTemporalDurationObject yearsDuration = JSTemporalDuration.createTemporalDuration(ctx, realm, years, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, this, errorBranch);
        JSTemporalPlainDateObject later = this.calendarDateAdd(calendarRec, plainRelativeTo, yearsDuration, node, errorBranch);
        JSObject untilOptions = JSOrdinary.createWithNullPrototype(ctx);
        JSObjectUtil.putDataProperty(untilOptions, TemporalConstants.LARGEST_UNIT, TemporalConstants.MONTH);
        JSTemporalDurationObject untilResult = this.calendarDateUntil(calendarRec, plainRelativeTo, later, untilOptions);
        double yearsInMonths = untilResult.getMonths();
        return JSTemporalDurationRecord.createWeeks(0.0, months + yearsInMonths, weeks, days, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    protected JSTemporalPlainDateObject calendarDateAdd(CalendarMethodsRecord calendarRec, JSDynamicObject date, JSDynamicObject duration, Node node, InlinedBranchProfile errorBranch) {
        if (this.callDateAddNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.callDateAddNode = this.insert(JSFunctionCallNode.createCall());
        }
        Object addedDate = this.callDateAddNode.executeCall(JSArguments.create(calendarRec.receiver(), calendarRec.dateAdd(), date, duration));
        return TemporalUtil.requireTemporalDate(addedDate, node, errorBranch);
    }

    protected JSTemporalDurationObject calendarDateUntil(CalendarMethodsRecord calendarRec, JSDynamicObject date, JSDynamicObject duration, JSDynamicObject options) {
        if (this.callDateUntilNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.callDateUntilNode = this.insert(JSFunctionCallNode.createCall());
        }
        Object addedDate = this.callDateUntilNode.executeCall(JSArguments.create(calendarRec.receiver(), calendarRec.dateUntil(), date, duration, options));
        return TemporalUtil.requireTemporalDuration(addedDate);
    }

    private static void checkCalendar(CalendarMethodsRecord calendarRec, Node node, InlinedBranchProfile errorBranch) {
        if (calendarRec == null) {
            errorBranch.enter(node);
            throw Errors.createRangeError("Calendar should not be undefined.");
        }
    }
}

