/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.CallSitePrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.GraalJSException;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSError;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSGlobal;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class CallSitePrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<CallSitePrototype> {
    public static final JSBuiltinsContainer BUILTINS = new CallSitePrototypeBuiltins();

    protected CallSitePrototypeBuiltins() {
        super(JSError.CALL_SITE_PROTOTYPE_NAME, CallSitePrototype.class);
    }

    @Override
    protected Object createNode(JSContext context2, JSBuiltin builtin, boolean construct, boolean newTarget, CallSitePrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 6: 
            case 7: 
            case 8: {
                return CallSitePrototypeBuiltinsFactory.CallSiteGetNumberNodeGen.create(context2, builtin, builtinEnum, CallSitePrototypeBuiltins.args().withThis().createArgumentNodes(context2));
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 18: {
                return CallSitePrototypeBuiltinsFactory.CallSiteGetNodeGen.create(context2, builtin, builtinEnum, CallSitePrototypeBuiltins.args().withThis().createArgumentNodes(context2));
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return CallSitePrototypeBuiltinsFactory.CallSiteGetBooleanNodeGen.create(context2, builtin, builtinEnum, CallSitePrototypeBuiltins.args().withThis().createArgumentNodes(context2));
            }
        }
        return null;
    }

    public static enum CallSitePrototype implements BuiltinEnum<CallSitePrototype>
    {
        getThis(0),
        getTypeName(0),
        getFunction(0),
        getFunctionName(0),
        getMethodName(0),
        getFileName(0),
        getLineNumber(0),
        getColumnNumber(0),
        getPosition(0),
        getEvalOrigin(0),
        getScriptNameOrSourceURL(0),
        getPromiseIndex(0),
        isToplevel(0),
        isEval(0),
        isNative(0),
        isConstructor(0),
        isAsync(0),
        isPromiseAll(0),
        toString(0);

        private final int length;

        private CallSitePrototype(int length2) {
            this.length = length2;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    static abstract class CallSiteGetNumberNode
    extends CallSiteOperation {
        private final CallSitePrototype method;

        CallSiteGetNumberNode(JSContext context2, JSBuiltin builtin, CallSitePrototype method) {
            super(context2, builtin);
            this.method = method;
        }

        @Specialization
        final int getNumber(JSObject thisObj) {
            GraalJSException.JSStackTraceElement stackTraceElement = this.getStackTraceElement(thisObj);
            switch (this.method.ordinal()) {
                case 6: {
                    return stackTraceElement.getLineNumber();
                }
                case 7: {
                    return stackTraceElement.getColumnNumber();
                }
                case 8: {
                    return stackTraceElement.getPosition();
                }
            }
            throw Errors.shouldNotReachHere();
        }
    }

    static abstract class CallSiteGetNode
    extends CallSiteOperation {
        private final CallSitePrototype method;

        CallSiteGetNode(JSContext context2, JSBuiltin builtin, CallSitePrototype method) {
            super(context2, builtin);
            this.method = method;
        }

        @Specialization
        final Object get(JSObject thisObj) {
            GraalJSException.JSStackTraceElement stackTraceElement = this.getStackTraceElement(thisObj);
            switch (this.method.ordinal()) {
                case 2: {
                    if (stackTraceElement.isStrict()) {
                        return Undefined.instance;
                    }
                    return JSRuntime.nullToUndefined(stackTraceElement.getFunction());
                }
                case 0: {
                    if (stackTraceElement.isStrict()) {
                        return Undefined.instance;
                    }
                    return JSRuntime.nullToUndefined(stackTraceElement.getThisOrGlobal());
                }
                case 18: {
                    return stackTraceElement.toString(this.getContext());
                }
                case 1: {
                    return JSRuntime.toJSNull(stackTraceElement.getTypeName());
                }
                case 3: {
                    TruffleString functionName = stackTraceElement.getFunctionName();
                    return Strings.isEmpty(functionName) ? Null.instance : functionName;
                }
                case 4: {
                    JSContext context2 = this.getContext();
                    TruffleString methodName = stackTraceElement.getMethodName(context2);
                    if (methodName == null || Strings.isEmpty(methodName) || methodName.equals(JSError.getAnonymousFunctionNameStackTrace(context2))) {
                        return Null.instance;
                    }
                    return methodName;
                }
                case 5: 
                case 10: {
                    TruffleString fileName = stackTraceElement.getFileName();
                    if (fileName != null && !Strings.startsWith(fileName, Strings.ANGLE_BRACKET_OPEN)) {
                        return fileName;
                    }
                    return Null.instance;
                }
                case 9: {
                    TruffleString evalOrigin = stackTraceElement.getEvalOrigin();
                    if (evalOrigin != null) {
                        return evalOrigin;
                    }
                    return Undefined.instance;
                }
                case 11: {
                    if (stackTraceElement.isPromiseAll()) {
                        return stackTraceElement.getPromiseIndex();
                    }
                    return Null.instance;
                }
            }
            throw Errors.shouldNotReachHere();
        }
    }

    static abstract class CallSiteGetBooleanNode
    extends CallSiteOperation {
        private final CallSitePrototype method;

        CallSiteGetBooleanNode(JSContext context2, JSBuiltin builtin, CallSitePrototype method) {
            super(context2, builtin);
            this.method = method;
        }

        @Specialization
        final boolean getBoolean(JSObject thisObj) {
            GraalJSException.JSStackTraceElement stackTraceElement = this.getStackTraceElement(thisObj);
            switch (this.method.ordinal()) {
                case 15: {
                    return stackTraceElement.isConstructor();
                }
                case 13: {
                    return stackTraceElement.isEval();
                }
                case 14: {
                    return JSFunction.isJSFunction(stackTraceElement.getFunction()) && JSFunction.isBuiltin((JSFunctionObject)stackTraceElement.getFunction());
                }
                case 12: {
                    return JSRuntime.isNullOrUndefined(stackTraceElement.getThis()) || JSGlobal.isJSGlobalObject(stackTraceElement.getThis()) || stackTraceElement.isEval();
                }
                case 16: {
                    return stackTraceElement.isAsync();
                }
                case 17: {
                    return stackTraceElement.isPromiseAll();
                }
            }
            throw Errors.shouldNotReachHere();
        }
    }

    protected static abstract class CallSiteOperation
    extends JSBuiltinNode {
        @Node.Child
        private PropertyGetNode getStackTraceElementNode;
        private final BranchProfile errorBranch = BranchProfile.create();

        protected CallSiteOperation(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
            this.getStackTraceElementNode = PropertyGetNode.createGetHidden(JSError.STACK_TRACE_ELEMENT_PROPERTY_NAME, context2);
        }

        protected final GraalJSException.JSStackTraceElement getStackTraceElement(JSObject thisObj) {
            Object element = this.getStackTraceElementNode.getValue(thisObj);
            if (!(element instanceof GraalJSException.JSStackTraceElement)) {
                this.errorBranch.enter();
                throw Errors.createTypeError("Expected CallSite as receiver");
            }
            return (GraalJSException.JSStackTraceElement)element;
        }

        @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
        @Fallback
        protected final Object incompatibleReceiver(Object thisObj) {
            throw Errors.createTypeErrorIncompatibleReceiver(this.getBuiltin().getFullName(), thisObj);
        }
    }
}

