/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\u001a\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\t\u001a\u0010\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\t\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\t\u001a\u0012\u0010\u000f\u001a\u0004\u0018\u00010\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\"\u0018\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "Ljava/util/logging/Logger;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "newObjNode", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "findJsonPathFirstKey", "", "path", "compileJsonPathSafely", "readTreeSafe", "Lcom/fasterxml/jackson/databind/JsonNode;", "value", "asJson", "obj", "", "intellij.httpClient.executor"})
public final class HttpClientJsonVariablesHelperKt {
    private static final Logger logger = Logger.getLogger("HttpClientJsonVariablesHelper.kt");
    @NotNull
    private static final ObjectMapper objectMapper = new ObjectMapper();

    @NotNull
    public static final ObjectNode newObjNode() {
        ObjectNode objectNode = objectMapper.createObjectNode();
        Intrinsics.checkNotNullExpressionValue((Object)objectNode, (String)"createObjectNode(...)");
        return objectNode;
    }

    @Nullable
    public static final String findJsonPathFirstKey(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = HttpClientJsonVariablesHelperKt.compileJsonPathSafely(path);
        if (string == null || (string = StringsKt.removePrefix((String)string, (CharSequence)"$")) == null) {
            return null;
        }
        Regex pathRegexp = new Regex("(?<segment>\\['[\\w-.]+'])");
        String compiledJsonPath = string;
        MatchResult matchResult = Regex.find$default((Regex)pathRegexp, (CharSequence)compiledJsonPath, (int)0, (int)2, null);
        if (matchResult == null || (matchResult = matchResult.getGroups()) == null || (matchResult = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult, (String)"segment")) == null) {
            return null;
        }
        MatchResult segment = matchResult;
        String segmentValue = segment.getValue();
        if (!StringsKt.startsWith$default((String)compiledJsonPath, (String)segmentValue, (boolean)false, (int)2, null)) {
            return null;
        }
        return StringsKt.removeSurrounding((String)segmentValue, (CharSequence)"['", (CharSequence)"']");
    }

    @Nullable
    public static final String compileJsonPathSafely(@NotNull String path) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            string = JsonPath.compile(path, new Predicate[0]).getPath();
        }
        catch (Exception e) {
            logger.fine("Failed to compile jsonPath: " + path);
            return null;
        }
        return string;
    }

    @Nullable
    public static final JsonNode readTreeSafe(@Nullable String value2) {
        JsonNode jsonNode;
        if (value2 == null) {
            return null;
        }
        try {
            jsonNode = new ObjectMapper().readTree(value2);
        }
        catch (Exception e) {
            logger.fine("Could not parse variable: " + e.getMessage());
            jsonNode = null;
        }
        return jsonNode;
    }

    @Nullable
    public static final JsonNode asJson(@Nullable Object obj) {
        JsonNode jsonNode;
        try {
            jsonNode = (JsonNode)objectMapper.convertValue(obj, JsonNode.class);
        }
        catch (Exception e) {
            jsonNode = null;
        }
        return jsonNode;
    }
}

