/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.codeInsight;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpClientCoroutinesService;
import com.intellij.httpClient.http.request.dynamicVariables.HttpClientDynamicVariableValue;
import com.intellij.httpClient.http.request.environment.EnvironmentFileModificator;
import com.intellij.httpClient.http.request.psi.HttpDynamicVariableArg;
import com.intellij.json.JsonFileType;
import com.intellij.json.JsonUtil;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u0003H\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J3\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0096\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"Lcom/intellij/httpClient/http/request/codeInsight/AddAuthToEnvironmentFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "envName", "", "element", "Lcom/intellij/psi/PsiElement;", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;)V", "getEnvName", "()Ljava/lang/String;", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "endElement", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "startInWriteAction", "", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpClientUnresolvedAuthIdInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientUnresolvedAuthIdInspection.kt\ncom/intellij/httpClient/http/request/codeInsight/AddAuthToEnvironmentFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,226:1\n1#2:227\n*E\n"})
final class AddAuthToEnvironmentFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    @NotNull
    private final String envName;

    public AddAuthToEnvironmentFix(@NotNull String envName, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)envName, (String)"envName");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(element);
        this.envName = envName;
    }

    @NotNull
    public final String getEnvName() {
        return this.envName;
    }

    @NotNull
    public String getFamilyName() {
        String string = RestClientBundle.message("http.client.add.auth.quickfix", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        HttpClientDynamicVariableValue.ParameterValue parameterValue = ((HttpDynamicVariableArg)startElement).getValue();
        Intrinsics.checkNotNull((Object)parameterValue, (String)"null cannot be cast to non-null type com.intellij.httpClient.http.request.dynamicVariables.HttpClientDynamicVariableValue.ParameterValue.Str");
        String id = ((HttpClientDynamicVariableValue.ParameterValue.Str)parameterValue).getValue();
        BuildersKt.launch$default((CoroutineScope)HttpClientCoroutinesService.scope$default(HttpClientCoroutinesService.Companion.getInstance(project), null, 1, null), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, file, id, null){
            int label;
            final /* synthetic */ AddAuthToEnvironmentFix this$0;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ String $id;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                this.$id = $id;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = new EnvironmentFileModificator(this.this$0.getEnvName(), this.$file).addAuthConfig(this.$id, (Continuation<? super Pair<? extends Editor, String>>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file) {
        JsonObject jsonObject;
        JsonValue authValue;
        JsonObject jsonObject2;
        JsonValue securityValue;
        JsonFile jsonFile;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        JsonFile envPsiFile = EnvironmentFileModificator.getEnvFile$default(new EnvironmentFileModificator(this.envName, file), false, 1, null);
        if (envPsiFile != null) {
            PsiFile psiFile = IntentionPreviewUtils.obtainCopyForPreview((PsiFile)((PsiFile)envPsiFile));
            Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.intellij.json.psi.JsonFile");
            jsonFile = (JsonFile)psiFile;
        } else {
            PsiFile psiFile;
            PsiFile it = psiFile = new JsonElementGenerator(project).createDummyFile(StringsKt.trimIndent((String)("\n          {\n            \"" + this.envName + "\": {\n            \n            }\n          }\n        ")));
            boolean bl = false;
            it.setName("http-client.env.json");
            PsiFile psiFile2 = psiFile;
            Intrinsics.checkNotNull((Object)psiFile2, (String)"null cannot be cast to non-null type com.intellij.json.psi.JsonFile");
            jsonFile = (JsonFile)psiFile2;
        }
        JsonFile envFile = jsonFile;
        PsiElement psiElement = this.getStartElement();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.httpClient.http.request.psi.HttpDynamicVariableArg");
        HttpClientDynamicVariableValue.ParameterValue parameterValue = ((HttpDynamicVariableArg)psiElement).getValue();
        Intrinsics.checkNotNull((Object)parameterValue, (String)"null cannot be cast to non-null type com.intellij.httpClient.http.request.dynamicVariables.HttpClientDynamicVariableValue.ParameterValue.Str");
        String id = ((HttpClientDynamicVariableValue.ParameterValue.Str)parameterValue).getValue();
        JsonElementGenerator jsonGenerator = new JsonElementGenerator(project);
        JsonProperty jsonProperty = jsonGenerator.createProperty(id, "{\n  \"Type\": \"OAuth2\",\n  \"Grant Type\": \"Implicit\",\n  \"Client ID\": \"\",\n  \"Auth URL\": \"\"\n}");
        Intrinsics.checkNotNullExpressionValue((Object)jsonProperty, (String)"createProperty(...)");
        JsonProperty prop = jsonProperty;
        JsonObject jsonObject3 = JsonUtil.getTopLevelObject((JsonFile)envFile);
        Intrinsics.checkNotNull((Object)jsonObject3);
        JsonObject jsonObject4 = jsonObject3;
        JsonProperty jsonProperty2 = jsonObject4.findProperty(this.envName);
        Intrinsics.checkNotNull((Object)jsonProperty2);
        JsonValue jsonValue = jsonProperty2.getValue();
        Intrinsics.checkNotNull((Object)jsonValue, (String)"null cannot be cast to non-null type com.intellij.json.psi.JsonObject");
        JsonObject envObject = (JsonObject)jsonValue;
        JsonProperty jsonProperty3 = envObject.findProperty("Security");
        Object object = securityValue = jsonProperty3 != null ? jsonProperty3.getValue() : null;
        if (securityValue instanceof JsonObject) {
            jsonObject2 = (JsonObject)securityValue;
        } else {
            JsonValue jsonValue2 = securityValue;
            if (jsonValue2 != null && (jsonValue2 = jsonValue2.getParent()) != null) {
                jsonValue2.delete();
            }
            PsiElement psiElement2 = JsonPsiUtil.addProperty((JsonObject)envObject, (JsonProperty)jsonGenerator.createProperty("Security", "{}"), (boolean)false);
            Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type com.intellij.json.psi.JsonProperty");
            JsonProperty newProp = (JsonProperty)psiElement2;
            JsonValue jsonValue3 = newProp.getValue();
            Intrinsics.checkNotNull((Object)jsonValue3, (String)"null cannot be cast to non-null type com.intellij.json.psi.JsonObject");
            jsonObject2 = (JsonObject)jsonValue3;
        }
        JsonObject securityObject = jsonObject2;
        JsonProperty jsonProperty4 = securityObject.findProperty("Auth");
        Object object2 = authValue = jsonProperty4 != null ? jsonProperty4.getValue() : null;
        if (authValue instanceof JsonObject) {
            jsonObject = (JsonObject)authValue;
        } else {
            JsonValue jsonValue4 = authValue;
            if (jsonValue4 != null && (jsonValue4 = jsonValue4.getParent()) != null) {
                jsonValue4.delete();
            }
            PsiElement psiElement3 = JsonPsiUtil.addProperty((JsonObject)securityObject, (JsonProperty)jsonGenerator.createProperty("Auth", "{}"), (boolean)false);
            Intrinsics.checkNotNull((Object)psiElement3, (String)"null cannot be cast to non-null type com.intellij.json.psi.JsonProperty");
            JsonProperty newProp = (JsonProperty)psiElement3;
            JsonValue jsonValue5 = newProp.getValue();
            Intrinsics.checkNotNull((Object)jsonValue5, (String)"null cannot be cast to non-null type com.intellij.json.psi.JsonObject");
            jsonObject = (JsonObject)jsonValue5;
        }
        JsonObject authObject = jsonObject;
        JsonPsiUtil.addProperty((JsonObject)authObject, (JsonProperty)prop, (boolean)false);
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)envFile);
        FileType fileType = (FileType)JsonFileType.INSTANCE;
        String string = envFile.getName();
        Object object3 = envPsiFile;
        if (object3 == null || (object3 = object3.getText()) == null) {
            object3 = "";
        }
        return (IntentionPreviewInfo)new IntentionPreviewInfo.CustomDiff(fileType, string, (String)object3, envFile.getText());
    }

    public boolean startInWriteAction() {
        return false;
    }
}

