/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.providers.vscode;

import com.intellij.ide.startup.importSettings.db.KnownKeymaps;
import com.intellij.ide.startup.importSettings.db.KnownLafs;
import com.intellij.ide.startup.importSettings.db.WindowsEnvVariables;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.transfer.backend.db.KnownColorSchemes;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.parsers.GeneralSettingsParser;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.parsers.KeyBindingsParser;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.parsers.PluginParser;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.parsers.StateDatabaseParser;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vscode.parsers.StorageParser;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020!J\b\u0010#\u001a\u00020\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n \n*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0014\u0010\u0017\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R\u0014\u0010\u0019\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012R\u0018\u0010\u001d\u001a\n \n*\u0004\u0018\u00010\u001e0\u001eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001f\u00a8\u0006$"}, d2={"Lcom/intellij/ide/startup/importSettings/providers/vscode/VSCodeSettingsProcessor;", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "appFolder", "", "pluginFolder", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Ljava/lang/String;Ljava/lang/String;)V", "homeDirectory", "kotlin.jvm.PlatformType", "Ljava/lang/String;", "vsCodeHome", "getVsCodeHome$intellij_ide_startup_importSettings", "()Ljava/lang/String;", "storageFile", "Ljava/io/File;", "getStorageFile$intellij_ide_startup_importSettings", "()Ljava/io/File;", "keyBindingsFile", "getKeyBindingsFile$intellij_ide_startup_importSettings", "generalSettingsFile", "getGeneralSettingsFile$intellij_ide_startup_importSettings", "pluginsDirectory", "getPluginsDirectory$intellij_ide_startup_importSettings", "database", "getDatabase$intellij_ide_startup_importSettings", "getDefaultSettings", "Lcom/intellij/ide/startup/importSettings/models/Settings;", "timeAfterLastModificationToConsiderTheInstanceRecent", "Ljava/time/Duration;", "Ljava/time/Duration;", "willDetectAtLeastSomething", "", "isInstanceRecentEnough", "getProcessedSettings", "intellij.ide.startup.importSettings"})
public class VSCodeSettingsProcessor {
    @NotNull
    private final CoroutineScope scope;
    private final String homeDirectory;
    @NotNull
    private final String vsCodeHome;
    @NotNull
    private final File storageFile;
    @NotNull
    private final File keyBindingsFile;
    @NotNull
    private final File generalSettingsFile;
    @NotNull
    private final File pluginsDirectory;
    @NotNull
    private final File database;
    private final Duration timeAfterLastModificationToConsiderTheInstanceRecent;

    public VSCodeSettingsProcessor(@NotNull CoroutineScope scope, @NotNull String appFolder, @NotNull String pluginFolder) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)appFolder, (String)"appFolder");
        Intrinsics.checkNotNullParameter((Object)pluginFolder, (String)"pluginFolder");
        this.scope = scope;
        this.homeDirectory = System.getProperty("user.home");
        this.vsCodeHome = SystemInfo.isMac ? this.homeDirectory + "/Library/Application Support/" + appFolder : (SystemInfo.isWindows ? WindowsEnvVariables.INSTANCE.getApplicationData() + "/" + appFolder : this.homeDirectory + "/.config/" + appFolder);
        this.storageFile = new File(this.vsCodeHome + "/storage.json");
        this.keyBindingsFile = new File(this.vsCodeHome + "/User/keybindings.json");
        this.generalSettingsFile = new File(this.vsCodeHome + "/User/settings.json");
        this.pluginsDirectory = new File(this.homeDirectory + "/" + pluginFolder + "/extensions");
        this.database = new File(this.vsCodeHome + "/User/globalStorage/state.vscdb");
        this.timeAfterLastModificationToConsiderTheInstanceRecent = Duration.ofHours(8760L);
    }

    public /* synthetic */ VSCodeSettingsProcessor(CoroutineScope coroutineScope, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "Code";
        }
        if ((n & 4) != 0) {
            string2 = ".vscode";
        }
        this(coroutineScope, string, string2);
    }

    @NotNull
    public final String getVsCodeHome$intellij_ide_startup_importSettings() {
        return this.vsCodeHome;
    }

    @NotNull
    public final File getStorageFile$intellij_ide_startup_importSettings() {
        return this.storageFile;
    }

    @NotNull
    public final File getKeyBindingsFile$intellij_ide_startup_importSettings() {
        return this.keyBindingsFile;
    }

    @NotNull
    public final File getGeneralSettingsFile$intellij_ide_startup_importSettings() {
        return this.generalSettingsFile;
    }

    @NotNull
    public final File getPluginsDirectory$intellij_ide_startup_importSettings() {
        return this.pluginsDirectory;
    }

    @NotNull
    public final File getDatabase$intellij_ide_startup_importSettings() {
        return this.database;
    }

    @NotNull
    public final Settings getDefaultSettings() {
        return new Settings(null, KnownLafs.INSTANCE.getDarcula(), KnownColorSchemes.INSTANCE.getDarcula(), SystemInfoRt.isMac ? KnownKeymaps.INSTANCE.getVSCodeMac() : KnownKeymaps.INSTANCE.getVSCode(), null, 17, null);
    }

    public final boolean willDetectAtLeastSomething() {
        if (this.generalSettingsFile.exists()) {
            return true;
        }
        if (!this.pluginsDirectory.exists() || !this.pluginsDirectory.isDirectory()) {
            return false;
        }
        File[] fileArray = this.pluginsDirectory.listFiles();
        if (fileArray == null) {
            return false;
        }
        for (File pluginDirEntry : fileArray) {
            if (!pluginDirEntry.isDirectory()) continue;
            return true;
        }
        return false;
    }

    public final boolean isInstanceRecentEnough() {
        try {
            File fileToCheck = this.database;
            if (fileToCheck.exists()) {
                FileTime time = Files.getLastModifiedTime(fileToCheck.toPath(), new LinkOption[0]);
                return time.toInstant().compareTo(Instant.now().minus(this.timeAfterLastModificationToConsiderTheInstanceRecent)) > 0;
            }
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @NotNull
    public Settings getProcessedSettings() {
        Settings settings = this.getDefaultSettings();
        if (this.keyBindingsFile.exists()) {
            new KeyBindingsParser(settings).process(this.keyBindingsFile);
        }
        if (this.pluginsDirectory.exists()) {
            new PluginParser(settings).process(this.pluginsDirectory);
        }
        if (this.storageFile.exists()) {
            new StorageParser(settings).process(this.storageFile);
        }
        if (this.generalSettingsFile.exists()) {
            new GeneralSettingsParser(settings).process(this.generalSettingsFile);
        }
        if (this.database.exists()) {
            new StateDatabaseParser(this.scope, settings).process(this.database);
        }
        return settings;
    }
}

