/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.util;

import java.time.Duration;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0004\u0010\u0007J\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u0011\u001a\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\b\u0010\u0017\u001a\u00020\u000bH\u0002J\b\u0010\u0018\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0011\u0010\u0015\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rd/platform/util/TimeoutTracker;", "", "timeout", "Ljava/time/Duration;", "<init>", "(Ljava/time/Duration;)V", "Lkotlin/time/Duration;", "(JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getTimeout", "()Ljava/time/Duration;", "startTimeNs", "", "isExpired", "", "()Z", "reset", "", "throwIfExpired", "message", "Lkotlin/Function0;", "", "delta", "getDelta", "getCurrentDeltaNs", "getCurrentTimeNs", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nTimeoutTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimeoutTracker.kt\ncom/jetbrains/rd/platform/util/TimeoutTracker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,35:1\n1#2:36\n*E\n"})
public final class TimeoutTracker {
    @NotNull
    private final Duration timeout;
    private long startTimeNs;

    public TimeoutTracker(@NotNull Duration timeout) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        this.timeout = timeout;
        boolean bl2 = bl = this.timeout.toNanos() > 0L;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "The number of nanoseconds (" + this.timeout.toNanos() + ") in timeout should be positive.";
            throw new AssertionError((Object)string);
        }
        this.reset();
    }

    @NotNull
    public final Duration getTimeout() {
        return this.timeout;
    }

    private TimeoutTracker(long timeout) {
        long l = timeout;
        int n = kotlin.time.Duration.getNanosecondsComponent-impl((long)l);
        long l2 = kotlin.time.Duration.getInWholeSeconds-impl((long)l);
        Duration duration = Duration.ofSeconds(l2, n);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"toComponents-impl(...)");
        this(duration);
    }

    public final boolean isExpired() {
        if (this.timeout.isNegative()) {
            return false;
        }
        return this.getCurrentDeltaNs() > this.timeout.toNanos();
    }

    public final void reset() {
        this.startTimeNs = this.getCurrentTimeNs();
    }

    public final void throwIfExpired(@NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        if (this.isExpired()) {
            throw new Exception((String)message.invoke());
        }
    }

    @NotNull
    public final Duration getDelta() {
        Duration duration = Duration.ofNanos(this.getCurrentDeltaNs());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofNanos(...)");
        return duration;
    }

    private final long getCurrentDeltaNs() {
        return this.getCurrentTimeNs() - this.startTimeNs;
    }

    private final long getCurrentTimeNs() {
        return System.nanoTime();
    }

    public /* synthetic */ TimeoutTracker(long timeout, DefaultConstructorMarker $constructor_marker) {
        this(timeout);
    }
}

