/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.FUSEventSource;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserService;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserServiceKt;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginSuggestion;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginSuggestionProvider;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.SuggestedIde;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.extensions.GithubYamlFileDetectionKt;
import org.jetbrains.plugins.github.i18n.GithubBundle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/GitHubUltimateSuggestionProvider;", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginSuggestionProvider;", "<init>", "()V", "getSuggestion", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginSuggestion;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isPluginSuggestionDismissed", "", "UltimateForGitHubActionsSuggestion", "intellij.vcs.github"})
public final class GitHubUltimateSuggestionProvider
implements PluginSuggestionProvider {
    @Nullable
    public PluginSuggestion getSuggestion(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.isPluginSuggestionDismissed() || PluginAdvertiserServiceKt.tryUltimateIsDisabled()) {
            return null;
        }
        if (!GithubYamlFileDetectionKt.isGithubActionsFile(file)) {
            return null;
        }
        String string = ApplicationInfo.getInstance().getBuild().getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProductCode(...)");
        String thisProductCode = string;
        String suggestedIdeCode = PluginAdvertiserService.Companion.getSuggestedCommercialIdeCode(thisProductCode);
        SuggestedIde suggestedIde = PluginAdvertiserService.Companion.getIde(suggestedIdeCode);
        if (suggestedIde == null) {
            return null;
        }
        SuggestedIde suggestedCommercialIde = suggestedIde;
        return new UltimateForGitHubActionsSuggestion(project, suggestedCommercialIde);
    }

    private final boolean isPluginSuggestionDismissed() {
        return PropertiesComponent.getInstance().isTrueValue("promo.github.actions.suggestion.dismissed");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/github/GitHubUltimateSuggestionProvider$UltimateForGitHubActionsSuggestion;", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginSuggestion;", "project", "Lcom/intellij/openapi/project/Project;", "suggestedCommercialIde", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/SuggestedIde;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/SuggestedIde;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSuggestedCommercialIde", "()Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/SuggestedIde;", "pluginIds", "", "", "getPluginIds", "()Ljava/util/List;", "apply", "Lcom/intellij/ui/EditorNotificationPanel;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "dismissPluginSuggestion", "", "intellij.vcs.github"})
    public static final class UltimateForGitHubActionsSuggestion
    implements PluginSuggestion {
        @NotNull
        private final Project project;
        @NotNull
        private final SuggestedIde suggestedCommercialIde;
        @NotNull
        private final List<String> pluginIds;

        public UltimateForGitHubActionsSuggestion(@NotNull Project project, @NotNull SuggestedIde suggestedCommercialIde) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)suggestedCommercialIde, (String)"suggestedCommercialIde");
            this.project = project;
            this.suggestedCommercialIde = suggestedCommercialIde;
            this.pluginIds = CollectionsKt.listOf((Object)"org.jetbrains.plugins.github");
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final SuggestedIde getSuggestedCommercialIde() {
            return this.suggestedCommercialIde;
        }

        @NotNull
        public List<String> getPluginIds() {
            return this.pluginIds;
        }

        @NotNull
        public EditorNotificationPanel apply(@NotNull FileEditor fileEditor) {
            Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
            EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Promo);
            Object[] objectArray = new Object[]{GithubBundle.message("github.actions.file.promo.label", new Object[0]), this.suggestedCommercialIde.getName()};
            panel2.setText(IdeBundle.message((String)"plugins.advertiser.extensions.supported.in.ultimate", (Object[])objectArray));
            PluginAdvertiserServiceKt.createTryUltimateActionLabel$default((EditorNotificationPanel)panel2, (SuggestedIde)this.suggestedCommercialIde, (Project)this.project, (PluginId)PluginId.getId((String)this.getPluginIds().get(0)), null, (int)8, null);
            panel2.createActionLabel(IdeBundle.message((String)"plugins.advertiser.action.ignore.ultimate", (Object[])new Object[0]), () -> UltimateForGitHubActionsSuggestion.apply$lambda$0(this));
            return panel2;
        }

        private final void dismissPluginSuggestion() {
            PropertiesComponent.getInstance().setValue("promo.github.actions.suggestion.dismissed", true);
        }

        private static final void apply$lambda$0(UltimateForGitHubActionsSuggestion this$0) {
            FUSEventSource.EDITOR.logIgnoreExtension(this$0.project);
            this$0.dismissPluginSuggestion();
            EditorNotifications.getInstance((Project)this$0.project).updateAllNotifications();
        }
    }
}

