/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.kdtree;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

public class KdNode {
    private Coordinate p = null;
    private Object data;
    private KdNode left;
    private KdNode right;
    private int count;

    public KdNode(double _x, double _y, Object data) {
        this.p = new Coordinate(_x, _y);
        this.left = null;
        this.right = null;
        this.count = 1;
        this.data = data;
    }

    public KdNode(Coordinate p2, Object data) {
        this.p = new Coordinate(p2);
        this.left = null;
        this.right = null;
        this.count = 1;
        this.data = data;
    }

    public double getX() {
        return this.p.x;
    }

    public double getY() {
        return this.p.y;
    }

    public double splitValue(boolean isSplitOnX) {
        if (isSplitOnX) {
            return this.p.getX();
        }
        return this.p.getY();
    }

    public Coordinate getCoordinate() {
        return this.p;
    }

    public Object getData() {
        return this.data;
    }

    public KdNode getLeft() {
        return this.left;
    }

    public KdNode getRight() {
        return this.right;
    }

    void increment() {
        ++this.count;
    }

    public int getCount() {
        return this.count;
    }

    public boolean isRepeated() {
        return this.count > 1;
    }

    void setLeft(KdNode _left) {
        this.left = _left;
    }

    void setRight(KdNode _right) {
        this.right = _right;
    }

    boolean isRangeOverLeft(boolean isSplitOnX, Envelope env) {
        double envMin = isSplitOnX ? env.getMinX() : env.getMinY();
        double splitValue = this.splitValue(isSplitOnX);
        boolean isInRange = envMin < splitValue;
        return isInRange;
    }

    boolean isRangeOverRight(boolean isSplitOnX, Envelope env) {
        double envMax = isSplitOnX ? env.getMaxX() : env.getMaxY();
        double splitValue = this.splitValue(isSplitOnX);
        boolean isInRange = splitValue <= envMax;
        return isInRange;
    }

    boolean isPointOnLeft(boolean isSplitOnX, Coordinate pt) {
        double ptOrdinate = isSplitOnX ? pt.x : pt.y;
        double splitValue = this.splitValue(isSplitOnX);
        boolean isInRange = ptOrdinate < splitValue;
        return isInRange;
    }
}

