/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.composition;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.composition.DependencyManagementImporter;

@Named
@Singleton
public class DefaultDependencyManagementImporter
implements DependencyManagementImporter {
    @Override
    public void importManagement(Model target2, List<? extends DependencyManagement> sources, ModelBuildingRequest request2, ModelProblemCollector problems) {
        if (sources != null && !sources.isEmpty()) {
            LinkedHashMap<String, Dependency> dependencies = new LinkedHashMap<String, Dependency>();
            DependencyManagement depMgmt = target2.getDependencyManagement();
            if (depMgmt != null) {
                for (Dependency dependency : depMgmt.getDependencies()) {
                    dependencies.put(dependency.getManagementKey(), dependency);
                }
            } else {
                depMgmt = new DependencyManagement();
                target2.setDependencyManagement(depMgmt);
            }
            for (DependencyManagement dependencyManagement : sources) {
                for (Dependency dependency : dependencyManagement.getDependencies()) {
                    String key2 = dependency.getManagementKey();
                    if (dependencies.containsKey(key2)) continue;
                    dependencies.put(key2, dependency);
                }
            }
            depMgmt.setDependencies(new ArrayList<Dependency>(dependencies.values()));
        }
    }
}

