/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core.util;

import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.core.util.FastStack;
import com.thoughtworks.xstream.core.util.OrderRetainingMap;
import com.thoughtworks.xstream.io.StreamException;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Map;

public class CustomObjectOutputStream
extends ObjectOutputStream {
    private FastStack callbacks = new FastStack(1);
    private FastStack customFields = new FastStack(1);
    private static final String DATA_HOLDER_KEY = CustomObjectOutputStream.class.getName();

    public static synchronized CustomObjectOutputStream getInstance(DataHolder whereFrom, StreamCallback callback) {
        try {
            CustomObjectOutputStream result2 = (CustomObjectOutputStream)whereFrom.get(DATA_HOLDER_KEY);
            if (result2 == null) {
                result2 = new CustomObjectOutputStream(callback);
                whereFrom.put(DATA_HOLDER_KEY, result2);
            } else {
                result2.pushCallback(callback);
            }
            return result2;
        }
        catch (SecurityException e) {
            throw new ObjectAccessException("Cannot create CustomObjectStream", e);
        }
        catch (IOException e) {
            throw new StreamException("Cannot create CustomObjectStream", e);
        }
    }

    public CustomObjectOutputStream(StreamCallback callback) throws IOException, SecurityException {
        this.callbacks.push(callback);
    }

    public void pushCallback(StreamCallback callback) {
        this.callbacks.push(callback);
    }

    public StreamCallback popCallback() {
        return (StreamCallback)this.callbacks.pop();
    }

    public StreamCallback peekCallback() {
        return (StreamCallback)this.callbacks.peek();
    }

    public void defaultWriteObject() throws IOException {
        this.peekCallback().defaultWriteObject();
    }

    protected void writeObjectOverride(Object obj2) throws IOException {
        this.peekCallback().writeToStream(obj2);
    }

    public void writeBoolean(boolean val) throws IOException {
        this.peekCallback().writeToStream(val ? Boolean.TRUE : Boolean.FALSE);
    }

    public void writeByte(int val) throws IOException {
        this.peekCallback().writeToStream(new Byte((byte)val));
    }

    public void writeInt(int val) throws IOException {
        this.peekCallback().writeToStream(new Integer(val));
    }

    public void writeChar(int val) throws IOException {
        this.peekCallback().writeToStream(new Character((char)val));
    }

    public void writeDouble(double val) throws IOException {
        this.peekCallback().writeToStream(new Double(val));
    }

    public void writeFloat(float val) throws IOException {
        this.peekCallback().writeToStream(new Float(val));
    }

    public void writeLong(long val) throws IOException {
        this.peekCallback().writeToStream(new Long(val));
    }

    public void writeShort(int val) throws IOException {
        this.peekCallback().writeToStream(new Short((short)val));
    }

    public void write(byte[] buf) throws IOException {
        this.peekCallback().writeToStream(buf);
    }

    public void writeChars(String str) throws IOException {
        this.peekCallback().writeToStream(str.toCharArray());
    }

    public void writeUTF(String str) throws IOException {
        this.peekCallback().writeToStream(str);
    }

    public void write(int val) throws IOException {
        this.peekCallback().writeToStream(new Byte((byte)val));
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        byte[] b = new byte[len];
        System.arraycopy(buf, off, b, 0, len);
        this.peekCallback().writeToStream(b);
    }

    public void flush() throws IOException {
        this.peekCallback().flush();
    }

    public void close() throws IOException {
        this.peekCallback().close();
    }

    public ObjectOutputStream.PutField putFields() {
        CustomPutField result2 = new CustomPutField();
        this.customFields.push(result2);
        return result2;
    }

    public void writeFields() throws IOException {
        CustomPutField customPutField = (CustomPutField)this.customFields.pop();
        this.peekCallback().writeFieldsToStream(customPutField.asMap());
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public void useProtocolVersion(int version) {
        throw new UnsupportedOperationException();
    }

    public void writeBytes(String str) {
        throw new UnsupportedOperationException();
    }

    public void writeUnshared(Object obj2) {
        throw new UnsupportedOperationException();
    }

    private class CustomPutField
    extends ObjectOutputStream.PutField {
        private final Map fields = new OrderRetainingMap();

        private CustomPutField() {
        }

        public Map asMap() {
            return this.fields;
        }

        public void write(ObjectOutput out) throws IOException {
            CustomObjectOutputStream.this.peekCallback().writeToStream(this.asMap());
        }

        public void put(String name2, Object val) {
            this.fields.put(name2, val);
        }

        public void put(String name2, byte val) {
            this.put(name2, new Byte(val));
        }

        public void put(String name2, char val) {
            this.put(name2, new Character(val));
        }

        public void put(String name2, double val) {
            this.put(name2, new Double(val));
        }

        public void put(String name2, float val) {
            this.put(name2, new Float(val));
        }

        public void put(String name2, int val) {
            this.put(name2, new Integer(val));
        }

        public void put(String name2, long val) {
            this.put(name2, new Long(val));
        }

        public void put(String name2, short val) {
            this.put(name2, new Short(val));
        }

        public void put(String name2, boolean val) {
            this.put(name2, val ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public static interface StreamCallback {
        public void writeToStream(Object var1) throws IOException;

        public void writeFieldsToStream(Map var1) throws IOException;

        public void defaultWriteObject() throws IOException;

        public void flush() throws IOException;

        public void close() throws IOException;
    }
}

