/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core.util;

import com.thoughtworks.xstream.core.JVM;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CompositeClassLoader
extends ClassLoader {
    private final ReferenceQueue queue = new ReferenceQueue();
    private final List classLoaders = new ArrayList();

    public CompositeClassLoader() {
        this.addInternal(Object.class.getClassLoader());
        this.addInternal(this.getClass().getClassLoader());
    }

    public synchronized void add(ClassLoader classLoader) {
        this.cleanup();
        if (classLoader != null) {
            this.addInternal(classLoader);
        }
    }

    private void addInternal(ClassLoader classLoader) {
        WeakReference refClassLoader = null;
        Iterator iterator = this.classLoaders.iterator();
        while (iterator.hasNext()) {
            WeakReference ref2 = (WeakReference)iterator.next();
            ClassLoader cl = (ClassLoader)ref2.get();
            if (cl == null) {
                iterator.remove();
                continue;
            }
            if (cl != classLoader) continue;
            iterator.remove();
            refClassLoader = ref2;
        }
        this.classLoaders.add(0, refClassLoader != null ? refClassLoader : new WeakReference(classLoader, this.queue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClass(String name2) throws ClassNotFoundException {
        ArrayList copy = new ArrayList(this.classLoaders.size()){

            public boolean addAll(Collection c2) {
                boolean result2 = false;
                Iterator iter = c2.iterator();
                while (iter.hasNext()) {
                    result2 |= this.add(iter.next());
                }
                return result2;
            }

            public boolean add(Object ref2) {
                Object classLoader = ((WeakReference)ref2).get();
                if (classLoader != null) {
                    return super.add(classLoader);
                }
                return false;
            }
        };
        CompositeClassLoader compositeClassLoader = this;
        synchronized (compositeClassLoader) {
            this.cleanup();
            copy.addAll(this.classLoaders);
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Iterator iterator = copy.iterator();
        while (iterator.hasNext()) {
            ClassLoader classLoader = (ClassLoader)iterator.next();
            if (classLoader == contextClassLoader) {
                contextClassLoader = null;
            }
            try {
                return classLoader.loadClass(name2);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        if (contextClassLoader != null) {
            return contextClassLoader.loadClass(name2);
        }
        throw new ClassNotFoundException(name2);
    }

    private void cleanup() {
        WeakReference ref2;
        while ((ref2 = (WeakReference)this.queue.poll()) != null) {
            this.classLoaders.remove(ref2);
        }
    }

    static {
        if (JVM.isVersion(7)) {
            try {
                Method m = ClassLoader.class.getDeclaredMethod("registerAsParallelCapable", null);
                if (!m.isAccessible()) {
                    m.setAccessible(true);
                }
                m.invoke(null, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

