/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.console.JdbcConsoleCore;
import com.intellij.database.console.JdbcConsoleProviderCore;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.sql.dialects.mongo.js.inspections.MongoJSInspectionBase;
import com.intellij.sql.inspections.SqlSideEffectsInspection;
import com.intellij.sql.psi.ExecutionFlowAnalyzer;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.ThreeState;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/dialects/mongo/js/inspections/MongoJSSideEffectsInspection;", "Lcom/intellij/sql/dialects/mongo/js/inspections/MongoJSInspectionBase;", "<init>", "()V", "createFileVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "results", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.database.dialects.mongo.ex"})
public class MongoJSSideEffectsInspection
extends MongoJSInspectionBase {
    @Override
    @Nullable
    protected PsiElementVisitor createFileVisitor(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly, @NotNull List<ProblemDescriptor> results2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(results2, (String)"results");
        return (PsiElementVisitor)new PsiRecursiveElementVisitor(results2, manager, isOnTheFly){
            final /* synthetic */ List<ProblemDescriptor> $results;
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ boolean $isOnTheFly;
            {
                this.$results = $results;
                this.$manager = $manager;
                this.$isOnTheFly = $isOnTheFly;
            }

            public void visitElement(PsiElement element) {
                LocalDataSource dataSource;
                JdbcConsoleCore console;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                super.visitElement(element);
                ExecutionFlowAnalyzer executionFlowAnalyzer = SqlPsiFacade.getInstance((Project)element.getProject()).getExecutionFlowAnalyzer(element.getLanguage());
                if (executionFlowAnalyzer == null) {
                    return;
                }
                ExecutionFlowAnalyzer analyzer = executionFlowAnalyzer;
                VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                VirtualFile virtualFile2 = virtualFile;
                JdbcConsoleCore jdbcConsoleCore = console = JdbcConsoleProviderCore.getValidConsole(element.getProject(), virtualFile2);
                LocalDataSource localDataSource = dataSource = jdbcConsoleCore != null ? jdbcConsoleCore.getDataSource() : null;
                if (dataSource == null || !dataSource.isReadOnly() || !analyzer.isAcceptable(element)) {
                    return;
                }
                ExecutionFlowAnalyzer.Flow flow = analyzer.analyze(element);
                Intrinsics.checkNotNullExpressionValue((Object)flow, (String)"analyze(...)");
                ExecutionFlowAnalyzer.Flow flow2 = flow;
                if (flow2.isPure() == ThreeState.YES) {
                    return;
                }
                String string = (String)flow2.transform(SqlSideEffectsInspection.TRANSFORMER);
                if (string == null) {
                    return;
                }
                String reason = string;
                SqlSideEffectsInspection.MakeDataSourceWritable fix = new SqlSideEffectsInspection.MakeDataSourceWritable(dataSource);
                Collection collection = this.$results;
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{fix};
                collection.add(this.$manager.createProblemDescriptor(element, reason, true, ProblemHighlightType.WEAK_WARNING, this.$isOnTheFly, localQuickFixArray));
            }
        };
    }
}

