/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js.inspections;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.mongo.js.MongoJSPsiUtilKt;
import com.intellij.sql.dialects.mongo.js.inspections.MongoJSInspectionBase;
import com.intellij.sql.dialects.mongo.js.psi.resolve.MongoJSResolveHelper;
import com.intellij.sql.dialects.mongo.js.psi.resolve.ResolveUtilKt;
import com.intellij.sql.dialects.mongo.js.psi.resolve.symbols.MongoJSSymbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014\u00a8\u0006\u0011"}, d2={"Lcom/intellij/sql/dialects/mongo/js/inspections/MongoJSDeprecationInspection;", "Lcom/intellij/sql/dialects/mongo/js/inspections/MongoJSInspectionBase;", "<init>", "()V", "createFileVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "results", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "Companion", "ReplaceDeprecatedMethodQuickFix", "intellij.database.dialects.mongo"})
public class MongoJSDeprecationInspection
extends MongoJSInspectionBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<String, Companion.QuickFix> deprecatedMethods;

    @Override
    @Nullable
    protected PsiElementVisitor createFileVisitor(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly, @NotNull List<ProblemDescriptor> results2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(results2, (String)"results");
        MongoJSResolveHelper mongoJSResolveHelper = ResolveUtilKt.getMongoHelper((PsiElement)file);
        if (mongoJSResolveHelper == null) {
            return null;
        }
        MongoJSResolveHelper helper = mongoJSResolveHelper;
        return (PsiElementVisitor)new PsiRecursiveElementVisitor(helper, results2, manager, isOnTheFly){
            final /* synthetic */ MongoJSResolveHelper $helper;
            final /* synthetic */ List<ProblemDescriptor> $results;
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ boolean $isOnTheFly;
            {
                this.$helper = $helper;
                this.$results = $results;
                this.$manager = $manager;
                this.$isOnTheFly = $isOnTheFly;
            }

            /*
             * WARNING - void declaration
             */
            public void visitElement(PsiElement element) {
                PsiPolyVariantReference psiPolyVariantReference;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                super.visitElement(element);
                if (!this.$helper.isCalleeReference(element)) {
                    return;
                }
                ResolveResult[] resolveResultArray = element.getReference();
                PsiPolyVariantReference psiPolyVariantReference2 = psiPolyVariantReference = resolveResultArray instanceof PsiPolyVariantReference ? (PsiPolyVariantReference)resolveResultArray : null;
                if (psiPolyVariantReference != null && (resolveResultArray = psiPolyVariantReference.multiResolve(false)) != null) {
                    void $this$forEach$iv;
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv;
                    ResolveResult[] resolveResultArray2 = resolveResultArray;
                    MongoJSResolveHelper mongoJSResolveHelper = this.$helper;
                    boolean $i$f$mapNotNull = false;
                    InspectionManager inspectionManager = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    int n = ((void)$this$forEach$iv$iv$iv).length;
                    for (int j = 0; j < n; ++j) {
                        MongoJSSymbol it$iv$iv;
                        void element$iv$iv$iv;
                        void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
                        boolean bl = false;
                        void it = element$iv$iv;
                        boolean bl2 = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (mongoJSResolveHelper.getSymbol((ResolveResult)it) == null) continue;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = (List)destination$iv$iv;
                    mongoJSResolveHelper = this.$helper;
                    List<ProblemDescriptor> list = this.$results;
                    inspectionManager = this.$manager;
                    boolean bl = this.$isOnTheFly;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv : $this$forEach$iv) {
                        MongoJSSymbol it = (MongoJSSymbol)element$iv;
                        boolean bl4 = false;
                        Companion.QuickFix quickFix = MongoJSDeprecationInspection.Companion.getDeprecatedMethods().get(it.getName());
                        if (quickFix == null) continue;
                        PsiElement psiElement = mongoJSResolveHelper.getReferenceNameElement(element);
                        if (psiElement == null) {
                            psiElement = element;
                        }
                        PsiElement anchor = psiElement;
                        ReplaceDeprecatedMethodQuickFix fix = quickFix instanceof Companion.Replacement ? new ReplaceDeprecatedMethodQuickFix(mongoJSResolveHelper, element, ((Companion.Replacement)quickFix).getName()) : null;
                        Collection collection = list;
                        Object[] objectArray = new Object[]{it.getName()};
                        String string = SqlBundle.message((String)"inspection.message.method.is.deprecated", (Object[])objectArray);
                        objectArray = LocalQuickFix.notNullElements((LocalQuickFix)((LocalQuickFix)fix));
                        collection.add(inspectionManager.createProblemDescriptor(anchor, anchor, string, ProblemHighlightType.LIKE_DEPRECATED, bl, (LocalQuickFix[])Arrays.copyOf(objectArray, objectArray.length)));
                    }
                }
            }
        };
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"insert", (Object)new Companion.Replacement("insertOne")), TuplesKt.to((Object)"remove", (Object)new Companion.Replacement("deleteMany")), TuplesKt.to((Object)"update", (Object)new Companion.Replacement("updateOne")), TuplesKt.to((Object)"save", (Object)Companion.NoReplacement.INSTANCE)};
        deprecatedMethods = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0003\n\u000b\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lcom/intellij/sql/dialects/mongo/js/inspections/MongoJSDeprecationInspection$Companion;", "", "<init>", "()V", "deprecatedMethods", "", "", "Lcom/intellij/sql/dialects/mongo/js/inspections/MongoJSDeprecationInspection$Companion$QuickFix;", "getDeprecatedMethods", "()Ljava/util/Map;", "QuickFix", "NoReplacement", "Replacement", "intellij.database.dialects.mongo"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, QuickFix> getDeprecatedMethods() {
            return deprecatedMethods;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/sql/dialects/mongo/js/inspections/MongoJSDeprecationInspection$Companion$NoReplacement;", "Lcom/intellij/sql/dialects/mongo/js/inspections/MongoJSDeprecationInspection$Companion$QuickFix;", "<init>", "()V", "intellij.database.dialects.mongo"})
        public static final class NoReplacement
        implements QuickFix {
            @NotNull
            public static final NoReplacement INSTANCE = new NoReplacement();

            private NoReplacement() {
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\bf\u0018\u00002\u00020\u0001\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0002\u00c0\u0006\u0001"}, d2={"Lcom/intellij/sql/dialects/mongo/js/inspections/MongoJSDeprecationInspection$Companion$QuickFix;", "", "intellij.database.dialects.mongo"})
        public static interface QuickFix {
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/dialects/mongo/js/inspections/MongoJSDeprecationInspection$Companion$Replacement;", "Lcom/intellij/sql/dialects/mongo/js/inspections/MongoJSDeprecationInspection$Companion$QuickFix;", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "intellij.database.dialects.mongo"})
        public static final class Replacement
        implements QuickFix {
            @NotNull
            private final String name;

            public Replacement(@NotNull String name2) {
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                this.name = name2;
            }

            @NotNull
            public final String getName() {
                return this.name;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0016J)\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0096\u0002R\u0010\u0010\u0002\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/sql/dialects/mongo/js/inspections/MongoJSDeprecationInspection$ReplaceDeprecatedMethodQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "helper", "Lcom/intellij/sql/dialects/mongo/js/psi/resolve/MongoJSResolveHelper;", "expr", "Lcom/intellij/psi/PsiElement;", "replacement", "", "<init>", "(Lcom/intellij/sql/dialects/mongo/js/psi/resolve/MongoJSResolveHelper;Lcom/intellij/psi/PsiElement;Ljava/lang/String;)V", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "endElement", "intellij.database.dialects.mongo"})
    private static final class ReplaceDeprecatedMethodQuickFix
    extends LocalQuickFixOnPsiElement {
        @FileModifier.SafeFieldForPreview
        @NotNull
        private final MongoJSResolveHelper helper;
        @NotNull
        private final String replacement;

        public ReplaceDeprecatedMethodQuickFix(@NotNull MongoJSResolveHelper helper, @NotNull PsiElement expr, @NotNull String replacement) {
            Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
            Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
            Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
            super(expr);
            this.helper = helper;
            this.replacement = replacement;
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message((String)"inspection.message.replace.deprecated.method.family.name", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getText() {
            Object[] objectArray = new Object[]{this.replacement};
            String string = SqlBundle.message((String)"inspection.message.replace.deprecated.method", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
                Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
                PsiElement psiElement = MongoJSPsiUtilKt.createRefFromText(project, this.replacement).getNameElement();
                if (psiElement == null) {
                    return;
                }
                PsiElement ident = psiElement;
                PsiElement psiElement2 = this.helper.getReferenceNameElement(startElement);
                if (psiElement2 == null) break block1;
                psiElement2.replace(ident);
            }
        }
    }
}

