/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.SmartPredicate;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.view.DbNamespaceNode;
import com.intellij.openapi.util.Couple;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbNamespacesTree {
    private boolean mySkipSpecForRoot = true;

    public void addNodes(@NotNull DbNamespaceNode p2, @Nullable BasicElement root) {
        if (p2 == null) {
            DbNamespacesTree.$$$reportNull$$$0(0);
        }
        @NotNull JBIterable objects = root == null ? JBIterable.empty() : DbNamespacesTree.sorted(DbNamespacesTree.getNamespaces(root));
        Map<String, DbNamespaceNode> oldCache = DbNamespacesTree.mapByName(p2.getChildNodes());
        ArrayList<DbNamespaceNode> children2 = new ArrayList<DbNamespaceNode>();
        BasicNamespace cur = null;
        for (BasicNamespace object : objects) {
            DbNamespaceNode node = oldCache.remove(object.getName());
            if (node != null) {
                node.setObject(object);
            } else {
                node = new DbNamespaceNode(object.getName(), object.getMetaObject(), object);
            }
            children2.add(node);
            if (object.isCurrent()) {
                cur = object;
            }
            if (DbImplUtilCore.isSchema(object)) continue;
            this.addNodes(node, object);
        }
        p2.setHasAllAndCur(p2.getKind() != ObjectKind.NONE || !this.mySkipSpecForRoot || p2.getAllNodes() != null);
        DbNamespaceNode.CurNode current = p2.getCurNode();
        if (current != null) {
            current.setCurObject(cur);
        }
        p2.setChildren(children2);
        oldCache.values().forEach(o -> DbNamespacesTree.resetNodeToShadow(o));
        p2.setShadowChildren(oldCache.values());
    }

    private static void resetNodeToShadow(DbNamespaceNode o) {
        DbNamespaceNode.CurNode curNode;
        if (!(o.getObject() instanceof TreePatternNode.PatternWrapper)) {
            o.setObject(o.getName());
        }
        if ((curNode = o.getCurNode()) != null) {
            curNode.setCurObject(null);
        }
        o.setShadowChildren(ContainerUtil.concat(o.getChildren(), o.getShadowChildren()));
        for (DbNamespaceNode child : o.getShadowChildren()) {
            DbNamespacesTree.resetNodeToShadow(child);
        }
    }

    private static Iterable<BasicNamespace> sorted(Iterable<? extends BasicNamespace> children2) {
        ArrayList namespaces2 = ContainerUtil.newArrayList(children2);
        namespaces2.sort(DasObject.NATURAL_COMPARATOR);
        return namespaces2;
    }

    public static void fillShadowChildren(TreePatternNode.Group[] groups, @NotNull DbNamespaceNode p2) {
        if (p2 == null) {
            DbNamespacesTree.$$$reportNull$$$0(1);
        }
        HashSet<DbNamespaceNode> processed = new HashSet<DbNamespaceNode>();
        ArrayList<DbNamespaceNode> shadow = new ArrayList<DbNamespaceNode>();
        ArrayList<DbNamespaceNode> filters = new ArrayList<DbNamespaceNode>();
        Map<String, DbNamespaceNode> oldCache = DbNamespacesTree.mapByName(p2.getShadowChildren());
        Map<String, DbNamespaceNode> objects = DbNamespacesTree.mapByName(p2.getChildNodes());
        if (p2.getWildcardMetas().isNotEmpty()) {
            p2.setHasAllAndCur(true);
        }
        for (TreePatternNode.Group g : groups) {
            BasicMetaObject<?> meta = p2.findChild(g.kind);
            if (g.matchedChildren(DataSourceSchemaMapping.CURRENT_NAMESPACE_NAME, null, null) || TreePatternUtils.findNegativeChild(g) != null) {
                p2.setHasAllAndCur(true);
            }
            if (g.children == null) continue;
            for (TreePatternNode child : g.children) {
                SmartPredicate<TreePatternNode.PatternWrapper> predicate = TreePatternNode.NegativeNaming.getPattern(child.naming);
                if (predicate != null && !predicate.isAll()) {
                    JBIterable<TreePatternNode.PatternWrapper> patterns2 = SmartPredicate.extractPositiveChecks(predicate);
                    for (TreePatternNode.PatternWrapper pattern : patterns2) {
                        DbNamespaceNode object = DbNamespacesTree.extractOrCreate(objects, DbNamespacesTree.getPatternKey(pattern), meta, pattern);
                        filters.add(object);
                        DbNamespacesTree.fillShadowChildren(child.groups, object);
                    }
                    continue;
                }
                if (DbNamespacesTree.isAll(child)) {
                    DbNamespaceNode object = (DbNamespaceNode)p2.getAllNode(meta);
                    if (object == null) continue;
                    DbNamespacesTree.fillShadowChildren(child.groups, object);
                    continue;
                }
                for (ObjectName name2 : child.naming.names) {
                    String n = name2.name;
                    DbNamespaceNode object = n.equals("@") ? p2.getCurNode() : (n.equals("*") ? (DbNamespaceNode)p2.getAllNode(meta) : DbNamespacesTree.processShadow(n, n, meta, processed, shadow, oldCache, objects));
                    if (object == null) continue;
                    DbNamespacesTree.fillShadowChildren(child.groups, object);
                }
            }
        }
        p2.setShadowChildren(shadow);
        p2.setFilterChildren(filters);
        for (DbNamespaceNode node : p2.getChildren()) {
            if (processed.contains(node)) continue;
            node.purgeShadow();
        }
    }

    private static DbNamespaceNode processShadow(@NotNull Object n, @NotNull String nm, @Nullable BasicMetaObject<?> meta, @NotNull Set<DbNamespaceNode> processed, @NotNull List<DbNamespaceNode> shadow, @NotNull Map<String, DbNamespaceNode> oldCache, @NotNull Map<String, DbNamespaceNode> objects) {
        DbNamespaceNode object;
        if (n == null) {
            DbNamespacesTree.$$$reportNull$$$0(2);
        }
        if (nm == null) {
            DbNamespacesTree.$$$reportNull$$$0(3);
        }
        if (processed == null) {
            DbNamespacesTree.$$$reportNull$$$0(4);
        }
        if (shadow == null) {
            DbNamespacesTree.$$$reportNull$$$0(5);
        }
        if (oldCache == null) {
            DbNamespacesTree.$$$reportNull$$$0(6);
        }
        if (objects == null) {
            DbNamespacesTree.$$$reportNull$$$0(7);
        }
        if ((object = objects.get(nm)) != null) {
            if (processed.add(object) && object.getObject() instanceof String) {
                shadow.add(object);
            }
        } else {
            object = DbNamespacesTree.extractOrCreate(oldCache, nm, meta, n);
            shadow.add(object);
        }
        return object;
    }

    @NotNull
    private static DbNamespaceNode extractOrCreate(@NotNull Map<String, DbNamespaceNode> oldCache, @NotNull String name2, @Nullable BasicMetaObject<?> meta, @NotNull Object n) {
        DbNamespaceNode object;
        if (oldCache == null) {
            DbNamespacesTree.$$$reportNull$$$0(8);
        }
        if (name2 == null) {
            DbNamespacesTree.$$$reportNull$$$0(9);
        }
        if (n == null) {
            DbNamespacesTree.$$$reportNull$$$0(10);
        }
        if ((object = oldCache.get(name2)) != null) {
            DbNamespaceNode dbNamespaceNode = object;
            if (dbNamespaceNode == null) {
                DbNamespacesTree.$$$reportNull$$$0(11);
            }
            return dbNamespaceNode;
        }
        return new DbNamespaceNode(name2, meta, n);
    }

    private static Map<String, DbNamespaceNode> mapByName(Iterable<DbNamespaceNode> children2) {
        HashMap<String, DbNamespaceNode> oldCache = new HashMap<String, DbNamespaceNode>();
        for (DbNamespaceNode node : children2) {
            if (node instanceof DbNamespaceNode.CurNode || node.getObject() == "*") continue;
            oldCache.put(DbNamespacesTree.getNodeKey(node), node);
        }
        return oldCache;
    }

    @NotNull
    public static TreePattern buildPattern(DbNamespaceNode node, boolean perm) {
        TreePatternNode rootNode = DbNamespacesTree.build(node, perm);
        return new TreePattern(rootNode.groups);
    }

    @NotNull
    public static TreePatternNode build(DbNamespaceNode node, boolean perm) {
        Map gg = FactoryMap.createMap(k -> new TreePatternUtils.GroupBuilder(), LinkedHashMap::new);
        for (DbNamespaceNode child : node.getChildNodes()) {
            ObjectKind kind;
            if (!child.isChecked() && (!perm || !(child.getObject() instanceof TreePatternNode.PatternWrapper)) || (kind = child.getKind()) == null) continue;
            TreePatternNode childNode = DbNamespacesTree.build(child, perm);
            ((TreePatternUtils.GroupBuilder)gg.get(kind)).add(childNode);
        }
        TreePatternUtils.NodeBuilder builder = new TreePatternUtils.NodeBuilder();
        for (Map.Entry entry : gg.entrySet()) {
            TreePatternUtils.GroupBuilder b = (TreePatternUtils.GroupBuilder)entry.getValue();
            b.deduplicate();
            builder.groups.add(b.build((ObjectKind)entry.getKey()));
        }
        TreePatternNode treePatternNode = builder.build(DbNamespacesTree.createNaming(node));
        if (treePatternNode == null) {
            DbNamespacesTree.$$$reportNull$$$0(12);
        }
        return treePatternNode;
    }

    @NotNull
    private static TreePatternNode.BaseNaming createNaming(DbNamespaceNode node) {
        Object object = node.getObject();
        if (object instanceof TreePatternNode.PatternWrapper) {
            return new TreePatternNode.NegativeNaming(SmartPredicate.create((TreePatternNode.PatternWrapper)object), new ObjectName[0]);
        }
        if (node instanceof DbNamespaceNode.CurNode) {
            return new TreePatternNode.PositiveNaming(DataSourceSchemaMapping.CURRENT_NAMESPACE_NAME);
        }
        if (object == "*" || node.getName() == null) {
            TreePatternNode.NegativeNaming negativeNaming = TreePatternNode.NegativeNaming.WILDCARD;
            if (negativeNaming == null) {
                DbNamespacesTree.$$$reportNull$$$0(13);
            }
            return negativeNaming;
        }
        return new TreePatternNode.PositiveNaming(ObjectName.quoted(node.getName()));
    }

    @Nullable
    public static String getNodeName(DbNamespaceNode n) {
        if (n instanceof DbNamespaceNode.CurNode) {
            return "@";
        }
        if (n.getObject() == "*") {
            return "*";
        }
        if (n.getObject() instanceof TreePatternNode.PatternWrapper) {
            return ((TreePatternNode.PatternWrapper)n.getObject()).getText();
        }
        return n.getName();
    }

    @Nullable
    public static String getNodeKey(DbNamespaceNode n) {
        Object object = n.getObject();
        if (object instanceof TreePatternNode.PatternWrapper) {
            TreePatternNode.PatternWrapper pw = (TreePatternNode.PatternWrapper)object;
            return DbNamespacesTree.getPatternKey(pw);
        }
        return DbNamespacesTree.getNodeName(n);
    }

    @NotNull
    public static String getPatternKey(TreePatternNode.PatternWrapper pw) {
        String string = "p\u0000" + pw.getText();
        if (string == null) {
            DbNamespacesTree.$$$reportNull$$$0(14);
        }
        return string;
    }

    public void recheck(DbNamespaceNode n, Iterable<TreePatternNode> pns) {
        for (DbNamespaceNode c2 : n.getChildNodes()) {
            HashSet<TreePatternNode> childPatterns = new HashSet<TreePatternNode>();
            JBIterable groups = JBIterable.from(pns).filterMap(pn -> pn.getGroup(c2.getKind()));
            Object object = c2.getObject();
            if ("*".equals(object)) {
                for (TreePatternNode.Group cg : groups) {
                    JBIterable.of((Object[])cg.children).filter(cn -> DbNamespacesTree.isAll(cn)).addAllTo(childPatterns);
                }
            } else {
                Object object2 = c2.getObject();
                if (object2 instanceof TreePatternNode.PatternWrapper) {
                    TreePatternNode.PatternWrapper pattern = (TreePatternNode.PatternWrapper)object2;
                    for (TreePatternNode.Group cg : groups) {
                        JBIterable.of((Object[])cg.children).filter(cn -> SmartPredicate.extractPositiveChecks(TreePatternNode.NegativeNaming.getPattern(cn.naming)).contains((Object)pattern)).addAllTo(childPatterns);
                    }
                } else {
                    String name2 = DbNamespacesTree.getNodeName(c2);
                    for (TreePatternNode.Group cg : groups) {
                        cg.matchedChildren(ObjectName.quoted(name2), Casing.EXACT, childPatterns);
                    }
                    childPatterns.removeIf(p2 -> p2.naming instanceof TreePatternNode.NegativeNaming);
                }
            }
            c2.setChecked(!childPatterns.isEmpty());
            this.recheck(c2, childPatterns);
        }
    }

    private static boolean isAll(TreePatternNode cn) {
        SmartPredicate<TreePatternNode.PatternWrapper> pattern = TreePatternNode.NegativeNaming.getPattern(cn.naming);
        return pattern != null && pattern.isAll();
    }

    private static JBIterable<BasicNamespace> getNamespaces(@NotNull BasicElement el) {
        if (el == null) {
            DbNamespacesTree.$$$reportNull$$$0(15);
        }
        return el.getChildren().filter(BasicNamespace.class);
    }

    public void setSkipSpecForRoot(boolean skipSpecForRoot) {
        this.mySkipSpecForRoot = skipSpecForRoot;
    }

    @Nls
    @NotNull
    public static String getCurrentNodeText(DbNamespaceNode node) {
        String string = DatabaseBundle.message("data.source.scope.editor.tree.current.node.pattern", DbNamespacesTree.getKindPresentableName(node, false));
        if (string == null) {
            DbNamespacesTree.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Nls
    @NotNull
    public static String getAllNodeText(DbNamespaceNode node) {
        String string = DatabaseBundle.message("data.source.scope.editor.tree.all.node.pattern", DbNamespacesTree.getKindPresentableName(node, true));
        if (string == null) {
            DbNamespacesTree.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Nls
    @NotNull
    private static String getKindPresentableName(@NotNull DbNamespaceNode node, boolean plural) {
        if (node == null) {
            DbNamespacesTree.$$$reportNull$$$0(18);
        }
        ObjectKind kind = (ObjectKind)ObjectUtils.notNull((Object)node.getKind(), (Object)ObjectKind.NONE);
        BasicMetaObject<?> meta = node.getMeta();
        Dbms dbms = meta == null ? Dbms.UNKNOWN : meta.getModel().dbms;
        String string = ModelFacade.forDbms(dbms).getModelHelper().getName(kind, plural);
        if (string == null) {
            DbNamespacesTree.$$$reportNull$$$0(19);
        }
        return string;
    }

    public static boolean matches(Couple<String> fsc, DbNamespaceNode node) {
        return DbImplUtilCore.isDatabase(node.getKind()) ? DbNamespacesTree.matches(fsc, node.getName(), null) : DbNamespacesTree.matches(fsc, DbNamespacesTree.getParentName(node), node.getName());
    }

    @Nullable
    public static String getParentName(DbNamespaceNode node) {
        DbNamespaceNode parent = (DbNamespaceNode)node.getParent();
        return parent != null && DbImplUtilCore.isDatabase(parent.getKind()) ? parent.getName() : null;
    }

    public static boolean matches(Couple<String> fsc, String pName, String name2) {
        return fsc != null && Objects.equals(fsc.first, pName) && (name2 == null || Objects.equals(fsc.second, name2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 13, 14, 16, 17, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nm";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processed";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shadow";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldCache";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DbNamespacesTree";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DbNamespacesTree";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "extractOrCreate";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createNaming";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternKey";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentNodeText";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllNodeText";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getKindPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addNodes";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fillShadowChildren";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processShadow";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "extractOrCreate";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaces";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getKindPresentableName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 13, 14, 16, 17, 19 -> new IllegalStateException(string);
        };
    }
}

