/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.util.Casing;
import com.intellij.database.util.ObjectPart;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.Interner;
import com.intellij.util.containers.WeakInterner;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectPath
extends ObjectPart {
    public static final Comparator<ObjectPath> PATH_COMPARATOR = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return StringUtil.naturalCompare((String)o1.getDisplayName(), (String)o2.getDisplayName());
    };
    private static final Interner<ObjectPath> ourInterner = new WeakInterner((HashingStrategy)new HashingStrategy<ObjectPath>(){

        public int hashCode(ObjectPath object) {
            int result2 = System.identityHashCode(object.parent);
            result2 = 31 * result2 + Boolean.hashCode(object.isStepUp());
            result2 = 31 * result2 + ObjectPart.hc(object);
            return result2;
        }

        public boolean equals(ObjectPath o1, ObjectPath o2) {
            if (o1 == o2 || o1 == null || o2 == null) {
                return o1 == o2;
            }
            return o1.parent == o2.parent && o1.isStepUp() == o2.isStepUp() && o1.matches(o2);
        }
    });
    public static final ObjectPath ROOT = ObjectPath.create("", ObjectKind.ROOT);
    public static final ObjectPath CURRENT = ObjectPath.createInterned(".", ObjectKind.NONE, true, null, false, null);
    public final ObjectPath parent;
    private final int depth;
    private static final List<String> TO_ESCAPE = Arrays.asList("/", "&", "\"", ":");
    private static final List<String> TO_UNESCAPE = Arrays.asList("&eslash;", "&amp;", "&quot;", "&colon;");

    private ObjectPath(@NotNull String name2, @NotNull ObjectKind kind, @Nullable ObjectPath parent) {
        if (name2 == null) {
            ObjectPath.$$$reportNull$$$0(0);
        }
        if (kind == null) {
            ObjectPath.$$$reportNull$$$0(1);
        }
        super(name2, kind);
        this.parent = parent;
        this.depth = parent == null ? 1 : parent.depth + 1;
    }

    @NotNull
    public ObjectPath append(@NotNull String name2, @NotNull ObjectKind kind) {
        if (name2 == null) {
            ObjectPath.$$$reportNull$$$0(2);
        }
        if (kind == null) {
            ObjectPath.$$$reportNull$$$0(3);
        }
        ObjectPath objectPath = ObjectPath.create(name2, kind, true, null, this);
        if (objectPath == null) {
            ObjectPath.$$$reportNull$$$0(4);
        }
        return objectPath;
    }

    public ObjectPath append(@NotNull String name2, @NotNull ObjectKind kind, boolean quoted, String identity) {
        if (name2 == null) {
            ObjectPath.$$$reportNull$$$0(5);
        }
        if (kind == null) {
            ObjectPath.$$$reportNull$$$0(6);
        }
        return ObjectPath.create(name2, kind, quoted, identity, this);
    }

    public boolean isStepUp() {
        return false;
    }

    public int getSize() {
        return this.depth;
    }

    @Nullable
    public ObjectPath getParent(int steps) {
        ObjectPath result2 = this;
        for (int i2 = steps; i2 > 0 && result2 != null; --i2) {
            result2 = result2.parent;
        }
        return result2;
    }

    @Nullable
    public ObjectPath getParentAtDepth(int depth) {
        ObjectPath result2 = this;
        while (result2 != null && result2.getSize() > depth) {
            result2 = result2.parent;
        }
        return result2 != null && result2.getSize() == depth ? result2 : null;
    }

    @Nullable
    public ObjectPath findParent(ObjectKind kind, boolean strict) {
        ObjectPath p2;
        ObjectPath objectPath = p2 = strict ? this.parent : this;
        while (p2 != null) {
            if (p2.kind == kind) {
                return p2;
            }
            p2 = p2.parent;
        }
        return null;
    }

    public boolean isAncestorOf(@Nullable ObjectPath child, boolean strict) {
        if (strict && this == child) {
            return false;
        }
        while (child != null && child != this) {
            child = child.parent;
        }
        return this == child;
    }

    @Nullable
    public ObjectPath getCommonAncestor(@Nullable ObjectPath other) {
        int os;
        if (other == null) {
            return null;
        }
        ObjectPath self = this;
        int s = self.getSize();
        if (s < (os = other.getSize())) {
            other = other.getParentAtDepth(s);
        } else if (s > os) {
            self = self.getParentAtDepth(os);
        }
        while (self != other) {
            if (self == null || other == null) {
                return null;
            }
            self = self.parent;
            other = other.parent;
        }
        return self;
    }

    @NlsSafe
    @NotNull
    public String getDisplayName() {
        String string = this.reduce(new StringBuilder(), (sb, p2) -> (!sb.isEmpty() && !p2.name.isEmpty() ? sb.append(".") : sb).append(p2.name)).toString();
        if (string == null) {
            ObjectPath.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            ObjectPath.$$$reportNull$$$0(8);
        }
        return string;
    }

    public <T> T reduce(T t, @NotNull BiFunction<T, ObjectPath, T> reducer) {
        if (reducer == null) {
            ObjectPath.$$$reportNull$$$0(9);
        }
        T result2 = t;
        if (this.parent != null) {
            result2 = this.parent.reduce(t, reducer);
        }
        return reducer.apply(result2, this);
    }

    @NotNull
    public ObjectPath appendPart(@NotNull ObjectPart o) {
        if (o == null) {
            ObjectPath.$$$reportNull$$$0(10);
        }
        ObjectPath objectPath = this.append(o.name, o.kind, o.isQuoted(), o.getIdentity());
        if (objectPath == null) {
            ObjectPath.$$$reportNull$$$0(11);
        }
        return objectPath;
    }

    @NotNull
    public static ObjectPath create(@NotNull String name2, @NotNull ObjectKind kind) {
        if (name2 == null) {
            ObjectPath.$$$reportNull$$$0(12);
        }
        if (kind == null) {
            ObjectPath.$$$reportNull$$$0(13);
        }
        ObjectPath objectPath = ObjectPath.create(name2, kind, true, null, null);
        if (objectPath == null) {
            ObjectPath.$$$reportNull$$$0(14);
        }
        return objectPath;
    }

    public static ObjectPath create(@NotNull String name2, @NotNull ObjectKind kind, boolean quoted, @Nullable String identity, @Nullable ObjectPath parent) {
        if (name2 == null) {
            ObjectPath.$$$reportNull$$$0(15);
        }
        if (kind == null) {
            ObjectPath.$$$reportNull$$$0(16);
        }
        return ObjectPath.createInterned(name2, kind, quoted, identity, false, parent);
    }

    public static ObjectPath createStepUp(@NotNull ObjectKind kind, @NotNull ObjectPath parent) {
        if (kind == null) {
            ObjectPath.$$$reportNull$$$0(17);
        }
        if (parent == null) {
            ObjectPath.$$$reportNull$$$0(18);
        }
        return ObjectPath.createInterned("..", kind, true, null, true, parent);
    }

    public static ObjectPath copyUnder(@NotNull ObjectPath child, @Nullable ObjectPath parent) {
        if (child == null) {
            ObjectPath.$$$reportNull$$$0(19);
        }
        return ObjectPath.create(child.name, child.kind, child.isQuoted(), child.getIdentity(), parent);
    }

    @NotNull
    private static ObjectPath createInterned(@NotNull String name2, @NotNull ObjectKind kind, boolean quoted, @Nullable String identity, boolean stepUp, @Nullable ObjectPath parent) {
        if (name2 == null) {
            ObjectPath.$$$reportNull$$$0(20);
        }
        if (kind == null) {
            ObjectPath.$$$reportNull$$$0(21);
        }
        ObjectPath objectPath = (ObjectPath)ourInterner.intern((Object)ObjectPath.prepare(name2, kind, quoted, identity, stepUp, parent));
        if (objectPath == null) {
            ObjectPath.$$$reportNull$$$0(22);
        }
        return objectPath;
    }

    @NotNull
    private static ObjectPath prepare(@NotNull String name2, @NotNull ObjectKind kind, boolean quoted, final @Nullable String identity, boolean stepUp, @Nullable ObjectPath parent) {
        if (name2 == null) {
            ObjectPath.$$$reportNull$$$0(23);
        }
        if (kind == null) {
            ObjectPath.$$$reportNull$$$0(24);
        }
        if (stepUp) {
            return new ObjectPath(name2, kind, parent){

                @Override
                public boolean isStepUp() {
                    return true;
                }
            };
        }
        if (quoted && identity == null) {
            return new ObjectPath(name2, kind, parent);
        }
        if (identity == null) {
            return new ObjectPath(name2, kind, parent){

                @Override
                public boolean isQuoted() {
                    return false;
                }
            };
        }
        if (quoted) {
            return new ObjectPath(name2, kind, parent){

                @Override
                public String getIdentity() {
                    return identity;
                }
            };
        }
        return new ObjectPath(name2, kind, parent){

            @Override
            public boolean isQuoted() {
                return false;
            }

            @Override
            public String getIdentity() {
                return identity;
            }
        };
    }

    @NotNull
    public static ObjectPath create(@NotNull ObjectKind kind, @NotNull Iterable<String> names) {
        if (kind == null) {
            ObjectPath.$$$reportNull$$$0(25);
        }
        if (names == null) {
            ObjectPath.$$$reportNull$$$0(26);
        }
        ObjectPath result2 = null;
        Iterator<String> it = names.iterator();
        while (it.hasNext()) {
            result2 = ObjectPath.create(it.next(), !it.hasNext() ? kind : ObjectKind.NONE, true, null, result2);
        }
        ObjectPath objectPath = Objects.requireNonNull(result2);
        if (objectPath == null) {
            ObjectPath.$$$reportNull$$$0(27);
        }
        return objectPath;
    }

    public <T extends Throwable> void forEach(@NotNull ThrowableConsumer<ObjectPath, T> r) throws T {
        if (r == null) {
            ObjectPath.$$$reportNull$$$0(28);
        }
        ObjectPath.forEachInner(this, r);
    }

    private static <T extends Throwable> void forEachInner(@NotNull ObjectPath p2, @NotNull ThrowableConsumer<ObjectPath, T> r) throws T {
        if (p2 == null) {
            ObjectPath.$$$reportNull$$$0(29);
        }
        if (r == null) {
            ObjectPath.$$$reportNull$$$0(30);
        }
        if (p2.parent != null) {
            ObjectPath.forEachInner(p2.parent, r);
        }
        r.consume((Object)p2);
    }

    public ObjectPath rebase(ObjectPath base) {
        return this.reduce(null, (r, o) -> o.kind == base.kind ? base : o.withParent((ObjectPath)r));
    }

    public ObjectPath withParent(ObjectPath p2) {
        return this.parent == p2 ? this : ObjectPath.create(this.name, this.kind, this.isQuoted(), this.getIdentity(), p2);
    }

    public String toString() {
        String id = this.getIdentity();
        return (String)(this.parent != null ? String.valueOf(this.parent) + "/" : "") + (String)(this.kind == ObjectKind.NONE ? "" : this.kind.name() + ":") + this.name + (String)(id == null ? "" : "@" + id);
    }

    @NotNull
    public String serialize() {
        String string = this.reduce(new StringBuilder(), (b, p2) -> {
            if (!b.isEmpty()) {
                b.append("/");
            }
            if (p2.isStepUp() || p2 == CURRENT) {
                b.append("#");
            }
            b.append(ObjectPath.escape(p2.kind.code())).append("/");
            if (p2.isQuoted()) {
                b.append('\"');
            }
            b.append(ObjectPath.escape(p2.name));
            if (p2.isQuoted()) {
                b.append('\"');
            }
            if (p2.getIdentity() != null) {
                b.append(ObjectPath.escape(p2.getIdentity()));
            }
            return b;
        }).toString();
        if (string == null) {
            ObjectPath.$$$reportNull$$$0(31);
        }
        return string;
    }

    @Nullable
    public static ObjectPath deserialize(@NotNull String s) {
        if (s == null) {
            ObjectPath.$$$reportNull$$$0(32);
        }
        ObjectPath result2 = null;
        ObjectKind kind = null;
        boolean rel = false;
        for (String chunk : StringUtil.split((String)s, (String)"/", (boolean)true, (boolean)false)) {
            boolean quoted;
            String id;
            if (kind == null) {
                rel = chunk.startsWith("#");
                kind = ObjectKind.getKind(ObjectPath.unescape(rel ? chunk.substring(1) : chunk));
                if (kind != null) continue;
                kind = ObjectKind.NONE;
                continue;
            }
            int idIdx = chunk.indexOf(":");
            String string = id = idIdx == -1 ? null : ObjectPath.unescape(chunk.substring(idIdx + 1));
            if (idIdx != -1) {
                chunk = chunk.substring(0, idIdx);
            }
            boolean bl = quoted = chunk.startsWith("\"") && chunk.endsWith("\"");
            if (quoted) {
                chunk = chunk.substring(1, chunk.length() - 1);
            }
            String name2 = ObjectPath.unescape(chunk);
            result2 = result2 == null && rel ? CURRENT : ObjectPath.createInterned(name2, kind, quoted, id, rel, result2);
            kind = null;
            rel = false;
        }
        if (kind != null) {
            result2 = ObjectPath.create("", kind, true, null, result2);
        }
        return result2;
    }

    private static String escape(String s) {
        return StringUtil.replace((String)s, TO_ESCAPE, TO_UNESCAPE);
    }

    private static String unescape(String s) {
        return StringUtil.replace((String)s, TO_UNESCAPE, TO_ESCAPE);
    }

    public static boolean namesEqual(@Nullable ObjectPath p1, @Nullable ObjectPath p2, @NotNull CasingProvider casingProvider) {
        if (casingProvider == null) {
            ObjectPath.$$$reportNull$$$0(33);
        }
        return p1 == null || p2 == null ? p1 == p2 : ObjectName.namesEqual(p1.name, casingProvider.getCasing(p1.kind, null).choose(!p1.isQuoted()), p2.name, casingProvider.getCasing(p2.kind, null).choose(!p2.isQuoted()));
    }

    public static boolean namesEqual(@Nullable ObjectPath p1, @Nullable ObjectPath p2, @NotNull Casing casing) {
        if (casing == null) {
            ObjectPath.$$$reportNull$$$0(34);
        }
        return p1 == null || p2 == null ? p1 == p2 : ObjectName.namesEqual(p1.name, casing.choose(!p1.isQuoted()), p2.name, casing.choose(!p2.isQuoted()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 8, 11, 14, 22, 27, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 13: 
            case 16: 
            case 17: 
            case 21: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 22: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/ObjectPath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reducer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casingProvider";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/ObjectPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "append";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "appendPart";
                break;
            }
            case 14: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createInterned";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "serialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 22: 
            case 27: 
            case 31: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "reduce";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "appendPart";
                break;
            }
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createStepUp";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "copyUnder";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createInterned";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "forEachInner";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "namesEqual";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 8, 11, 14, 22, 27, 31 -> new IllegalStateException(string);
        };
    }
}

