/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.properties.references;

import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.NameValueGetter;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaReferenceDesc;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.meta.BasicResolveAssistant;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.ObjectPaths;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicNameReference
implements BasicReference {
    public final String name;

    private BasicNameReference(@NotNull String name2) {
        if (name2 == null) {
            BasicNameReference.$$$reportNull$$$0(0);
        }
        this.name = DbUtil.intern(name2);
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isCrossPortable() {
        return true;
    }

    public boolean isUnrestricted() {
        return false;
    }

    @Nullable
    public String getIdentity() {
        return null;
    }

    @NotNull
    protected ObjectKind getForcedKind() {
        ObjectKind objectKind = ObjectKind.NONE;
        if (objectKind == null) {
            BasicNameReference.$$$reportNull$$$0(1);
        }
        return objectKind;
    }

    @Override
    @NotNull
    public ObjectKind getKind(@NotNull BasicMetaReferenceDesc<?, ?> meta) {
        ObjectKind kind;
        if (meta == null) {
            BasicNameReference.$$$reportNull$$$0(2);
        }
        ObjectKind objectKind = (kind = this.getForcedKind()) == ObjectKind.NONE ? BasicReference.super.getKind(meta) : kind;
        if (objectKind == null) {
            BasicNameReference.$$$reportNull$$$0(3);
        }
        return objectKind;
    }

    @Override
    public long getObjectId() {
        return Long.MIN_VALUE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BasicNameReference)) {
            return false;
        }
        BasicNameReference reference = (BasicNameReference)o;
        return this.name.equals(reference.name) && this.isPlain() == reference.isPlain() && this.isUnrestricted() == reference.isUnrestricted();
    }

    public int hashCode() {
        return Objects.hash(this.name, this.isPlain(), this.isUnrestricted());
    }

    @Nullable
    public static BasicNameReference create(@Nullable String name2) {
        return BasicNameReference.create(name2, false);
    }

    @Nullable
    public static BasicNameReference create(@Nullable String name2, ObjectKind forcedKind) {
        return BasicNameReference.create(name2, false, false, forcedKind);
    }

    @Nullable
    public static BasicNameReference create(@Nullable String name2, boolean plain) {
        return BasicNameReference.create(name2, plain, false);
    }

    @Nullable
    public static BasicNameReference create(@Nullable String name2, boolean plain, boolean unrestricted) {
        return BasicNameReference.create(name2, plain, unrestricted, ObjectKind.NONE);
    }

    @Nullable
    public static BasicNameReference create(@Nullable String name2, boolean plain, boolean unrestricted, ObjectKind forcedKind) {
        return BasicNameReference.create(name2, plain, unrestricted, forcedKind, null);
    }

    @Nullable
    public static BasicNameReference create(@NotNull DasObject object) {
        if (object == null) {
            BasicNameReference.$$$reportNull$$$0(4);
        }
        return BasicNameReference.create(object.getName(), !DbSqlUtilCore.isQuoted(object), false, ObjectKind.NONE, ObjectPaths.getIdentity(object));
    }

    @Nullable
    public static BasicNameReference create(@Nullable String name2, final boolean plain, final boolean unrestricted, final ObjectKind forcedKind, final @Nullable String identity) {
        if (BasicNameReference.isDefault(name2) && identity == null && !plain) {
            return null;
        }
        if (name2 == null) {
            name2 = "";
        }
        if (forcedKind != ObjectKind.NONE || identity != null) {
            return new BasicNameReference(name2){

                @Override
                @Nullable
                public String getIdentity() {
                    return identity;
                }

                @Override
                public boolean isUnrestricted() {
                    return unrestricted;
                }

                @Override
                public boolean isPlain() {
                    return plain;
                }

                @Override
                @NotNull
                protected ObjectKind getForcedKind() {
                    ObjectKind objectKind = forcedKind;
                    if (objectKind == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return objectKind;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/properties/references/BasicNameReference$1", "getForcedKind"));
                }
            };
        }
        if (unrestricted) {
            if (plain) {
                return new BasicNameReference(name2){

                    @Override
                    public boolean isUnrestricted() {
                        return true;
                    }
                };
            }
            return new BasicNameReference(name2){

                @Override
                public boolean isUnrestricted() {
                    return true;
                }

                @Override
                public boolean isPlain() {
                    return true;
                }
            };
        }
        if (plain) {
            return new BasicNameReference(name2){

                @Override
                public boolean isPlain() {
                    return true;
                }
            };
        }
        return new BasicNameReference(name2);
    }

    public static boolean isDefault(@Nullable String name2) {
        return name2 == null || name2.isEmpty();
    }

    @Override
    @NotNull
    public <S extends BasicElement, T extends BasicElement> JBIterable<T> multiResolve(@NotNull S source, @NotNull BasicMetaReferenceDesc<S, T> meta, @NotNull BasicResolveAssistant assistant) {
        if (source == null) {
            BasicNameReference.$$$reportNull$$$0(5);
        }
        if (meta == null) {
            BasicNameReference.$$$reportNull$$$0(6);
        }
        if (assistant == null) {
            BasicNameReference.$$$reportNull$$$0(7);
        }
        JBIterable<T> jBIterable = this.multiResolve(source, meta, this.isUnrestricted(), assistant);
        if (jBIterable == null) {
            BasicNameReference.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    @NotNull
    public <S extends BasicElement, T extends BasicElement> JBIterable<T> multiResolve(@NotNull S source, @NotNull BasicMetaReferenceDesc<S, T> meta, boolean unrestricted, @NotNull BasicResolveAssistant assistant) {
        BasicElement root;
        if (source == null) {
            BasicNameReference.$$$reportNull$$$0(9);
        }
        if (meta == null) {
            BasicNameReference.$$$reportNull$$$0(10);
        }
        if (assistant == null) {
            BasicNameReference.$$$reportNull$$$0(11);
        }
        BasicMetaObject<? extends T>[] targets = this.filteredTargets(meta.targets);
        BasicElement base = BasicMetaUtils.getResolveBase(source, meta, assistant);
        if (base == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                BasicNameReference.$$$reportNull$$$0(12);
            }
            return jBIterable;
        }
        BasicElement basicElement = unrestricted ? (meta.getBaseRef() == null ? assistant.getRoot(base, meta.getScope()) : base) : (root = assistant.getRestrictedRoot(base, 1, targets));
        if (root == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                BasicNameReference.$$$reportNull$$$0(13);
            }
            return jBIterable;
        }
        String identity = this.getIdentity();
        JBIterable res2 = assistant.findAllByNameInScope(root, this.name, targets);
        JBIterable jBIterable = identity == null ? res2 : res2.filter(o -> identity.equals(BasicPaths.getIdentity(o)));
        if (jBIterable == null) {
            BasicNameReference.$$$reportNull$$$0(14);
        }
        return jBIterable;
    }

    @Override
    public <S extends BasicElement, T extends BasicElement> boolean matches(@NotNull S source, @NotNull BasicMetaReferenceDesc<S, T> meta, @NotNull T target2) {
        ObjectKind forced;
        if (source == null) {
            BasicNameReference.$$$reportNull$$$0(15);
        }
        if (meta == null) {
            BasicNameReference.$$$reportNull$$$0(16);
        }
        if (target2 == null) {
            BasicNameReference.$$$reportNull$$$0(17);
        }
        if ((forced = this.getForcedKind()) != ObjectKind.NONE && forced != target2.getKind()) {
            return false;
        }
        if (!this.nameMatches(target2)) {
            return false;
        }
        String id = this.getIdentity();
        return id == null || id.equals(BasicPaths.getIdentity(target2));
    }

    private <T extends BasicElement> boolean nameMatches(@NotNull T target2) {
        CasingProvider p2;
        if (target2 == null) {
            BasicNameReference.$$$reportNull$$$0(18);
        }
        if ((p2 = DasUtil.getParentOfClass(target2, CasingProvider.class, false)) == null) {
            p2 = target2.getModel();
        }
        if (p2 == null) {
            p2 = DasUtil.NO_CASING_PROVIDER;
        }
        Casing casing = p2.getCasing(target2.getKind(), target2);
        Case c2 = casing.choose(this.isPlain() || !DbSqlUtilCore.isQuoted(target2));
        return Comparing.equal((String)this.name, (String)target2.getName(), (c2 == Case.EXACT ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    public <T extends BasicElement> BasicMetaObject<? extends T>[] filteredTargets(BasicMetaObject<? extends T>[] targets) {
        void var7_10;
        ObjectKind forcedKind = this.getForcedKind();
        if (forcedKind == ObjectKind.NONE) {
            return targets;
        }
        int cnt = 0;
        for (BasicMetaObject<T> basicMetaObject : targets) {
            if (!BasicNameReference.isAccepted(basicMetaObject, forcedKind)) continue;
            ++cnt;
        }
        if (cnt == targets.length) {
            return targets;
        }
        BasicMetaObject[] filtered = new BasicMetaObject[cnt];
        cnt = 0;
        BasicMetaObject<? extends T>[] basicMetaObjectArray = targets;
        int n = basicMetaObjectArray.length;
        boolean bl = false;
        while (var7_10 < n) {
            BasicMetaObject<T> basicMetaObject = basicMetaObjectArray[var7_10];
            if (BasicNameReference.isAccepted(basicMetaObject, forcedKind)) {
                filtered[cnt] = basicMetaObject;
                ++cnt;
            }
            ++var7_10;
        }
        return filtered;
    }

    private static boolean isAccepted(BasicMetaObject<?> target2, ObjectKind forcedKind) {
        return target2.kind == forcedKind || target2.kind == ObjectKind.SYNONYM;
    }

    @Override
    public void exportProperties(@NotNull NameValueConsumer<? super String> consumer) {
        String identity;
        ObjectKind forcedKind;
        if (consumer == null) {
            BasicNameReference.$$$reportNull$$$0(19);
        }
        BasicNameReference.exportName(this.name, "Name", consumer);
        if (this.isPlain()) {
            consumer.accept("Plain", "true");
        }
        if (this.isUnrestricted()) {
            consumer.accept("Unrestricted", "true");
        }
        if ((forcedKind = this.getForcedKind()) != ObjectKind.NONE) {
            consumer.accept("Kind", forcedKind.code());
        }
        if ((identity = this.getIdentity()) != null) {
            consumer.accept("Identity", identity);
        }
    }

    @Override
    public boolean isEquivalent(BasicReference ref2) {
        return StringUtil.equals((CharSequence)this.name, (CharSequence)ref2.getName());
    }

    @Nullable
    public static BasicNameReference importProperties(@NotNull NameValueGetter<String> properties2) {
        if (properties2 == null) {
            BasicNameReference.$$$reportNull$$$0(20);
        }
        return BasicNameReference.create(BasicNameReference.importName("Name", properties2), BasicNameReference.isPlain(properties2), BasicNameReference.isUnrestricted(properties2), BasicNameReference.getForcedKind(properties2), properties2.get("Identity"));
    }

    static boolean isPlain(@NotNull NameValueGetter<String> properties2) {
        if (properties2 == null) {
            BasicNameReference.$$$reportNull$$$0(21);
        }
        return "true".equals(properties2.get("Plain"));
    }

    static boolean isUnrestricted(@NotNull NameValueGetter<String> properties2) {
        if (properties2 == null) {
            BasicNameReference.$$$reportNull$$$0(22);
        }
        return "true".equals(properties2.get("Unrestricted"));
    }

    static ObjectKind getForcedKind(@NotNull NameValueGetter<String> properties2) {
        String code;
        if (properties2 == null) {
            BasicNameReference.$$$reportNull$$$0(23);
        }
        ObjectKind res2 = (code = properties2.get("Kind")) == null ? null : ObjectKind.getKind(code);
        return res2 == null ? ObjectKind.NONE : res2;
    }

    @NotNull
    public static String importName(String propName, @NotNull NameValueGetter<String> properties2) {
        String name2;
        if (properties2 == null) {
            BasicNameReference.$$$reportNull$$$0(24);
        }
        String string = (name2 = properties2.get(propName)) == null ? "" : name2;
        if (string == null) {
            BasicNameReference.$$$reportNull$$$0(25);
        }
        return string;
    }

    public static void exportName(String name2, String propName, @NotNull NameValueConsumer<? super String> consumer) {
        if (consumer == null) {
            BasicNameReference.$$$reportNull$$$0(26);
        }
        if (!BasicNameReference.isDefault(name2)) {
            consumer.accept(propName, name2);
        }
    }

    public String toString() {
        return "name=" + this.name + (this.isPlain() ? "; plain" : "") + (this.isUnrestricted() ? "; unrestricted" : "") + (String)(this.getForcedKind() != ObjectKind.NONE ? "; kind=" + this.getForcedKind().code() : "") + (String)(this.getIdentity() != null ? "; identity=" + this.getIdentity() : "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 8, 12, 13, 14, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/properties/references/BasicNameReference";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 5: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assistant";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 19: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/properties/references/BasicNameReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getForcedKind";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 8: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "importName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 25: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getKind";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "multiResolve";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "nameMatches";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isPlain";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isUnrestricted";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getForcedKind";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "importName";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "exportName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 8, 12, 13, 14, 25 -> new IllegalStateException(string);
        };
    }
}

