/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.model;

import com.intellij.database.dialects.oracle.model.OraBody;
import com.intellij.database.dialects.oracle.model.OraForeignKey;
import com.intellij.database.dialects.oracle.model.OraInnerRoutine;
import com.intellij.database.dialects.oracle.model.OraMatLog;
import com.intellij.database.dialects.oracle.model.OraMatView;
import com.intellij.database.dialects.oracle.model.OraModule;
import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.dialects.oracle.model.OraSchemaObject;
import com.intellij.database.dialects.oracle.model.OraSequence;
import com.intellij.database.dialects.oracle.model.OraSourceAware;
import com.intellij.database.dialects.oracle.model.OraTable;
import com.intellij.database.dialects.oracle.model.OraTableColumn;
import com.intellij.database.dialects.oracle.model.OraTrigger;
import com.intellij.database.dialects.oracle.model.properties.OraTableType;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicMixinElement;
import com.intellij.database.model.basic.GeneratedModelUtil;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.BasicReferenceInfo;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.util.ObjectNamePart;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraGeneratedModelUtil
extends GeneratedModelUtil {
    public static void setSubstituted(@NotNull OraSchema nsp) {
        if (nsp == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(0);
        }
        OraGeneratedModelUtil.setSubstituted(nsp);
        nsp.setLastIntrospectionServerTimestamp(null);
        nsp.setLastIntrospectionL3Timestamp(null);
        nsp.setLastIntrospectionL2Timestamp(null);
        nsp.setLastIntrospectionL1Timestamp(null);
        nsp.setDbLinksHash(0L);
        nsp.setCommentsHash(0L);
    }

    public static List<String> getRefColNames(OraForeignKey fk) {
        return OraGeneratedModelUtil.getRefColNamesByKey(fk);
    }

    public static void setRefColNames(OraForeignKey fk, List<String> names) {
        OraGeneratedModelUtil.setRefColNamesByKey(fk, names);
    }

    public static void handleRename(@NotNull OraModule m, @NotNull ObjectNamePart oldName) {
        if (m == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(1);
        }
        if (oldName == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(2);
        }
        GeneratedModelUtil.handleRename(m, oldName);
        for (OraBody oraBody : m.getBodies()) {
            GeneratedModelUtil.handleRename(oraBody, oldName);
        }
    }

    public static SequenceIdentity getSequenceIdentity(OraTableColumn column2) {
        OraSequence sequence = column2.getSequence();
        BasicReference ref2 = column2.getSequenceRef();
        if (sequence != null) {
            return sequence.getSequenceIdentity();
        }
        return ref2 == null ? null : SequenceIdentity.UNKNOWN;
    }

    public static void setSequenceIdentity(OraTableColumn column2, SequenceIdentity identity) {
        if (identity == null) {
            column2.setSequenceRef(null);
        } else if (column2.getSequenceRef() == null) {
            column2.setSequenceRef(OraGeneratedModelUtil.generateSequenceRef(column2));
        }
    }

    @Nullable
    public static BasicNameReference generateSequenceRef(OraTableColumn column2) {
        return BasicNameReference.create(OraGeneratedModelUtil.generateSequenceName(column2));
    }

    public static String generateSequenceName(OraTableColumn column2) {
        OraTable table = column2.getTable();
        if (table != null && table.getObjectId() != Long.MIN_VALUE) {
            return "ISEQ$$_" + table.getObjectId();
        }
        return "???";
    }

    @NotNull
    public static Iterable<? extends BasicElement> getPredecessors(@NotNull OraSourceAware element) {
        if (element == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(3);
        }
        BasicDatabase database = BasicMixinElement.parent(element, BasicDatabase.class);
        JBIterable jBIterable = JBIterable.from(element.getDependsOnIds()).map(objectId -> database.findIdentifiedElement((long)objectId, OraSchemaObject.class)).filter(e -> e != null);
        if (jBIterable == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    @NotNull
    public static Iterable<? extends BasicElement> getPredecessors(@NotNull OraTrigger element) {
        if (element == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(5);
        }
        JBIterable jBIterable = JBIterable.from(OraGeneratedModelUtil.getPredecessors((OraSourceAware)element)).append(OraGeneratedModelUtil.getPredecessors(element));
        if (jBIterable == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    public static boolean isElementSurrogate(@NotNull OraTableColumn element) {
        OraTable table;
        if (element == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(7);
        }
        return (table = element.getTable()) != null && table.getTableType() == OraTableType.MAT_LOG && element.getName().endsWith("$$");
    }

    public static boolean isElementSurrogate(@NotNull OraSequence sequence) {
        if (sequence == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(8);
        }
        return sequence.isBelongsToColumn();
    }

    public static int getDisplayOrder(@NotNull OraBody e1, @NotNull OraBody e2) {
        if (e1 == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(9);
        }
        if (e2 == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(10);
        }
        return 0;
    }

    public static int getDisplayOrder(@NotNull OraTable e1, @NotNull OraBody e2) {
        if (e1 == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(11);
        }
        if (e2 == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(12);
        }
        String id1 = e1.identity(false);
        String id2 = e2.identity(false);
        return Comparing.compare((Comparable)((Object)id1), (Comparable)((Object)id2));
    }

    public static boolean getAutoCreated(@NotNull OraTable element) {
        if (element == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(13);
        }
        return switch (element.getTableType()) {
            default -> throw new IncompatibleClassChangeError();
            case OraTableType.MAT_LOG, OraTableType.MAT_LOG_TEMP -> true;
            case OraTableType.MAT_VIEW -> {
                OraSchema schema = element.getSchema();
                if (schema == null) {
                    yield false;
                }
                OraMatView mv = (OraMatView)schema.getMatViews().get(element.getName());
                if (mv == null) {
                    yield false;
                }
                if (!mv.isPrebuilt()) {
                    yield true;
                }
                yield false;
            }
            case OraTableType.BASIC -> element.isSecondary();
        };
    }

    @NotNull
    public static String identity(@NotNull OraBody element, boolean includingSurrogate, boolean forPath, boolean normalize) {
        if (element == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(14);
        }
        return forPath ? "" : "#BODY";
    }

    @NotNull
    public static String identity(@NotNull OraMatLog element, boolean includingSurrogate, boolean forPath, boolean normalize) {
        if (element == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(15);
        }
        return forPath || includingSurrogate ? OraGeneratedModelUtil.identity(element, includingSurrogate, forPath, normalize) : "#ML";
    }

    @NotNull
    public static String identity(@NotNull OraTable element, boolean includingSurrogate, boolean forPath, boolean normalize) {
        if (element == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(16);
        }
        if (element.getTableType() == OraTableType.MAT_LOG && !forPath) {
            if (includingSurrogate) {
                String string = element.getName();
                if (string == null) {
                    OraGeneratedModelUtil.$$$reportNull$$$0(17);
                }
                return string;
            }
            BasicReference ref2 = element.getMasterTableRef();
            String masterTableName = StringUtil.notNullize((String)(ref2 == null ? null : ref2.getName()), (String)"???");
            String string = masterTableName + "'ML";
            if (string == null) {
                OraGeneratedModelUtil.$$$reportNull$$$0(18);
            }
            return string;
        }
        String string = OraGeneratedModelUtil.identity(element, includingSurrogate, forPath, normalize);
        if (string == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public static String identity(@NotNull OraInnerRoutine routine2, boolean includingSurrogate, boolean forPath, boolean normalize) {
        if (routine2 == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(20);
        }
        if (forPath) {
            String string = OraGeneratedModelUtil.identity(routine2, includingSurrogate, forPath, normalize);
            if (string == null) {
                OraGeneratedModelUtil.$$$reportNull$$$0(21);
            }
            return string;
        }
        short ovr = routine2.getOverloadNr();
        if (ovr > 0) {
            String string = routine2.getName() + "[" + ovr + "]";
            if (string == null) {
                OraGeneratedModelUtil.$$$reportNull$$$0(22);
            }
            return string;
        }
        String string = routine2.getName();
        if (string == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public static String identity(@NotNull OraTrigger trigger2, boolean includingSurrogate, boolean forPath, boolean normalize) {
        BasicReferenceInfo<? extends OraSchema> refInfo;
        if (trigger2 == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(24);
        }
        String refSchemaName = (refInfo = trigger2.getInSchemaRefInfo()) != null ? refInfo.getName() : null;
        String schemaName = refSchemaName != null && !refSchemaName.equals(trigger2.getSchemaName()) ? refSchemaName : null;
        Object identity = OraGeneratedModelUtil.identity(trigger2, includingSurrogate, forPath, normalize);
        if (schemaName != null) {
            identity = (String)identity + "(" + schemaName + ")";
        }
        String string = identity;
        if (string == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(25);
        }
        return string;
    }

    public static int getDisplayOrder(@NotNull OraInnerRoutine e1, @NotNull OraInnerRoutine e2) {
        int res2;
        if (e1 == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(26);
        }
        if (e2 == null) {
            OraGeneratedModelUtil.$$$reportNull$$$0(27);
        }
        if ((res2 = OraGeneratedModelUtil.getDisplayOrder((BasicElement)e1, (BasicElement)e2)) != 0) {
            return res2;
        }
        res2 = Integer.compare(e1.getOverloadNr(), e2.getOverloadNr());
        if (res2 != 0) {
            return res2;
        }
        return OraGeneratedModelUtil.compareSignatures(e1, e2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 17, 18, 19, 21, 22, 23, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nsp";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 6: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/model/OraGeneratedModelUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 9: 
            case 11: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e1";
                break;
            }
            case 10: 
            case 12: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e2";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trigger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/model/OraGeneratedModelUtil";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredecessors";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "identity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setSubstituted";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleRename";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPredecessors";
                break;
            }
            case 4: 
            case 6: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isElementSurrogate";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayOrder";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAutoCreated";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "identity";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 17, 18, 19, 21, 22, 23, 25 -> new IllegalStateException(string);
        };
    }
}

