/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.h2;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import java.sql.SQLException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class H2Dialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    private H2Dialect() {
        super(new TypeHelper.H2TypeHelper());
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.H2;
        if (dbms == null) {
            H2Dialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return "H2";
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            H2Dialect.$$$reportNull$$$0(1);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        String schema = this.getNamingService().catToScript(current.getName(), current.kind, this.getCodeStyle().getQuotesPriority());
        return String.format("set schema %s", schema);
    }

    @Override
    public boolean supportsInsertInto() {
        return super.supportsInsertInto();
    }

    @Override
    public boolean supportsCommonTableExpression() {
        return false;
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(@NotNull DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (builder == null) {
            H2Dialect.$$$reportNull$$$0(2);
        }
        if (identifier == null) {
            H2Dialect.$$$reportNull$$$0(3);
        }
        if (qualifier == null) {
            H2Dialect.$$$reportNull$$$0(4);
        }
        DasObject schema = DasUtil.getSchemaObject(qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName(schema), null, null, null, null);
        if (ddlBuilder == null) {
            H2Dialect.$$$reportNull$$$0(5);
        }
        return ddlBuilder;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DatabaseConnectionCore connection2) throws SQLException {
        if (connection2 == null) {
            H2Dialect.$$$reportNull$$$0(6);
        }
        Map<String, Object> rs = DbImplUtilCore.resultRowAsMap(connection2, "select database() \"D\", schema() \"S\"");
        String d = (String)ObjectUtils.tryCast((Object)rs.get("D"), String.class);
        String s = (String)ObjectUtils.tryCast((Object)rs.get("S"), String.class);
        return StringUtil.isEmpty((String)s) || StringUtil.isEmpty((String)d) ? null : SearchPath.of(ObjectPath.create(d, ObjectKind.DATABASE).append(s, ObjectKind.SCHEMA));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/h2/H2Dialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/h2/H2Dialect";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6 -> new IllegalArgumentException(string);
        };
    }
}

