/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.autoconfig;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.Dbms;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.access.DatabaseCredentialsUi;
import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseCredentialsAuthProvider;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.classpath.SimpleClasspathElementFactory;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataSourceRegistry {
    private final Project myProject;
    private final Map<LocalDataSource, DataSourceDetector.Callback> myDataSources = new LinkedHashMap<LocalDataSource, DataSourceDetector.Callback>();
    private final Map<String, DatabaseDriverImpl> myDrivers = new LinkedHashMap<String, DatabaseDriverImpl>();
    private final DatabaseCredentials myCredentialsStore;
    private boolean myImportedFlag = true;

    public DataSourceRegistry(Project project, DatabaseCredentials credentials) {
        this.myProject = project;
        this.myCredentialsStore = credentials;
    }

    public DataSourceRegistry(Project project) {
        this(project, DatabaseCredentialsUi.newUIInstance());
    }

    public void setImportedFlag(boolean flag) {
        this.myImportedFlag = flag;
    }

    public DataSourceDetector.Builder getBuilder() {
        return new MyBuilder().reset();
    }

    public boolean isEmpty() {
        return this.myDataSources.isEmpty();
    }

    public Collection<LocalDataSource> getDataSources() {
        return Collections.unmodifiableCollection(this.myDataSources.keySet());
    }

    public boolean showDialog() {
        if (this.isEmpty()) {
            return true;
        }
        return DataSourceManagerDialog.showDialog(DbPsiFacade.getInstance(this.myProject), this);
    }

    @Nullable
    public DataSourceDetector.Callback getCallback(LocalDataSource dataSource) {
        return this.myDataSources.get(dataSource);
    }

    public Collection<? extends LocalDataSource> getNewDataSources() {
        if (this.myDataSources.isEmpty()) {
            return Collections.emptyList();
        }
        MultiMap uniqueNames = MultiMap.createLinked();
        for (LocalDataSource localDataSource : this.myDataSources.keySet()) {
            uniqueNames.putValue((Object)localDataSource.getName(), (Object)localDataSource);
        }
        for (RawDataSource rawDataSource : DataSourceStorage.getProjectStorage(this.myProject).getDataSources()) {
            uniqueNames.remove((Object)rawDataSource.getName());
        }
        return uniqueNames.values();
    }

    private boolean isEmpty(@NotNull LocalDataSource tmp) {
        if (tmp == null) {
            DataSourceRegistry.$$$reportNull$$$0(0);
        }
        return StringUtil.isEmptyOrSpaces((String)tmp.getDriverClass()) && StringUtil.isEmptyOrSpaces((String)tmp.getUsername()) && DatabaseAuthProvider.get(tmp).loadAuthConfig(tmp, this.myCredentialsStore, true) == null && StringUtil.isEmptyOrSpaces((String)tmp.getUrl()) && tmp.getDriverProperties().isEmpty();
    }

    public void retainNewOnly() {
        this.myDataSources.keySet().retainAll(this.getNewDataSources());
    }

    public String toString() {
        return "DataSourceRegistry:" + this.myDataSources.size();
    }

    @NotNull
    public DatabaseCredentials getCredentialsStore() {
        DatabaseCredentials databaseCredentials = this.myCredentialsStore;
        if (databaseCredentials == null) {
            DataSourceRegistry.$$$reportNull$$$0(1);
        }
        return databaseCredentials;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tmp";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/autoconfig/DataSourceRegistry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/autoconfig/DataSourceRegistry";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCredentialsStore";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEmpty";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private class MyBuilder
    implements DataSourceDetector.Builder {
        MyDriverBuilder driverBuilder = new MyDriverBuilder(this);
        LocalDataSource tmp;
        String authProviderId;
        DataSourceDetector.Callback callback;

        private MyBuilder() {
        }

        @Override
        public DataSourceDetector.Builder commit() {
            ProgressManager.checkCanceled();
            if (!DataSourceRegistry.this.isEmpty(this.tmp)) {
                DatabaseDriver driver = this.tmp.getDatabaseDriver();
                if (driver == null) {
                    driver = DbImplUtilCore.guessDatabaseDriver(this.tmp);
                }
                if (driver != null) {
                    this.tmp.setDatabaseDriver(driver);
                    if (driver instanceof DatabaseDriverImpl) {
                        ((DatabaseDriverImpl)driver).setDefaultProperties(this.tmp, false);
                    }
                    if (this.authProviderId != null) {
                        this.tmp.setAuthProviderId(this.authProviderId);
                    }
                }
                DataSourceRegistry.this.myDataSources.put(this.tmp, this.callback);
            }
            return this.reset();
        }

        @Override
        public DataSourceDetector.Builder reset() {
            this.tmp = new LocalDataSource(DataSourceRegistry.this.myImportedFlag);
            this.authProviderId = null;
            this.callback = null;
            this.driverBuilder.paths.clear();
            this.driverBuilder.tmp = null;
            return this;
        }

        @Override
        public DataSourceDetector.DriverBuilder driver(@NotNull Dbms dbms) {
            if (dbms == null) {
                MyBuilder.$$$reportNull$$$0(0);
            }
            DatabaseDriver baseDriver = DbImplUtilCore.guessDatabaseDriver(dbms);
            this.driverBuilder.paths.clear();
            this.driverBuilder.tmp = baseDriver == null ? new DatabaseDriverImpl(null, false) : ((DatabaseDriverImpl)baseDriver).copy(null, false);
            return this.driverBuilder;
        }

        DataSourceDetector.Builder commitDriver() {
            List cp = SimpleClasspathElementFactory.createElements((String[])ArrayUtilRt.toStringArray(this.driverBuilder.paths));
            DatabaseDriverImpl tmp = this.driverBuilder.tmp;
            tmp.setAdditionalClasspathElements(cp);
            DataSourceRegistry.this.myDrivers.put(tmp.getName(), tmp);
            this.driverBuilder.paths.clear();
            this.driverBuilder.tmp = null;
            return this;
        }

        @Override
        public DataSourceDetector.Builder withCallback(@NotNull DataSourceDetector.Callback callback) {
            if (callback == null) {
                MyBuilder.$$$reportNull$$$0(1);
            }
            this.callback = callback;
            return this;
        }

        @Override
        public DataSourceDetector.Builder withName(String s) {
            if (StringUtil.isEmptyOrSpaces((String)s)) {
                return this;
            }
            this.tmp.setName(s);
            return this;
        }

        @Override
        public DataSourceDetector.Builder withComment(@Nullable String s) {
            if (StringUtil.isEmptyOrSpaces((String)s)) {
                return this;
            }
            this.tmp.setComment(s);
            return this;
        }

        @Override
        public DataSourceDetector.Builder withGroupName(@Nullable String s) {
            if (StringUtil.isEmptyOrSpaces((String)s)) {
                return this;
            }
            this.tmp.setGroupName(s);
            return this;
        }

        @Override
        public DataSourceDetector.Builder withDriverClass(String s) {
            if (StringUtil.isEmptyOrSpaces((String)s)) {
                return this;
            }
            this.tmp.setDriverClass(s);
            return this;
        }

        @Override
        public DataSourceDetector.Builder withUrl(String s) {
            if (StringUtil.isEmptyOrSpaces((String)s)) {
                return this;
            }
            this.tmp.setUrlSmart(s);
            return this;
        }

        @Override
        public DataSourceDetector.Builder withUser(String s) {
            if (StringUtil.isEmptyOrSpaces((String)s)) {
                return this;
            }
            this.tmp.setUsername(s);
            return this;
        }

        @Override
        public DataSourceDetector.Builder withPassword(String s) {
            if (StringUtil.isEmptyOrSpaces((String)s)) {
                return this;
            }
            if (this.authProviderId == null) {
                this.authProviderId = "user-pass";
            }
            DatabaseCredentialsAuthProvider.saveCredentialsConfig(this.tmp, DataSourceRegistry.this.myCredentialsStore, new DatabaseCredentialsAuthProvider.UserPassCredentials(new OneTimeString(s)), true);
            return this;
        }

        @Override
        public DataSourceDetector.Builder withAuthProviderId(@Nullable String providerId) {
            if (providerId == null) {
                return this;
            }
            this.authProviderId = providerId;
            return this;
        }

        @Override
        public DataSourceDetector.Builder withDriverProperty(@Nullable String name2, @Nullable String value) {
            if (StringUtil.isEmptyOrSpaces((String)name2)) {
                return this;
            }
            this.tmp.getDriverProperties().put(name2, value);
            return this;
        }

        @Override
        public DataSourceDetector.Builder withJdbcAdditionalProperty(@Nullable String name2, @Nullable String value) {
            if (StringUtil.isEmptyOrSpaces((String)name2)) {
                return this;
            }
            if ("domain-auth".equals(name2)) {
                this.authProviderId = Boolean.parseBoolean(value) ? "ms-sso" : "user-pass";
                this.tmp.setPasswordStorage(LocalDataSource.Storage.PERSIST);
            } else {
                this.tmp.setAdditionalProperty(name2, value);
            }
            return this;
        }

        @Override
        public DataSourceDetector.Builder withDbms(@Nullable Dbms dbms) {
            if (dbms == null) {
                return this;
            }
            this.tmp.setDatabaseDriver(DbImplUtilCore.guessDatabaseDriver(dbms));
            return this;
        }

        @Override
        public DataSourceDetector.Builder withDriver(@Nullable String name2) {
            if (StringUtil.isEmptyOrSpaces((String)name2)) {
                return this;
            }
            this.tmp.setDatabaseDriver(DataSourceRegistry.this.myDrivers.get(name2));
            return this;
        }

        @Override
        public DataSourceDetector.Builder withOrigin(@Nullable Object origin) {
            VirtualFile file = origin instanceof PsiElement ? PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)origin)) : null;
            String path = file != null ? file.getPath() : null;
            String comment = this.tmp.getComment();
            if (path != null) {
                this.tmp.setComment((String)(StringUtil.isEmpty((String)comment) ? path : comment + "\n\n" + path));
            }
            return this;
        }

        @Override
        public DataSourceDetector.Builder withVMOptions(@Nullable String s) {
            if (StringUtil.isEmptyOrSpaces((String)s)) {
                return this;
            }
            this.tmp.setVmOptions(s);
            return this;
        }

        @Override
        public DataSourceDetector.Builder withVMEnv(@Nullable String name2, @Nullable String value) {
            if (StringUtil.isEmptyOrSpaces((String)name2)) {
                return this;
            }
            this.tmp.getVmEnv().put(name2, value);
            return this;
        }

        public String toString() {
            Object c2 = DatabaseAuthProvider.get(this.tmp).loadAuthConfig(this.tmp, DataSourceRegistry.this.myCredentialsStore, true);
            return "Builder{" + this.tmp.getName() + "; " + this.tmp.getUsername() + "@" + (c2 == null ? "" : c2.toString()) + "; " + this.tmp.getUrl() + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callback";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/autoconfig/DataSourceRegistry$MyBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "driver";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "withCallback";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyDriverBuilder
    implements DataSourceDetector.DriverBuilder {
        final MyBuilder builder;
        final Set<String> paths = new LinkedHashSet<String>();
        DatabaseDriverImpl tmp;

        MyDriverBuilder(MyBuilder builder) {
            this.builder = builder;
        }

        @Override
        public DataSourceDetector.Builder commitDriver() {
            return this.builder.commitDriver();
        }

        @Override
        public DataSourceDetector.DriverBuilder withName(@Nullable String s) {
            if (StringUtil.isEmptyOrSpaces((String)s)) {
                return this;
            }
            this.tmp.setName(s);
            return this;
        }

        @Override
        public DataSourceDetector.DriverBuilder withComment(@Nullable String s) {
            if (StringUtil.isEmptyOrSpaces((String)s)) {
                return this;
            }
            this.tmp.setComment(s);
            return this;
        }

        @Override
        public DataSourceDetector.DriverBuilder withDriverClass(@Nullable String s) {
            if (StringUtil.isEmptyOrSpaces((String)s)) {
                return this;
            }
            this.tmp.setDriverClass(s);
            return this;
        }

        @Override
        public DataSourceDetector.DriverBuilder withAdditionalJar(@Nullable String path) {
            if (StringUtil.isEmptyOrSpaces((String)path)) {
                return this;
            }
            for (String s : StringUtil.split((String)path, (String)File.pathSeparator, (boolean)true, (boolean)true)) {
                this.paths.add(VfsUtilCore.pathToUrl((String)s));
            }
            return this;
        }

        @Override
        public DataSourceDetector.DriverBuilder withDriverProperty(@Nullable String name2, @Nullable String value) {
            if (StringUtil.isEmptyOrSpaces((String)name2)) {
                return this;
            }
            this.tmp.getDriverProperties().put(name2, value);
            return this;
        }

        @Override
        public DataSourceDetector.DriverBuilder withVMOptions(@Nullable String s) {
            if (StringUtil.isEmptyOrSpaces((String)s)) {
                return this;
            }
            this.tmp.setVmOptions(s);
            return this;
        }

        @Override
        public DataSourceDetector.DriverBuilder withVMEnv(@Nullable String name2, @Nullable String value) {
            if (StringUtil.isEmptyOrSpaces((String)name2)) {
                return this;
            }
            this.tmp.getVmEnv().put(name2, value);
            return this;
        }
    }
}

