/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.thinClientLink;

import com.intellij.idea.LoggerFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.remoteDev.downloader.CodeWithMeGuestLauncher;
import com.intellij.remoteDev.thinClientLink.ClientToGtwMessage;
import com.intellij.remoteDev.thinClientLink.GtwToClientMessage;
import com.intellij.remoteDev.tracing.RdctScopesKt;
import com.intellij.util.UriUtilKt;
import com.jetbrains.gateway.GatewayBundle;
import com.jetbrains.gateway.thinClientLink.ClientLifetimeTracker;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.Signal;
import io.netty.buffer.Unpooled;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.Meter;
import java.net.URI;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.webSocket.WebSocketClient;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0016\b\u0007\u0018\u0000 g2\u00020\u0001:\u0001gB9\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010D\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\bEJ\u001d\u0010F\u001a\u00020\u00182\u000e\b\u0002\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00180HH\u0000\u00a2\u0006\u0002\bIJ\b\u0010J\u001a\u00020\u0018H\u0002J\u0016\u0010V\u001a\u00020\u00182\u0006\u0010W\u001a\u00020\u00072\u0006\u0010X\u001a\u00020\rJ\u0006\u0010Y\u001a\u00020\u0018J\u0006\u0010Z\u001a\u00020\u0018J\u0006\u0010[\u001a\u00020\u0018J\b\u0010\\\u001a\u00020\u0018H\u0002J\u000e\u0010]\u001a\u00020\u00182\u0006\u0010^\u001a\u00020\u001bJ\u0010\u0010_\u001a\u00020\u00182\u0006\u0010`\u001a\u000205H\u0002J\u0018\u0010_\u001a\u00020\u00182\u0006\u0010a\u001a\u00020#2\u0006\u0010`\u001a\u000205H\u0002J\u001d\u0010b\u001a\u00020\u00182\u0006\u0010c\u001a\u00020/2\u0006\u0010a\u001a\u00020#H\u0000\u00a2\u0006\u0002\bdJ\u0010\u0010e\u001a\u00020\u00182\u0006\u0010W\u001a\u00020\u0007H\u0002J\b\u0010f\u001a\u00020\u0007H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010&\u001a\n (*\u0004\u0018\u00010'0'X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010)R\u0018\u0010*\u001a\n (*\u0004\u0018\u00010'0'X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010)R\u0018\u0010+\u001a\n (*\u0004\u0018\u00010'0'X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010)R\u0018\u0010,\u001a\n (*\u0004\u0018\u00010'0'X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010)R\u0018\u0010-\u001a\n (*\u0004\u0018\u00010'0'X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010)R\u0011\u0010.\u001a\u00020/\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u000e\u00102\u001a\u000203X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u000205X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000207X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u00109\u001a\u00020\r2\u0006\u00108\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010\u0015R\u0016\u0010;\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010<X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010=\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010<X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010?\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010@R\"\u0010A\u001a\u0004\u0018\u00010\u00072\b\u00108\u001a\u0004\u0018\u00010\u0007@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u0011\u0010K\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\bL\u0010\u0015R\u0017\u0010M\u001a\b\u0012\u0004\u0012\u00020\u00180N8F\u00a2\u0006\u0006\u001a\u0004\bO\u0010PR\u001b\u0010Q\u001a\f\u0012\u0004\u0012\u00020\u00180Nj\u0002`R8F\u00a2\u0006\u0006\u001a\u0004\bS\u0010PR\u0017\u0010T\u001a\b\u0012\u0004\u0012\u00020\u001b0N8F\u00a2\u0006\u0006\u001a\u0004\bU\u0010P\u00a8\u0006h"}, d2={"Lcom/jetbrains/gateway/thinClientLink/ThinClientHandle;", "", "uid", "", "lifetimeDef", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "initialGwwsLink", "Ljava/net/URI;", "clientLifetimeTracker", "Lcom/jetbrains/gateway/thinClientLink/ClientLifetimeTracker;", "clientBuildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "enableBeforeRunHooks", "", "<init>", "(Ljava/lang/String;Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;Ljava/net/URI;Lcom/jetbrains/gateway/thinClientLink/ClientLifetimeTracker;Lcom/intellij/openapi/util/BuildNumber;Z)V", "getUid", "()Ljava/lang/String;", "getClientBuildNumber", "()Lcom/intellij/openapi/util/BuildNumber;", "getEnableBeforeRunHooks", "()Z", "presenceChangeSignal", "Lcom/jetbrains/rd/util/reactive/Signal;", "", "closedSignalImpl", "openFailedSignalImpl", "", "onMessage", "Lcom/intellij/remoteDev/thinClientLink/ClientToGtwMessage;", "getOnMessage$intellij_gateway_core", "()Lcom/jetbrains/rd/util/reactive/Signal;", "timeoutTicks", "clients", "", "Lorg/jetbrains/io/webSocket/WebSocketClient;", "meter", "Lio/opentelemetry/api/metrics/Meter;", "pingMessagesCounter", "Lio/opentelemetry/api/metrics/LongCounter;", "kotlin.jvm.PlatformType", "Lio/opentelemetry/api/metrics/LongCounter;", "closingMessagesCounter", "askLongsMessagesCounter", "clientRestartMessagesCounter", "projectOpenFailedMessagesCounter", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "pingLifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "currentConnectionStateMessage", "Lcom/intellij/remoteDev/thinClientLink/GtwToClientMessage;", "clientCapabilities", "Lcom/intellij/remoteDev/thinClientLink/ClientToGtwMessage$ClientCapabilities;", "value", "restartNeeded", "getRestartNeeded", "linkUpdatedFuture", "Ljava/util/concurrent/CompletableFuture;", "clientProcessTerminated", "gwwsLink", "currentNewUiState", "Ljava/lang/Boolean;", "lastSeenLink", "getLastSeenLink$intellij_gateway_core", "()Ljava/net/URI;", "startPingingClient", "startPingingClient$intellij_gateway_core", "onClientLaunch", "onStarted", "Lkotlin/Function0;", "onClientLaunch$intellij_gateway_core", "onProcessTermination", "clientPresent", "getClientPresent", "onClientPresenceChanged", "Lcom/jetbrains/rd/util/reactive/ISource;", "getOnClientPresenceChanged", "()Lcom/jetbrains/rd/util/reactive/ISource;", "clientClosed", "Lcom/jetbrains/rd/util/reactive/IVoidSource;", "getClientClosed", "clientFailedToOpenProject", "getClientFailedToOpenProject", "updateJoinLink", "newLink", "reconnectIfConnected", "notifyReconnect", "close", "focusClientWindow", "prepareLaunchAfterRestart", "reportNetworkLatency", "latency", "sendMessage", "message", "client", "clientConnected", "clientLifetime", "clientConnected$intellij_gateway_core", "handleNewUiSwitch", "createGwwsLinkWithUpdatedFragmentParams", "Companion", "intellij.gateway.core"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nThinClientHandle.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThinClientHandle.kt\ncom/jetbrains/gateway/thinClientLink/ThinClientHandle\n+ 2 RLifetime.kt\ncom/jetbrains/rd/util/lifetime/Lifetime$Companion\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,344:1\n39#2,5:345\n62#3,5:350\n62#3,5:355\n62#3,5:360\n62#3,5:367\n62#3,5:372\n15#3:377\n1863#4,2:365\n*S KotlinDebug\n*F\n+ 1 ThinClientHandle.kt\ncom/jetbrains/gateway/thinClientLink/ThinClientHandle\n*L\n73#1:345,5\n237#1:350,5\n239#1:355,5\n273#1:360,5\n102#1:367,5\n180#1:372,5\n340#1:377\n299#1:365,2\n*E\n"})
public final class ThinClientHandle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String uid;
    @NotNull
    private final LifetimeDefinition lifetimeDef;
    @NotNull
    private final ClientLifetimeTracker clientLifetimeTracker;
    @NotNull
    private final BuildNumber clientBuildNumber;
    private final boolean enableBeforeRunHooks;
    @NotNull
    private final Signal<Unit> presenceChangeSignal;
    @NotNull
    private final Signal<Unit> closedSignalImpl;
    @NotNull
    private final Signal<Integer> openFailedSignalImpl;
    @NotNull
    private final Signal<ClientToGtwMessage> onMessage;
    private int timeoutTicks;
    @NotNull
    private final Set<WebSocketClient> clients;
    @NotNull
    private final Meter meter;
    private final LongCounter pingMessagesCounter;
    private final LongCounter closingMessagesCounter;
    private final LongCounter askLongsMessagesCounter;
    private final LongCounter clientRestartMessagesCounter;
    private final LongCounter projectOpenFailedMessagesCounter;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final SequentialLifetimes pingLifetimes;
    @NotNull
    private GtwToClientMessage currentConnectionStateMessage;
    @NotNull
    private ClientToGtwMessage.ClientCapabilities clientCapabilities;
    private boolean restartNeeded;
    @Nullable
    private CompletableFuture<Boolean> linkUpdatedFuture;
    @Nullable
    private CompletableFuture<Boolean> clientProcessTerminated;
    @NotNull
    private final URI gwwsLink;
    @Nullable
    private Boolean currentNewUiState;
    @Nullable
    private URI lastSeenLink;
    @NotNull
    private static final KSerializer<GtwToClientMessage> serializer = GtwToClientMessage.Companion.serializer();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final GtwToClientMessage.GatewayCapabilities gatewayCapabilities;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThinClientHandle(@NotNull String uid, @NotNull LifetimeDefinition lifetimeDef, @NotNull URI initialGwwsLink, @NotNull ClientLifetimeTracker clientLifetimeTracker, @NotNull BuildNumber clientBuildNumber, boolean enableBeforeRunHooks) {
        Intrinsics.checkNotNullParameter((Object)uid, (String)"uid");
        Intrinsics.checkNotNullParameter((Object)lifetimeDef, (String)"lifetimeDef");
        Intrinsics.checkNotNullParameter((Object)initialGwwsLink, (String)"initialGwwsLink");
        Intrinsics.checkNotNullParameter((Object)clientLifetimeTracker, (String)"clientLifetimeTracker");
        Intrinsics.checkNotNullParameter((Object)clientBuildNumber, (String)"clientBuildNumber");
        this.uid = uid;
        this.lifetimeDef = lifetimeDef;
        this.clientLifetimeTracker = clientLifetimeTracker;
        this.clientBuildNumber = clientBuildNumber;
        this.enableBeforeRunHooks = enableBeforeRunHooks;
        this.presenceChangeSignal = new Signal();
        this.closedSignalImpl = new Signal();
        this.openFailedSignalImpl = new Signal();
        this.onMessage = new Signal();
        ConcurrentHashMap.KeySetView keySetView = new ConcurrentHashMap().keySet(Unit.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"keySet(...)");
        this.clients = keySetView;
        this.meter = TelemetryManager.Companion.getMeter(RdctScopesKt.RDCT);
        this.pingMessagesCounter = this.meter.counterBuilder("rdct.ThinClientHandle.pingMessages").setUnit("messages").build();
        this.closingMessagesCounter = this.meter.counterBuilder("rdct.ThinClientHandle.closingMessages").setUnit("messages").build();
        this.askLongsMessagesCounter = this.meter.counterBuilder("rdct.ThinClientHandle.askLogsMessages").setUnit("messages").build();
        this.clientRestartMessagesCounter = this.meter.counterBuilder("rdct.ThinClientHandle.clientRestartMessages").setUnit("messages").build();
        this.projectOpenFailedMessagesCounter = this.meter.counterBuilder("rdct.ThinClientHandle.projectOpenFailedMessagesMessages").setUnit("messages").build();
        this.lifetime = (Lifetime)this.lifetimeDef;
        ThinClientHandle thinClientHandle = this;
        SequentialLifetimes sequentialLifetimes = (SequentialLifetimes)this.lifetime.executeIfAlive(() -> ThinClientHandle.pingLifetimes$lambda$0(this));
        if (sequentialLifetimes == null) {
            SequentialLifetimes sequentialLifetimes2;
            Lifetime.Companion companion = Lifetime.Companion;
            ThinClientHandle thinClientHandle2 = thinClientHandle;
            boolean $i$f$using = false;
            LifetimeDefinition def$iv = new LifetimeDefinition();
            try {
                Lifetime it = def$iv.getLifetime();
                boolean bl = false;
                sequentialLifetimes2 = new SequentialLifetimes(it);
            }
            finally {
                LifetimeDefinition.terminate$default((LifetimeDefinition)def$iv, (boolean)false, (int)1, null);
            }
            sequentialLifetimes = sequentialLifetimes2;
            thinClientHandle = thinClientHandle2;
        }
        thinClientHandle.pingLifetimes = sequentialLifetimes;
        this.currentConnectionStateMessage = (GtwToClientMessage)GtwToClientMessage.GatewayReconnecting.INSTANCE;
        this.clientCapabilities = new ClientToGtwMessage.ClientCapabilities(false, 0L, 2, null);
        this.gwwsLink = UriUtilKt.newURIWithFragmentParameters((URI)initialGwwsLink, (Map)MapsKt.minus((Map)UriUtilKt.getFragmentParameters((URI)initialGwwsLink), (Object)"newUi"));
        String string = (String)UriUtilKt.getFragmentParameters((URI)initialGwwsLink).get("newUi");
        this.currentNewUiState = string != null ? Boolean.valueOf(Boolean.parseBoolean(string)) : null;
        this.clientLifetimeTracker.registerClientHandleLifetime(this.lifetime, this.uid);
        this.clientLifetimeTracker.getClientsTerminated().advise(this.lifetime, arg_0 -> ThinClientHandle._init_$lambda$3(this, arg_0));
        this.onMessage.advise(this.lifetime, arg_0 -> ThinClientHandle._init_$lambda$4(this, arg_0));
        this.closedSignalImpl.advise(this.lifetime, arg_0 -> ThinClientHandle._init_$lambda$5(this, arg_0));
    }

    @NotNull
    public final String getUid() {
        return this.uid;
    }

    @NotNull
    public final BuildNumber getClientBuildNumber() {
        return this.clientBuildNumber;
    }

    public final boolean getEnableBeforeRunHooks() {
        return this.enableBeforeRunHooks;
    }

    @NotNull
    public final Signal<ClientToGtwMessage> getOnMessage$intellij_gateway_core() {
        return this.onMessage;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    public final boolean getRestartNeeded() {
        return this.restartNeeded;
    }

    @Nullable
    public final URI getLastSeenLink$intellij_gateway_core() {
        return this.lastSeenLink;
    }

    public final void startPingingClient$intellij_gateway_core() {
        LifetimeDefinition currentLifetime = this.pingLifetimes.next();
        RdCoroutinesUtilKt.launchNonUrgentBackground$default((Lifetime)((Lifetime)currentLifetime), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(currentLifetime, this, null){
            int label;
            final /* synthetic */ LifetimeDefinition $currentLifetime;
            final /* synthetic */ ThinClientHandle this$0;
            {
                this.$currentLifetime = $currentLifetime;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
lbl5:
                        // 3 sources

                        while (RLifetimeKt.isAlive((Lifetime)((Lifetime)this.$currentLifetime))) {
                            this.label = 1;
                            v0 = DelayKt.delay((long)5000L, (Continuation)((Continuation)this));
                            if (v0 == var8_2) {
                                return var8_2;
                            }
                            ** GOTO lbl15
                        }
                        break;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        var2_3 = ThinClientHandle.access$getTimeoutTicks$p(this.this$0);
                        ThinClientHandle.access$setTimeoutTicks$p(this.this$0, var2_3 + 1);
                        if (var2_3 <= 5) ** GOTO lbl5
                        var2_4 = ThinClientHandle.access$getLogger$cp();
                        var4_6 = this.this$0;
                        e$iv = null;
                        $i$f$debug = false;
                        if ($this$debug_u24default$iv.isDebugEnabled()) {
                            var7_9 = $this$debug_u24default$iv;
                            $i$a$-debug$default-ThinClientHandle$startPingingClient$1$1 = false;
                            var7_9.debug("Handle " + var4_6.getUid() + " timed out, closing", e$iv);
                        }
                        this.this$0.close();
                        ** GOTO lbl5
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void onClientLaunch$intellij_gateway_core(@NotNull Function0<Unit> onStarted) {
        Intrinsics.checkNotNullParameter(onStarted, (String)"onStarted");
        Lifetime lifetime = this.clientLifetimeTracker.getLifetime();
        BuildNumber buildNumber = this.clientLifetimeTracker.getBuildNumber();
        String string = this.createGwwsLinkWithUpdatedFragmentParams().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        CodeWithMeGuestLauncher.INSTANCE.downloadCompatibleClientAndLaunch(lifetime, null, buildNumber, string, GatewayBundle.INSTANCE.message("ssh.deploy.dialog.title", new Object[0]), this.enableBeforeRunHooks, arg_0 -> ThinClientHandle.onClientLaunch$lambda$8(this, onStarted, arg_0));
    }

    public static /* synthetic */ void onClientLaunch$intellij_gateway_core$default(ThinClientHandle thinClientHandle, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            function0 = ThinClientHandle::onClientLaunch$lambda$6;
        }
        thinClientHandle.onClientLaunch$intellij_gateway_core((Function0<Unit>)function0);
    }

    private final void onProcessTermination() {
        block1: {
            block0: {
                if (this.restartNeeded) break block0;
                this.close();
                break block1;
            }
            this.pingLifetimes.terminateCurrent();
            CompletableFuture<Boolean> completableFuture = this.clientProcessTerminated;
            if (completableFuture == null) break block1;
            completableFuture.complete(true);
        }
    }

    public final boolean getClientPresent() {
        return this.clients.size() > 0;
    }

    @NotNull
    public final ISource<Unit> getOnClientPresenceChanged() {
        return (ISource)this.presenceChangeSignal;
    }

    @NotNull
    public final ISource<Unit> getClientClosed() {
        return (ISource)this.closedSignalImpl;
    }

    @NotNull
    public final ISource<Integer> getClientFailedToOpenProject() {
        return (ISource)this.openFailedSignalImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateJoinLink(@NotNull URI newLink, boolean reconnectIfConnected) {
        Intrinsics.checkNotNullParameter((Object)newLink, (String)"newLink");
        ThinClientHandle thinClientHandle = this;
        synchronized (thinClientHandle) {
            boolean bl = false;
            logger.info("Updating join link for handle " + this.uid + ": " + newLink + " forceReconnect=" + reconnectIfConnected);
            String string = newLink.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            this.sendMessage((GtwToClientMessage)new GtwToClientMessage.UpdateLink(string, reconnectIfConnected));
            URI lastSeenLinkTemp = this.lastSeenLink;
            this.lastSeenLink = newLink;
            if (this.restartNeeded) {
                if (!Intrinsics.areEqual((Object)this.lastSeenLink, (Object)lastSeenLinkTemp)) {
                    this.handleNewUiSwitch(newLink);
                    CompletableFuture<Boolean> completableFuture = this.linkUpdatedFuture;
                    if (completableFuture != null) {
                        completableFuture.complete(true);
                    }
                    Logger $this$debug_u24default$iv = logger;
                    Throwable e$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        Logger logger = $this$debug_u24default$iv;
                        boolean bl2 = false;
                        logger.debug("Link updated after restart for handle: " + this.uid, e$iv);
                    }
                } else {
                    Logger $this$debug_u24default$iv = logger;
                    Throwable e$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        Logger logger = $this$debug_u24default$iv;
                        boolean bl3 = false;
                        logger.debug("Received the same link while restarting. Skipping...", e$iv);
                    }
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void notifyReconnect() {
        logger.info("Setting handle " + this.uid + " to reconnecting state");
        this.sendMessage((GtwToClientMessage)GtwToClientMessage.GatewayReconnecting.INSTANCE);
    }

    public final void close() {
        if (RLifetimeKt.isNotAlive((Lifetime)this.lifetime)) {
            return;
        }
        logger.info("Closing handle " + this.uid);
        this.sendMessage((GtwToClientMessage)GtwToClientMessage.GatewayClose.INSTANCE);
        Thread.sleep(1000L);
        this.closedSignalImpl.fire((Object)Unit.INSTANCE);
    }

    public final void focusClientWindow() {
        Logger $this$debug_u24default$iv = logger;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Requesting focus on handle " + this.uid, e$iv);
        }
        this.sendMessage((GtwToClientMessage)GtwToClientMessage.RequestWindowFocus.INSTANCE);
    }

    private final void prepareLaunchAfterRestart() {
        CompletableFuture<Boolean> completableFuture = this.linkUpdatedFuture;
        if (completableFuture != null) {
            completableFuture.cancel(false);
        }
        CompletableFuture<Boolean> completableFuture2 = this.clientProcessTerminated;
        if (completableFuture2 != null) {
            completableFuture2.cancel(false);
        }
        this.linkUpdatedFuture = new CompletableFuture();
        this.clientProcessTerminated = new CompletableFuture();
        CompletableFuture[] completableFutureArray = new CompletableFuture[]{this.linkUpdatedFuture, this.clientProcessTerminated};
        CompletableFuture.allOf(completableFutureArray).thenAccept(arg_0 -> ThinClientHandle.prepareLaunchAfterRestart$lambda$14(arg_0 -> ThinClientHandle.prepareLaunchAfterRestart$lambda$13(this, arg_0), arg_0));
    }

    public final void reportNetworkLatency(int latency) {
        this.sendMessage((GtwToClientMessage)new GtwToClientMessage.NetworkLatency(latency));
    }

    private final void sendMessage(GtwToClientMessage message) {
        if (message instanceof GtwToClientMessage.GatewayReconnecting || message instanceof GtwToClientMessage.UpdateLink || message instanceof GtwToClientMessage.GatewayClose) {
            this.currentConnectionStateMessage = message;
        }
        Iterable $this$forEach$iv = this.clients;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WebSocketClient client = (WebSocketClient)element$iv;
            boolean bl = false;
            this.sendMessage(client, message);
        }
    }

    private final void sendMessage(WebSocketClient client, GtwToClientMessage message) {
        String serialized;
        String string = serialized = Json.Default.encodeToString((SerializationStrategy)serializer, (Object)message);
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        client.sendFrame(Unpooled.wrappedBuffer((byte[])byArray), false);
    }

    public final void clientConnected$intellij_gateway_core(@NotNull Lifetime clientLifetime, @NotNull WebSocketClient client) {
        Intrinsics.checkNotNullParameter((Object)clientLifetime, (String)"clientLifetime");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.clients.add(client);
        this.restartNeeded = false;
        clientLifetime.onTermination(() -> ThinClientHandle.clientConnected$lambda$16(this, client));
        this.presenceChangeSignal.fire((Object)Unit.INSTANCE);
        this.sendMessage(client, (GtwToClientMessage)gatewayCapabilities);
        this.sendMessage(client, this.currentConnectionStateMessage);
    }

    private final void handleNewUiSwitch(URI newLink) {
        Boolean updatedLinkNewUi;
        String string = (String)UriUtilKt.getFragmentParameters((URI)newLink).get("newUi");
        this.currentNewUiState = updatedLinkNewUi = string != null ? Boolean.valueOf(Boolean.parseBoolean(string)) : null;
    }

    private final URI createGwwsLinkWithUpdatedFragmentParams() {
        Boolean newUiState = this.currentNewUiState;
        if (newUiState != null) {
            return UriUtilKt.newURIWithFragmentParameters((URI)this.gwwsLink, (Map)MapsKt.plus((Map)UriUtilKt.getFragmentParameters((URI)this.gwwsLink), (Pair)TuplesKt.to((Object)"newUi", (Object)newUiState.toString())));
        }
        return this.gwwsLink;
    }

    private static final SequentialLifetimes pingLifetimes$lambda$0(ThinClientHandle this$0) {
        return new SequentialLifetimes(this$0.lifetime);
    }

    private static final Unit _init_$lambda$3(ThinClientHandle this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Logger $this$debug_u24default$iv = logger;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Got process exit notification for client " + this$0.uid, e$iv);
        }
        this$0.onProcessTermination();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(ThinClientHandle this$0, ClientToGtwMessage it) {
        ClientToGtwMessage clientToGtwMessage;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!Intrinsics.areEqual((Object)it, (Object)ClientToGtwMessage.Ping.INSTANCE)) {
            logger.info("Message from thin client " + this$0.uid + ": " + it);
        }
        if (Intrinsics.areEqual((Object)(clientToGtwMessage = it), (Object)ClientToGtwMessage.ClientClosing.INSTANCE)) {
            this$0.closingMessagesCounter.add(1L);
            InterfacesKt.fire((ISignal)((ISignal)this$0.closedSignalImpl));
        } else if (Intrinsics.areEqual((Object)clientToGtwMessage, (Object)ClientToGtwMessage.Ping.INSTANCE)) {
            this$0.pingMessagesCounter.add(1L);
            this$0.timeoutTicks = 0;
        } else if (Intrinsics.areEqual((Object)clientToGtwMessage, (Object)ClientToGtwMessage.ClientAsksLogs.INSTANCE)) {
            this$0.askLongsMessagesCounter.add(1L);
            Path path = LoggerFactory.getLogFilePath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getLogFilePath(...)");
            this$0.sendMessage((GtwToClientMessage)new GtwToClientMessage.GatewayLogs(((Object)path).toString()));
        } else if (Intrinsics.areEqual((Object)clientToGtwMessage, (Object)ClientToGtwMessage.ClientRestart.INSTANCE)) {
            this$0.clientRestartMessagesCounter.add(1L);
            this$0.restartNeeded = true;
            logger.info("starting preparing launch after restart");
            this$0.prepareLaunchAfterRestart();
            this$0.sendMessage((GtwToClientMessage)GtwToClientMessage.RestartReady.INSTANCE);
            logger.info("RestartReady message sent");
        } else if (Intrinsics.areEqual((Object)clientToGtwMessage, (Object)ClientToGtwMessage.ClientSelfRestart.INSTANCE)) {
            this$0.clientRestartMessagesCounter.add(1L);
            logger.info("Client for " + this$0.uid + " will self-restart");
            this$0.restartNeeded = true;
        } else if (clientToGtwMessage instanceof ClientToGtwMessage.ProjectOpenFailed) {
            this$0.projectOpenFailedMessagesCounter.add(1L);
            this$0.openFailedSignalImpl.fire((Object)((ClientToGtwMessage.ProjectOpenFailed)it).getExitCode());
        } else if (clientToGtwMessage instanceof ClientToGtwMessage.ClientCapabilities) {
            this$0.clientCapabilities = (ClientToGtwMessage.ClientCapabilities)it;
            logger.info("Received client capabilities for " + this$0.uid + ": " + it);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$5(ThinClientHandle this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        RdCoroutinesUtilKt.startIOBackgroundAsync$default((Lifetime)this$0.lifetime, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            final /* synthetic */ ThinClientHandle this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = DelayKt.delay((long)2000L, (Continuation)((Continuation)this));
                        if (v0 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if (!this.this$0.getRestartNeeded()) {
                            var2_3 = ThinClientHandle.access$getLogger$cp();
                            var4_4 = this.this$0;
                            e$iv = null;
                            $i$f$debug = false;
                            if ($this$debug_u24default$iv.isDebugEnabled()) {
                                var7_7 = $this$debug_u24default$iv;
                                $i$a$-debug$default-ThinClientHandle$3$1$1 = false;
                                var7_7.debug("Terminating handle lifetime for " + var4_4.getUid(), e$iv);
                            }
                            LifetimeDefinition.terminate$default((LifetimeDefinition)ThinClientHandle.access$getLifetimeDef$p(this.this$0), (boolean)false, (int)1, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return Unit.INSTANCE;
    }

    private static final Unit onClientLaunch$lambda$6() {
        return Unit.INSTANCE;
    }

    private static final Unit onClientLaunch$lambda$8(ThinClientHandle this$0, Function0 $onStarted, Lifetime it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Logger $this$debug_u24default$iv = logger;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Attaching process lifetime for linked client " + this$0.uid, e$iv);
        }
        this$0.clientLifetimeTracker.registerClientProcessLifetime(it, this$0.uid);
        $onStarted.invoke();
        this$0.startPingingClient$intellij_gateway_core();
        return Unit.INSTANCE;
    }

    private static final Unit prepareLaunchAfterRestart$lambda$13(ThinClientHandle this$0, Void it) {
        ThinClientHandle.onClientLaunch$intellij_gateway_core$default(this$0, null, 1, null);
        this$0.restartNeeded = false;
        this$0.linkUpdatedFuture = null;
        this$0.clientProcessTerminated = null;
        return Unit.INSTANCE;
    }

    private static final void prepareLaunchAfterRestart$lambda$14(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit clientConnected$lambda$16(ThinClientHandle this$0, WebSocketClient $client) {
        this$0.clients.remove($client);
        this$0.presenceChangeSignal.fire((Object)Unit.INSTANCE);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ int access$getTimeoutTicks$p(ThinClientHandle $this) {
        return $this.timeoutTicks;
    }

    public static final /* synthetic */ void access$setTimeoutTicks$p(ThinClientHandle $this, int n) {
        $this.timeoutTicks = n;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ LifetimeDefinition access$getLifetimeDef$p(ThinClientHandle $this) {
        return $this.lifetimeDef;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ThinClientHandle.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ThinClientHandle.logger = logger;
        gatewayCapabilities = new GtwToClientMessage.GatewayCapabilities(true);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/gateway/thinClientLink/ThinClientHandle$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/remoteDev/thinClientLink/GtwToClientMessage;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "gatewayCapabilities", "Lcom/intellij/remoteDev/thinClientLink/GtwToClientMessage$GatewayCapabilities;", "intellij.gateway.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

