/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log;

import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.V8RawLogProcessor;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8CpuViewCreatorPartner;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8LogCachingReader;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.FlameChartParameters;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfilingMainComponent;
import com.jetbrains.nodejs.run.profile.heap.CompositeCloseable;
import com.jetbrains.nodejs.run.profile.settings.NodeProfilingSettings;
import icons.NodeJSIcons;
import java.io.File;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ReadV8LogRawAction
extends DumbAwareAction {
    public static final Supplier<@Nls String> TOOL_WINDOW_TITLE = NodeJSBundle.messagePointer("profile.cpu.toolwindow.title", new Object[0]);

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ReadV8LogRawAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        VirtualFile vf = FileChooser.chooseFile((FileChooserDescriptor)FileChooserDescriptorFactory.createSingleLocalFileDescriptor(), (Project)project, null);
        if (vf != null) {
            File file = new File(vf.getPath());
            ReadV8LogRawAction.openFile(project, file);
        }
    }

    public static void openFile(final @NotNull Project project, final File file) {
        if (project == null) {
            ReadV8LogRawAction.$$$reportNull$$$0(1);
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, NodeJSBundle.message("progress.title.process.v8.log", new Object[0]), true){
            private CompositeCloseable myResources;
            private V8LogCachingReader myReader;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                Consumer<String> notificator = ReadV8LogRawAction.createNotificator(project);
                V8RawLogProcessor processor = new V8RawLogProcessor(project, file, notificator);
                processor.run(indicator);
                this.myResources = processor.getResources();
                this.myReader = processor.getReader();
            }

            public void onSuccess() {
                if (this.myReader != null) {
                    String description = file.getName();
                    V8CpuViewCreatorPartner partner = new V8CpuViewCreatorPartner(this.myProject, this.myResources, this.myReader, ReadV8LogRawAction.createNotificator(project), description, null, null, new FlameChartParameters());
                    V8ProfilingMainComponent.showMe(project, description, TOOL_WINDOW_TITLE.get(), NodeJSIcons.OpenV8ProfilingLog_ToolWin, 1, partner, null, description, null);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/nodejs/run/profile/cpu/v8log/ReadV8LogRawAction$1", "run"));
            }
        });
    }

    @NotNull
    public static Consumer<String> createNotificator(@NotNull Project project) {
        if (project == null) {
            ReadV8LogRawAction.$$$reportNull$$$0(2);
        }
        Consumer<String> consumer = s -> NodeProfilingSettings.CPU_NOTIFICATION_GROUP.createNotification(NodeJSBundle.message("profile.cpu.processing.log.error.notification.content", s), NotificationType.ERROR).notify(project);
        if (consumer == null) {
            ReadV8LogRawAction.$$$reportNull$$$0(3);
        }
        return consumer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/run/profile/cpu/v8log/ReadV8LogRawAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/v8log/ReadV8LogRawAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotificator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "openFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createNotificator";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

