/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.calculation;

import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryManager;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.search.LowLevelSearchUtil;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringSearcher;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public final class V8ProfileLineFileDescriptor {
    private final String myName;
    private final String myPath;
    private final int myRow;
    private final int myCol;

    public V8ProfileLineFileDescriptor(String name, String path, int row, int col) {
        this.myName = name;
        this.myPath = path;
        this.myRow = row;
        this.myCol = col;
    }

    public String getPathOrName() {
        return this.myPath == null ? this.myName : this.myPath;
    }

    public String getName() {
        return this.myName;
    }

    public String getPath() {
        return this.myPath;
    }

    public int getRow() {
        return this.myRow;
    }

    public int getCol() {
        return this.myCol;
    }

    public Navigatable[] getNavigatables(Project project, String functionName, boolean isNative) {
        NodeCoreLibraryManager coreLibraryManager;
        VirtualFile fileByName;
        if (this.myPath != null) {
            VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(this.myPath));
            if (file != null) {
                return new Navigatable[]{new OpenFileDescriptor(project, file, Math.max(0, this.myRow - 1), Math.max(0, this.myCol - 1))};
            }
            int idx = this.myPath.indexOf("node_modules");
            if (idx > 0) {
                return this.getNavigatablesFromNodeModules(project, idx);
            }
        }
        if (this.myPath == null && (fileByName = (coreLibraryManager = NodeCoreLibraryManager.getInstance((Project)project)).findCoreModuleFileByName(this.myName)) != null) {
            return new Navigatable[]{new OpenFileDescriptor(project, fileByName, Math.max(0, this.myRow - 1), Math.max(0, this.myCol - 1))};
        }
        JavaScriptIndex instance = JavaScriptIndex.getInstance((Project)project);
        HashSet items = ContainerUtil.newHashSet((Object[])instance.getFileByName(this.myName, true));
        HashSet<Object> list = new HashSet<Object>();
        for (Navigatable navigationItem : items) {
            if (navigationItem instanceof PsiFile) {
                PsiFile jsFile = (PsiFile)navigationItem;
                if (GlobalSearchScope.allScope((Project)project).contains(jsFile.getVirtualFile())) {
                    Collection<NavigationItem> innerSymbols = V8ProfileLineFileDescriptor.lookIntoFile(jsFile, functionName);
                    if (!innerSymbols.isEmpty()) {
                        list.addAll(innerSymbols);
                    }
                    list.add(jsFile);
                    continue;
                }
            }
            if (navigationItem instanceof PsiFile) {
                list.add(new OpenFileDescriptor(project, ((PsiFile)navigationItem).getVirtualFile(), Math.max(0, this.myRow - 1), Math.max(0, this.myCol - 1)));
                continue;
            }
            list.add(navigationItem);
        }
        return list.toArray(Navigatable.EMPTY_NAVIGATABLE_ARRAY);
    }

    private Navigatable @NotNull [] getNavigatablesFromNodeModules(Project project, int idx) {
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        String subPath = this.myPath.substring(idx).replace('\\', '/');
        ArrayList<VirtualFile> candidates = new ArrayList<VirtualFile>();
        Collection files = FilenameIndex.getVirtualFilesByName((String)"node_modules", (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
        for (VirtualFile file2 : files) {
            VirtualFile child;
            if (!file2.isDirectory() || (child = lfs.refreshAndFindFileByIoFile(new File(file2.getPath(), subPath))) == null || !child.isValid()) continue;
            candidates.add(child);
        }
        Collection packageJsonFiles = FilenameIndex.getVirtualFilesByName((String)"package.json", (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
        for (VirtualFile file3 : packageJsonFiles) {
            VirtualFile child;
            if (file3.isDirectory() || file3.getParent() == null || (child = lfs.refreshAndFindFileByIoFile(new File(file3.getParent().getPath(), subPath))) == null || !child.isValid()) continue;
            candidates.add(child);
        }
        candidates.sort(NodeModuleUtil.VIRTUAL_FILE_COMPARATOR);
        Navigatable[] navigatableArray = (Navigatable[])ContainerUtil.map2Array(candidates, Navigatable.class, file -> new OpenFileDescriptor(project, file, Math.max(0, this.myRow - 1), Math.max(0, this.myCol - 1)));
        if (navigatableArray == null) {
            V8ProfileLineFileDescriptor.$$$reportNull$$$0(0);
        }
        return navigatableArray;
    }

    private static Collection<NavigationItem> lookIntoFile(PsiFile file, String functionName) {
        ArrayList<NavigationItem> list = new ArrayList<NavigationItem>();
        int idx = functionName.lastIndexOf(46);
        String clazzName = idx > 0 ? functionName.substring(0, idx) : null;
        String cutFunctionName = idx >= 0 ? functionName.substring(idx + 1) : functionName;
        TextOccurenceProcessor processor = (element, offsetInElement) -> {
            JSQualifiedNamedElement named = null;
            if (element instanceof JSDefinitionExpression && cutFunctionName.equals(((JSDefinitionExpression)element).getName())) {
                named = (JSQualifiedNamedElement)element;
            } else if (element.getNode().getElementType() == JSTokenTypes.IDENTIFIER && element.getParent() instanceof JSFunction) {
                named = (JSQualifiedNamedElement)element.getParent();
            }
            if (named == null) {
                return true;
            }
            JSQualifiedName namespace = named.getNamespace();
            if (clazzName == null || namespace != null && clazzName.equals(namespace.getQualifiedName())) {
                list.add((NavigationItem)element);
            }
            return true;
        };
        StringSearcher searcher = new StringSearcher(cutFunctionName, true, true);
        LowLevelSearchUtil.processElementsContainingWordInElement((TextOccurenceProcessor)processor, (PsiElement)file, (StringSearcher)searcher, (boolean)true, (ProgressIndicator)new EmptyProgressIndicator());
        return list;
    }

    public String getShortLink() {
        if (this.myRow < 0) {
            return this.myName;
        }
        return this.myName + ":" + this.myRow + ":" + this.myCol;
    }

    public String getLink() {
        if (this.myRow < 0) {
            return FileUtil.toSystemDependentName((String)this.getPathOrName());
        }
        return FileUtil.toSystemDependentName((String)this.getPathOrName()) + ":" + this.myRow + ":" + this.myCol;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/cpu/calculation/V8ProfileLineFileDescriptor", "getNavigatablesFromNodeModules"));
    }
}

