/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduceParameter;

import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.refactoring.introduce.BaseIntroduceSettings;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nullable;

public interface JSIntroduceParameterSettings
extends BaseIntroduceSettings {
    public boolean addOptionalParameter();

    public String getInitialValue();

    public JSFunction functionForIntroduceParameter();

    public boolean addJsDoc();

    public void setFunctionToIntroduceParameter(JSFunction var1);

    public static abstract class Base
    implements JSIntroduceParameterSettings {
        protected final Pair<JSExpression, TextRange> myExpressionDescriptor;
        @Nullable
        private SmartPsiElementPointer<JSFunction> myFunctionPointer;

        public Base(Pair<JSExpression, TextRange> expressionDescriptor) {
            this.myExpressionDescriptor = expressionDescriptor;
            JSFunction parentFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)expressionDescriptor.first), JSFunction.class);
            this.myFunctionPointer = parentFunction == null ? null : SmartPointerManager.createPointer((PsiElement)parentFunction);
        }

        @Override
        public JSFunction functionForIntroduceParameter() {
            return this.myFunctionPointer == null ? null : (JSFunction)this.myFunctionPointer.getElement();
        }

        @Override
        public void setFunctionToIntroduceParameter(JSFunction function) {
            this.myFunctionPointer = SmartPointerManager.createPointer((PsiElement)function);
        }

        @Override
        public boolean addJsDoc() {
            return false;
        }
    }
}

