/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptResolveProcessor;
import com.intellij.lang.javascript.ecmascript6.TypeScriptServiceResolveFacade;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeSignatureChooser;
import com.intellij.lang.javascript.ecmascript6.types.OverloadStrictness;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypePredicate;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSReferenceExpressionResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.typescript.TypeScriptResolveHelper;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptReferenceExpressionResolver
extends JSReferenceExpressionResolver
implements ResolveCache.PolyVariantResolver<JSReferenceExpressionImpl> {
    public TypeScriptReferenceExpressionResolver(@NotNull JSReferenceExpressionImpl expression, boolean ignorePerformanceLimits) {
        if (expression == null) {
            TypeScriptReferenceExpressionResolver.$$$reportNull$$$0(0);
        }
        super(expression, ignorePerformanceLimits);
    }

    @Override
    public ResolveResult @NotNull [] resolve(@NotNull JSReferenceExpressionImpl expression, boolean incompleteCode) {
        JSCallLikeExpression callLikeExpression;
        ResolveResult[] resultsFromWebSymbols;
        if (expression == null) {
            TypeScriptReferenceExpressionResolver.$$$reportNull$$$0(1);
        }
        if (this.myReferencedName == null || Registry.is((String)"typescript.disable.ide.resolve")) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                TypeScriptReferenceExpressionResolver.$$$reportNull$$$0(2);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        if (this.myPrivateNameResolve) {
            ResolveResult[] resolveResultArray = this.resolvePrivateNameReference();
            if (resolveResultArray == null) {
                TypeScriptReferenceExpressionResolver.$$$reportNull$$$0(3);
            }
            return resolveResultArray;
        }
        PsiElement currentParent = JSResolveUtil.getTopReferenceParent(this.myParent);
        if (currentParent instanceof TypeScriptTypePredicate) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new JSResolveResult((PsiElement)((TypeScriptTypePredicate)currentParent).getParameterMatchName())};
            if (resolveResultArray == null) {
                TypeScriptReferenceExpressionResolver.$$$reportNull$$$0(4);
            }
            return resolveResultArray;
        }
        if (expression.getQualifier() == null && PsiTreeUtil.getParentOfType((PsiElement)expression, JSEmbeddedContent.class) != null && (resultsFromWebSymbols = this.resolveFromWebSymbols()) != null) {
            if (resultsFromWebSymbols == null) {
                TypeScriptReferenceExpressionResolver.$$$reportNull$$$0(5);
            }
            return resultsFromWebSymbols;
        }
        if (!incompleteCode && (callLikeExpression = TypeScriptSignatureChooser.getCallLikeExpression((PsiElement)expression)) != null) {
            ResolveResult[] results = expression.multiResolve(true);
            if (this.myQualifier instanceof JSSuperExpression && !TypeScriptUtil.isValidSuperQualifier(this.myQualifier)) {
                if (results == null) {
                    TypeScriptReferenceExpressionResolver.$$$reportNull$$$0(6);
                }
                return results;
            }
            ResolveResult[] resolveResultArray = new JSTypeSignatureChooser(callLikeExpression).chooseOverload(results, OverloadStrictness.UNIQUE);
            if (resolveResultArray == null) {
                TypeScriptReferenceExpressionResolver.$$$reportNull$$$0(7);
            }
            return resolveResultArray;
        }
        Object[] resolveResults = this.doResolveReference(incompleteCode);
        if (currentParent instanceof TypeScriptModule) {
            ResolveResult[] resolveResultArray = (ResolveResult[])ArrayUtil.mergeArrays((Object[])resolveResults, (Object[])new ResolveResult[]{new JSResolveResult(currentParent)});
            if (resolveResultArray == null) {
                TypeScriptReferenceExpressionResolver.$$$reportNull$$$0(8);
            }
            return resolveResultArray;
        }
        if (this.isDummyResolve((ResolveResult[])resolveResults)) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new JSResolveResult((PsiElement)this.myRef)};
            if (resolveResultArray == null) {
                TypeScriptReferenceExpressionResolver.$$$reportNull$$$0(9);
            }
            return resolveResultArray;
        }
        if (resolveResults == null) {
            TypeScriptReferenceExpressionResolver.$$$reportNull$$$0(10);
        }
        return resolveResults;
    }

    private boolean isDummyResolve(ResolveResult[] results) {
        if (this.undefinedResolve(results)) {
            return true;
        }
        if (results != null && results.length != 0) {
            return false;
        }
        return this.isGlobalThis();
    }

    private ResolveResult[] doResolveReference(boolean incompleteCode) {
        assert (this.myReferencedName != null);
        TypeScriptResolveProcessor localProcessor = (TypeScriptResolveProcessor)JSDialectSpecificHandlersFactory.forLanguage((Language)JavaScriptSupportLoader.TYPESCRIPT).createResolveProcessor(this.myReferencedName, (PsiElement)this.myRef, incompleteCode);
        boolean isTypeContext = JSResolveUtil.isExprInTypeContext(this.myRef);
        if (this.myQualifier == null || this.myQualifier instanceof JSSuperExpression && TypeScriptUtil.isValidSuperQualifier(this.myQualifier)) {
            localProcessor.setToProcessHierarchy(true);
            boolean strictTypeContext = localProcessor.isStrictTypeContext();
            if (strictTypeContext) {
                this.processLocalDeclarationsByExportScopes(localProcessor, this.myRef);
            } else {
                this.processLocalDeclarations(localProcessor, (PsiElement)this.myRef, false, null);
            }
            ResolveResult[] results = localProcessor.getResultsAsResolveResults();
            PsiElement complete = ((ResolveResultSink)localProcessor.getResultSink()).getCompleteResult();
            if (complete != null) {
                return results;
            }
            if (this.myQualifier == null) {
                TypeScriptResolveHelper.processGlobalThings(localProcessor, ResolveState.initial(), (PsiElement)this.myRef);
            }
            return localProcessor.getResultsAsResolveResults();
        }
        JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)this.myRef, () -> JSResolveUtil.evaluateQualifierType(this.myQualifier, this.myRef, localProcessor));
        ResolveResult[] results = localProcessor.getResultsIfResolveCompleted();
        if (results != null) {
            return results;
        }
        ResolveResult[] resultsFromProviders = this.resolveFromProviders();
        if (resultsFromProviders != null) {
            return resultsFromProviders;
        }
        ResolveResult[] resultsFromService = TypeScriptServiceResolveFacade.resolve(this.myRef, this.myReferencedName, incompleteCode);
        if (resultsFromService != null) {
            return resultsFromService;
        }
        ResolveResult[] results2 = this.resolveFromIndices(localProcessor, false, isTypeContext);
        return this.postProcessIndexResults(results2);
    }

    protected ResolveResult[] postProcessIndexResults(ResolveResult[] results) {
        return results.length <= 1 || this.myIgnorePerformanceLimits ? results : JSResolveResult.tooManyCandidatesResult();
    }

    private void processLocalDeclarationsByExportScopes(@NotNull TypeScriptResolveProcessor<ResolveResultSink> localProcessor, @NotNull JSElement startElement) {
        if (localProcessor == null) {
            TypeScriptReferenceExpressionResolver.$$$reportNull$$$0(11);
        }
        if (startElement == null) {
            TypeScriptReferenceExpressionResolver.$$$reportNull$$$0(12);
        }
        JSElement scope2 = startElement;
        while (scope2 != null) {
            if (!(scope2 instanceof JSExpressionCodeFragment) && TypeScriptReferenceExpressionResolver.isExportedScope((PsiElement)scope2)) {
                if (!scope2.processDeclarations(localProcessor, ResolveState.initial(), (PsiElement)scope2, (PsiElement)this.myRef)) {
                    break;
                }
            } else {
                JSElement context2 = scope2;
                if ((scope2 = TypeScriptReferenceExpressionResolver.getExportedScopeOrContext((PsiElement)scope2)) instanceof JSExpressionCodeFragment) {
                    scope2 = null;
                }
                this.processLocalDeclarations(localProcessor, (PsiElement)context2, true, (PsiElement)scope2);
                if (((ResolveResultSink)localProcessor.getResultSink()).getCompleteResult() != null) break;
            }
            scope2 = TypeScriptReferenceExpressionResolver.getExportedScopeOrContext((PsiElement)scope2);
        }
    }

    @Nullable
    private static PsiElement getExportedScopeOrContext(@Nullable PsiElement stopAt) {
        if (stopAt == null) {
            return null;
        }
        PsiElement stopElement = JSResolveUtil.getContext(stopAt);
        if (stopElement != null) {
            return stopElement;
        }
        if (stopAt instanceof PsiFile) {
            return null;
        }
        NavigatablePsiElement type2 = TypeScriptReferenceExpressionResolver.getParentCandidate(stopAt);
        while (type2 != null && !TypeScriptReferenceExpressionResolver.isExportedScope((PsiElement)type2)) {
            if (TypeScriptReferenceExpressionResolver.isExportedScope(type2.getContext())) {
                return type2;
            }
            type2 = TypeScriptReferenceExpressionResolver.getParentCandidate((PsiElement)type2);
        }
        return type2;
    }

    @Nullable
    private static NavigatablePsiElement getParentCandidate(@Nullable PsiElement stopAt) {
        return (NavigatablePsiElement)PsiTreeUtil.getParentOfType((PsiElement)stopAt, (Class[])new Class[]{JSStatement.class, JSExecutionScope.class, JSClass.class, PsiFile.class});
    }

    private static boolean isExportedScope(@Nullable PsiElement type2) {
        return type2 instanceof TypeScriptModule || type2 instanceof PsiFile || ES6PsiUtil.isEmbeddedModule(type2);
    }

    private void processLocalDeclarations(@NotNull TypeScriptResolveProcessor<ResolveResultSink> localProcessor, @NotNull PsiElement context2, boolean strictTypeContext, @Nullable PsiElement stopAt) {
        if (localProcessor == null) {
            TypeScriptReferenceExpressionResolver.$$$reportNull$$$0(13);
        }
        if (context2 == null) {
            TypeScriptReferenceExpressionResolver.$$$reportNull$$$0(14);
        }
        JSReferenceExpressionImpl.doProcessLocalDeclarations(context2, this.myQualifier, localProcessor, false, false, strictTypeContext, stopAt);
    }

    @Override
    @Nullable
    protected String adjustReferencedName(@NotNull JSReferenceExpression ref2) {
        if (ref2 == null) {
            TypeScriptReferenceExpressionResolver.$$$reportNull$$$0(15);
        }
        return TypeScriptReferenceExpressionResolver.adjustPrimitiveTypes(ref2);
    }

    @Nullable
    public static String adjustPrimitiveTypes(@NotNull JSReferenceExpression ref2) {
        String wrapperType;
        if (ref2 == null) {
            TypeScriptReferenceExpressionResolver.$$$reportNull$$$0(16);
        }
        String referenceName = ref2.getReferenceName();
        if (JSResolveUtil.isExprInStrictTypeContext(ref2) && ref2.getQualifier() == null && (wrapperType = JSCommonTypeNames.PRIMITIVE_TYPE_TO_WRAPPER_MAP.get(referenceName)) != null) {
            return wrapperType;
        }
        return referenceName;
    }

    @Override
    protected boolean prepareProcessor(WalkUpResolveProcessor processor, @NotNull SinkResolveProcessor<ResolveResultSink> localProcessor) {
        if (localProcessor == null) {
            TypeScriptReferenceExpressionResolver.$$$reportNull$$$0(17);
        }
        if (!localProcessor.isEncounteredDynamicClasses() || this.myQualifier instanceof JSThisExpression) {
            processor.allowPartialResults();
        } else {
            processor.setAddOnlyCompleteMatches();
        }
        processor.setSkipDefinitions(false);
        return true;
    }

    @Override
    protected ResolveResult[] getResultsForDefinition() {
        JSTypeSource source;
        JSType type2;
        if (this.myQualifier == null) {
            return ResolveResult.EMPTY_ARRAY;
        }
        if (this.myQualifier instanceof JSReferenceExpression && (type2 = JSResolveUtil.getExpressionJSType(this.myQualifier)) != null && !(type2 instanceof JSAnyType) && (source = type2.getSource()).isStrict()) {
            return ResolveResult.EMPTY_ARRAY;
        }
        return new ResolveResult[]{new JSResolveResult(this.myParent)};
    }

    private ResolveResult @Nullable [] resolveFromWebSymbols() {
        for (PsiReference reference : ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this.myRef)) {
            ResolveResult[] results;
            if (!(reference instanceof PsiReferenceFromWebSymbolContributor) || (results = ((PsiPolyVariantReference)reference).multiResolve(false)).length <= 0) continue;
            return results;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceExpressionResolver";
                break;
            }
            case 11: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localProcessor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptReferenceExpressionResolver";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processLocalDeclarationsByExportScopes";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processLocalDeclarations";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "adjustReferencedName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "adjustPrimitiveTypes";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "prepareProcessor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static interface PsiReferenceFromWebSymbolContributor
    extends PsiPolyVariantReference {
    }
}

