/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp.codeInsight;

import com.google.common.collect.ImmutableMap;
import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.buildTools.JSPsiUtil;
import com.intellij.lang.javascript.buildTools.gulp.codeInsight.NodeRequireDirCall;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GulpfilePsiStructure {
    private static final Key<CachedValue<GulpfilePsiStructure>> KEY = Key.create((String)GulpfilePsiStructure.class.getName());
    private static final Key<Boolean> PROCESSING = Key.create((String)"Building gulpfile structure");
    private final Map<String, JSCallExpression> myPsiByNameMap;

    public GulpfilePsiStructure(@NotNull Map<String, JSCallExpression> psiByNameMap) {
        if (psiByNameMap == null) {
            GulpfilePsiStructure.$$$reportNull$$$0(0);
        }
        this.myPsiByNameMap = ImmutableMap.copyOf(psiByNameMap);
    }

    @Nullable
    public JSCallExpression getPsiByName(@NotNull String taskName) {
        if (taskName == null) {
            GulpfilePsiStructure.$$$reportNull$$$0(1);
        }
        return this.myPsiByNameMap.get(taskName);
    }

    @NotNull
    public Collection<String> getTasks() {
        Set<String> set = this.myPsiByNameMap.keySet();
        if (set == null) {
            GulpfilePsiStructure.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    private static GulpfilePsiStructure build(@NotNull JSFile file) {
        if (file == null) {
            GulpfilePsiStructure.$$$reportNull$$$0(3);
        }
        HashMap<String, JSCallExpression> taskNameToPsiMap = new HashMap<String, JSCallExpression>();
        List<JSStatement> statements = JsPsiUtils.listStatementsInExecutionOrder(file);
        HashSet<String> requireDirVarNames = new HashSet<String>();
        GulpfilePsiStructure.collectImports(file, requireDirVarNames);
        for (JSStatement statement : statements) {
            JSCallExpression callExpression = JSPsiUtil.getCallExpression((PsiElement)statement);
            if (callExpression != null) {
                String taskName = GulpfilePsiStructure.getGulpTaskName(callExpression);
                if (taskName != null) {
                    taskNameToPsiMap.put(taskName, callExpression);
                    continue;
                }
                GulpfilePsiStructure.processRequireDirCall(file, callExpression, requireDirVarNames, taskNameToPsiMap);
                GulpfilePsiStructure.processFileRequireCall(file, callExpression, taskNameToPsiMap);
                GulpfilePsiStructure.processFileRequireCall2(file, callExpression, taskNameToPsiMap);
                continue;
            }
            if (!(statement instanceof JSVarStatement)) continue;
            JSVarStatement varStatement = (JSVarStatement)statement;
            for (JSVariable variable : varStatement.getVariables()) {
                GulpfilePsiStructure.processVariable(file, variable, requireDirVarNames, taskNameToPsiMap);
            }
        }
        return new GulpfilePsiStructure(taskNameToPsiMap);
    }

    private static void collectImports(@NotNull JSFile file, @NotNull Set<String> requireDirVarNames) {
        DialectOptionHolder holder;
        if (file == null) {
            GulpfilePsiStructure.$$$reportNull$$$0(4);
        }
        if (requireDirVarNames == null) {
            GulpfilePsiStructure.$$$reportNull$$$0(5);
        }
        if ((holder = DialectDetector.dialectOfElement(file)) != null && holder.isECMA6) {
            PsiElement[] children;
            for (PsiElement child : children = file.getChildren()) {
                ES6ImportDeclaration decl;
                String name;
                if (!(child instanceof ES6ImportDeclaration) || (name = ES6ImportPsiUtil.getFromClauseText(decl = (ES6ImportDeclaration)child)) == null || !NodeRequireDirCall.isRequireDirLiteralValue(name)) continue;
                for (ES6ImportedBinding binding : decl.getImportedBindings()) {
                    String varName = binding.getName();
                    if (!StringUtil.isNotEmpty((String)varName)) continue;
                    requireDirVarNames.add(varName);
                }
            }
        }
    }

    private static void processVariable(@NotNull JSFile file, @Nullable JSVariable variable, @NotNull Set<String> requireDirVarNames, @NotNull Map<String, JSCallExpression> taskNameToPsiMap) {
        if (file == null) {
            GulpfilePsiStructure.$$$reportNull$$$0(6);
        }
        if (requireDirVarNames == null) {
            GulpfilePsiStructure.$$$reportNull$$$0(7);
        }
        if (taskNameToPsiMap == null) {
            GulpfilePsiStructure.$$$reportNull$$$0(8);
        }
        if (variable == null) {
            return;
        }
        JSCallExpression callExpression = (JSCallExpression)ObjectUtils.tryCast((Object)variable.getInitializerOrStub(), JSCallExpression.class);
        if (callExpression != null) {
            if (NodeRequireDirCall.isRequireDirRequireCall(callExpression)) {
                String name = variable.getQualifiedName();
                if (StringUtil.isNotEmpty((String)name)) {
                    requireDirVarNames.add(name);
                }
            } else {
                GulpfilePsiStructure.processRequireDirCall(file, callExpression, requireDirVarNames, taskNameToPsiMap);
            }
        }
    }

    private static void processRequireDirCall(@NotNull JSFile callerFile, @NotNull JSCallExpression callExpr, @NotNull Set<String> requireDirVarNames, @NotNull Map<String, JSCallExpression> taskToPsiMap) {
        VirtualFile requiredDir;
        NodeRequireDirCall requireDirCall;
        if (callerFile == null) {
            GulpfilePsiStructure.$$$reportNull$$$0(9);
        }
        if (callExpr == null) {
            GulpfilePsiStructure.$$$reportNull$$$0(10);
        }
        if (requireDirVarNames == null) {
            GulpfilePsiStructure.$$$reportNull$$$0(11);
        }
        if (taskToPsiMap == null) {
            GulpfilePsiStructure.$$$reportNull$$$0(12);
        }
        if ((requireDirCall = NodeRequireDirCall.build(callExpr, requireDirVarNames)) != null && (requiredDir = requireDirCall.resolveRequiredDir(callerFile.getViewProvider().getVirtualFile())) != null) {
            for (VirtualFile child : requiredDir.getChildren()) {
                GulpfilePsiStructure.addTasksFromFile(callerFile.getManager(), child, taskToPsiMap);
            }
        }
    }

    private static void processFileRequireCall(@NotNull JSFile callerFile, @NotNull JSCallExpression callExpr, @NotNull Map<String, JSCallExpression> taskNameToPsiMap) {
        String value;
        JSLiteralExpression literal;
        if (callerFile == null) {
            GulpfilePsiStructure.$$$reportNull$$$0(13);
        }
        if (callExpr == null) {
            GulpfilePsiStructure.$$$reportNull$$$0(14);
        }
        if (taskNameToPsiMap == null) {
            GulpfilePsiStructure.$$$reportNull$$$0(15);
        }
        if (callExpr.isRequireCall() && (literal = JSPsiUtil.getFirstArgumentAsStringLiteral(callExpr.getArgumentList())) != null && ((value = JSPsiUtil.getStringLiteralValue(literal)).startsWith("./") || value.startsWith("../"))) {
            for (PsiReference reference : literal.getReferences()) {
                VirtualFile child;
                PsiElement element = reference.resolve();
                if (element == null || (child = PsiUtilBase.asVirtualFile((PsiElement)element)) == null) continue;
                GulpfilePsiStructure.addTasksFromFile(callerFile.getManager(), child, taskNameToPsiMap);
            }
        }
    }

    private static void processFileRequireCall2(@NotNull JSFile callerFile, @NotNull JSCallExpression callExpr, @NotNull Map<String, JSCallExpression> taskNameToPsiMap) {
        JSCallExpression requireCallExpr;
        if (callerFile == null) {
            GulpfilePsiStructure.$$$reportNull$$$0(16);
        }
        if (callExpr == null) {
            GulpfilePsiStructure.$$$reportNull$$$0(17);
        }
        if (taskNameToPsiMap == null) {
            GulpfilePsiStructure.$$$reportNull$$$0(18);
        }
        if ((requireCallExpr = (JSCallExpression)ObjectUtils.tryCast((Object)callExpr.getMethodExpression(), JSCallExpression.class)) != null) {
            GulpfilePsiStructure.processFileRequireCall(callerFile, requireCallExpr, taskNameToPsiMap);
        }
    }

    private static void addTasksFromFile(@NotNull PsiManager psiManager, @NotNull VirtualFile file, @NotNull Map<String, JSCallExpression> taskToPsiMap) {
        PsiFile psiFile;
        if (psiManager == null) {
            GulpfilePsiStructure.$$$reportNull$$$0(19);
        }
        if (file == null) {
            GulpfilePsiStructure.$$$reportNull$$$0(20);
        }
        if (taskToPsiMap == null) {
            GulpfilePsiStructure.$$$reportNull$$$0(21);
        }
        if (!file.isDirectory() && (psiFile = psiManager.findFile(file)) instanceof JSFile && PROCESSING.get((UserDataHolder)psiFile) != Boolean.TRUE) {
            GulpfilePsiStructure structure = GulpfilePsiStructure.get((JSFile)psiFile);
            taskToPsiMap.putAll(structure.myPsiByNameMap);
        }
    }

    @Nullable
    private static String getGulpTaskName(@Nullable JSCallExpression callExpression) {
        String taskName;
        JSExpression[] arguments;
        if (callExpression == null) {
            return null;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)callExpression.getMethodExpression(), JSReferenceExpression.class);
        if (referenceExpression != null && GulpfilePsiStructure.isGulpTaskFunctionReference(referenceExpression) && (arguments = callExpression.getArguments()).length >= 2 && (taskName = JSPsiUtil.getStringLiteralValue(arguments[0])) != null) {
            return taskName;
        }
        return null;
    }

    private static boolean isGulpTaskFunctionReference(@NotNull JSReferenceExpression gulpTaskFunction) {
        if (gulpTaskFunction == null) {
            GulpfilePsiStructure.$$$reportNull$$$0(22);
        }
        if ("task".equals(gulpTaskFunction.getReferenceName())) {
            JSReferenceExpression qualifier = (JSReferenceExpression)ObjectUtils.tryCast((Object)gulpTaskFunction.getQualifier(), JSReferenceExpression.class);
            return qualifier != null && qualifier.getQualifier() == null && "gulp".equals(qualifier.getReferenceName());
        }
        return false;
    }

    public static boolean isDependency(@NotNull JSLiteralExpression dependency) {
        JSArrayLiteralExpression arrayLiteral;
        if (dependency == null) {
            GulpfilePsiStructure.$$$reportNull$$$0(23);
        }
        if ((arrayLiteral = (JSArrayLiteralExpression)ObjectUtils.tryCast((Object)dependency.getParent(), JSArrayLiteralExpression.class)) == null) {
            return false;
        }
        JSArgumentList argumentList = (JSArgumentList)ObjectUtils.tryCast((Object)arrayLiteral.getParent(), JSArgumentList.class);
        if (argumentList == null) {
            return false;
        }
        JSCallExpression callExpression = (JSCallExpression)ObjectUtils.tryCast((Object)argumentList.getParent(), JSCallExpression.class);
        if (callExpression == null) {
            return false;
        }
        return GulpfilePsiStructure.getGulpTaskName(callExpression) != null;
    }

    @NotNull
    public static GulpfilePsiStructure get(@NotNull JSFile jsFile) {
        if (jsFile == null) {
            GulpfilePsiStructure.$$$reportNull$$$0(24);
        }
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)jsFile.getProject());
        GulpfilePsiStructure gulpfilePsiStructure = (GulpfilePsiStructure)cachedValuesManager.getCachedValue((UserDataHolder)jsFile, KEY, () -> {
            try {
                PROCESSING.set((UserDataHolder)jsFile, (Object)Boolean.TRUE);
                GulpfilePsiStructure structure = GulpfilePsiStructure.build(jsFile);
                CachedValueProvider.Result result2 = CachedValueProvider.Result.create((Object)structure, (Object[])new Object[]{jsFile});
                return result2;
            }
            finally {
                PROCESSING.set((UserDataHolder)jsFile, null);
            }
        }, false);
        if (gulpfilePsiStructure == null) {
            GulpfilePsiStructure.$$$reportNull$$$0(25);
        }
        return gulpfilePsiStructure;
    }

    @Nullable
    public static Pair<String, JSCallExpression> findEnclosingTask(@NotNull PsiElement element, @NotNull JSFile psiGulpfile) {
        if (element == null) {
            GulpfilePsiStructure.$$$reportNull$$$0(26);
        }
        if (psiGulpfile == null) {
            GulpfilePsiStructure.$$$reportNull$$$0(27);
        }
        PsiElement statement = PsiTreeUtil.findFirstParent((PsiElement)element, (boolean)false, element1 -> {
            if (element1 == psiGulpfile) {
                return true;
            }
            JSCallExpression callExpression = JSPsiUtil.getCallExpression(element1);
            return GulpfilePsiStructure.getGulpTaskName(callExpression) != null;
        });
        JSCallExpression callExpression = JSPsiUtil.getCallExpression(statement);
        String taskName = GulpfilePsiStructure.getGulpTaskName(callExpression);
        if (callExpression != null && taskName != null) {
            return Pair.create((Object)taskName, (Object)callExpression);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiByNameMap";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 2: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/gulp/codeInsight/GulpfilePsiStructure";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requireDirVarNames";
                break;
            }
            case 8: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskNameToPsiMap";
                break;
            }
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callerFile";
                break;
            }
            case 10: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpr";
                break;
            }
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskToPsiMap";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gulpTaskFunction";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFile";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiGulpfile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/gulp/codeInsight/GulpfilePsiStructure";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTasks";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPsiByName";
                break;
            }
            case 2: 
            case 25: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectImports";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processVariable";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processRequireDirCall";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processFileRequireCall";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processFileRequireCall2";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addTasksFromFile";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isGulpTaskFunctionReference";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isDependency";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findEnclosingTask";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 25 -> new IllegalStateException(string);
        };
    }
}

