/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.npm;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.util.JsonUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AvailablePackageVersions {
    public static final String LATEST_DIST_TAG = "latest";
    private static final Logger LOG = Logger.getInstance(AvailablePackageVersions.class);
    private static final AvailablePackageVersions EMPTY = new AvailablePackageVersions(new Builder());
    private static final String DIST_TAGS = "dist-tags";
    private static final String VERSIONS = "versions";
    private static final String DEPRECATED = "deprecated";
    private static final String DIST = "dist";
    private static final String TARBALL = "tarball";
    private final List<Pair<String, SemVer>> myDistTags;
    private final ImmutableSortedMap<SemVer, VersionInfo> myVersions;

    private AvailablePackageVersions(@NotNull Builder builder2) {
        if (builder2 == null) {
            AvailablePackageVersions.$$$reportNull$$$0(0);
        }
        this.myDistTags = List.copyOf(builder2.myDistTags);
        this.myVersions = ImmutableSortedMap.copyOf(builder2.myVersions, Comparator.reverseOrder());
    }

    @NotNull
    public static AvailablePackageVersions parseFromPackageMetadata(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            AvailablePackageVersions.$$$reportNull$$$0(1);
        }
        Builder builder2 = new Builder();
        if (reader.peek() == JsonToken.BEGIN_OBJECT) {
            AvailablePackageVersions.readPackageMetadata(reader, builder2);
        }
        return new AvailablePackageVersions(builder2);
    }

    @NotNull
    public static AvailablePackageVersions parseFromPackageMetadata(@NotNull JsonObject root) {
        if (root == null) {
            AvailablePackageVersions.$$$reportNull$$$0(2);
        }
        JsonObjectBuilder builder2 = new JsonObjectBuilder();
        builder2.build(root);
        return new AvailablePackageVersions(builder2);
    }

    @NotNull
    public List<SemVer> getVersions() {
        ImmutableList immutableList = this.myVersions.keySet().asList();
        if (immutableList == null) {
            AvailablePackageVersions.$$$reportNull$$$0(3);
        }
        return immutableList;
    }

    @NotNull
    public List<Pair<String, SemVer>> getDistTags() {
        List<Pair<String, SemVer>> list = this.myDistTags;
        if (list == null) {
            AvailablePackageVersions.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public SortedMap<SemVer, VersionInfo> getVersionsInfo() {
        ImmutableSortedMap<SemVer, VersionInfo> immutableSortedMap = this.myVersions;
        if (immutableSortedMap == null) {
            AvailablePackageVersions.$$$reportNull$$$0(5);
        }
        return immutableSortedMap;
    }

    @Nullable
    public SemVer findVersionByDistTag(@NotNull String distTagName) {
        if (distTagName == null) {
            AvailablePackageVersions.$$$reportNull$$$0(6);
        }
        for (Pair<String, SemVer> tag : this.myDistTags) {
            if (!distTagName.equals(tag.getFirst())) continue;
            return (SemVer)tag.getSecond();
        }
        return null;
    }

    @Nullable
    public SemVer findVersionByLatestDistTag() {
        return this.findVersionByDistTag(LATEST_DIST_TAG);
    }

    @Nullable
    public String findDistTagByVersion(@NotNull SemVer version2) {
        if (version2 == null) {
            AvailablePackageVersions.$$$reportNull$$$0(7);
        }
        return this.myDistTags.stream().filter(pair -> version2.getRawVersion().equals(((SemVer)pair.second).getRawVersion())).map(pair -> (String)pair.first).findFirst().orElse(null);
    }

    private static void readPackageMetadata(@NotNull JsonReader reader, @NotNull Builder builder2) throws IOException {
        if (reader == null) {
            AvailablePackageVersions.$$$reportNull$$$0(8);
        }
        if (builder2 == null) {
            AvailablePackageVersions.$$$reportNull$$$0(9);
        }
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (DIST_TAGS.equals(name)) {
                AvailablePackageVersions.readDistTags(reader, builder2);
                continue;
            }
            if (VERSIONS.equals(name)) {
                if (reader.peek() == JsonToken.BEGIN_OBJECT) {
                    AvailablePackageVersions.readVersionsObject(reader, builder2);
                    continue;
                }
                AvailablePackageVersions.readVersionsArray(reader, builder2);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
    }

    private static void readDistTags(@NotNull JsonReader reader, @NotNull Builder builder2) throws IOException {
        if (reader == null) {
            AvailablePackageVersions.$$$reportNull$$$0(10);
        }
        if (builder2 == null) {
            AvailablePackageVersions.$$$reportNull$$$0(11);
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            reader.skipValue();
            return;
        }
        reader.beginObject();
        while (reader.hasNext()) {
            String distTagName = reader.nextName();
            String versionStr = JsonUtil.nextStringOrSkip((JsonReader)reader);
            SemVer version2 = SemVer.parseFromText((String)versionStr);
            if (version2 == null) {
                LOG.info("Cannot parse dist-tag version from " + versionStr);
                continue;
            }
            builder2.addDistTag((Pair<String, SemVer>)Pair.create((Object)distTagName, (Object)version2));
        }
        reader.endObject();
    }

    private static void readVersionsObject(@NotNull JsonReader reader, @NotNull Builder builder2) throws IOException {
        if (reader == null) {
            AvailablePackageVersions.$$$reportNull$$$0(12);
        }
        if (builder2 == null) {
            AvailablePackageVersions.$$$reportNull$$$0(13);
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            reader.skipValue();
            return;
        }
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            SemVer version2 = SemVer.parseFromText((String)name);
            if (version2 != null) {
                AvailablePackageVersions.readVersionInfo(reader, version2, builder2);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
    }

    private static void readVersionInfo(@NotNull JsonReader reader, @NotNull SemVer version2, @NotNull Builder builder2) throws IOException {
        if (reader == null) {
            AvailablePackageVersions.$$$reportNull$$$0(14);
        }
        if (version2 == null) {
            AvailablePackageVersions.$$$reportNull$$$0(15);
        }
        if (builder2 == null) {
            AvailablePackageVersions.$$$reportNull$$$0(16);
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            reader.skipValue();
            return;
        }
        reader.beginObject();
        boolean isDeprecated = false;
        String url = null;
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals(DIST) && reader.peek() == JsonToken.BEGIN_OBJECT) {
                reader.beginObject();
                while (reader.hasNext()) {
                    name = reader.nextName();
                    if (name.equals(TARBALL) && reader.peek() == JsonToken.STRING) {
                        url = reader.nextString();
                        continue;
                    }
                    reader.skipValue();
                }
                reader.endObject();
                continue;
            }
            if (name.equals(DEPRECATED)) {
                if (reader.peek() == JsonToken.STRING) {
                    reader.skipValue();
                    isDeprecated = true;
                    continue;
                }
                if (reader.peek() == JsonToken.BOOLEAN) {
                    isDeprecated = reader.nextBoolean();
                    continue;
                }
                reader.skipValue();
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        builder2.addVersion(version2, new VersionInfo(url, isDeprecated));
    }

    private static void readVersionsArray(@NotNull JsonReader reader, @NotNull Builder builder2) throws IOException {
        if (reader == null) {
            AvailablePackageVersions.$$$reportNull$$$0(17);
        }
        if (builder2 == null) {
            AvailablePackageVersions.$$$reportNull$$$0(18);
        }
        if (reader.peek() != JsonToken.BEGIN_ARRAY) {
            reader.skipValue();
            return;
        }
        reader.beginArray();
        while (reader.hasNext()) {
            SemVer version2 = SemVer.parseFromText((String)JsonUtil.nextStringOrSkip((JsonReader)reader));
            if (version2 == null) continue;
            builder2.addVersion(version2);
        }
        reader.endArray();
    }

    @NotNull
    public static AvailablePackageVersions createEmpty() {
        AvailablePackageVersions availablePackageVersions = EMPTY;
        if (availablePackageVersions == null) {
            AvailablePackageVersions.$$$reportNull$$$0(19);
        }
        return availablePackageVersions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/npm/AvailablePackageVersions";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distTagName";
                break;
            }
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/npm/AvailablePackageVersions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDistTags";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionsInfo";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmpty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseFromPackageMetadata";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 19: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findVersionByDistTag";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findDistTagByVersion";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readPackageMetadata";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readDistTags";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readVersionsObject";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "readVersionInfo";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "readVersionsArray";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 19 -> new IllegalStateException(string);
        };
    }

    private static class Builder {
        private final List<Pair<String, SemVer>> myDistTags = new ArrayList<Pair<String, SemVer>>();
        private final Map<SemVer, VersionInfo> myVersions = new HashMap<SemVer, VersionInfo>();

        private Builder() {
        }

        protected void addDistTag(@NotNull Pair<String, SemVer> distTag) {
            if (distTag == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myDistTags.add(distTag);
        }

        protected void addVersion(@NotNull SemVer version2) {
            if (version2 == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myVersions.put(version2, new VersionInfo(null, false));
        }

        protected void addVersion(@NotNull SemVer version2, @NotNull VersionInfo versionInfo) {
            if (version2 == null) {
                Builder.$$$reportNull$$$0(2);
            }
            if (versionInfo == null) {
                Builder.$$$reportNull$$$0(3);
            }
            this.myVersions.put(version2, versionInfo);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "distTag";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "version";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "versionInfo";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/nodejs/npm/AvailablePackageVersions$Builder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addDistTag";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addVersion";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class JsonObjectBuilder
    extends Builder {
        private JsonObjectBuilder() {
        }

        private void build(@NotNull JsonObject rootObj) {
            if (rootObj == null) {
                JsonObjectBuilder.$$$reportNull$$$0(0);
            }
            this.buildDistTags(JsonUtil.getChildAsObject((JsonObject)rootObj, (String)AvailablePackageVersions.DIST_TAGS));
            this.buildVersions(rootObj.get(AvailablePackageVersions.VERSIONS));
        }

        private void buildDistTags(@Nullable JsonObject distTags) {
            if (distTags == null) {
                return;
            }
            for (Map.Entry entry : distTags.entrySet()) {
                String distTagName = (String)entry.getKey();
                String versionStr = JsonUtil.getString((JsonElement)((JsonElement)entry.getValue()));
                SemVer version2 = SemVer.parseFromText((String)versionStr);
                if (version2 == null) {
                    LOG.info("Cannot parse dist-tag version from " + versionStr);
                    continue;
                }
                this.addDistTag((Pair<String, SemVer>)Pair.create((Object)distTagName, (Object)version2));
            }
        }

        private void buildVersions(@Nullable JsonElement versionsElement) {
            block3: {
                block2: {
                    if (!(versionsElement instanceof JsonArray)) break block2;
                    for (String version2 : JsonUtil.arrayToStringList((JsonArray)((JsonArray)versionsElement))) {
                        SemVer semVer = SemVer.parseFromText((String)version2);
                        if (semVer == null) continue;
                        this.addVersion(semVer, new VersionInfo(null, false));
                    }
                    break block3;
                }
                if (!(versionsElement instanceof JsonObject)) break block3;
                for (Map.Entry entry : ((JsonObject)versionsElement).entrySet()) {
                    SemVer version3 = SemVer.parseFromText((String)((String)entry.getKey()));
                    JsonObject valueObj = (JsonObject)ObjectUtils.tryCast(entry.getValue(), JsonObject.class);
                    if (version3 == null || valueObj == null) continue;
                    boolean deprecated = JsonObjectBuilder.isDeprecated(valueObj.get(AvailablePackageVersions.DEPRECATED));
                    JsonObject distObj = JsonUtil.getChildAsObject((JsonObject)valueObj, (String)AvailablePackageVersions.DIST);
                    String url = JsonUtil.getChildAsString((JsonObject)distObj, (String)AvailablePackageVersions.TARBALL);
                    this.addVersion(version3, new VersionInfo(url, deprecated));
                }
            }
        }

        private static boolean isDeprecated(@Nullable JsonElement deprecated) {
            Boolean booleanValue = JsonUtil.getBoolean((JsonElement)deprecated);
            if (booleanValue != null) {
                return booleanValue;
            }
            return JsonUtil.getString((JsonElement)deprecated) != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootObj", "com/intellij/javascript/nodejs/npm/AvailablePackageVersions$JsonObjectBuilder", "build"));
        }
    }

    public static class VersionInfo {
        private final boolean myDeprecated;
        private final String myUrl;

        public VersionInfo(@Nullable String url, boolean deprecated) {
            this.myUrl = url;
            this.myDeprecated = deprecated;
        }

        public boolean isDeprecated() {
            return this.myDeprecated;
        }

        @Nullable
        public String getUrl() {
            return this.myUrl;
        }
    }
}

