/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.microservices;

import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.stubs.JSFrameworkMarkersIndex;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001d\u0010\u0006\u001a\u00020\u00012\u000b\u0010\u0007\u001a\u00070\u0001\u00a2\u0006\u0002\b\b2\u0006\u0010\t\u001a\u00020\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"URL_PARAMETER_PREFIX", "", "isArgumentForUrlParameterCandidate", "", "expression", "Lcom/intellij/lang/javascript/psi/JSExpression;", "getKey", "functionName", "Lcom/intellij/openapi/util/NlsSafe;", "parameterIndex", "", "intellij.javascript.langInjection"})
public final class JSUrlParameterIndexingHandlerKt {
    @NotNull
    private static final String URL_PARAMETER_PREFIX = "url_param";

    public static final boolean isArgumentForUrlParameterCandidate(@NotNull JSExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        PsiElement psiElement = expression.getParent();
        JSArgumentList jSArgumentList = psiElement instanceof JSArgumentList ? (JSArgumentList)psiElement : null;
        PsiElement psiElement2 = jSArgumentList != null ? jSArgumentList.getParent() : null;
        JSCallExpression jSCallExpression = psiElement2 instanceof JSCallExpression ? (JSCallExpression)psiElement2 : null;
        if (jSCallExpression == null) {
            return false;
        }
        JSCallExpression callExpression = jSCallExpression;
        JSExpression jSExpression = callExpression.getMethodExpression();
        Object object = jSExpression instanceof JSReferenceExpression ? (JSReferenceExpression)jSExpression : null;
        if (object == null || (object = object.getReferenceName()) == null) {
            return false;
        }
        Object functionName = object;
        JSExpression[] jSExpressionArray = callExpression.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)jSExpressionArray, (String)"getArguments(...)");
        int index = ArraysKt.indexOf((Object[])jSExpressionArray, (Object)expression);
        if (index == -1) {
            return false;
        }
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        String string = JSUrlParameterIndexingHandlerKt.getKey((String)functionName, index);
        Project project = expression.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        JSFrameworkMarkersIndex.Companion.processElements(string, PsiElement.class, project, null, (Processor)processor);
        return processor.isFound();
    }

    private static final String getKey(String functionName, int parameterIndex) {
        return "url_param#" + functionName + "#" + parameterIndex;
    }

    public static final /* synthetic */ String access$getKey(String functionName, int parameterIndex) {
        return JSUrlParameterIndexingHandlerKt.getKey(functionName, parameterIndex);
    }
}

