/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.util;

import org.assertj.swing.dependency.jsr305.Nonnull;

public final class TimeoutWatch {
    private final long timeout;
    private long startTime;

    @Nonnull
    public static TimeoutWatch startWatchWithTimeoutOf(long timeout) {
        TimeoutWatch watch = new TimeoutWatch(timeout);
        watch.start();
        return watch;
    }

    private TimeoutWatch(long timeout) {
        this.timeout = timeout;
    }

    void start() {
        this.startTime = System.currentTimeMillis();
    }

    public boolean isTimeOut() {
        long timePassed = System.currentTimeMillis() - this.startTime;
        return timePassed >= this.timeout;
    }
}

