/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.dashboard.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.services.ServiceViewActionUtils;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

final class RemoveRunConfigurationTypeAction
extends DumbAwareAction {
    RemoveRunConfigurationTypeAction() {
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            RemoveRunConfigurationTypeAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RemoveRunConfigurationTypeAction.$$$reportNull$$$0(1);
        }
        Set<ConfigurationType> types = RemoveRunConfigurationTypeAction.getTargetTypes(e);
        boolean isEnabled = e.getProject() != null && !types.isEmpty();
        Presentation presentation = e.getPresentation();
        presentation.setEnabledAndVisible(isEnabled);
        if (isEnabled) {
            presentation.setText(ExecutionBundle.messagePointer((String)"run.dashboard.remove.run.configuration.type.action.name", (Object[])new Object[]{types.size()}));
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            RemoveRunConfigurationTypeAction.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        RunDashboardManager runDashboardManager = RunDashboardManager.getInstance((Project)project);
        HashSet types = new HashSet(runDashboardManager.getTypes());
        Set<ConfigurationType> targetTypes = RemoveRunConfigurationTypeAction.getTargetTypes(e);
        for (ConfigurationType type : targetTypes) {
            types.remove(type.getId());
        }
        runDashboardManager.setTypes(types);
    }

    private static @Unmodifiable Set<ConfigurationType> getTargetTypes(AnActionEvent e) {
        List nodes = ServiceViewActionUtils.getTargets((AnActionEvent)e, RunDashboardRunConfigurationNode.class);
        return ContainerUtil.map2Set((Collection)nodes, node -> node.getConfigurationSettings().getType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/execution/dashboard/actions/RemoveRunConfigurationTypeAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/execution/dashboard/actions/RemoveRunConfigurationTypeAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

