/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.prompt;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptState;
import org.jetbrains.plugins.terminal.block.session.BlockTerminalSession;
import org.jetbrains.plugins.terminal.block.session.CommandFinishedEvent;
import org.jetbrains.plugins.terminal.block.session.KeyBinding;
import org.jetbrains.plugins.terminal.block.session.ShellCommandListener;
import org.jetbrains.plugins.terminal.util.ShellType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0006H\u0016J\b\u0010\u000e\u001a\u00020\u0007H\u0016J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0007H\u0016J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/terminal/block/prompt/ShellEditorBufferReportShellCommandListener;", "Lorg/jetbrains/plugins/terminal/block/session/ShellCommandListener;", "blockTerminalSession", "Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;", "onShellEditorBufferReceived", "Lkotlin/Function1;", "", "", "<init>", "(Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;Lkotlin/jvm/functions/Function1;)V", "isBlockClosedRecently", "", "commandBufferReceived", "buffer", "initialized", "commandFinished", "event", "Lorg/jetbrains/plugins/terminal/block/session/CommandFinishedEvent;", "promptShown", "promptStateUpdated", "newState", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptState;", "sendCodeToReportBuffer", "intellij.terminal"})
public final class ShellEditorBufferReportShellCommandListener
implements ShellCommandListener {
    @NotNull
    private final BlockTerminalSession blockTerminalSession;
    @NotNull
    private final Function1<String, Unit> onShellEditorBufferReceived;
    private volatile boolean isBlockClosedRecently;

    public ShellEditorBufferReportShellCommandListener(@NotNull BlockTerminalSession blockTerminalSession, @NotNull Function1<? super String, Unit> onShellEditorBufferReceived) {
        Intrinsics.checkNotNullParameter((Object)blockTerminalSession, (String)"blockTerminalSession");
        Intrinsics.checkNotNullParameter(onShellEditorBufferReceived, (String)"onShellEditorBufferReceived");
        this.blockTerminalSession = blockTerminalSession;
        this.onShellEditorBufferReceived = onShellEditorBufferReceived;
    }

    @Override
    public void commandBufferReceived(@NotNull String buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.onShellEditorBufferReceived.invoke((Object)buffer);
    }

    @Override
    public void initialized() {
        this.isBlockClosedRecently = true;
    }

    @Override
    public void commandFinished(@NotNull CommandFinishedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.isBlockClosedRecently = true;
    }

    @Override
    public void promptShown() {
        if (this.isBlockClosedRecently) {
            this.isBlockClosedRecently = false;
            this.sendCodeToReportBuffer(this.blockTerminalSession);
        }
    }

    @Override
    public void promptStateUpdated(@NotNull TerminalPromptState newState) {
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        if (this.isBlockClosedRecently) {
            this.isBlockClosedRecently = false;
            this.sendCodeToReportBuffer(this.blockTerminalSession);
        }
    }

    private final void sendCodeToReportBuffer(BlockTerminalSession blockTerminalSession) {
        ShellType[] shellTypeArray = new ShellType[]{ShellType.ZSH, ShellType.BASH};
        if (!SetsKt.setOf((Object[])shellTypeArray).contains((Object)blockTerminalSession.getShellIntegration().getShellType())) {
            return;
        }
        byte[] byArray = new byte[]{27};
        byte[] escapeSymbol = byArray;
        String string = "o";
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray2 = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        byte[] iSymbol = byArray2;
        blockTerminalSession.getCommandExecutionManager$intellij_terminal().sendKeyBinding(new KeyBinding(ArraysKt.plus((byte[])escapeSymbol, (byte[])iSymbol)));
    }
}

