/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.BaseCollector;
import com.intellij.javascript.debugger.JSDebuggerSupportUtils;
import com.intellij.javascript.debugger.MyValueModifier;
import com.intellij.javascript.debugger.NameMapper;
import com.intellij.javascript.debugger.NavigatableVariableBackedPsiElement;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.util.SideEffectChecker;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.ValueModifier;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020/2\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020/2\u0006\u00106\u001a\u00020+H\u0016J\u0018\u00107\u001a\u00020\f2\u0006\u00106\u001a\u00020+2\u0006\u00108\u001a\u00020\u0005H\u0002J\u0010\u00109\u001a\u00020/2\u0006\u00103\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020/2\u0006\u00103\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u00020/2\u0006\u0010>\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020\f2\u0006\u0010A\u001a\u00020BH\u0002J\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u001b0DR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u000b\u0010\rR\u000e\u0010\u0010\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\n \u0014*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0018\u0010\u0016\u001a\n \u0014*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0016\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R'\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001e0\u001d8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u000f\u001a\u0004\b\u001f\u0010 R\u001b\u0010\"\u001a\u00020#8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u000f\u001a\u0004\b$\u0010%R\u001a\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010)\u001a\n\u0012\u0004\u0012\u00020+\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00030\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/intellij/javascript/debugger/VariablesAndExpressionsCollector;", "Lcom/intellij/javascript/debugger/BaseCollector;", "positionOffset", "", "host", "Lcom/intellij/psi/PsiElement;", "nameMapper", "Lcom/intellij/javascript/debugger/NameMapper;", "positionElement", "<init>", "(ILcom/intellij/psi/PsiElement;Lcom/intellij/javascript/debugger/NameMapper;Lcom/intellij/psi/PsiElement;)V", "isProcessAllQualifiers", "", "()Z", "isProcessAllQualifiers$delegate", "Lkotlin/Lazy;", "QUALIFIER_LIMIT", "collectExpression", "hostTextRange", "Lcom/intellij/openapi/util/TextRange;", "kotlin.jvm.PlatformType", "Lcom/intellij/openapi/util/TextRange;", "hostFile", "Lcom/intellij/psi/PsiFile;", "Lcom/intellij/psi/PsiFile;", "variableDeclaredAfter", "", "", "expressions", "", "Lcom/intellij/javascript/debugger/NavigatableVariableBackedPsiElement;", "getExpressions", "()Ljava/util/Map;", "expressions$delegate", "valueModifier", "Lorg/jetbrains/debugger/ValueModifier;", "getValueModifier", "()Lorg/jetbrains/debugger/ValueModifier;", "valueModifier$delegate", "processedReferenceTargets", "Ljava/util/HashMap;", "tempQualifiers", "", "Lcom/intellij/lang/javascript/psi/JSReferenceExpression;", "qualifierCount", "ignoreReferences", "visitJSCallExpression", "", "callExpression", "Lcom/intellij/lang/javascript/psi/JSCallExpression;", "visitJSIndexedPropertyAccessExpression", "node", "Lcom/intellij/lang/javascript/psi/JSIndexedPropertyAccessExpression;", "visitJSReferenceExpression", "referenceExpression", "isSuitableTarget", "target", "visitJSFunctionDeclaration", "Lcom/intellij/lang/javascript/psi/JSFunction;", "visitJSFunctionExpression", "Lcom/intellij/lang/javascript/psi/JSFunctionExpression;", "visitJSVariable", "variable", "Lcom/intellij/lang/javascript/psi/JSVariable;", "isVisible", "element", "Lcom/intellij/lang/javascript/psi/JSElement;", "getVariableDeclaredAfter", "", "intellij.javascript.debugger"})
@SourceDebugExtension(value={"SMAP\nVariablesAndExpressionsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VariablesAndExpressionsCollector.kt\ncom/intellij/javascript/debugger/VariablesAndExpressionsCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,311:1\n1#2:312\n12567#3,2:313\n*S KotlinDebug\n*F\n+ 1 VariablesAndExpressionsCollector.kt\ncom/intellij/javascript/debugger/VariablesAndExpressionsCollector\n*L\n248#1:313,2\n*E\n"})
public final class VariablesAndExpressionsCollector
extends BaseCollector {
    private final int positionOffset;
    @Nullable
    private final NameMapper nameMapper;
    @NotNull
    private final PsiElement positionElement;
    @NotNull
    private final Lazy isProcessAllQualifiers$delegate;
    private final int QUALIFIER_LIMIT;
    private final boolean collectExpression;
    private final TextRange hostTextRange;
    private final PsiFile hostFile;
    @Nullable
    private Set<String> variableDeclaredAfter;
    @NotNull
    private final Lazy expressions$delegate;
    @NotNull
    private final Lazy valueModifier$delegate;
    @NotNull
    private final HashMap<PsiElement, Boolean> processedReferenceTargets;
    @Nullable
    private List<JSReferenceExpression> tempQualifiers;
    @NotNull
    private final Map<String, Integer> qualifierCount;
    private boolean ignoreReferences;

    /*
     * Unable to fully structure code
     */
    public VariablesAndExpressionsCollector(int positionOffset, @NotNull PsiElement host, @Nullable NameMapper nameMapper, @NotNull PsiElement positionElement) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)positionElement, (String)"positionElement");
        super();
        this.positionOffset = positionOffset;
        this.nameMapper = nameMapper;
        this.positionElement = positionElement;
        this.isProcessAllQualifiers$delegate = LazyKt.lazy((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, isProcessAllQualifiers_delegate$lambda$0(), ()Ljava/lang/Boolean;)());
        this.QUALIFIER_LIMIT = 9;
        if (!XDebuggerSettingsManager.getInstance().getDataViewSettings().isAutoExpressions()) ** GOTO lbl-1000
        v0 = host.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getProject(...)");
        if (!DumbService.Companion.isDumb(v0)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        this.collectExpression = v1;
        this.hostTextRange = host.getTextRange();
        this.hostFile = host.getContainingFile();
        this.expressions$delegate = LazyKt.lazy((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, expressions_delegate$lambda$1(), ()Ljava/util/HashMap;)());
        this.valueModifier$delegate = LazyKt.lazy((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, valueModifier_delegate$lambda$2(), ()Lcom/intellij/javascript/debugger/MyValueModifier;)());
        this.processedReferenceTargets = new HashMap<K, V>();
        this.qualifierCount = new LinkedHashMap<K, V>();
    }

    private final boolean isProcessAllQualifiers() {
        Lazy lazy = this.isProcessAllQualifiers$delegate;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public final Map<String, NavigatableVariableBackedPsiElement> getExpressions() {
        Lazy lazy = this.expressions$delegate;
        return (Map)lazy.getValue();
    }

    private final ValueModifier getValueModifier() {
        Lazy lazy = this.valueModifier$delegate;
        return (ValueModifier)lazy.getValue();
    }

    public void visitJSCallExpression(@NotNull JSCallExpression callExpression) {
        Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
        boolean ignoreState = this.ignoreReferences;
        this.ignoreReferences = false;
        JSArgumentList jSArgumentList = callExpression.getArgumentList();
        if (jSArgumentList != null) {
            jSArgumentList.accept((PsiElementVisitor)this);
        }
        this.ignoreReferences = true;
        PsiElement firstChild = callExpression.getFirstChild();
        if (firstChild instanceof JSReferenceExpression) {
            JSExpression jSExpression = ((JSReferenceExpression)firstChild).getQualifier();
            if (jSExpression != null) {
                jSExpression.accept((PsiElementVisitor)this);
            }
        }
        this.ignoreReferences = ignoreState;
    }

    public void visitJSIndexedPropertyAccessExpression(@NotNull JSIndexedPropertyAccessExpression node) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            JSExpression jSExpression = node.getQualifier();
            JSReferenceExpression jSReferenceExpression = jSExpression instanceof JSReferenceExpression ? (JSReferenceExpression)jSExpression : null;
            if (jSReferenceExpression != null) {
                boolean bl;
                JSReferenceExpression qualifier = jSReferenceExpression;
                boolean bl2 = false;
                JSExpression jSExpression2 = node.getIndexExpression();
                if (jSExpression2 != null) {
                    JSExpression it = jSExpression2;
                    boolean bl3 = false;
                    bl = SideEffectChecker.mayHaveSideEffects((JSExpression)it);
                } else {
                    bl = true;
                }
                boolean hasSideEffects = bl;
                PsiElement psiElement = JSDebuggerSupportUtils.resolve((PsiPolyVariantReference)qualifier);
                if (psiElement != null) {
                    PsiElement arrayTarget = psiElement;
                    boolean bl4 = false;
                    if (this.isSuitableTarget(qualifier, arrayTarget) && !hasSideEffects) {
                        String name = node.getText();
                        if (this.getExpressions().containsKey(name)) {
                            NavigatableVariableBackedPsiElement navigatableVariableBackedPsiElement = this.getExpressions().get(name);
                            Intrinsics.checkNotNull((Object)navigatableVariableBackedPsiElement);
                            navigatableVariableBackedPsiElement.addInlineReference((PsiElement)node);
                        } else {
                            Map<String, NavigatableVariableBackedPsiElement> map = this.getExpressions();
                            String string = node.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                            map.putIfAbsent(name, new NavigatableVariableBackedPsiElement(string, (PsiElement)node, this.getValueModifier()));
                        }
                    }
                }
            }
            JSExpression jSExpression3 = node.getIndexExpression();
            if (jSExpression3 == null) break block7;
            jSExpression3.accept((PsiElementVisitor)this);
        }
    }

    public void visitJSReferenceExpression(@NotNull JSReferenceExpression referenceExpression) {
        JSExpression qualifier;
        block15: {
            block14: {
                Integer n;
                Intrinsics.checkNotNullParameter((Object)referenceExpression, (String)"referenceExpression");
                if (!this.collectExpression || this.ignoreReferences || SideEffectChecker.mayHaveSideEffects((JSExpression)((JSExpression)referenceExpression))) break block14;
                Map<String, Integer> map = this.qualifierCount;
                JSExpression jSExpression = referenceExpression.getQualifier();
                String string = jSExpression != null ? jSExpression.getText() : null;
                if (((Number)map.getOrDefault(string, n = Integer.valueOf(0))).intValue() < this.QUALIFIER_LIMIT) break block15;
            }
            return;
        }
        if (this.tempQualifiers == null) {
            this.tempQualifiers = (List)new SmartList();
        } else {
            List<JSReferenceExpression> list = this.tempQualifiers;
            Intrinsics.checkNotNull(list);
            list.clear();
        }
        List<JSReferenceExpression> list = this.tempQualifiers;
        Intrinsics.checkNotNull(list);
        List<JSReferenceExpression> qualifiers = list;
        qualifiers.add(referenceExpression);
        Ref.ObjectRef thisGeneratedName = new Ref.ObjectRef();
        JSReferenceExpression expression = referenceExpression;
        while ((qualifier = expression.getQualifier()) instanceof JSReferenceExpression) {
            expression = (JSReferenceExpression)qualifier;
            qualifiers.add(expression);
        }
        if (qualifier instanceof JSThisExpression) {
            NameMapper nameMapper = this.nameMapper;
            thisGeneratedName.element = nameMapper != null ? NameMapper.map$default(nameMapper, (PsiElement)qualifier, false, 2, null) : null;
        }
        PsiElement prevTarget = null;
        int n = ((Collection)qualifiers).size() + -1;
        if (0 <= n) {
            do {
                int i;
                PsiElement target;
                if ((target = JSDebuggerSupportUtils.resolve((PsiPolyVariantReference)(expression = qualifiers.get(i = n--)))) == null && !(prevTarget instanceof JSVariable)) {
                    if (!this.isProcessAllQualifiers()) break;
                    continue;
                }
                prevTarget = target;
                if (target == null || this.isSuitableTarget(expression, target)) continue;
                if (i != CollectionsKt.getLastIndex(qualifiers)) break;
                return;
            } while (0 <= n);
        }
        String name = VariablesAndExpressionsCollector.visitJSReferenceExpression$computeRawName((Ref.ObjectRef<String>)thisGeneratedName, this, expression);
        if (!this.getExpressions().containsKey(name)) {
            this.getExpressions().put(name, new NavigatableVariableBackedPsiElement(name, (PsiElement)expression, this.getValueModifier()));
            JSExpression jSExpression = expression.getQualifier();
            if (jSExpression != null) {
                JSExpression it = jSExpression;
                boolean bl = false;
                this.qualifierCount.compute(it.getText(), (arg_0, arg_1) -> VariablesAndExpressionsCollector.visitJSReferenceExpression$lambda$8$lambda$7(VariablesAndExpressionsCollector::visitJSReferenceExpression$lambda$8$lambda$6, arg_0, arg_1));
            }
        } else {
            NavigatableVariableBackedPsiElement navigatableVariableBackedPsiElement = this.getExpressions().get(name);
            Intrinsics.checkNotNull((Object)navigatableVariableBackedPsiElement);
            NavigatableVariableBackedPsiElement variable = navigatableVariableBackedPsiElement;
            variable.addInlineReference((PsiElement)expression);
        }
    }

    private final boolean isSuitableTarget(JSReferenceExpression referenceExpression, PsiElement target) {
        if (((Map)this.processedReferenceTargets).containsKey(target)) {
            Boolean bl = this.processedReferenceTargets.get(target);
            Intrinsics.checkNotNull((Object)bl);
            return bl;
        }
        boolean belongsToHostFile = Intrinsics.areEqual((Object)target.getContainingFile(), (Object)this.hostFile);
        PsiElement psiElement = target;
        if (psiElement instanceof JSProperty) {
            if (belongsToHostFile && !this.isVisible((JSElement)target)) {
                return false;
            }
            JSFunction jSFunction = ((JSProperty)target).tryGetFunctionInitializer();
            CharSequence charSequence = jSFunction != null ? jSFunction.getName() : null;
            return charSequence == null || charSequence.length() == 0;
        }
        if (psiElement instanceof JSDefinitionExpression) {
            if (belongsToHostFile && !this.isVisible((JSElement)target)) {
                return false;
            }
            return ((JSDefinitionExpression)target).isDeclaration() && referenceExpression.getQualifier() != null;
        }
        if (psiElement instanceof JSParameter) {
            return true;
        }
        if (psiElement instanceof LightElement) {
            return false;
        }
        if (psiElement instanceof JSVariable) {
            if (belongsToHostFile) {
                JSExpression initializer = ((JSVariable)target).getInitializer();
                if (initializer instanceof JSCallExpression && ((JSCallExpression)initializer).isRequireCall()) {
                    return false;
                }
                boolean visible = this.isVisible((JSElement)target);
                if (((JSVariable)target).getName() != null) {
                    NameMapper nameMapper = this.nameMapper;
                    if (nameMapper != null) {
                        nameMapper.map(target, visible);
                    }
                }
                return visible;
            }
            return true;
        }
        return psiElement instanceof TypeScriptPropertySignature;
    }

    public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
    }

    public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
    }

    public void visitJSVariable(@NotNull JSVariable variable) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            String name = variable.getName();
            if (name != null) {
                if (!this.isVisible((JSElement)variable)) {
                    if (this.variableDeclaredAfter == null) {
                        this.variableDeclaredAfter = new HashSet();
                    }
                    Set<String> set = this.variableDeclaredAfter;
                    Intrinsics.checkNotNull(set);
                    set.add(name);
                    NameMapper nameMapper = this.nameMapper;
                    if (nameMapper != null) {
                        NameMapper it = nameMapper;
                        boolean bl = false;
                        String string = it.map((PsiElement)variable, false);
                        if (string != null) {
                            String generatedName = string;
                            boolean bl2 = false;
                            Set<String> set2 = this.variableDeclaredAfter;
                            Intrinsics.checkNotNull(set2);
                            set2.add(generatedName);
                        }
                    }
                } else {
                    NameMapper nameMapper = this.nameMapper;
                    if (nameMapper != null) {
                        NameMapper.map$default(nameMapper, (PsiElement)variable, false, 2, null);
                    }
                }
            }
            JSExpression jSExpression = variable.getInitializerOrStub();
            if (jSExpression == null) break block7;
            jSExpression.accept((PsiElementVisitor)this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isVisible(JSElement element) {
        TextRange textRange = element.getTextRange();
        if (this.hostTextRange.contains(textRange) && textRange.getStartOffset() >= this.positionOffset) {
            return false;
        }
        if (element instanceof JSNamedElement) {
            PsiElement psiElement = JSUseScopeProvider.getUseScopeElement((JSNamedElement)((JSNamedElement)element));
            if (psiElement == null) {
                return true;
            }
            PsiElement scope = psiElement;
            return PsiTreeUtil.isAncestor((PsiElement)scope, (PsiElement)this.positionElement, (boolean)false);
        }
        SearchScope searchScope = element.getUseScope();
        if (!(searchScope instanceof LocalSearchScope)) return true;
        LocalSearchScope localSearchScope = (LocalSearchScope)searchScope;
        if (localSearchScope == null) return true;
        PsiElement[] psiElementArray = localSearchScope.getScope();
        PsiElement[] scope = psiElementArray;
        if (scope == null) return true;
        PsiElement[] $this$any$iv = scope;
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            PsiElement element$iv;
            PsiElement it = element$iv = $this$any$iv[n];
            boolean bl = false;
            if (PsiTreeUtil.isAncestor((PsiElement)it, (PsiElement)this.positionElement, (boolean)false)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @NotNull
    public final Set<String> getVariableDeclaredAfter() {
        Set set = this.variableDeclaredAfter;
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    private static final boolean isProcessAllQualifiers_delegate$lambda$0() {
        return Registry.Companion.is("js.debugger.auto.expressions.all.qualifiers", false);
    }

    private static final HashMap expressions_delegate$lambda$1() {
        return new HashMap();
    }

    private static final MyValueModifier valueModifier_delegate$lambda$2() {
        return new MyValueModifier();
    }

    private static final String visitJSReferenceExpression$computeRawName(Ref.ObjectRef<String> thisGeneratedName, VariablesAndExpressionsCollector this$0, JSReferenceExpression expression) {
        String sourceQualifiedName = expression.getText();
        if (thisGeneratedName.element == null) {
            Object object = this$0.nameMapper;
            if (object == null || (object = NameMapper.map$default((NameMapper)object, (PsiElement)expression, false, 2, null)) == null) {
                Intrinsics.checkNotNull((Object)sourceQualifiedName);
                object = sourceQualifiedName;
            }
            return object;
        }
        StringBuilder builder = new StringBuilder(sourceQualifiedName.length() + ((String)thisGeneratedName.element).length());
        builder.append((String)thisGeneratedName.element);
        builder.append(sourceQualifiedName, 4, sourceQualifiedName.length());
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String rawQualifiedName = string;
        NameMapper nameMapper = this$0.nameMapper;
        Intrinsics.checkNotNull((Object)nameMapper);
        Intrinsics.checkNotNull((Object)sourceQualifiedName);
        nameMapper.addMapping(rawQualifiedName, sourceQualifiedName);
        return rawQualifiedName;
    }

    private static final Integer visitJSReferenceExpression$lambda$8$lambda$6(String string, Integer v) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Integer n = v;
        return n == null ? Integer.valueOf(1) : Integer.valueOf(n + 1);
    }

    private static final Integer visitJSReferenceExpression$lambda$8$lambda$7(Function2 $tmp0, Object p0, Object p1) {
        return (Integer)$tmp0.invoke(p0, p1);
    }
}

