/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.locks;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import jdk.internal.vm.annotation.ReservedStackAccess;

public class ReentrantLock
implements Lock,
Serializable {
    private static final long serialVersionUID = 7373984872572414699L;
    private final Sync sync;

    public ReentrantLock() {
    }

    public ReentrantLock(boolean bl) {
    }

    @Override
    public void lock() {
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
    }

    @Override
    public boolean tryLock() {
        return false;
    }

    @Override
    public boolean tryLock(long l, TimeUnit timeUnit) throws InterruptedException {
        return false;
    }

    @Override
    public void unlock() {
    }

    @Override
    public Condition newCondition() {
        return null;
    }

    public int getHoldCount() {
        return 0;
    }

    public boolean isHeldByCurrentThread() {
        return false;
    }

    public boolean isLocked() {
        return false;
    }

    public final boolean isFair() {
        return false;
    }

    protected Thread getOwner() {
        return null;
    }

    public final boolean hasQueuedThreads() {
        return false;
    }

    public final boolean hasQueuedThread(Thread thread) {
        return false;
    }

    public final int getQueueLength() {
        return 0;
    }

    protected Collection<Thread> getQueuedThreads() {
        return null;
    }

    public boolean hasWaiters(Condition condition) {
        return false;
    }

    public int getWaitQueueLength(Condition condition) {
        return 0;
    }

    protected Collection<Thread> getWaitingThreads(Condition condition) {
        return null;
    }

    public String toString() {
        return null;
    }

    static final class FairSync
    extends Sync {
        private static final long serialVersionUID = -3000897897090466540L;

        FairSync() {
        }

        @Override
        final boolean initialTryLock() {
            Thread current = Thread.currentThread();
            int c = this.getState();
            if (c == 0) {
                if (!this.hasQueuedThreads() && this.compareAndSetState(0, 1)) {
                    this.setExclusiveOwnerThread(current);
                    return true;
                }
            } else if (this.getExclusiveOwnerThread() == current) {
                if (++c < 0) {
                    throw new Error("Maximum lock count exceeded");
                }
                this.setState(c);
                return true;
            }
            return false;
        }

        @Override
        protected final boolean tryAcquire(int acquires) {
            if (this.getState() == 0 && !this.hasQueuedPredecessors() && this.compareAndSetState(0, acquires)) {
                this.setExclusiveOwnerThread(Thread.currentThread());
                return true;
            }
            return false;
        }
    }

    static final class NonfairSync
    extends Sync {
        private static final long serialVersionUID = 7316153563782823691L;

        NonfairSync() {
        }

        @Override
        final boolean initialTryLock() {
            Thread current = Thread.currentThread();
            if (this.compareAndSetState(0, 1)) {
                this.setExclusiveOwnerThread(current);
                return true;
            }
            if (this.getExclusiveOwnerThread() == current) {
                int c = this.getState() + 1;
                if (c < 0) {
                    throw new Error("Maximum lock count exceeded");
                }
                this.setState(c);
                return true;
            }
            return false;
        }

        @Override
        protected final boolean tryAcquire(int acquires) {
            if (this.getState() == 0 && this.compareAndSetState(0, acquires)) {
                this.setExclusiveOwnerThread(Thread.currentThread());
                return true;
            }
            return false;
        }
    }

    static abstract class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = -5179523762034025860L;

        Sync() {
        }

        @ReservedStackAccess
        final boolean tryLock() {
            Thread current = Thread.currentThread();
            int c = this.getState();
            if (c == 0) {
                if (this.compareAndSetState(0, 1)) {
                    this.setExclusiveOwnerThread(current);
                    return true;
                }
            } else if (this.getExclusiveOwnerThread() == current) {
                if (++c < 0) {
                    throw new Error("Maximum lock count exceeded");
                }
                this.setState(c);
                return true;
            }
            return false;
        }

        abstract boolean initialTryLock();

        @ReservedStackAccess
        final void lock() {
            if (!this.initialTryLock()) {
                this.acquire(1);
            }
        }

        @ReservedStackAccess
        final void lockInterruptibly() throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (!this.initialTryLock()) {
                this.acquireInterruptibly(1);
            }
        }

        @ReservedStackAccess
        final boolean tryLockNanos(long nanos) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            return this.initialTryLock() || this.tryAcquireNanos(1, nanos);
        }

        @Override
        @ReservedStackAccess
        protected final boolean tryRelease(int releases) {
            boolean free;
            int c = this.getState() - releases;
            if (this.getExclusiveOwnerThread() != Thread.currentThread()) {
                throw new IllegalMonitorStateException();
            }
            boolean bl = free = c == 0;
            if (free) {
                this.setExclusiveOwnerThread(null);
            }
            this.setState(c);
            return free;
        }

        @Override
        protected final boolean isHeldExclusively() {
            return this.getExclusiveOwnerThread() == Thread.currentThread();
        }

        final AbstractQueuedSynchronizer.ConditionObject newCondition() {
            return new AbstractQueuedSynchronizer.ConditionObject(this);
        }

        final Thread getOwner() {
            return this.getState() == 0 ? null : this.getExclusiveOwnerThread();
        }

        final int getHoldCount() {
            return this.isHeldExclusively() ? this.getState() : 0;
        }

        final boolean isLocked() {
            return this.getState() != 0;
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            this.setState(0);
        }
    }
}

