//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfpropertylistmutabilityoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFPropertyListMutabilityOptions(pub CFOptionFlags);
bitflags::bitflags! {
    impl CFPropertyListMutabilityOptions: CFOptionFlags {
        #[doc(alias = "kCFPropertyListImmutable")]
        const Immutable = 0;
        #[doc(alias = "kCFPropertyListMutableContainers")]
        const MutableContainers = 1<<0;
        #[doc(alias = "kCFPropertyListMutableContainersAndLeaves")]
        const MutableContainersAndLeaves = 1<<1;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFPropertyListMutabilityOptions {
    const ENCODING: Encoding = CFOptionFlags::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFPropertyListMutabilityOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

#[cfg(feature = "CFData")]
#[deprecated = "Use CFPropertyListCreateWithData instead."]
#[inline]
pub unsafe extern "C-unwind" fn CFPropertyListCreateFromXMLData(
    allocator: Option<&CFAllocator>,
    xml_data: Option<&CFData>,
    mutability_option: CFOptionFlags,
    error_string: *mut *const CFString,
) -> Option<CFRetained<CFPropertyList>> {
    extern "C-unwind" {
        fn CFPropertyListCreateFromXMLData(
            allocator: Option<&CFAllocator>,
            xml_data: Option<&CFData>,
            mutability_option: CFOptionFlags,
            error_string: *mut *const CFString,
        ) -> Option<NonNull<CFPropertyList>>;
    }
    let ret = unsafe {
        CFPropertyListCreateFromXMLData(allocator, xml_data, mutability_option, error_string)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFData")]
#[deprecated = "Use CFPropertyListCreateData instead."]
#[inline]
pub unsafe extern "C-unwind" fn CFPropertyListCreateXMLData(
    allocator: Option<&CFAllocator>,
    property_list: Option<&CFPropertyList>,
) -> Option<CFRetained<CFData>> {
    extern "C-unwind" {
        fn CFPropertyListCreateXMLData(
            allocator: Option<&CFAllocator>,
            property_list: Option<&CFPropertyList>,
        ) -> Option<NonNull<CFData>>;
    }
    let ret = unsafe { CFPropertyListCreateXMLData(allocator, property_list) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[inline]
pub unsafe extern "C-unwind" fn CFPropertyListCreateDeepCopy(
    allocator: Option<&CFAllocator>,
    property_list: Option<&CFPropertyList>,
    mutability_option: CFOptionFlags,
) -> Option<CFRetained<CFPropertyList>> {
    extern "C-unwind" {
        fn CFPropertyListCreateDeepCopy(
            allocator: Option<&CFAllocator>,
            property_list: Option<&CFPropertyList>,
            mutability_option: CFOptionFlags,
        ) -> Option<NonNull<CFPropertyList>>;
    }
    let ret = unsafe { CFPropertyListCreateDeepCopy(allocator, property_list, mutability_option) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfpropertylistformat?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFPropertyListFormat(pub CFIndex);
impl CFPropertyListFormat {
    #[doc(alias = "kCFPropertyListOpenStepFormat")]
    pub const OpenStepFormat: Self = Self(1);
    #[doc(alias = "kCFPropertyListXMLFormat_v1_0")]
    pub const XMLFormat_v1_0: Self = Self(100);
    #[doc(alias = "kCFPropertyListBinaryFormat_v1_0")]
    pub const BinaryFormat_v1_0: Self = Self(200);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFPropertyListFormat {
    const ENCODING: Encoding = CFIndex::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFPropertyListFormat {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

#[inline]
pub unsafe extern "C-unwind" fn CFPropertyListIsValid(
    plist: &CFPropertyList,
    format: CFPropertyListFormat,
) -> bool {
    extern "C-unwind" {
        fn CFPropertyListIsValid(plist: &CFPropertyList, format: CFPropertyListFormat) -> Boolean;
    }
    let ret = unsafe { CFPropertyListIsValid(plist, format) };
    ret != 0
}

extern "C-unwind" {
    #[cfg(feature = "CFStream")]
    #[deprecated = "Use CFPropertyListWrite instead."]
    pub fn CFPropertyListWriteToStream(
        property_list: &CFPropertyList,
        stream: Option<&CFWriteStream>,
        format: CFPropertyListFormat,
        error_string: *mut *const CFString,
    ) -> CFIndex;
}

#[cfg(feature = "CFStream")]
#[deprecated = "Use CFPropertyListCreateWithStream instead."]
#[inline]
pub unsafe extern "C-unwind" fn CFPropertyListCreateFromStream(
    allocator: Option<&CFAllocator>,
    stream: Option<&CFReadStream>,
    stream_length: CFIndex,
    mutability_option: CFOptionFlags,
    format: *mut CFPropertyListFormat,
    error_string: *mut *const CFString,
) -> Option<CFRetained<CFPropertyList>> {
    extern "C-unwind" {
        fn CFPropertyListCreateFromStream(
            allocator: Option<&CFAllocator>,
            stream: Option<&CFReadStream>,
            stream_length: CFIndex,
            mutability_option: CFOptionFlags,
            format: *mut CFPropertyListFormat,
            error_string: *mut *const CFString,
        ) -> Option<NonNull<CFPropertyList>>;
    }
    let ret = unsafe {
        CFPropertyListCreateFromStream(
            allocator,
            stream,
            stream_length,
            mutability_option,
            format,
            error_string,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfpropertylistreadcorrupterror?language=objc)
pub const kCFPropertyListReadCorruptError: CFIndex = 3840;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfpropertylistreadunknownversionerror?language=objc)
pub const kCFPropertyListReadUnknownVersionError: CFIndex = 3841;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfpropertylistreadstreamerror?language=objc)
pub const kCFPropertyListReadStreamError: CFIndex = 3842;
/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfpropertylistwritestreamerror?language=objc)
pub const kCFPropertyListWriteStreamError: CFIndex = 3851;

#[cfg(all(feature = "CFData", feature = "CFError"))]
#[inline]
pub unsafe extern "C-unwind" fn CFPropertyListCreateWithData(
    allocator: Option<&CFAllocator>,
    data: Option<&CFData>,
    options: CFOptionFlags,
    format: *mut CFPropertyListFormat,
    error: *mut *mut CFError,
) -> Option<CFRetained<CFPropertyList>> {
    extern "C-unwind" {
        fn CFPropertyListCreateWithData(
            allocator: Option<&CFAllocator>,
            data: Option<&CFData>,
            options: CFOptionFlags,
            format: *mut CFPropertyListFormat,
            error: *mut *mut CFError,
        ) -> Option<NonNull<CFPropertyList>>;
    }
    let ret = unsafe { CFPropertyListCreateWithData(allocator, data, options, format, error) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFError", feature = "CFStream"))]
#[inline]
pub unsafe extern "C-unwind" fn CFPropertyListCreateWithStream(
    allocator: Option<&CFAllocator>,
    stream: Option<&CFReadStream>,
    stream_length: CFIndex,
    options: CFOptionFlags,
    format: *mut CFPropertyListFormat,
    error: *mut *mut CFError,
) -> Option<CFRetained<CFPropertyList>> {
    extern "C-unwind" {
        fn CFPropertyListCreateWithStream(
            allocator: Option<&CFAllocator>,
            stream: Option<&CFReadStream>,
            stream_length: CFIndex,
            options: CFOptionFlags,
            format: *mut CFPropertyListFormat,
            error: *mut *mut CFError,
        ) -> Option<NonNull<CFPropertyList>>;
    }
    let ret = unsafe {
        CFPropertyListCreateWithStream(allocator, stream, stream_length, options, format, error)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[cfg(all(feature = "CFError", feature = "CFStream"))]
    pub fn CFPropertyListWrite(
        property_list: &CFPropertyList,
        stream: Option<&CFWriteStream>,
        format: CFPropertyListFormat,
        options: CFOptionFlags,
        error: *mut *mut CFError,
    ) -> CFIndex;
}

#[cfg(all(feature = "CFData", feature = "CFError"))]
#[inline]
pub unsafe extern "C-unwind" fn CFPropertyListCreateData(
    allocator: Option<&CFAllocator>,
    property_list: Option<&CFPropertyList>,
    format: CFPropertyListFormat,
    options: CFOptionFlags,
    error: *mut *mut CFError,
) -> Option<CFRetained<CFData>> {
    extern "C-unwind" {
        fn CFPropertyListCreateData(
            allocator: Option<&CFAllocator>,
            property_list: Option<&CFPropertyList>,
            format: CFPropertyListFormat,
            options: CFOptionFlags,
            error: *mut *mut CFError,
        ) -> Option<NonNull<CFData>>;
    }
    let ret = unsafe { CFPropertyListCreateData(allocator, property_list, format, options, error) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}
