/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.openapi.vcs.VcsException;
import git4idea.i18n.GitBundle;
import org.jetbrains.annotations.NotNull;

public class StringScanner {
    private final String myText;
    private int myPosition;

    public StringScanner(@NotNull String text2) {
        if (text2 == null) {
            StringScanner.$$$reportNull$$$0(0);
        }
        this.myText = text2;
        this.myPosition = 0;
    }

    public boolean hasMoreData() {
        return this.myPosition < this.myText.length();
    }

    public boolean isEol() {
        if (!this.hasMoreData()) {
            return true;
        }
        char ch = this.myText.charAt(this.myPosition);
        return ch == '\n';
    }

    public void nextLine() {
        while (!this.isEol()) {
            ++this.myPosition;
        }
        if (this.hasMoreData()) {
            char ch = this.myText.charAt(this.myPosition++);
            if (this.hasMoreData()) {
                char ch2 = this.myText.charAt(this.myPosition);
                if (ch == '\r' && ch2 == '\n') {
                    ++this.myPosition;
                }
            }
        }
    }

    public String spaceToken() throws VcsException {
        return this.boundedToken(' ');
    }

    public String tabToken() throws VcsException {
        return this.boundedToken('\t');
    }

    @NotNull
    public String boundedToken(char boundaryChar) throws VcsException {
        String string = this.boundedToken(boundaryChar, false);
        if (string == null) {
            StringScanner.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String boundedToken(char boundaryChar, boolean ignoreEol) throws VcsException {
        int start = this.myPosition;
        while (this.myPosition < this.myText.length()) {
            char ch = this.myText.charAt(this.myPosition);
            if (ch == boundaryChar) {
                String rc = this.myText.substring(start, this.myPosition);
                ++this.myPosition;
                String string = rc;
                if (string == null) {
                    StringScanner.$$$reportNull$$$0(2);
                }
                return string;
            }
            if (!ignoreEol && this.isEol()) {
                String string = this.myText.substring(start, this.myPosition);
                if (string == null) {
                    StringScanner.$$$reportNull$$$0(3);
                }
                return string;
            }
            ++this.myPosition;
        }
        throw this.unexpectedTextEndException(start);
    }

    public boolean startsWith(char c) {
        return this.hasMoreData() && this.myText.charAt(this.myPosition) == c;
    }

    public boolean startsWith(String text2) {
        return this.myText.startsWith(text2, this.myPosition);
    }

    public String line() {
        return this.line(false);
    }

    public String line(boolean includeNewLine) {
        int end;
        int start = this.myPosition;
        while (!this.isEol()) {
            ++this.myPosition;
        }
        if (includeNewLine) {
            this.nextLine();
            end = this.myPosition;
        } else {
            end = this.myPosition;
            this.nextLine();
        }
        return this.myText.substring(start, end);
    }

    public void skipChars(int n) throws VcsException {
        if (n < 0) {
            throw new IllegalArgumentException("Amount of chars to skip must be non neagitve: " + n);
        }
        if (this.myPosition + n >= this.myText.length()) {
            throw this.unexpectedTextEndException(this.myPosition);
        }
        this.myPosition += n;
    }

    public char peek() throws VcsException {
        if (!this.hasMoreData()) {
            throw this.unexpectedTextEndException(this.myPosition);
        }
        return this.myText.charAt(this.myPosition);
    }

    public String getAllText() {
        return this.myText;
    }

    @NotNull
    private VcsException unexpectedTextEndException(int start) {
        start = this.boundToText(start);
        int firstWindowStart = this.boundToText(start - 10);
        int firstWindowEnd = this.boundToText(start + 10);
        int secondWindowStart = this.boundToText(this.myText.length() - 10);
        int secondWindowEnd = this.boundToText(this.myText.length());
        String context = secondWindowEnd - firstWindowStart < 50 ? this.myText.substring(firstWindowStart, start) + "<!>" + this.myText.substring(start, secondWindowEnd) : this.myText.substring(firstWindowStart, start) + "<!>" + this.myText.substring(start, firstWindowEnd) + "..." + this.myText.substring(secondWindowStart, secondWindowEnd);
        return new VcsException(GitBundle.message((String)"output.parse.exception.unexpected.end.message", (Object[])new Object[]{context}));
    }

    private int boundToText(int offset) {
        return Math.max(0, Math.min(this.myText.length(), offset));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/util/StringScanner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/util/StringScanner";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "boundedToken";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

