/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.project;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPProjectListener;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNProjectDatabases;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.rcp.RCPProject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.LazyLabelProvider;
import org.jkiss.dbeaver.ui.ProgramInfo;
import org.jkiss.dbeaver.ui.UIExecutionQueue;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.ObjectPropertyTester;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.project.DecoratedProjectView;
import org.jkiss.dbeaver.utils.ResourceUtils;
import org.jkiss.utils.CommonUtils;

public class ProjectExplorerView
extends DecoratedProjectView
implements DBPProjectListener {
    public static final String VIEW_ID = "org.jkiss.dbeaver.core.projectExplorer";
    private ViewerColumnController<?, ?> columnController;
    private final NumberFormat sizeFormat = new DecimalFormat();
    private Composite treeContainer;
    private Label lockPlaceholder;
    private GridData lockPlaceholderLayoutInfo;
    private GridData treeViewLayoutInfo;

    public ProjectExplorerView() {
        DBPPlatformDesktop.getInstance().getWorkspace().addProjectListener((DBPProjectListener)this);
    }

    @Override
    public DBNNode getRootNode() {
        DBNModel model = ProjectExplorerView.getGlobalNavigatorModel();
        DBNProject projectNode = model.getRoot().getProjectNode(DBWorkbench.getPlatform().getWorkspace().getActiveProject());
        return projectNode != null ? projectNode : model.getRoot();
    }

    @Override
    public void createPartControl(Composite parent) {
        this.treeContainer = UIUtils.createComposite((Composite)parent, (int)1);
        super.createPartControl(this.treeContainer);
        UIUtils.setHelp((Control)parent, (String)"view-project-explorer");
        TreeViewer viewer = this.getNavigatorViewer();
        viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return !(element instanceof DBNProjectDatabases);
            }
        });
        viewer.getTree().setHeaderVisible(true);
        UIExecutionQueue.queueExec(() -> {
            if (!viewer.getControl().isDisposed()) {
                this.createColumns(viewer);
                this.updateTitle();
            }
        });
        this.getNavigatorTree().getViewer().addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return parentElement != viewer.getInput() || element instanceof DBNResource;
            }
        });
        this.lockPlaceholder = UIUtils.createLabel((Composite)this.treeContainer, (DBPImage)UIIcon.READONLY_RESOURCES);
        this.lockPlaceholder.setAlignment(0x1000000);
        this.lockPlaceholder.setVisible(false);
        this.lockPlaceholderLayoutInfo = new GridData(0x1000000, 0x1000000, true, true);
        this.lockPlaceholderLayoutInfo.exclude = true;
        this.lockPlaceholder.setLayoutData((Object)this.lockPlaceholderLayoutInfo);
        this.treeViewLayoutInfo = new GridData(4, 4, true, true);
        this.getNavigatorTree().setLayoutData(this.treeViewLayoutInfo);
        this.updateRepresentation();
    }

    private void createColumns(TreeViewer viewer) {
        Color shadowColor = viewer.getControl().getDisplay().getSystemColor(17);
        final ILabelProvider mainLabelProvider = (ILabelProvider)viewer.getLabelProvider();
        this.columnController = new ViewerColumnController("projectExplorer", (ColumnViewer)viewer);
        this.columnController.setForceAutoSize(true);
        this.columnController.addColumn(UINavigatorMessages.navigator_project_explorer_columns_name_text, UINavigatorMessages.navigator_project_explorer_columns_name_description, 16384, true, true, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return mainLabelProvider.getText(element);
            }

            public Image getImage(Object element) {
                Image image = mainLabelProvider.getImage(element);
                if (element instanceof DBNResource) {
                    image = ProjectExplorerView.this.labelDecorator.decorateImage(image, element);
                }
                return image;
            }

            public String getToolTipText(Object element) {
                if (mainLabelProvider instanceof IToolTipProvider) {
                    return ((IToolTipProvider)mainLabelProvider).getToolTipText(element);
                }
                return null;
            }
        });
        this.columnController.addColumn(UINavigatorMessages.navigator_project_explorer_columns_datasource_text, UINavigatorMessages.navigator_project_explorer_columns_datasource_description, 16384, true, false, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Collection containers;
                if (element instanceof DBNDatabaseNode) {
                    return ((DBNDatabaseNode)element).getDataSourceContainer().getName();
                }
                if (element instanceof DBNResource && !CommonUtils.isEmpty((Collection)(containers = ((DBNResource)element).getAssociatedDataSources()))) {
                    StringBuilder text = new StringBuilder();
                    for (DBPDataSourceContainer container : containers) {
                        if (text.length() > 0) {
                            text.append(", ");
                        }
                        text.append(container.getName());
                    }
                    return text.toString();
                }
                return "";
            }

            public Image getImage(Object element) {
                return null;
            }

            public String getToolTipText(Object element) {
                Collection containers;
                if (element instanceof DBNResource && !CommonUtils.isEmpty((Collection)(containers = ((DBNResource)element).getAssociatedDataSources()))) {
                    StringBuilder text = new StringBuilder();
                    for (DBPDataSourceContainer container : containers) {
                        String description = container.getDescription();
                        if (CommonUtils.isEmpty((String)description)) {
                            description = container.getName();
                        }
                        if (CommonUtils.isEmpty((String)description)) continue;
                        if (text.length() > 0) {
                            text.append(", ");
                        }
                        text.append(description);
                    }
                    return text.toString();
                }
                return null;
            }
        });
        this.columnController.addColumn(UINavigatorMessages.navigator_project_explorer_columns_preview_text, UINavigatorMessages.navigator_project_explorer_columns_preview_description, 16384, false, false, (CellLabelProvider)new LazyLabelProvider(shadowColor){

            public String getLazyText(Object element) {
                if (element instanceof DBNNode) {
                    return ((DBNNode)element).getNodeDescription();
                }
                return null;
            }
        });
        this.columnController.addColumn(UINavigatorMessages.navigator_project_explorer_columns_size_text, UINavigatorMessages.navigator_project_explorer_columns_size_description, 16384, false, false, true, null, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                IResource resource;
                if (element instanceof DBNResource && (resource = ((DBNResource)element).getResource()) instanceof IFile && resource.exists()) {
                    return ProjectExplorerView.this.sizeFormat.format(ResourceUtils.getFileLength((IResource)resource));
                }
                return "";
            }
        }, null);
        this.columnController.addColumn(UINavigatorMessages.navigator_project_explorer_columns_modified_text, UINavigatorMessages.navigator_project_explorer_columns_modified_description, 16384, false, false, (CellLabelProvider)new ColumnLabelProvider(){
            private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

            public String getText(Object element) {
                IResource resource;
                if (element instanceof DBNResource && (resource = ((DBNResource)element).getResource()) != null && resource.exists()) {
                    long lastModified = ResourceUtils.getResourceLastModified((IResource)resource);
                    if (lastModified <= 0L) {
                        return "";
                    }
                    return this.sdf.format(new Date(lastModified));
                }
                return "";
            }
        });
        this.columnController.addColumn(UINavigatorMessages.navigator_project_explorer_columns_type_text, UINavigatorMessages.navigator_project_explorer_columns_type_description, 16384, false, false, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                ProgramInfo program;
                IResource resource;
                if (element instanceof DBNResource && (resource = ((DBNResource)element).getResource()).exists() && (program = ProgramInfo.getProgram((IResource)resource)) != null) {
                    return program.getProgram().getName();
                }
                return "";
            }
        });
        var closure = new Object(){
            public Runnable createColumnsWhenNotBusy;
        };
        closure.createColumnsWhenNotBusy = () -> {
            if (viewer.isBusy()) {
                UIUtils.asyncExec((Runnable)var2_2.createColumnsWhenNotBusy);
            } else {
                this.columnController.createColumns(true);
            }
        };
        UIUtils.asyncExec((Runnable)closure.createColumnsWhenNotBusy);
    }

    @Override
    protected int getTreeStyle() {
        return super.getTreeStyle() | 0x10000;
    }

    @Override
    public void dispose() {
        DBPPlatformDesktop.getInstance().getWorkspace().removeProjectListener((DBPProjectListener)this);
        super.dispose();
    }

    public void handleProjectAdd(@NotNull DBPProject project) {
    }

    public void handleProjectRemove(@NotNull DBPProject project) {
    }

    public void handleActiveProjectChange(@NotNull DBPProject oldValue, @NotNull DBPProject newValue) {
        this.updateRepresentation();
    }

    private void updateRepresentation() {
        UIExecutionQueue.queueExec(() -> {
            if (this.getNavigatorTree().isDisposed()) {
                return;
            }
            this.getNavigatorTree().reloadTree(this.getRootNode());
            this.updateTitle();
            boolean viewable = ObjectPropertyTester.nodeProjectHasPermission(this.getRootNode(), "project-resource-view");
            this.getNavigatorTree().setVisible(viewable);
            this.treeViewLayoutInfo.exclude = !viewable;
            this.lockPlaceholder.setVisible(!viewable);
            this.lockPlaceholderLayoutInfo.exclude = viewable;
            this.treeContainer.layout(true, true);
        });
    }

    private void updateTitle() {
        this.setPartName("Project - " + this.getRootNode().getNodeDisplayName());
    }

    @Override
    public void configureView() {
        DBPProject activeProject = DBWorkbench.getPlatform().getWorkspace().getActiveProject();
        if (activeProject instanceof RCPProject) {
            RCPProject rcpProject = (RCPProject)activeProject;
            UIUtils.showPreferencesFor((Shell)this.getSite().getShell(), (Object)rcpProject.getEclipseProject(), (String[])new String[]{"org.jkiss.dbeaver.preferences.projectSettings"});
        }
    }
}

