/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.util.Collection;
import java.util.Optional;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDInsertReplaceMethod;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableConstraint;
import org.jkiss.utils.CommonUtils;

public class OracleInsertReplaceMethodIgnore
implements DBDInsertReplaceMethod {
    private static final Log log = Log.getLog(OracleInsertReplaceMethodIgnore.class);

    @NotNull
    public String getOpeningClause(DBSTable table, DBRProgressMonitor monitor) {
        if (table != null) {
            try {
                Optional<DBSTableConstraint> tableConstraint;
                Collection constraints = table.getConstraints(monitor);
                if (!CommonUtils.isEmpty((Collection)constraints) && (tableConstraint = constraints.stream().filter(key -> key.getConstraintType() == DBSEntityConstraintType.PRIMARY_KEY).findFirst()).isPresent()) {
                    DBSTableConstraint constraint = tableConstraint.get();
                    return "INSERT /*+ IGNORE_ROW_ON_DUPKEY_INDEX(" + table.getName() + ", " + constraint.getName() + ") */ INTO";
                }
            }
            catch (DBException dBException) {
                log.debug((Object)"Can't read table constraints list");
            }
        }
        return "INSERT INTO";
    }

    public String getTrailingClause(DBSTable table, DBRProgressMonitor monitor, DBSAttributeBase[] attributes) {
        return null;
    }
}

