/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetUpdater;

public class ResourceWorkingSetUpdater
implements IWorkingSetUpdater,
IResourceChangeListener {
    private List<IWorkingSet> fWorkingSets = new ArrayList<IWorkingSet>();

    public ResourceWorkingSetUpdater() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IWorkingSet workingSet) {
        this.checkElementExistence(workingSet);
        List<IWorkingSet> list = this.fWorkingSets;
        synchronized (list) {
            this.fWorkingSets.add(workingSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(IWorkingSet workingSet) {
        boolean result;
        List<IWorkingSet> list = this.fWorkingSets;
        synchronized (list) {
            result = this.fWorkingSets.remove(workingSet);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(IWorkingSet workingSet) {
        List<IWorkingSet> list = this.fWorkingSets;
        synchronized (list) {
            return this.fWorkingSets.contains(workingSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        List<IWorkingSet> list = this.fWorkingSets;
        synchronized (list) {
            this.fWorkingSets.clear();
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceChanged(IResourceChangeEvent event) {
        IWorkingSet[] workingSets;
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        List<IWorkingSet> list = this.fWorkingSets;
        synchronized (list) {
            workingSets = this.fWorkingSets.toArray(new IWorkingSet[this.fWorkingSets.size()]);
        }
        IWorkingSet[] iWorkingSetArray = workingSets;
        int n = workingSets.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet workingSet = iWorkingSetArray[n2];
            WorkingSetDelta workingSetDelta = new WorkingSetDelta(workingSet);
            this.processResourceDelta(workingSetDelta, delta);
            workingSetDelta.process();
            ++n2;
        }
    }

    private void processResourceDelta(WorkingSetDelta result, IResourceDelta delta) {
        IResource resource = delta.getResource();
        int type = resource.getType();
        int index = result.indexOf(resource);
        int kind = delta.getKind();
        int flags = delta.getFlags();
        if (kind == 4 && type == 4 && index != -1 && (flags & 0x4000) != 0) {
            result.set(index, (IAdaptable)resource);
        }
        if (index != -1 && kind == 2) {
            if ((flags & 0x2000) != 0) {
                result.set(index, (IAdaptable)ResourcesPlugin.getWorkspace().getRoot().findMember(delta.getMovedToPath()));
            } else {
                result.remove(index);
            }
        }
        if (this.projectGotClosedOrOpened(resource, kind, flags)) {
            return;
        }
        IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
        int n = iResourceDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceDelta child = iResourceDeltaArray[n2];
            this.processResourceDelta(result, child);
            ++n2;
        }
    }

    private boolean projectGotClosedOrOpened(IResource resource, int kind, int flags) {
        return resource.getType() == 4 && kind == 4 && (flags & 0x4000) != 0;
    }

    private void checkElementExistence(IWorkingSet workingSet) {
        ArrayList<IAdaptable> elements = new ArrayList<IAdaptable>(Arrays.asList(workingSet.getElements()));
        boolean changed = false;
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            IAdaptable element = (IAdaptable)iter.next();
            boolean remove = false;
            if (element instanceof IProject) {
                IProject project = (IProject)element;
                remove = !project.exists();
            } else if (element instanceof IResource) {
                IResource resource = (IResource)element;
                IProject project = resource.getProject();
                boolean bl = remove = (project == null || project.isOpen()) && !resource.exists();
            }
            if (!remove) continue;
            iter.remove();
            changed = true;
        }
        if (changed) {
            workingSet.setElements(elements.toArray(new IAdaptable[elements.size()]));
        }
    }

    private static class WorkingSetDelta {
        private IWorkingSet fWorkingSet;
        private List<IAdaptable> fElements;
        private boolean fChanged;

        public WorkingSetDelta(IWorkingSet workingSet) {
            this.fWorkingSet = workingSet;
            this.fElements = new ArrayList<IAdaptable>(Arrays.asList(workingSet.getElements()));
        }

        public int indexOf(Object element) {
            return this.fElements.indexOf(element);
        }

        public void set(int index, IAdaptable element) {
            this.fElements.set(index, element);
            this.fChanged = true;
        }

        public void remove(int index) {
            if (this.fElements.remove(index) != null) {
                this.fChanged = true;
            }
        }

        public void process() {
            if (this.fChanged) {
                this.fWorkingSet.setElements(this.fElements.toArray(new IAdaptable[this.fElements.size()]));
            }
        }
    }
}

