/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.instrument;

import java.io.IOException;
import jdk.jfr.events.FileWriteEvent;
import jdk.jfr.internal.instrument.JIInstrumentationMethod;
import jdk.jfr.internal.instrument.JIInstrumentationTarget;

@JIInstrumentationTarget(value="java.io.FileOutputStream")
final class FileOutputStreamInstrumentor {
    private String path;

    private FileOutputStreamInstrumentor() {
    }

    @JIInstrumentationMethod
    public void write(int n) throws IOException {
        FileWriteEvent fileWriteEvent = FileWriteEvent.EVENT.get();
        if (!fileWriteEvent.isEnabled()) {
            this.write(n);
            return;
        }
        try {
            fileWriteEvent.begin();
            this.write(n);
            fileWriteEvent.bytesWritten = 1L;
        }
        finally {
            fileWriteEvent.path = this.path;
            fileWriteEvent.commit();
            fileWriteEvent.reset();
        }
    }

    @JIInstrumentationMethod
    public void write(byte[] byArray) throws IOException {
        FileWriteEvent fileWriteEvent = FileWriteEvent.EVENT.get();
        if (!fileWriteEvent.isEnabled()) {
            this.write(byArray);
            return;
        }
        try {
            fileWriteEvent.begin();
            this.write(byArray);
            fileWriteEvent.bytesWritten = byArray.length;
        }
        finally {
            fileWriteEvent.path = this.path;
            fileWriteEvent.commit();
            fileWriteEvent.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public void write(byte[] byArray, int n, int n2) throws IOException {
        FileWriteEvent fileWriteEvent = FileWriteEvent.EVENT.get();
        if (!fileWriteEvent.isEnabled()) {
            this.write(byArray, n, n2);
            return;
        }
        try {
            fileWriteEvent.begin();
            this.write(byArray, n, n2);
            fileWriteEvent.bytesWritten = n2;
        }
        finally {
            fileWriteEvent.path = this.path;
            fileWriteEvent.commit();
            fileWriteEvent.reset();
        }
    }
}

