/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.internal.KDCOptions;
import sun.security.krb5.internal.util.KerberosFlags;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class PaPacOptions {
    private static final int CLAIMS = 0;
    private static final int BRANCH_AWARE = 1;
    private static final int FORWARD_TO_FULL_DC = 2;
    private static final int RESOURCE_BASED_CONSTRAINED_DELEGATION = 3;
    private KerberosFlags flags;

    public PaPacOptions() {
        this.flags = new KerberosFlags(32);
    }

    public PaPacOptions(DerValue derValue) throws Asn1Exception, IOException {
        if (derValue.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.flags = new KDCOptions(derValue2.getData().getDerValue());
    }

    public PaPacOptions setClaims(boolean bl) {
        this.flags.set(0, bl);
        return this;
    }

    public boolean getClaims() {
        return this.flags.get(0);
    }

    public PaPacOptions setBranchAware(boolean bl) {
        this.flags.set(1, bl);
        return this;
    }

    public boolean getBranchAware() {
        return this.flags.get(1);
    }

    public PaPacOptions setForwardToFullDC(boolean bl) {
        this.flags.set(2, bl);
        return this;
    }

    public boolean getForwardToFullDC() {
        return this.flags.get(2);
    }

    public PaPacOptions setResourceBasedConstrainedDelegation(boolean bl) {
        this.flags.set(3, bl);
        return this;
    }

    public boolean getResourceBasedConstrainedDelegation() {
        return this.flags.get(3);
    }

    public byte[] asn1Encode() throws IOException {
        byte[] byArray = null;
        try (DerOutputStream derOutputStream = new DerOutputStream();){
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), this.flags.asn1Encode());
            byArray = derOutputStream.toByteArray();
        }
        derOutputStream = new DerOutputStream();
        var3_3 = null;
        try {
            derOutputStream.write((byte)48, byArray);
            byte[] byArray2 = derOutputStream.toByteArray();
            return byArray2;
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (derOutputStream != null) {
                if (var3_3 != null) {
                    try {
                        derOutputStream.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    derOutputStream.close();
                }
            }
        }
    }

    public String toString() {
        return this.flags.toString();
    }
}

