/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.SocketPermissionCollection;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import sun.net.PortConfig;
import sun.net.util.IPAddressUtil;
import sun.net.www.URLConnection;
import sun.security.action.GetBooleanAction;
import sun.security.util.Debug;
import sun.security.util.RegisteredDomain;

public final class SocketPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = -7204263841984476862L;
    private static final int CONNECT = 1;
    private static final int LISTEN = 2;
    private static final int ACCEPT = 4;
    private static final int RESOLVE = 8;
    private static final int NONE = 0;
    private static final int ALL = 15;
    private static final int PORT_MIN = 0;
    private static final int PORT_MAX = 65535;
    private static final int PRIV_PORT_MAX = 1023;
    private static final int DEF_EPH_LOW = 49152;
    private transient int mask;
    private String actions;
    private transient String hostname;
    private transient String cname;
    private transient InetAddress[] addresses;
    private transient boolean wildcard;
    private transient boolean init_with_ip;
    private transient boolean invalid;
    private transient int[] portrange;
    private transient boolean defaultDeny = false;
    private transient boolean untrusted;
    private transient boolean trusted;
    private static boolean trustNameService;
    private static Debug debug;
    private static boolean debugInit;
    private transient String cdomain;
    private transient String hdomain;

    private static synchronized Debug getDebug() {
        if (!debugInit) {
            debug = Debug.getInstance("access");
            debugInit = true;
        }
        return debug;
    }

    public SocketPermission(String string, String string2) {
        super(SocketPermission.getHost(string));
        this.init(this.getName(), SocketPermission.getMask(string2));
    }

    SocketPermission(String string, int n) {
        super(SocketPermission.getHost(string));
        this.init(this.getName(), n);
    }

    private void setDeny() {
        this.defaultDeny = true;
    }

    private static String getHost(String string) {
        int n;
        if (string.equals("")) {
            return "localhost";
        }
        if (string.charAt(0) != '[' && (n = string.indexOf(58)) != string.lastIndexOf(58)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            int n2 = stringTokenizer.countTokens();
            if (n2 == 9) {
                n = string.lastIndexOf(58);
                string = "[" + string.substring(0, n) + "]" + string.substring(n);
            } else if (n2 == 8 && string.indexOf("::") == -1) {
                string = "[" + string + "]";
            } else {
                throw new IllegalArgumentException("Ambiguous hostport part");
            }
        }
        return string;
    }

    private int[] parsePort(String string) throws Exception {
        if (string == null || string.equals("") || string.equals("*")) {
            return new int[]{0, 65535};
        }
        int n = string.indexOf(45);
        if (n == -1) {
            int n2 = Integer.parseInt(string);
            return new int[]{n2, n2};
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        int n3 = string2.equals("") ? 0 : Integer.parseInt(string2);
        int n4 = string3.equals("") ? 65535 : Integer.parseInt(string3);
        if (n3 < 0 || n4 < 0 || n4 < n3) {
            throw new IllegalArgumentException("invalid port range");
        }
        return new int[]{n3, n4};
    }

    private boolean includesEphemerals() {
        return this.portrange[0] == 0;
    }

    private void init(String string, int n) {
        char c;
        if ((n & 0xF) != n) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        this.mask = n | 8;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        String string2 = string;
        if (string.charAt(0) == '[') {
            n3 = 1;
            n2 = string.indexOf(93);
            if (n2 == -1) {
                throw new IllegalArgumentException("invalid host/port: " + string);
            }
            string = string.substring(n3, n2);
            n5 = string2.indexOf(58, n2 + 1);
        } else {
            n3 = 0;
            n4 = n5 = string.indexOf(58, n2);
            if (n5 != -1) {
                string = string.substring(n3, n4);
            }
        }
        if (n5 != -1) {
            String string3 = string2.substring(n5 + 1);
            try {
                this.portrange = this.parsePort(string3);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("invalid port range: " + string3);
            }
        } else {
            this.portrange = new int[]{0, 65535};
        }
        this.hostname = string;
        if (string.lastIndexOf(42) > 0) {
            throw new IllegalArgumentException("invalid host wildcard specification");
        }
        if (string.startsWith("*")) {
            this.wildcard = true;
            if (string.equals("*")) {
                this.cname = "";
            } else if (string.startsWith("*.")) {
                this.cname = string.substring(1).toLowerCase();
            } else {
                throw new IllegalArgumentException("invalid host wildcard specification");
            }
            return;
        }
        if (string.length() > 0 && ((c = string.charAt(0)) == ':' || IPAddressUtil.digit(c, 16) != -1)) {
            byte[] byArray = IPAddressUtil.textToNumericFormatV4(string);
            if (byArray == null) {
                byArray = IPAddressUtil.textToNumericFormatV6(string);
            }
            if (byArray != null) {
                try {
                    this.addresses = new InetAddress[]{InetAddress.getByAddress(byArray)};
                    this.init_with_ip = true;
                }
                catch (UnknownHostException unknownHostException) {
                    this.invalid = true;
                }
            }
        }
    }

    private static int getMask(String string) {
        if (string == null) {
            throw new NullPointerException("action can't be null");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("action can't be empty");
        }
        int n = 0;
        if (string == "resolve") {
            return 8;
        }
        if (string == "connect") {
            return 1;
        }
        if (string == "listen") {
            return 2;
        }
        if (string == "accept") {
            return 4;
        }
        if (string == "connect,accept") {
            return 5;
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length - 1;
        if (n2 < 0) {
            return n;
        }
        while (n2 != -1) {
            int n3;
            char c;
            while (n2 != -1 && ((c = cArray[n2]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) {
                --n2;
            }
            if (!(n2 < 6 || cArray[n2 - 6] != 'c' && cArray[n2 - 6] != 'C' || cArray[n2 - 5] != 'o' && cArray[n2 - 5] != 'O' || cArray[n2 - 4] != 'n' && cArray[n2 - 4] != 'N' || cArray[n2 - 3] != 'n' && cArray[n2 - 3] != 'N' || cArray[n2 - 2] != 'e' && cArray[n2 - 2] != 'E' || cArray[n2 - 1] != 'c' && cArray[n2 - 1] != 'C' || cArray[n2] != 't' && cArray[n2] != 'T')) {
                n3 = 7;
                n |= 1;
            } else if (!(n2 < 6 || cArray[n2 - 6] != 'r' && cArray[n2 - 6] != 'R' || cArray[n2 - 5] != 'e' && cArray[n2 - 5] != 'E' || cArray[n2 - 4] != 's' && cArray[n2 - 4] != 'S' || cArray[n2 - 3] != 'o' && cArray[n2 - 3] != 'O' || cArray[n2 - 2] != 'l' && cArray[n2 - 2] != 'L' || cArray[n2 - 1] != 'v' && cArray[n2 - 1] != 'V' || cArray[n2] != 'e' && cArray[n2] != 'E')) {
                n3 = 7;
                n |= 8;
            } else if (!(n2 < 5 || cArray[n2 - 5] != 'l' && cArray[n2 - 5] != 'L' || cArray[n2 - 4] != 'i' && cArray[n2 - 4] != 'I' || cArray[n2 - 3] != 's' && cArray[n2 - 3] != 'S' || cArray[n2 - 2] != 't' && cArray[n2 - 2] != 'T' || cArray[n2 - 1] != 'e' && cArray[n2 - 1] != 'E' || cArray[n2] != 'n' && cArray[n2] != 'N')) {
                n3 = 6;
                n |= 2;
            } else if (!(n2 < 5 || cArray[n2 - 5] != 'a' && cArray[n2 - 5] != 'A' || cArray[n2 - 4] != 'c' && cArray[n2 - 4] != 'C' || cArray[n2 - 3] != 'c' && cArray[n2 - 3] != 'C' || cArray[n2 - 2] != 'e' && cArray[n2 - 2] != 'E' || cArray[n2 - 1] != 'p' && cArray[n2 - 1] != 'P' || cArray[n2] != 't' && cArray[n2] != 'T')) {
                n3 = 6;
                n |= 4;
            } else {
                throw new IllegalArgumentException("invalid permission: " + string);
            }
            boolean bl = false;
            while (n2 >= n3 && !bl) {
                switch (cArray[n2 - n3]) {
                    case ',': {
                        bl = true;
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid permission: " + string);
                    }
                }
                --n2;
            }
            n2 -= n3;
        }
        return n;
    }

    private boolean isUntrusted() throws UnknownHostException {
        if (this.trusted) {
            return false;
        }
        if (this.invalid || this.untrusted) {
            return true;
        }
        try {
            if (!trustNameService && (this.defaultDeny || URLConnection.isProxiedHost(this.hostname))) {
                if (this.cname == null) {
                    this.getCanonName();
                }
                if (!this.match(this.cname, this.hostname) && !this.authorized(this.hostname, this.addresses[0].getAddress())) {
                    this.untrusted = true;
                    Debug debug = SocketPermission.getDebug();
                    if (debug != null && Debug.isOn("failure")) {
                        debug.println("socket access restriction: proxied host (" + this.addresses[0] + ") does not match " + this.cname + " from reverse lookup");
                    }
                    return true;
                }
                this.trusted = true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            this.invalid = true;
            throw unknownHostException;
        }
        return false;
    }

    void getCanonName() throws UnknownHostException {
        if (this.cname != null || this.invalid || this.untrusted) {
            return;
        }
        try {
            if (this.addresses == null) {
                this.getIP();
            }
            this.cname = this.init_with_ip ? this.addresses[0].getHostName(false).toLowerCase() : InetAddress.getByName(this.addresses[0].getHostAddress()).getHostName(false).toLowerCase();
        }
        catch (UnknownHostException unknownHostException) {
            this.invalid = true;
            throw unknownHostException;
        }
    }

    private boolean match(String string, String string2) {
        String string3;
        String string4 = string.toLowerCase();
        if (string4.startsWith(string3 = string2.toLowerCase()) && (string4.length() == string3.length() || string4.charAt(string3.length()) == '.')) {
            return true;
        }
        if (this.cdomain == null) {
            this.cdomain = RegisteredDomain.from(string4).map(RegisteredDomain::name).orElse(string4);
        }
        if (this.hdomain == null) {
            this.hdomain = RegisteredDomain.from(string3).map(RegisteredDomain::name).orElse(string3);
        }
        return this.cdomain.length() != 0 && this.hdomain.length() != 0 && this.cdomain.equals(this.hdomain);
    }

    private boolean authorized(String string, byte[] byArray) {
        if (byArray.length == 4) {
            return this.authorizedIPv4(string, byArray);
        }
        if (byArray.length == 16) {
            return this.authorizedIPv6(string, byArray);
        }
        return false;
    }

    private boolean authorizedIPv4(String string, byte[] byArray) {
        block4: {
            String string2 = "";
            try {
                string2 = "auth." + (byArray[3] & 0xFF) + "." + (byArray[2] & 0xFF) + "." + (byArray[1] & 0xFF) + "." + (byArray[0] & 0xFF) + ".in-addr.arpa";
                string2 = this.hostname + '.' + string2;
                InetAddress inetAddress = InetAddress.getAllByName0(string2, false)[0];
                if (inetAddress.equals(InetAddress.getByAddress(byArray))) {
                    return true;
                }
                Debug debug = SocketPermission.getDebug();
                if (debug != null && Debug.isOn("failure")) {
                    debug.println("socket access restriction: IP address of " + inetAddress + " != " + InetAddress.getByAddress(byArray));
                }
            }
            catch (UnknownHostException unknownHostException) {
                Debug debug = SocketPermission.getDebug();
                if (debug == null || !Debug.isOn("failure")) break block4;
                debug.println("socket access restriction: forward lookup failed for " + string2);
            }
        }
        return false;
    }

    private boolean authorizedIPv6(String string, byte[] byArray) {
        block5: {
            String string2 = "";
            try {
                StringBuffer stringBuffer = new StringBuffer(39);
                for (int i = 15; i >= 0; --i) {
                    stringBuffer.append(Integer.toHexString(byArray[i] & 0xF));
                    stringBuffer.append('.');
                    stringBuffer.append(Integer.toHexString(byArray[i] >> 4 & 0xF));
                    stringBuffer.append('.');
                }
                string2 = "auth." + stringBuffer.toString() + "IP6.ARPA";
                string2 = this.hostname + '.' + string2;
                InetAddress inetAddress = InetAddress.getAllByName0(string2, false)[0];
                if (inetAddress.equals(InetAddress.getByAddress(byArray))) {
                    return true;
                }
                Debug debug = SocketPermission.getDebug();
                if (debug != null && Debug.isOn("failure")) {
                    debug.println("socket access restriction: IP address of " + inetAddress + " != " + InetAddress.getByAddress(byArray));
                }
            }
            catch (UnknownHostException unknownHostException) {
                Debug debug = SocketPermission.getDebug();
                if (debug == null || !Debug.isOn("failure")) break block5;
                debug.println("socket access restriction: forward lookup failed for " + string2);
            }
        }
        return false;
    }

    void getIP() throws UnknownHostException {
        if (this.addresses != null || this.wildcard || this.invalid) {
            return;
        }
        try {
            int n;
            String string = this.getName().charAt(0) == '[' ? this.getName().substring(1, this.getName().indexOf(93)) : ((n = this.getName().indexOf(":")) == -1 ? this.getName() : this.getName().substring(0, n));
            this.addresses = new InetAddress[]{InetAddress.getAllByName0(string, false)[0]};
        }
        catch (UnknownHostException unknownHostException) {
            this.invalid = true;
            throw unknownHostException;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.invalid = true;
            throw new UnknownHostException(this.getName());
        }
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof SocketPermission)) {
            return false;
        }
        if (permission == this) {
            return true;
        }
        SocketPermission socketPermission = (SocketPermission)permission;
        return (this.mask & socketPermission.mask) == socketPermission.mask && this.impliesIgnoreMask(socketPermission);
    }

    boolean impliesIgnoreMask(SocketPermission socketPermission) {
        if ((socketPermission.mask & 8) != socketPermission.mask && (socketPermission.portrange[0] < this.portrange[0] || socketPermission.portrange[1] > this.portrange[1])) {
            if (this.includesEphemerals() || socketPermission.includesEphemerals()) {
                if (!SocketPermission.inRange(this.portrange[0], this.portrange[1], socketPermission.portrange[0], socketPermission.portrange[1])) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (this.wildcard && "".equals(this.cname)) {
            return true;
        }
        if (this.invalid || socketPermission.invalid) {
            return this.compareHostnames(socketPermission);
        }
        try {
            if (this.init_with_ip) {
                if (socketPermission.wildcard) {
                    return false;
                }
                if (socketPermission.init_with_ip) {
                    return this.addresses[0].equals(socketPermission.addresses[0]);
                }
                if (socketPermission.addresses == null) {
                    socketPermission.getIP();
                }
                for (int i = 0; i < socketPermission.addresses.length; ++i) {
                    if (!this.addresses[0].equals(socketPermission.addresses[i])) continue;
                    return true;
                }
                return false;
            }
            if (this.wildcard || socketPermission.wildcard) {
                if (this.wildcard && socketPermission.wildcard) {
                    return socketPermission.cname.endsWith(this.cname);
                }
                if (socketPermission.wildcard) {
                    return false;
                }
                if (socketPermission.cname == null) {
                    socketPermission.getCanonName();
                }
                return socketPermission.cname.endsWith(this.cname);
            }
            if (this.addresses == null) {
                this.getIP();
            }
            if (socketPermission.addresses == null) {
                socketPermission.getIP();
            }
            if (!socketPermission.init_with_ip || !this.isUntrusted()) {
                for (int i = 0; i < this.addresses.length; ++i) {
                    for (int j = 0; j < socketPermission.addresses.length; ++j) {
                        if (!this.addresses[i].equals(socketPermission.addresses[j])) continue;
                        return true;
                    }
                }
                if (this.cname == null) {
                    this.getCanonName();
                }
                if (socketPermission.cname == null) {
                    socketPermission.getCanonName();
                }
                return this.cname.equalsIgnoreCase(socketPermission.cname);
            }
        }
        catch (UnknownHostException unknownHostException) {
            return this.compareHostnames(socketPermission);
        }
        return false;
    }

    private boolean compareHostnames(SocketPermission socketPermission) {
        String string = this.hostname;
        String string2 = socketPermission.hostname;
        if (string == null) {
            return false;
        }
        if (this.wildcard) {
            int n = this.cname.length();
            return string2.regionMatches(true, string2.length() - n, this.cname, 0, n);
        }
        return string.equalsIgnoreCase(string2);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SocketPermission)) {
            return false;
        }
        SocketPermission socketPermission = (SocketPermission)object;
        if (this.mask != socketPermission.mask) {
            return false;
        }
        if ((socketPermission.mask & 8) != socketPermission.mask && (this.portrange[0] != socketPermission.portrange[0] || this.portrange[1] != socketPermission.portrange[1])) {
            return false;
        }
        if (this.getName().equalsIgnoreCase(socketPermission.getName())) {
            return true;
        }
        try {
            this.getCanonName();
            socketPermission.getCanonName();
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        if (this.invalid || socketPermission.invalid) {
            return false;
        }
        if (this.cname != null) {
            return this.cname.equalsIgnoreCase(socketPermission.cname);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.init_with_ip || this.wildcard) {
            return this.getName().hashCode();
        }
        try {
            this.getCanonName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (this.invalid || this.cname == null) {
            return this.getName().hashCode();
        }
        return this.cname.hashCode();
    }

    int getMask() {
        return this.mask;
    }

    private static String getActions(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        if ((n & 1) == 1) {
            bl = true;
            stringBuilder.append("connect");
        }
        if ((n & 2) == 2) {
            if (bl) {
                stringBuilder.append(',');
            } else {
                bl = true;
            }
            stringBuilder.append("listen");
        }
        if ((n & 4) == 4) {
            if (bl) {
                stringBuilder.append(',');
            } else {
                bl = true;
            }
            stringBuilder.append("accept");
        }
        if ((n & 8) == 8) {
            if (bl) {
                stringBuilder.append(',');
            } else {
                bl = true;
            }
            stringBuilder.append("resolve");
        }
        return stringBuilder.toString();
    }

    @Override
    public String getActions() {
        if (this.actions == null) {
            this.actions = SocketPermission.getActions(this.mask);
        }
        return this.actions;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new SocketPermissionCollection();
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(this.getName(), SocketPermission.getMask(this.actions));
    }

    private static int initEphemeralPorts(final String string, int n) {
        return AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                int n = Integer.getInteger("jdk.net.ephemeralPortRange." + string, -1);
                if (n != -1) {
                    return n;
                }
                return string.equals("low") ? PortConfig.getLower() : PortConfig.getUpper();
            }
        });
    }

    private static boolean inRange(int n, int n2, int n3, int n4) {
        int n5 = EphemeralRange.low;
        int n6 = EphemeralRange.high;
        if (n3 == 0) {
            if (!SocketPermission.inRange(n, n2, n5, n6)) {
                return false;
            }
            if (n4 == 0) {
                return true;
            }
            n3 = 1;
        }
        if (n == 0 && n2 == 0) {
            return n3 >= n5 && n4 <= n6;
        }
        if (n != 0) {
            return n3 >= n && n4 <= n2;
        }
        if (n2 >= n5 - 1) {
            return n4 <= n6;
        }
        return n3 <= n2 && n4 <= n2 || n3 >= n5 && n4 <= n6;
    }

    static /* synthetic */ int access$000(String string, int n) {
        return SocketPermission.initEphemeralPorts(string, n);
    }

    static {
        debug = null;
        debugInit = false;
        Boolean bl = AccessController.doPrivileged(new GetBooleanAction("sun.net.trustNameService"));
        trustNameService = bl;
    }

    private static class EphemeralRange {
        static final int low = SocketPermission.access$000("low", 49152);
        static final int high = SocketPermission.access$000("high", 65535);

        private EphemeralRange() {
        }
    }
}

