/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Transparency;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.TileObserver;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import sun.awt.image.ByteComponentRaster;
import sun.awt.image.BytePackedRaster;
import sun.awt.image.IntegerComponentRaster;
import sun.awt.image.OffScreenImageSource;
import sun.awt.image.ShortComponentRaster;

public class BufferedImage
extends Image
implements WritableRenderedImage,
Transparency {
    private int imageType = 0;
    private ColorModel colorModel;
    private final WritableRaster raster;
    private OffScreenImageSource osis;
    private Hashtable<String, Object> properties;
    public static final int TYPE_CUSTOM = 0;
    public static final int TYPE_INT_RGB = 1;
    public static final int TYPE_INT_ARGB = 2;
    public static final int TYPE_INT_ARGB_PRE = 3;
    public static final int TYPE_INT_BGR = 4;
    public static final int TYPE_3BYTE_BGR = 5;
    public static final int TYPE_4BYTE_ABGR = 6;
    public static final int TYPE_4BYTE_ABGR_PRE = 7;
    public static final int TYPE_USHORT_565_RGB = 8;
    public static final int TYPE_USHORT_555_RGB = 9;
    public static final int TYPE_BYTE_GRAY = 10;
    public static final int TYPE_USHORT_GRAY = 11;
    public static final int TYPE_BYTE_BINARY = 12;
    public static final int TYPE_BYTE_INDEXED = 13;
    private static final int DCM_RED_MASK = 0xFF0000;
    private static final int DCM_GREEN_MASK = 65280;
    private static final int DCM_BLUE_MASK = 255;
    private static final int DCM_ALPHA_MASK = -16777216;
    private static final int DCM_565_RED_MASK = 63488;
    private static final int DCM_565_GRN_MASK = 2016;
    private static final int DCM_565_BLU_MASK = 31;
    private static final int DCM_555_RED_MASK = 31744;
    private static final int DCM_555_GRN_MASK = 992;
    private static final int DCM_555_BLU_MASK = 31;
    private static final int DCM_BGR_RED_MASK = 255;
    private static final int DCM_BGR_GRN_MASK = 65280;
    private static final int DCM_BGR_BLU_MASK = 0xFF0000;

    private static native void initIDs();

    public BufferedImage(int n, int n2, int n3) {
        switch (n3) {
            case 1: {
                this.colorModel = new DirectColorModel(24, 0xFF0000, 65280, 255, 0);
                this.raster = this.colorModel.createCompatibleWritableRaster(n, n2);
                break;
            }
            case 2: {
                this.colorModel = ColorModel.getRGBdefault();
                this.raster = this.colorModel.createCompatibleWritableRaster(n, n2);
                break;
            }
            case 3: {
                this.colorModel = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, true, 3);
                this.raster = this.colorModel.createCompatibleWritableRaster(n, n2);
                break;
            }
            case 4: {
                this.colorModel = new DirectColorModel(24, 255, 65280, 0xFF0000);
                this.raster = this.colorModel.createCompatibleWritableRaster(n, n2);
                break;
            }
            case 5: {
                ColorSpace colorSpace = ColorSpace.getInstance(1000);
                int[] nArray = new int[]{8, 8, 8};
                int[] nArray2 = new int[]{2, 1, 0};
                this.colorModel = new ComponentColorModel(colorSpace, nArray, false, false, 1, 0);
                this.raster = Raster.createInterleavedRaster(0, n, n2, n * 3, 3, nArray2, null);
                break;
            }
            case 6: {
                ColorSpace colorSpace = ColorSpace.getInstance(1000);
                int[] nArray = new int[]{8, 8, 8, 8};
                int[] nArray3 = new int[]{3, 2, 1, 0};
                this.colorModel = new ComponentColorModel(colorSpace, nArray, true, false, 3, 0);
                this.raster = Raster.createInterleavedRaster(0, n, n2, n * 4, 4, nArray3, null);
                break;
            }
            case 7: {
                ColorSpace colorSpace = ColorSpace.getInstance(1000);
                int[] nArray = new int[]{8, 8, 8, 8};
                int[] nArray4 = new int[]{3, 2, 1, 0};
                this.colorModel = new ComponentColorModel(colorSpace, nArray, true, true, 3, 0);
                this.raster = Raster.createInterleavedRaster(0, n, n2, n * 4, 4, nArray4, null);
                break;
            }
            case 10: {
                ColorSpace colorSpace = ColorSpace.getInstance(1003);
                int[] nArray = new int[]{8};
                this.colorModel = new ComponentColorModel(colorSpace, nArray, false, true, 1, 0);
                this.raster = this.colorModel.createCompatibleWritableRaster(n, n2);
                break;
            }
            case 11: {
                ColorSpace colorSpace = ColorSpace.getInstance(1003);
                int[] nArray = new int[]{16};
                this.colorModel = new ComponentColorModel(colorSpace, nArray, false, true, 1, 1);
                this.raster = this.colorModel.createCompatibleWritableRaster(n, n2);
                break;
            }
            case 12: {
                byte[] byArray = new byte[]{0, -1};
                this.colorModel = new IndexColorModel(1, 2, byArray, byArray, byArray);
                this.raster = Raster.createPackedRaster(0, n, n2, 1, 1, null);
                break;
            }
            case 13: {
                int n4;
                int n5;
                int[] nArray = new int[256];
                int n6 = 0;
                for (n5 = 0; n5 < 256; n5 += 51) {
                    for (n4 = 0; n4 < 256; n4 += 51) {
                        for (int i = 0; i < 256; i += 51) {
                            nArray[n6++] = n5 << 16 | n4 << 8 | i;
                        }
                    }
                }
                n5 = 256 / (256 - n6);
                n4 = n5 * 3;
                while (n6 < 256) {
                    nArray[n6] = n4 << 16 | n4 << 8 | n4;
                    n4 += n5;
                    ++n6;
                }
                this.colorModel = new IndexColorModel(8, 256, nArray, 0, false, -1, 0);
                this.raster = Raster.createInterleavedRaster(0, n, n2, 1, null);
                break;
            }
            case 8: {
                this.colorModel = new DirectColorModel(16, 63488, 2016, 31);
                this.raster = this.colorModel.createCompatibleWritableRaster(n, n2);
                break;
            }
            case 9: {
                this.colorModel = new DirectColorModel(15, 31744, 992, 31);
                this.raster = this.colorModel.createCompatibleWritableRaster(n, n2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown image type " + n3);
            }
        }
        this.imageType = n3;
    }

    public BufferedImage(int n, int n2, int n3, IndexColorModel indexColorModel) {
        if (indexColorModel.hasAlpha() && indexColorModel.isAlphaPremultiplied()) {
            throw new IllegalArgumentException("This image types do not have premultiplied alpha.");
        }
        switch (n3) {
            case 12: {
                int n4;
                int n5 = indexColorModel.getMapSize();
                if (n5 <= 2) {
                    n4 = 1;
                } else if (n5 <= 4) {
                    n4 = 2;
                } else if (n5 <= 16) {
                    n4 = 4;
                } else {
                    throw new IllegalArgumentException("Color map for TYPE_BYTE_BINARY must have no more than 16 entries");
                }
                this.raster = Raster.createPackedRaster(0, n, n2, 1, n4, null);
                break;
            }
            case 13: {
                this.raster = Raster.createInterleavedRaster(0, n, n2, 1, null);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid image type (" + n3 + ").  Image type must be either TYPE_BYTE_BINARY or  TYPE_BYTE_INDEXED");
            }
        }
        if (!indexColorModel.isCompatibleRaster(this.raster)) {
            throw new IllegalArgumentException("Incompatible image type and IndexColorModel");
        }
        this.colorModel = indexColorModel;
        this.imageType = n3;
    }

    public BufferedImage(ColorModel colorModel, WritableRaster writableRaster, boolean bl, Hashtable<?, ?> hashtable) {
        if (!colorModel.isCompatibleRaster(writableRaster)) {
            throw new IllegalArgumentException("Raster " + writableRaster + " is incompatible with ColorModel " + colorModel);
        }
        if (writableRaster.minX != 0 || writableRaster.minY != 0) {
            throw new IllegalArgumentException("Raster " + writableRaster + " has minX or minY not equal to zero: " + writableRaster.minX + " " + writableRaster.minY);
        }
        this.colorModel = colorModel;
        this.raster = writableRaster;
        if (hashtable != null && !hashtable.isEmpty()) {
            this.properties = new Hashtable();
            for (Object obj : hashtable.keySet()) {
                if (!(obj instanceof String)) continue;
                this.properties.put((String)obj, hashtable.get(obj));
            }
        }
        int n = writableRaster.getNumBands();
        boolean bl2 = colorModel.isAlphaPremultiplied();
        boolean bl3 = BufferedImage.isStandard(colorModel, writableRaster);
        this.coerceData(bl);
        SampleModel sampleModel = writableRaster.getSampleModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        int n2 = colorSpace.getType();
        if (n2 != 5) {
            if (n2 == 6 && bl3 && colorModel instanceof ComponentColorModel) {
                if (sampleModel instanceof ComponentSampleModel && ((ComponentSampleModel)sampleModel).getPixelStride() != n) {
                    this.imageType = 0;
                } else if (writableRaster instanceof ByteComponentRaster && writableRaster.getNumBands() == 1 && colorModel.getComponentSize(0) == 8 && ((ByteComponentRaster)writableRaster).getPixelStride() == 1) {
                    this.imageType = 10;
                } else if (writableRaster instanceof ShortComponentRaster && writableRaster.getNumBands() == 1 && colorModel.getComponentSize(0) == 16 && ((ShortComponentRaster)writableRaster).getPixelStride() == 1) {
                    this.imageType = 11;
                }
            } else {
                this.imageType = 0;
            }
            return;
        }
        if (writableRaster instanceof IntegerComponentRaster && (n == 3 || n == 4)) {
            IntegerComponentRaster integerComponentRaster = (IntegerComponentRaster)writableRaster;
            int n3 = colorModel.getPixelSize();
            if (integerComponentRaster.getPixelStride() == 1 && bl3 && colorModel instanceof DirectColorModel && (n3 == 32 || n3 == 24)) {
                DirectColorModel directColorModel = (DirectColorModel)colorModel;
                int n4 = directColorModel.getRedMask();
                int n5 = directColorModel.getGreenMask();
                int n6 = directColorModel.getBlueMask();
                if (n4 == 0xFF0000 && n5 == 65280 && n6 == 255) {
                    if (directColorModel.getAlphaMask() == -16777216) {
                        this.imageType = bl2 ? 3 : 2;
                    } else if (!directColorModel.hasAlpha()) {
                        this.imageType = 1;
                    }
                } else if (n4 == 255 && n5 == 65280 && n6 == 0xFF0000 && !directColorModel.hasAlpha()) {
                    this.imageType = 4;
                }
            }
        } else if (colorModel instanceof IndexColorModel && n == 1 && bl3 && (!colorModel.hasAlpha() || !bl2)) {
            ByteComponentRaster byteComponentRaster;
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            int n7 = indexColorModel.getPixelSize();
            if (writableRaster instanceof BytePackedRaster) {
                this.imageType = 12;
            } else if (writableRaster instanceof ByteComponentRaster && (byteComponentRaster = (ByteComponentRaster)writableRaster).getPixelStride() == 1 && n7 <= 8) {
                this.imageType = 13;
            }
        } else if (writableRaster instanceof ShortComponentRaster && colorModel instanceof DirectColorModel && bl3 && n == 3 && !colorModel.hasAlpha()) {
            DirectColorModel directColorModel = (DirectColorModel)colorModel;
            if (directColorModel.getRedMask() == 63488) {
                if (directColorModel.getGreenMask() == 2016 && directColorModel.getBlueMask() == 31) {
                    this.imageType = 8;
                }
            } else if (directColorModel.getRedMask() == 31744 && directColorModel.getGreenMask() == 992 && directColorModel.getBlueMask() == 31) {
                this.imageType = 9;
            }
        } else if (writableRaster instanceof ByteComponentRaster && colorModel instanceof ComponentColorModel && bl3 && writableRaster.getSampleModel() instanceof PixelInterleavedSampleModel && (n == 3 || n == 4)) {
            ComponentColorModel componentColorModel = (ComponentColorModel)colorModel;
            PixelInterleavedSampleModel pixelInterleavedSampleModel = (PixelInterleavedSampleModel)writableRaster.getSampleModel();
            ByteComponentRaster byteComponentRaster = (ByteComponentRaster)writableRaster;
            int[] nArray = pixelInterleavedSampleModel.getBandOffsets();
            if (componentColorModel.getNumComponents() != n) {
                throw new RasterFormatException("Number of components in ColorModel (" + componentColorModel.getNumComponents() + ") does not match # in  Raster (" + n + ")");
            }
            int[] nArray2 = componentColorModel.getComponentSize();
            boolean bl4 = true;
            for (int i = 0; i < n; ++i) {
                if (nArray2[i] == 8) continue;
                bl4 = false;
                break;
            }
            if (bl4 && byteComponentRaster.getPixelStride() == n && nArray[0] == n - 1 && nArray[1] == n - 2 && nArray[2] == n - 3) {
                if (n == 3 && !componentColorModel.hasAlpha()) {
                    this.imageType = 5;
                } else if (nArray[3] == 0 && componentColorModel.hasAlpha()) {
                    this.imageType = bl2 ? 7 : 6;
                }
            }
        }
    }

    private static boolean isStandard(ColorModel colorModel, WritableRaster writableRaster) {
        final Class<?> clazz = colorModel.getClass();
        final Class<?> clazz2 = writableRaster.getClass();
        final Class<?> clazz3 = writableRaster.getSampleModel().getClass();
        PrivilegedAction<Boolean> privilegedAction = new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                ClassLoader classLoader = System.class.getClassLoader();
                return clazz.getClassLoader() == classLoader && clazz3.getClassLoader() == classLoader && clazz2.getClassLoader() == classLoader;
            }
        };
        return AccessController.doPrivileged(privilegedAction);
    }

    public int getType() {
        return this.imageType;
    }

    @Override
    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public WritableRaster getRaster() {
        return this.raster;
    }

    public WritableRaster getAlphaRaster() {
        return this.colorModel.getAlphaRaster(this.raster);
    }

    public int getRGB(int n, int n2) {
        return this.colorModel.getRGB(this.raster.getDataElements(n, n2, null));
    }

    public int[] getRGB(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        Object[] objectArray;
        int n7 = n5;
        int n8 = this.raster.getNumBands();
        int n9 = this.raster.getDataBuffer().getDataType();
        switch (n9) {
            case 0: {
                objectArray = new byte[n8];
                break;
            }
            case 1: {
                objectArray = new short[n8];
                break;
            }
            case 3: {
                objectArray = new int[n8];
                break;
            }
            case 4: {
                objectArray = new float[n8];
                break;
            }
            case 5: {
                objectArray = new double[n8];
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown data buffer type: " + n9);
            }
        }
        if (nArray == null) {
            nArray = new int[n5 + n4 * n6];
        }
        int n10 = n2;
        while (n10 < n2 + n4) {
            int n11 = n7;
            for (int i = n; i < n + n3; ++i) {
                nArray[n11++] = this.colorModel.getRGB(this.raster.getDataElements(i, n10, objectArray));
            }
            ++n10;
            n7 += n6;
        }
        return nArray;
    }

    public synchronized void setRGB(int n, int n2, int n3) {
        this.raster.setDataElements(n, n2, this.colorModel.getDataElements(n3, null));
    }

    public void setRGB(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        int n7 = n5;
        Object object = null;
        int n8 = n2;
        while (n8 < n2 + n4) {
            int n9 = n7;
            for (int i = n; i < n + n3; ++i) {
                object = this.colorModel.getDataElements(nArray[n9++], object);
                this.raster.setDataElements(i, n8, object);
            }
            ++n8;
            n7 += n6;
        }
    }

    @Override
    public int getWidth() {
        return this.raster.getWidth();
    }

    @Override
    public int getHeight() {
        return this.raster.getHeight();
    }

    @Override
    public int getWidth(ImageObserver imageObserver) {
        return this.raster.getWidth();
    }

    @Override
    public int getHeight(ImageObserver imageObserver) {
        return this.raster.getHeight();
    }

    @Override
    public ImageProducer getSource() {
        if (this.osis == null) {
            if (this.properties == null) {
                this.properties = new Hashtable();
            }
            this.osis = new OffScreenImageSource(this, this.properties);
        }
        return this.osis;
    }

    @Override
    public Object getProperty(String string, ImageObserver imageObserver) {
        return this.getProperty(string);
    }

    @Override
    public Object getProperty(String string) {
        if (string == null) {
            throw new NullPointerException("null property name is not allowed");
        }
        if (this.properties == null) {
            return Image.UndefinedProperty;
        }
        Object object = this.properties.get(string);
        if (object == null) {
            object = Image.UndefinedProperty;
        }
        return object;
    }

    @Override
    public Graphics getGraphics() {
        return this.createGraphics();
    }

    public Graphics2D createGraphics() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return graphicsEnvironment.createGraphics(this);
    }

    public BufferedImage getSubimage(int n, int n2, int n3, int n4) {
        return new BufferedImage(this.colorModel, this.raster.createWritableChild(n, n2, n3, n4, 0, 0, null), this.colorModel.isAlphaPremultiplied(), this.properties);
    }

    public boolean isAlphaPremultiplied() {
        return this.colorModel.isAlphaPremultiplied();
    }

    public void coerceData(boolean bl) {
        if (this.colorModel.hasAlpha() && this.colorModel.isAlphaPremultiplied() != bl) {
            this.colorModel = this.colorModel.coerceData(this.raster, bl);
        }
    }

    public String toString() {
        return "BufferedImage@" + Integer.toHexString(this.hashCode()) + ": type = " + this.imageType + " " + this.colorModel + " " + this.raster;
    }

    @Override
    public Vector<RenderedImage> getSources() {
        return null;
    }

    @Override
    public String[] getPropertyNames() {
        if (this.properties == null || this.properties.isEmpty()) {
            return null;
        }
        Set<String> set = this.properties.keySet();
        return set.toArray(new String[set.size()]);
    }

    @Override
    public int getMinX() {
        return this.raster.getMinX();
    }

    @Override
    public int getMinY() {
        return this.raster.getMinY();
    }

    @Override
    public SampleModel getSampleModel() {
        return this.raster.getSampleModel();
    }

    @Override
    public int getNumXTiles() {
        return 1;
    }

    @Override
    public int getNumYTiles() {
        return 1;
    }

    @Override
    public int getMinTileX() {
        return 0;
    }

    @Override
    public int getMinTileY() {
        return 0;
    }

    @Override
    public int getTileWidth() {
        return this.raster.getWidth();
    }

    @Override
    public int getTileHeight() {
        return this.raster.getHeight();
    }

    @Override
    public int getTileGridXOffset() {
        return this.raster.getSampleModelTranslateX();
    }

    @Override
    public int getTileGridYOffset() {
        return this.raster.getSampleModelTranslateY();
    }

    @Override
    public Raster getTile(int n, int n2) {
        if (n == 0 && n2 == 0) {
            return this.raster;
        }
        throw new ArrayIndexOutOfBoundsException("BufferedImages only have one tile with index 0,0");
    }

    @Override
    public Raster getData() {
        int n = this.raster.getWidth();
        int n2 = this.raster.getHeight();
        int n3 = this.raster.getMinX();
        int n4 = this.raster.getMinY();
        WritableRaster writableRaster = Raster.createWritableRaster(this.raster.getSampleModel(), new Point(this.raster.getSampleModelTranslateX(), this.raster.getSampleModelTranslateY()));
        Object object = null;
        for (int i = n4; i < n4 + n2; ++i) {
            object = this.raster.getDataElements(n3, i, n, 1, object);
            writableRaster.setDataElements(n3, i, n, 1, object);
        }
        return writableRaster;
    }

    @Override
    public Raster getData(Rectangle rectangle) {
        SampleModel sampleModel = this.raster.getSampleModel();
        SampleModel sampleModel2 = sampleModel.createCompatibleSampleModel(rectangle.width, rectangle.height);
        WritableRaster writableRaster = Raster.createWritableRaster(sampleModel2, rectangle.getLocation());
        int n = rectangle.width;
        int n2 = rectangle.height;
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        Object object = null;
        for (int i = n4; i < n4 + n2; ++i) {
            object = this.raster.getDataElements(n3, i, n, 1, object);
            writableRaster.setDataElements(n3, i, n, 1, object);
        }
        return writableRaster;
    }

    @Override
    public WritableRaster copyData(WritableRaster writableRaster) {
        if (writableRaster == null) {
            return (WritableRaster)this.getData();
        }
        int n = writableRaster.getWidth();
        int n2 = writableRaster.getHeight();
        int n3 = writableRaster.getMinX();
        int n4 = writableRaster.getMinY();
        Object object = null;
        for (int i = n4; i < n4 + n2; ++i) {
            object = this.raster.getDataElements(n3, i, n, 1, object);
            writableRaster.setDataElements(n3, i, n, 1, object);
        }
        return writableRaster;
    }

    @Override
    public void setData(Raster raster) {
        int n = raster.getWidth();
        int n2 = raster.getHeight();
        int n3 = raster.getMinX();
        int n4 = raster.getMinY();
        int[] nArray = null;
        Rectangle rectangle = new Rectangle(n3, n4, n, n2);
        Rectangle rectangle2 = new Rectangle(0, 0, this.raster.width, this.raster.height);
        Rectangle rectangle3 = rectangle.intersection(rectangle2);
        if (rectangle3.isEmpty()) {
            return;
        }
        n = rectangle3.width;
        n2 = rectangle3.height;
        n3 = rectangle3.x;
        for (int i = n4 = rectangle3.y; i < n4 + n2; ++i) {
            nArray = raster.getPixels(n3, i, n, 1, nArray);
            this.raster.setPixels(n3, i, n, 1, nArray);
        }
    }

    @Override
    public void addTileObserver(TileObserver tileObserver) {
    }

    @Override
    public void removeTileObserver(TileObserver tileObserver) {
    }

    @Override
    public boolean isTileWritable(int n, int n2) {
        if (n == 0 && n2 == 0) {
            return true;
        }
        throw new IllegalArgumentException("Only 1 tile in image");
    }

    @Override
    public Point[] getWritableTileIndices() {
        Point[] pointArray = new Point[]{new Point(0, 0)};
        return pointArray;
    }

    @Override
    public boolean hasTileWriters() {
        return true;
    }

    @Override
    public WritableRaster getWritableTile(int n, int n2) {
        return this.raster;
    }

    @Override
    public void releaseWritableTile(int n, int n2) {
    }

    @Override
    public int getTransparency() {
        return this.colorModel.getTransparency();
    }

    static {
        ColorModel.loadLibraries();
        BufferedImage.initIDs();
    }
}

