/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.interceptors;

import com.sun.corba.se.impl.interceptors.SlotTable;
import com.sun.corba.se.impl.interceptors.SlotTableStack;
import com.sun.corba.se.impl.logging.OMGSystemException;
import com.sun.corba.se.spi.orb.ORB;
import org.omg.CORBA.Any;
import org.omg.CORBA.LocalObject;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.InvalidSlot;

public class PICurrent
extends LocalObject
implements Current {
    private int slotCounter;
    private ORB myORB;
    private OMGSystemException wrapper;
    private boolean orbInitializing;
    private ThreadLocal threadLocalSlotTable = new ThreadLocal(){

        protected Object initialValue() {
            SlotTable slotTable = new SlotTable(PICurrent.this.myORB, PICurrent.this.slotCounter);
            return new SlotTableStack(PICurrent.this.myORB, slotTable);
        }
    };

    PICurrent(ORB oRB) {
        this.myORB = oRB;
        this.wrapper = OMGSystemException.get(oRB, "rpc.protocol");
        this.orbInitializing = true;
        this.slotCounter = 0;
    }

    int allocateSlotId() {
        int n = this.slotCounter++;
        return n;
    }

    SlotTable getSlotTable() {
        SlotTable slotTable = ((SlotTableStack)this.threadLocalSlotTable.get()).peekSlotTable();
        return slotTable;
    }

    void pushSlotTable() {
        SlotTableStack slotTableStack = (SlotTableStack)this.threadLocalSlotTable.get();
        slotTableStack.pushSlotTable();
    }

    void popSlotTable() {
        SlotTableStack slotTableStack = (SlotTableStack)this.threadLocalSlotTable.get();
        slotTableStack.popSlotTable();
    }

    @Override
    public void set_slot(int n, Any any) throws InvalidSlot {
        if (this.orbInitializing) {
            throw this.wrapper.invalidPiCall3();
        }
        this.getSlotTable().set_slot(n, any);
    }

    @Override
    public Any get_slot(int n) throws InvalidSlot {
        if (this.orbInitializing) {
            throw this.wrapper.invalidPiCall4();
        }
        return this.getSlotTable().get_slot(n);
    }

    void resetSlotTable() {
        this.getSlotTable().resetSlots();
    }

    void setORBInitializing(boolean bl) {
        this.orbInitializing = bl;
    }
}

