## RabbitMQ 3.8.18

RabbitMQ `3.8.18` is a maintenance release that includes a security patch.

This release addresses an undisclosed vulnerability with CVSS 3.1 [score of 3.1](https://www.first.org/cvss/calculator/3.1#CVSS:3.1/AV:N/AC:H/PR:H/UI:R/S:U/C:L/I:L/A:N/E:P/RL:O/RC:C) (low): [CVE-2021-32719](https://github.com/rabbitmq/rabbitmq-server/security/advisories/GHSA-5452-hxj4-773x)

Our team would like to thank Fahimhusain Raydurg for [responsibly disclosing](https://www.rabbitmq.com/contact.html#security)
the vulnerability and Patrik Ragnarsson from CloudAMQP for contributing a fix.

### Obtaining Packages

RabbitMQ releases are distributed via [GitHub](https://github.com/rabbitmq/rabbitmq-server/releases), [Cloudsmith](https://cloudsmith.io/~rabbitmq/repos/),
and [PackageCloud](https://packagecloud.io/rabbitmq).

### Erlang/OTP Compatibility Notes

This release [requires Erlang 23.2](https://www.rabbitmq.com/which-erlang.html) and [supports Erlang 24](https://blog.rabbitmq.com/posts/2021/03/erlang-24-support-roadmap/).

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision modern Erlang versions.


## Upgrade and Compatibility Notes

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades and
[RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

If upgrading from a`3.7.x` release, see [3.8.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.8.0)
upgrade and compatibility notes first.

If upgrading from a `3.6.x` or older [release series](https://www.rabbitmq.com/versions.html), first upgrade
to [`3.7.27`](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.27) and then to this version.


## Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the [RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users)
and [RabbitMQ community Slack](https://rabbitmq-slack.herokuapp.com/).


## Changes Worth Mentioning

### Core Server

#### Enhancements

 * [Peer discovery](https://www.rabbitmq.com/cluster-formation.html) no longer uses randomized delays to avoid the inherent race condition
   during [initial cluster formation](https://www.rabbitmq.com/cluster-formation.html#initial-formation-race-condition). Instead it relies on an internal
   distributed locking mechanism available in modern Erlang releases.

   While randomized startup delay was reasonably effective at ensuring only one cluster was formed even during parallel node
   startup, it by definition assumes that with some low probability more than one node can still start as seed nodes,
   and be joined by different groups of cluster peers. The locking mechanism does not have this downside.
   Now that RabbitMQ requires Erlang 23.2, the internal locking library becomes an option for peer discovery.
   Note that etcd and Consul-based peer discovery still use those service's support for distributed locks.

   `cluster_formation.randomized_startup_delay_range.min` and `cluster_formation.randomized_startup_delay_range.max` configuration keys
   will no longer have any effect.

   GitHub issue: [#3075](https://github.com/rabbitmq/rabbitmq-server/pull/3075)

 * Node startup banner now includes Erlang version, runtime operation mode (JIT vs. emulator),
   and underlying crypto library version (e.g. OpenSSL 1.1.1k)  it was built against.

   GitHub issue: [#2777](https://github.com/rabbitmq/rabbitmq-server/pull/2777)

 * Build system targets now use `hostname(1)` in a way that is compatible with Solaris.

   Contributed by Pavel @tropikhajma Heimlich.

   GitHub issue: [#3117](https://github.com/rabbitmq/rabbitmq-server/pull/3117)

#### Bug Fixes

 * Queue deletion could run into an exception in some rare cases.

   Contributed by @tomyouyou.

   GitHub issue: [#3086](https://github.com/rabbitmq/rabbitmq-server/issues/3086)


### Prometheus Plugin

#### Bug Fixes

 * In certain double stack (IPv4 and IPv6) environments, the plugin would start a single listener
   but register two internally. That extra non-existent listener would make `rabbitmq-diagnostics drain`
   fail as it disables all registered listeners.

   GitHub issue: [#3021](https://github.com/rabbitmq/rabbitmq-server/pull/3021)


### Management Plugin

#### Bug Fixes

 * In certain double stack (IPv4 and IPv6) environments, the plugin would start a single listener
   but register two internally. That extra non-existent listener would make `rabbitmq-diagnostics drain`
   fail as it disables all registered listeners.

   GitHub issue: [#3021](https://github.com/rabbitmq/rabbitmq-server/pull/3021)

### Kubernetes Peer Discovery Plugin

#### Enhancements

 * Kubernetes [peer discovery](https://www.rabbitmq.com/cluster-formation.html) mechanism no longer uses randomized delays to avoid the inherent race condition
   during [initial cluster formation](https://www.rabbitmq.com/cluster-formation.html#initial-formation-race-condition). Instead it relies on an internal
   distributed locking mechanism available in modern Erlang releases.

   While randomized startup delay was reasonably effective at ensuring only one cluster was formed even during parallel node
   startup, it by definitely assumes that with some low probability more than one node can still start as seed nodes,
   and be joined by different groups of cluster peers. The locking mechanism does not have this downside.
   Now that RabbitMQ requires Erlang 23.2, the internal locking library becomes an option for peer discovery.

   `cluster_formation.randomized_startup_delay_range.min` and `cluster_formation.randomized_startup_delay_range.max` configuration keys
   will no longer have any effect.

   GitHub issue: [#3075](https://github.com/rabbitmq/rabbitmq-server/pull/3075)


### AWS Peer Discovery Plugin

#### Enhancements

 * AWS [peer discovery](https://www.rabbitmq.com/cluster-formation.html) mechanism no longer uses randomized delays to avoid the inherent race condition
   during [initial cluster formation](https://www.rabbitmq.com/cluster-formation.html#initial-formation-race-condition). Instead it relies on an internal
   distributed locking mechanism available in modern Erlang releases.

   While randomized startup delay was reasonably effective at ensuring only one cluster was formed even during parallel node
   startup, it by definitely assumes that with some low probability more than one node can still start as seed nodes,
   and be joined by different groups of cluster peers. The locking mechanism does not have this downside.
   Now that RabbitMQ requires Erlang 23.2, the internal locking library becomes an option for peer discovery.

   `cluster_formation.randomized_startup_delay_range.min` and `cluster_formation.randomized_startup_delay_range.max` configuration keys
   will no longer have any effect.

   GitHub issue: [#3075](https://github.com/rabbitmq/rabbitmq-server/pull/3075)


### Federation Plugin

#### Bug Fixes

  * Queue federation will now declare queues on the upstream side only if it does not already
    exist. This makes it possible to federate pre-declared queues of different types.

    Note that such setups should be considered edge cases. Queue federation was never meant
    to federated queues of different types under the same name in different clusters.
    Such setups could be useful in [Blue/Green deployment upgrade](https://www.rabbitmq.com/blue-green-upgrade.html) scenarios but
    otherwise should be avoided.

    GitHub issue: [#3107](https://github.com/rabbitmq/rabbitmq-server/pull/3107)


### AuthN/AuthZ Backend HTTP Plugin

#### Bug Fixes

 * `auth_http.connection_timeout` and `auth_http.request_timeout` are two new configuration parameters that control HTTP client connection
    and overall request timeouts. They both default to 15 seconds. The value can be increased for services that can occasionally slow down
    significantly.

   Contributed by Miłosz @SzumiecM Szumiec.

   GitHub issue: [#3140](https://github.com/rabbitmq/rabbitmq-server/pull/3140)


## Dependency Upgrades

 * `jose` was updated [from `1.11.1` to `2b1d66b5f4`](https://github.com/potatosalad/erlang-jose/commit/2b1d66b5f4fbe33cb198149a8cb23895a2c877ea)
 * `jsx` was updated [from `2.11.0` to `3.1.0`](https://github.com/talentdeficit/jsx/blob/main/CHANGES.md)
 * `observer_cli` was updated [from `1.6.1` to `1.6.2`](https://github.com/zhongwencool/observer_cli/compare/1.6.1..1.6.2)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.8.18.tar.xz`
instead of the source tarball produced by GitHub.
