// Copyright 2022 the V8 project authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is automatically generated by `tools/dev/gen-static-roots.py`. Do
// not edit manually.

#ifndef V8_ROOTS_STATIC_ROOTS_H_
#define V8_ROOTS_STATIC_ROOTS_H_

#include "src/common/globals.h"

#if V8_STATIC_ROOTS_BOOL

#include "src/roots/roots.h"

// Disabling Wasm or Intl invalidates the contents of static-roots.h.
// TODO(olivf): To support static roots for multiple build configurations we
//              will need to generate target specific versions of this file.
static_assert(V8_ENABLE_WEBASSEMBLY);
static_assert(V8_INTL_SUPPORT);

namespace v8 {
namespace internal {

struct StaticReadOnlyRoot {
  static constexpr Tagged_t kUndefinedValue = 0x69;
  static constexpr Tagged_t kNullValue = 0x85;
  static constexpr Tagged_t kempty_string = 0xa1;
  static constexpr Tagged_t kFalseValue = 0xad;
  static constexpr Tagged_t kTrueValue = 0xc9;
  static constexpr Tagged_t kSeqTwoByteStringMap = 0xe5;
  static constexpr Tagged_t kSeqOneByteStringMap = 0x10d;
  static constexpr Tagged_t kConsTwoByteStringMap = 0x135;
  static constexpr Tagged_t kConsOneByteStringMap = 0x15d;
  static constexpr Tagged_t kSlicedTwoByteStringMap = 0x185;
  static constexpr Tagged_t kSlicedOneByteStringMap = 0x1ad;
  static constexpr Tagged_t kExternalTwoByteStringMap = 0x1d5;
  static constexpr Tagged_t kExternalOneByteStringMap = 0x1fd;
  static constexpr Tagged_t kUncachedExternalTwoByteStringMap = 0x225;
  static constexpr Tagged_t kUncachedExternalOneByteStringMap = 0x24d;
  static constexpr Tagged_t kSharedExternalTwoByteStringMap = 0x275;
  static constexpr Tagged_t kSharedExternalOneByteStringMap = 0x29d;
  static constexpr Tagged_t kSharedUncachedExternalTwoByteStringMap = 0x2c5;
  static constexpr Tagged_t kSharedUncachedExternalOneByteStringMap = 0x2ed;
  static constexpr Tagged_t kExternalInternalizedTwoByteStringMap = 0x315;
  static constexpr Tagged_t kExternalInternalizedOneByteStringMap = 0x33d;
  static constexpr Tagged_t kUncachedExternalInternalizedTwoByteStringMap =
      0x365;
  static constexpr Tagged_t kUncachedExternalInternalizedOneByteStringMap =
      0x38d;
  static constexpr Tagged_t kInternalizedTwoByteStringMap = 0x3b5;
  static constexpr Tagged_t kInternalizedOneByteStringMap = 0x3dd;
  static constexpr Tagged_t kThinTwoByteStringMap = 0x405;
  static constexpr Tagged_t kThinOneByteStringMap = 0x42d;
  static constexpr Tagged_t kSharedSeqTwoByteStringMap = 0x455;
  static constexpr Tagged_t kSharedSeqOneByteStringMap = 0x47d;
  static constexpr Tagged_t kSymbolMap = 0x4a5;
  static constexpr Tagged_t kMetaMap = 0x4cd;
  static constexpr Tagged_t kUndefinedMap = 0x4f5;
  static constexpr Tagged_t kNullMap = 0x51d;
  static constexpr Tagged_t kBooleanMap = 0x545;
  static constexpr Tagged_t kFixedArrayMap = 0x56d;
  static constexpr Tagged_t kTrustedFixedArrayMap = 0x595;
  static constexpr Tagged_t kProtectedFixedArrayMap = 0x5bd;
  static constexpr Tagged_t kWeakFixedArrayMap = 0x5e5;
  static constexpr Tagged_t kWeakArrayListMap = 0x60d;
  static constexpr Tagged_t kFixedCOWArrayMap = 0x635;
  static constexpr Tagged_t kDescriptorArrayMap = 0x65d;
  static constexpr Tagged_t kHoleMap = 0x685;
  static constexpr Tagged_t kCallSiteInfoMap = 0x6ad;
  static constexpr Tagged_t kEnumCacheMap = 0x6d5;
  static constexpr Tagged_t kEmptyFixedArray = 0x6fd;
  static constexpr Tagged_t kEmptyWeakFixedArray = 0x705;
  static constexpr Tagged_t kEmptyWeakArrayList = 0x70d;
  static constexpr Tagged_t kTheHoleValue = 0x719;
  static constexpr Tagged_t kEmptyEnumCache = 0x725;
  static constexpr Tagged_t kEmptyDescriptorArray = 0x731;
  static constexpr Tagged_t kScopeInfoMap = 0x741;
  static constexpr Tagged_t kModuleInfoMap = 0x769;
  static constexpr Tagged_t kClosureFeedbackCellArrayMap = 0x791;
  static constexpr Tagged_t kFeedbackVectorMap = 0x7b9;
  static constexpr Tagged_t kHeapNumberMap = 0x7e1;
  static constexpr Tagged_t kBigIntMap = 0x809;
  static constexpr Tagged_t kForeignMap = 0x831;
  static constexpr Tagged_t kMegaDomHandlerMap = 0x859;
  static constexpr Tagged_t kFixedDoubleArrayMap = 0x881;
  static constexpr Tagged_t kFeedbackMetadataArrayMap = 0x8a9;
  static constexpr Tagged_t kByteArrayMap = 0x8d1;
  static constexpr Tagged_t kTrustedByteArrayMap = 0x8f9;
  static constexpr Tagged_t kBytecodeArrayMap = 0x921;
  static constexpr Tagged_t kFreeSpaceMap = 0x949;
  static constexpr Tagged_t kPropertyArrayMap = 0x971;
  static constexpr Tagged_t kSmallOrderedHashMapMap = 0x999;
  static constexpr Tagged_t kSmallOrderedHashSetMap = 0x9c1;
  static constexpr Tagged_t kSmallOrderedNameDictionaryMap = 0x9e9;
  static constexpr Tagged_t kInstructionStreamMap = 0xa11;
  static constexpr Tagged_t kCellMap = 0xa39;
  static constexpr Tagged_t kInvalidPrototypeValidityCell = 0xa61;
  static constexpr Tagged_t kGlobalPropertyCellMap = 0xa69;
  static constexpr Tagged_t kOnePointerFillerMap = 0xa91;
  static constexpr Tagged_t kTwoPointerFillerMap = 0xab9;
  static constexpr Tagged_t kNoClosuresCellMap = 0xae1;
  static constexpr Tagged_t kOneClosureCellMap = 0xb09;
  static constexpr Tagged_t kManyClosuresCellMap = 0xb31;
  static constexpr Tagged_t kTransitionArrayMap = 0xb59;
  static constexpr Tagged_t kHashTableMap = 0xb81;
  static constexpr Tagged_t kOrderedNameDictionaryMap = 0xba9;
  static constexpr Tagged_t kNameDictionaryMap = 0xbd1;
  static constexpr Tagged_t kSwissNameDictionaryMap = 0xbf9;
  static constexpr Tagged_t kGlobalDictionaryMap = 0xc21;
  static constexpr Tagged_t kNumberDictionaryMap = 0xc49;
  static constexpr Tagged_t kRegisteredSymbolTableMap = 0xc71;
  static constexpr Tagged_t kArrayListMap = 0xc99;
  static constexpr Tagged_t kAccessorInfoMap = 0xcc1;
  static constexpr Tagged_t kPreparseDataMap = 0xce9;
  static constexpr Tagged_t kSharedFunctionInfoMap = 0xd11;
  static constexpr Tagged_t kCodeMap = 0xd39;
  static constexpr Tagged_t kHashSeed = 0xd61;
  static constexpr Tagged_t klength_string = 0xd71;
  static constexpr Tagged_t kprototype_string = 0xd85;
  static constexpr Tagged_t kname_string = 0xd9d;
  static constexpr Tagged_t kenumerable_string = 0xdad;
  static constexpr Tagged_t kconfigurable_string = 0xdc5;
  static constexpr Tagged_t kvalue_string = 0xddd;
  static constexpr Tagged_t kwritable_string = 0xdf1;
  static constexpr Tagged_t knot_mapped_symbol = 0xe05;
  static constexpr Tagged_t kuninitialized_symbol = 0xe15;
  static constexpr Tagged_t kmegamorphic_symbol = 0xe25;
  static constexpr Tagged_t kelements_transition_symbol = 0xe35;
  static constexpr Tagged_t kmega_dom_symbol = 0xe45;
  static constexpr Tagged_t kEmptyPropertyDictionary = 0xe55;
  static constexpr Tagged_t kEmptyOrderedPropertyDictionary = 0xe81;
  static constexpr Tagged_t kEmptyByteArray = 0xe99;
  static constexpr Tagged_t kEmptyScopeInfo = 0xea1;
  static constexpr Tagged_t kEmptyPropertyArray = 0xeb1;
  static constexpr Tagged_t kMinusZeroValue = 0xeb9;
  static constexpr Tagged_t kNanValue = 0xec5;
  static constexpr Tagged_t kHoleNanValue = 0xed1;
  static constexpr Tagged_t kInfinityValue = 0xedd;
  static constexpr Tagged_t kMinusInfinityValue = 0xee9;
  static constexpr Tagged_t kMaxSafeInteger = 0xef5;
  static constexpr Tagged_t kMaxUInt32 = 0xf01;
  static constexpr Tagged_t kSmiMinValue = 0xf0d;
  static constexpr Tagged_t kSmiMaxValuePlusOne = 0xf19;
  static constexpr Tagged_t kPromiseFulfillReactionJobTaskMap = 0xf25;
  static constexpr Tagged_t kPromiseRejectReactionJobTaskMap = 0xf4d;
  static constexpr Tagged_t kCallableTaskMap = 0xf75;
  static constexpr Tagged_t kCallbackTaskMap = 0xf9d;
  static constexpr Tagged_t kPromiseResolveThenableJobTaskMap = 0xfc5;
  static constexpr Tagged_t kAccessCheckInfoMap = 0xfed;
  static constexpr Tagged_t kAccessorPairMap = 0x1015;
  static constexpr Tagged_t kAliasedArgumentsEntryMap = 0x103d;
  static constexpr Tagged_t kAllocationMementoMap = 0x1065;
  static constexpr Tagged_t kArrayBoilerplateDescriptionMap = 0x108d;
  static constexpr Tagged_t kAsmWasmDataMap = 0x10b5;
  static constexpr Tagged_t kAsyncGeneratorRequestMap = 0x10dd;
  static constexpr Tagged_t kBreakPointMap = 0x1105;
  static constexpr Tagged_t kBreakPointInfoMap = 0x112d;
  static constexpr Tagged_t kBytecodeWrapperMap = 0x1155;
  static constexpr Tagged_t kClassBoilerplateMap = 0x117d;
  static constexpr Tagged_t kClassPositionsMap = 0x11a5;
  static constexpr Tagged_t kCodeWrapperMap = 0x11cd;
  static constexpr Tagged_t kDebugInfoMap = 0x11f5;
  static constexpr Tagged_t kErrorStackDataMap = 0x121d;
  static constexpr Tagged_t kFunctionTemplateRareDataMap = 0x1245;
  static constexpr Tagged_t kInterceptorInfoMap = 0x126d;
  static constexpr Tagged_t kModuleRequestMap = 0x1295;
  static constexpr Tagged_t kPromiseCapabilityMap = 0x12bd;
  static constexpr Tagged_t kPromiseOnStackMap = 0x12e5;
  static constexpr Tagged_t kPromiseReactionMap = 0x130d;
  static constexpr Tagged_t kPropertyDescriptorObjectMap = 0x1335;
  static constexpr Tagged_t kPrototypeInfoMap = 0x135d;
  static constexpr Tagged_t kRegExpBoilerplateDescriptionMap = 0x1385;
  static constexpr Tagged_t kScriptMap = 0x13ad;
  static constexpr Tagged_t kScriptOrModuleMap = 0x13d5;
  static constexpr Tagged_t kSourceTextModuleInfoEntryMap = 0x13fd;
  static constexpr Tagged_t kStackFrameInfoMap = 0x1425;
  static constexpr Tagged_t kTemplateObjectDescriptionMap = 0x144d;
  static constexpr Tagged_t kTuple2Map = 0x1475;
  static constexpr Tagged_t kWasmExceptionTagMap = 0x149d;
  static constexpr Tagged_t kAllocationSiteWithWeakNextMap = 0x14c5;
  static constexpr Tagged_t kAllocationSiteWithoutWeakNextMap = 0x14ed;
  static constexpr Tagged_t kLoadHandler1Map = 0x1515;
  static constexpr Tagged_t kLoadHandler2Map = 0x153d;
  static constexpr Tagged_t kLoadHandler3Map = 0x1565;
  static constexpr Tagged_t kStoreHandler0Map = 0x158d;
  static constexpr Tagged_t kStoreHandler1Map = 0x15b5;
  static constexpr Tagged_t kStoreHandler2Map = 0x15dd;
  static constexpr Tagged_t kStoreHandler3Map = 0x1605;
  static constexpr Tagged_t kUncompiledDataWithoutPreparseDataMap = 0x162d;
  static constexpr Tagged_t kUncompiledDataWithPreparseDataMap = 0x1655;
  static constexpr Tagged_t kUncompiledDataWithoutPreparseDataWithJobMap =
      0x167d;
  static constexpr Tagged_t kUncompiledDataWithPreparseDataAndJobMap = 0x16a5;
  static constexpr Tagged_t kOnHeapBasicBlockProfilerDataMap = 0x16cd;
  static constexpr Tagged_t kFunctionTemplateInfoMap = 0x16f5;
  static constexpr Tagged_t kObjectTemplateInfoMap = 0x171d;
  static constexpr Tagged_t kTurbofanBitsetTypeMap = 0x1745;
  static constexpr Tagged_t kTurbofanUnionTypeMap = 0x176d;
  static constexpr Tagged_t kTurbofanRangeTypeMap = 0x1795;
  static constexpr Tagged_t kTurbofanHeapConstantTypeMap = 0x17bd;
  static constexpr Tagged_t kTurbofanOtherNumberConstantTypeMap = 0x17e5;
  static constexpr Tagged_t kTurboshaftWord32TypeMap = 0x180d;
  static constexpr Tagged_t kTurboshaftWord32RangeTypeMap = 0x1835;
  static constexpr Tagged_t kTurboshaftWord64TypeMap = 0x185d;
  static constexpr Tagged_t kTurboshaftWord64RangeTypeMap = 0x1885;
  static constexpr Tagged_t kTurboshaftFloat64TypeMap = 0x18ad;
  static constexpr Tagged_t kTurboshaftFloat64RangeTypeMap = 0x18d5;
  static constexpr Tagged_t kInternalClassMap = 0x18fd;
  static constexpr Tagged_t kSmiPairMap = 0x1925;
  static constexpr Tagged_t kSmiBoxMap = 0x194d;
  static constexpr Tagged_t kExportedSubClassBaseMap = 0x1975;
  static constexpr Tagged_t kExportedSubClassMap = 0x199d;
  static constexpr Tagged_t kAbstractInternalClassSubclass1Map = 0x19c5;
  static constexpr Tagged_t kAbstractInternalClassSubclass2Map = 0x19ed;
  static constexpr Tagged_t kExportedSubClass2Map = 0x1a15;
  static constexpr Tagged_t kSortStateMap = 0x1a3d;
  static constexpr Tagged_t kWasmFastApiCallDataMap = 0x1a65;
  static constexpr Tagged_t kWasmStringViewIterMap = 0x1a8d;
  static constexpr Tagged_t kSloppyArgumentsElementsMap = 0x1ab5;
  static constexpr Tagged_t kStrongDescriptorArrayMap = 0x1add;
  static constexpr Tagged_t kTurboshaftWord32SetTypeMap = 0x1b05;
  static constexpr Tagged_t kTurboshaftWord64SetTypeMap = 0x1b2d;
  static constexpr Tagged_t kTurboshaftFloat64SetTypeMap = 0x1b55;
  static constexpr Tagged_t kInternalClassWithStructElementsMap = 0x1b7d;
  static constexpr Tagged_t kOrderedHashMapMap = 0x1ba5;
  static constexpr Tagged_t kOrderedHashSetMap = 0x1bcd;
  static constexpr Tagged_t kSimpleNumberDictionaryMap = 0x1bf5;
  static constexpr Tagged_t kNameToIndexHashTableMap = 0x1c1d;
  static constexpr Tagged_t kEmbedderDataArrayMap = 0x1c45;
  static constexpr Tagged_t kEphemeronHashTableMap = 0x1c6d;
  static constexpr Tagged_t kScriptContextTableMap = 0x1c95;
  static constexpr Tagged_t kObjectBoilerplateDescriptionMap = 0x1cbd;
  static constexpr Tagged_t kCoverageInfoMap = 0x1ce5;
  static constexpr Tagged_t kRegExpMatchInfoMap = 0x1d0d;
  static constexpr Tagged_t kSourceTextModuleMap = 0x1d35;
  static constexpr Tagged_t kSyntheticModuleMap = 0x1d5d;
  static constexpr Tagged_t kGlobalConstTrackingLetCellMap = 0x1d85;
  static constexpr Tagged_t kWasmApiFunctionRefMap = 0x1dad;
  static constexpr Tagged_t kWasmCapiFunctionDataMap = 0x1dd5;
  static constexpr Tagged_t kWasmExportedFunctionDataMap = 0x1dfd;
  static constexpr Tagged_t kWasmInternalFunctionMap = 0x1e25;
  static constexpr Tagged_t kWasmFuncRefMap = 0x1e4d;
  static constexpr Tagged_t kWasmJSFunctionDataMap = 0x1e75;
  static constexpr Tagged_t kWasmResumeDataMap = 0x1e9d;
  static constexpr Tagged_t kWasmTypeInfoMap = 0x1ec5;
  static constexpr Tagged_t kWasmContinuationObjectMap = 0x1eed;
  static constexpr Tagged_t kWasmNullMap = 0x1f15;
  static constexpr Tagged_t kWasmTrustedInstanceDataMap = 0x1f3d;
  static constexpr Tagged_t kWasmDispatchTableMap = 0x1f65;
  static constexpr Tagged_t kWeakCellMap = 0x1f8d;
  static constexpr Tagged_t kExternalPointerArrayMap = 0x1fb5;
  static constexpr Tagged_t kInterpreterDataMap = 0x1fdd;
  static constexpr Tagged_t kDictionaryTemplateInfoMap = 0x2005;
  static constexpr Tagged_t kNoOpInterceptorInfo = 0x202d;
  static constexpr Tagged_t kEmptyArrayList = 0x2055;
  static constexpr Tagged_t kEmptyObjectBoilerplateDescription = 0x2061;
  static constexpr Tagged_t kEmptyArrayBoilerplateDescription = 0x2071;
  static constexpr Tagged_t kEmptyClosureFeedbackCellArray = 0x207d;
  static constexpr Tagged_t kEmptySwissPropertyDictionary = 0x2091;
  static constexpr Tagged_t kSingleCharacterStringTable = 0x20b1;
  static constexpr Tagged_t kdot_string = 0x2799;
  static constexpr Tagged_t kzero_string = 0x27b9;
  static constexpr Tagged_t kone_string = 0x27c9;
  static constexpr Tagged_t kadoptText_string = 0x34b9;
  static constexpr Tagged_t kapproximatelySign_string = 0x34d1;
  static constexpr Tagged_t kbaseName_string = 0x34f1;
  static constexpr Tagged_t kaccounting_string = 0x3505;
  static constexpr Tagged_t kbreakType_string = 0x351d;
  static constexpr Tagged_t kcalendars_string = 0x3535;
  static constexpr Tagged_t kcardinal_string = 0x354d;
  static constexpr Tagged_t kcaseFirst_string = 0x3561;
  static constexpr Tagged_t kceil_string = 0x3579;
  static constexpr Tagged_t kcompare_string = 0x3589;
  static constexpr Tagged_t kcollation_string = 0x359d;
  static constexpr Tagged_t kcollations_string = 0x35b5;
  static constexpr Tagged_t kcompact_string = 0x35cd;
  static constexpr Tagged_t kcompactDisplay_string = 0x35e1;
  static constexpr Tagged_t kcurrency_string = 0x35fd;
  static constexpr Tagged_t kcurrencyDisplay_string = 0x3611;
  static constexpr Tagged_t kcurrencySign_string = 0x362d;
  static constexpr Tagged_t kdateStyle_string = 0x3645;
  static constexpr Tagged_t kdateTimeField_string = 0x365d;
  static constexpr Tagged_t kdayPeriod_string = 0x3679;
  static constexpr Tagged_t kdaysDisplay_string = 0x3691;
  static constexpr Tagged_t kdecimal_string = 0x36a9;
  static constexpr Tagged_t kdialect_string = 0x36bd;
  static constexpr Tagged_t kdigital_string = 0x36d1;
  static constexpr Tagged_t kdirection_string = 0x36e5;
  static constexpr Tagged_t kendRange_string = 0x36fd;
  static constexpr Tagged_t kengineering_string = 0x3711;
  static constexpr Tagged_t kexceptZero_string = 0x3729;
  static constexpr Tagged_t kexpand_string = 0x3741;
  static constexpr Tagged_t kexponentInteger_string = 0x3755;
  static constexpr Tagged_t kexponentMinusSign_string = 0x3771;
  static constexpr Tagged_t kexponentSeparator_string = 0x3791;
  static constexpr Tagged_t kfallback_string = 0x37b1;
  static constexpr Tagged_t kfirst_string = 0x37c5;
  static constexpr Tagged_t kfirstDay_string = 0x37d9;
  static constexpr Tagged_t kfloor_string = 0x37ed;
  static constexpr Tagged_t kformat_string = 0x3801;
  static constexpr Tagged_t kfraction_string = 0x3815;
  static constexpr Tagged_t kfractionalDigits_string = 0x3829;
  static constexpr Tagged_t kfractionalSecond_string = 0x3845;
  static constexpr Tagged_t kfull_string = 0x3861;
  static constexpr Tagged_t kgranularity_string = 0x3871;
  static constexpr Tagged_t kgrapheme_string = 0x3889;
  static constexpr Tagged_t kgroup_string = 0x389d;
  static constexpr Tagged_t kh11_string = 0x38b1;
  static constexpr Tagged_t kh12_string = 0x38c1;
  static constexpr Tagged_t kh23_string = 0x38d1;
  static constexpr Tagged_t kh24_string = 0x38e1;
  static constexpr Tagged_t khalfCeil_string = 0x38f1;
  static constexpr Tagged_t khalfEven_string = 0x3905;
  static constexpr Tagged_t khalfExpand_string = 0x3919;
  static constexpr Tagged_t khalfFloor_string = 0x3931;
  static constexpr Tagged_t khalfTrunc_string = 0x3949;
  static constexpr Tagged_t khour12_string = 0x3961;
  static constexpr Tagged_t khourCycle_string = 0x3975;
  static constexpr Tagged_t khourCycles_string = 0x398d;
  static constexpr Tagged_t khoursDisplay_string = 0x39a5;
  static constexpr Tagged_t kideo_string = 0x39bd;
  static constexpr Tagged_t kignorePunctuation_string = 0x39cd;
  static constexpr Tagged_t kInvalid_Date_string = 0x39ed;
  static constexpr Tagged_t kinteger_string = 0x3a05;
  static constexpr Tagged_t kisWordLike_string = 0x3a19;
  static constexpr Tagged_t kkana_string = 0x3a31;
  static constexpr Tagged_t klanguage_string = 0x3a41;
  static constexpr Tagged_t klanguageDisplay_string = 0x3a55;
  static constexpr Tagged_t klessPrecision_string = 0x3a71;
  static constexpr Tagged_t kletter_string = 0x3a8d;
  static constexpr Tagged_t klist_string = 0x3aa1;
  static constexpr Tagged_t kliteral_string = 0x3ab1;
  static constexpr Tagged_t klocale_string = 0x3ac5;
  static constexpr Tagged_t kloose_string = 0x3ad9;
  static constexpr Tagged_t klower_string = 0x3aed;
  static constexpr Tagged_t kltr_string = 0x3b01;
  static constexpr Tagged_t kmaximumFractionDigits_string = 0x3b11;
  static constexpr Tagged_t kmaximumSignificantDigits_string = 0x3b35;
  static constexpr Tagged_t kmicrosecondsDisplay_string = 0x3b59;
  static constexpr Tagged_t kmillisecondsDisplay_string = 0x3b79;
  static constexpr Tagged_t kmin2_string = 0x3b99;
  static constexpr Tagged_t kminimalDays_string = 0x3ba9;
  static constexpr Tagged_t kminimumFractionDigits_string = 0x3bc1;
  static constexpr Tagged_t kminimumIntegerDigits_string = 0x3be5;
  static constexpr Tagged_t kminimumSignificantDigits_string = 0x3c05;
  static constexpr Tagged_t kminus_0 = 0x3c29;
  static constexpr Tagged_t kminusSign_string = 0x3c39;
  static constexpr Tagged_t kminutesDisplay_string = 0x3c51;
  static constexpr Tagged_t kmonthsDisplay_string = 0x3c6d;
  static constexpr Tagged_t kmorePrecision_string = 0x3c89;
  static constexpr Tagged_t knan_string = 0x3ca5;
  static constexpr Tagged_t knanosecondsDisplay_string = 0x3cb5;
  static constexpr Tagged_t knarrowSymbol_string = 0x3cd5;
  static constexpr Tagged_t knegative_string = 0x3ced;
  static constexpr Tagged_t knever_string = 0x3d01;
  static constexpr Tagged_t knone_string = 0x3d15;
  static constexpr Tagged_t knotation_string = 0x3d25;
  static constexpr Tagged_t knormal_string = 0x3d39;
  static constexpr Tagged_t knumberingSystem_string = 0x3d4d;
  static constexpr Tagged_t knumberingSystems_string = 0x3d69;
  static constexpr Tagged_t knumeric_string = 0x3d85;
  static constexpr Tagged_t kordinal_string = 0x3d99;
  static constexpr Tagged_t kpercentSign_string = 0x3dad;
  static constexpr Tagged_t kplusSign_string = 0x3dc5;
  static constexpr Tagged_t kquarter_string = 0x3dd9;
  static constexpr Tagged_t kregion_string = 0x3ded;
  static constexpr Tagged_t krelatedYear_string = 0x3e01;
  static constexpr Tagged_t kroundingMode_string = 0x3e19;
  static constexpr Tagged_t kroundingPriority_string = 0x3e31;
  static constexpr Tagged_t krtl_string = 0x3e4d;
  static constexpr Tagged_t kscientific_string = 0x3e5d;
  static constexpr Tagged_t ksecondsDisplay_string = 0x3e75;
  static constexpr Tagged_t ksegment_string = 0x3e91;
  static constexpr Tagged_t kSegmentIterator_string = 0x3ea5;
  static constexpr Tagged_t kSegments_string = 0x3ec1;
  static constexpr Tagged_t ksensitivity_string = 0x3ed5;
  static constexpr Tagged_t ksep_string = 0x3eed;
  static constexpr Tagged_t kshared_string = 0x3efd;
  static constexpr Tagged_t ksignDisplay_string = 0x3f11;
  static constexpr Tagged_t kstandard_string = 0x3f29;
  static constexpr Tagged_t kstartRange_string = 0x3f3d;
  static constexpr Tagged_t kstrict_string = 0x3f55;
  static constexpr Tagged_t kstripIfInteger_string = 0x3f69;
  static constexpr Tagged_t kstyle_string = 0x3f85;
  static constexpr Tagged_t kterm_string = 0x3f99;
  static constexpr Tagged_t ktextInfo_string = 0x3fa9;
  static constexpr Tagged_t ktimeStyle_string = 0x3fbd;
  static constexpr Tagged_t ktimeZones_string = 0x3fd5;
  static constexpr Tagged_t ktimeZoneName_string = 0x3fed;
  static constexpr Tagged_t ktrailingZeroDisplay_string = 0x4005;
  static constexpr Tagged_t ktrunc_string = 0x4025;
  static constexpr Tagged_t ktwo_digit_string = 0x4039;
  static constexpr Tagged_t ktype_string = 0x404d;
  static constexpr Tagged_t kunknown_string = 0x405d;
  static constexpr Tagged_t kupper_string = 0x4071;
  static constexpr Tagged_t kusage_string = 0x4085;
  static constexpr Tagged_t kuseGrouping_string = 0x4099;
  static constexpr Tagged_t kunitDisplay_string = 0x40b1;
  static constexpr Tagged_t kweekday_string = 0x40c9;
  static constexpr Tagged_t kweekend_string = 0x40dd;
  static constexpr Tagged_t kweeksDisplay_string = 0x40f1;
  static constexpr Tagged_t kweekInfo_string = 0x4109;
  static constexpr Tagged_t kyearName_string = 0x411d;
  static constexpr Tagged_t kyearsDisplay_string = 0x4131;
  static constexpr Tagged_t kadd_string = 0x4149;
  static constexpr Tagged_t kAggregateError_string = 0x4159;
  static constexpr Tagged_t kalways_string = 0x4175;
  static constexpr Tagged_t kanonymous_function_string = 0x4189;
  static constexpr Tagged_t kanonymous_string = 0x41a9;
  static constexpr Tagged_t kapply_string = 0x41c1;
  static constexpr Tagged_t kArguments_string = 0x41d5;
  static constexpr Tagged_t karguments_string = 0x41ed;
  static constexpr Tagged_t karguments_to_string = 0x4205;
  static constexpr Tagged_t kArray_string = 0x4225;
  static constexpr Tagged_t karray_to_string = 0x4239;
  static constexpr Tagged_t kArrayBuffer_string = 0x4255;
  static constexpr Tagged_t kArrayIterator_string = 0x426d;
  static constexpr Tagged_t kas_string = 0x4289;
  static constexpr Tagged_t kassert_string = 0x4299;
  static constexpr Tagged_t kasync_string = 0x42ad;
  static constexpr Tagged_t kAtomicsCondition_string = 0x42c1;
  static constexpr Tagged_t kAtomicsMutex_string = 0x42e1;
  static constexpr Tagged_t kauto_string = 0x42fd;
  static constexpr Tagged_t kawait_string = 0x430d;
  static constexpr Tagged_t kBigInt_string = 0x4321;
  static constexpr Tagged_t kbigint_string = 0x4335;
  static constexpr Tagged_t kBigInt64Array_string = 0x4349;
  static constexpr Tagged_t kBigUint64Array_string = 0x4365;
  static constexpr Tagged_t kbind_string = 0x4381;
  static constexpr Tagged_t kblank_string = 0x4391;
  static constexpr Tagged_t kBoolean_string = 0x43a5;
  static constexpr Tagged_t kboolean_string = 0x43b9;
  static constexpr Tagged_t kboolean_to_string = 0x43cd;
  static constexpr Tagged_t kbound__string = 0x43e9;
  static constexpr Tagged_t kbuffer_string = 0x43fd;
  static constexpr Tagged_t kbyte_length_string = 0x4411;
  static constexpr Tagged_t kbyte_offset_string = 0x4429;
  static constexpr Tagged_t kCompileError_string = 0x4441;
  static constexpr Tagged_t kcalendar_string = 0x4459;
  static constexpr Tagged_t kcallee_string = 0x446d;
  static constexpr Tagged_t kcaller_string = 0x4481;
  static constexpr Tagged_t kcause_string = 0x4495;
  static constexpr Tagged_t kcharacter_string = 0x44a9;
  static constexpr Tagged_t kcode_string = 0x44c1;
  static constexpr Tagged_t kcolumn_string = 0x44d1;
  static constexpr Tagged_t kcomputed_string = 0x44e5;
  static constexpr Tagged_t kconjunction_string = 0x44fd;
  static constexpr Tagged_t kconsole_string = 0x4515;
  static constexpr Tagged_t kconstrain_string = 0x4529;
  static constexpr Tagged_t kconstruct_string = 0x4541;
  static constexpr Tagged_t kcurrent_string = 0x4559;
  static constexpr Tagged_t kDate_string = 0x456d;
  static constexpr Tagged_t kdate_to_string = 0x457d;
  static constexpr Tagged_t kdateAdd_string = 0x4599;
  static constexpr Tagged_t kdateFromFields_string = 0x45ad;
  static constexpr Tagged_t kdateUntil_string = 0x45c9;
  static constexpr Tagged_t kday_string = 0x45e1;
  static constexpr Tagged_t kdayOfWeek_string = 0x45f1;
  static constexpr Tagged_t kdayOfYear_string = 0x4609;
  static constexpr Tagged_t kdays_string = 0x4621;
  static constexpr Tagged_t kdaysInMonth_string = 0x4631;
  static constexpr Tagged_t kdaysInWeek_string = 0x4649;
  static constexpr Tagged_t kdaysInYear_string = 0x4661;
  static constexpr Tagged_t kdefault_string = 0x4679;
  static constexpr Tagged_t kdefineProperty_string = 0x468d;
  static constexpr Tagged_t kdeleteProperty_string = 0x46a9;
  static constexpr Tagged_t kdetached_string = 0x46c5;
  static constexpr Tagged_t kdisjunction_string = 0x46d9;
  static constexpr Tagged_t kdone_string = 0x46f1;
  static constexpr Tagged_t kdot_brand_string = 0x4701;
  static constexpr Tagged_t kdot_catch_string = 0x4715;
  static constexpr Tagged_t kdot_default_string = 0x4729;
  static constexpr Tagged_t kdot_for_string = 0x473d;
  static constexpr Tagged_t kdot_generator_object_string = 0x474d;
  static constexpr Tagged_t kdot_home_object_string = 0x476d;
  static constexpr Tagged_t kdot_new_target_string = 0x4785;
  static constexpr Tagged_t knew_target_string = 0x4785;
  static constexpr Tagged_t kdot_result_string = 0x479d;
  static constexpr Tagged_t kdot_repl_result_string = 0x47b1;
  static constexpr Tagged_t kdot_static_home_object_string = 0x47c9;
  static constexpr Tagged_t kdot_switch_tag_string = 0x47e9;
  static constexpr Tagged_t kdotAll_string = 0x4801;
  static constexpr Tagged_t kError_string = 0x4815;
  static constexpr Tagged_t kEvalError_string = 0x4829;
  static constexpr Tagged_t kelement_string = 0x4841;
  static constexpr Tagged_t kepochMicroseconds_string = 0x4855;
  static constexpr Tagged_t kepochMilliseconds_string = 0x4875;
  static constexpr Tagged_t kepochNanoseconds_string = 0x4895;
  static constexpr Tagged_t kepochSeconds_string = 0x48b1;
  static constexpr Tagged_t kera_string = 0x48c9;
  static constexpr Tagged_t keraYear_string = 0x48d9;
  static constexpr Tagged_t kerror_string = 0x48ed;
  static constexpr Tagged_t kerrors_string = 0x4901;
  static constexpr Tagged_t kerror_to_string = 0x4915;
  static constexpr Tagged_t keval_string = 0x4931;
  static constexpr Tagged_t kexception_string = 0x4941;
  static constexpr Tagged_t kexec_string = 0x4959;
  static constexpr Tagged_t kfalse_string = 0x4969;
  static constexpr Tagged_t kfields_string = 0x497d;
  static constexpr Tagged_t kFinalizationRegistry_string = 0x4991;
  static constexpr Tagged_t kflags_string = 0x49b1;
  static constexpr Tagged_t kFloat16Array_string = 0x49c5;
  static constexpr Tagged_t kFloat32Array_string = 0x49dd;
  static constexpr Tagged_t kFloat64Array_string = 0x49f5;
  static constexpr Tagged_t kfractionalSecondDigits_string = 0x4a0d;
  static constexpr Tagged_t kfrom_string = 0x4a31;
  static constexpr Tagged_t kFunction_string = 0x4a41;
  static constexpr Tagged_t kfunction_native_code_string = 0x4a55;
  static constexpr Tagged_t kfunction_string = 0x4a81;
  static constexpr Tagged_t kfunction_to_string = 0x4a95;
  static constexpr Tagged_t kGenerator_string = 0x4ab5;
  static constexpr Tagged_t kget_space_string = 0x4acd;
  static constexpr Tagged_t kget_string = 0x4add;
  static constexpr Tagged_t kgetOffsetNanosecondsFor_string = 0x4aed;
  static constexpr Tagged_t kgetOwnPropertyDescriptor_string = 0x4b11;
  static constexpr Tagged_t kgetPossibleInstantsFor_string = 0x4b35;
  static constexpr Tagged_t kgetPrototypeOf_string = 0x4b59;
  static constexpr Tagged_t kglobal_string = 0x4b75;
  static constexpr Tagged_t kglobalThis_string = 0x4b89;
  static constexpr Tagged_t kgroups_string = 0x4ba1;
  static constexpr Tagged_t kgrowable_string = 0x4bb5;
  static constexpr Tagged_t khas_string = 0x4bc9;
  static constexpr Tagged_t khasIndices_string = 0x4bd9;
  static constexpr Tagged_t khour_string = 0x4bf1;
  static constexpr Tagged_t khours_string = 0x4c01;
  static constexpr Tagged_t khoursInDay_string = 0x4c15;
  static constexpr Tagged_t kignoreCase_string = 0x4c2d;
  static constexpr Tagged_t kid_string = 0x4c45;
  static constexpr Tagged_t killegal_access_string = 0x4c55;
  static constexpr Tagged_t killegal_argument_string = 0x4c71;
  static constexpr Tagged_t kinLeapYear_string = 0x4c8d;
  static constexpr Tagged_t kindex_string = 0x4ca5;
  static constexpr Tagged_t kindices_string = 0x4cb9;
  static constexpr Tagged_t kInfinity_string = 0x4ccd;
  static constexpr Tagged_t kinfinity_string = 0x4ce1;
  static constexpr Tagged_t kinput_string = 0x4cf5;
  static constexpr Tagged_t kinstance_members_initializer_string = 0x4d09;
  static constexpr Tagged_t kInt16Array_string = 0x4d35;
  static constexpr Tagged_t kInt32Array_string = 0x4d4d;
  static constexpr Tagged_t kInt8Array_string = 0x4d65;
  static constexpr Tagged_t kisExtensible_string = 0x4d7d;
  static constexpr Tagged_t kiso8601_string = 0x4d95;
  static constexpr Tagged_t kisoDay_string = 0x4da9;
  static constexpr Tagged_t kisoHour_string = 0x4dbd;
  static constexpr Tagged_t kisoMicrosecond_string = 0x4dd1;
  static constexpr Tagged_t kisoMillisecond_string = 0x4ded;
  static constexpr Tagged_t kisoMinute_string = 0x4e09;
  static constexpr Tagged_t kisoMonth_string = 0x4e21;
  static constexpr Tagged_t kisoNanosecond_string = 0x4e35;
  static constexpr Tagged_t kisoSecond_string = 0x4e51;
  static constexpr Tagged_t kisoYear_string = 0x4e69;
  static constexpr Tagged_t kIterator_string = 0x4e7d;
  static constexpr Tagged_t kjsMemoryEstimate_string = 0x4e91;
  static constexpr Tagged_t kjsMemoryRange_string = 0x4ead;
  static constexpr Tagged_t kkeys_string = 0x4ec9;
  static constexpr Tagged_t klargestUnit_string = 0x4ed9;
  static constexpr Tagged_t klastIndex_string = 0x4ef1;
  static constexpr Tagged_t klet_string = 0x4f09;
  static constexpr Tagged_t kline_string = 0x4f19;
  static constexpr Tagged_t klinear_string = 0x4f29;
  static constexpr Tagged_t kLinkError_string = 0x4f3d;
  static constexpr Tagged_t klong_string = 0x4f55;
  static constexpr Tagged_t kMap_string = 0x4f65;
  static constexpr Tagged_t kMapIterator_string = 0x4f75;
  static constexpr Tagged_t kmax_byte_length_string = 0x4f8d;
  static constexpr Tagged_t kmedium_string = 0x4fa9;
  static constexpr Tagged_t kmergeFields_string = 0x4fbd;
  static constexpr Tagged_t kmessage_string = 0x4fd5;
  static constexpr Tagged_t kmeta_string = 0x4fe9;
  static constexpr Tagged_t kminus_Infinity_string = 0x4ff9;
  static constexpr Tagged_t kmicrosecond_string = 0x5011;
  static constexpr Tagged_t kmicroseconds_string = 0x5029;
  static constexpr Tagged_t kmillisecond_string = 0x5041;
  static constexpr Tagged_t kmilliseconds_string = 0x5059;
  static constexpr Tagged_t kminute_string = 0x5071;
  static constexpr Tagged_t kminutes_string = 0x5085;
  static constexpr Tagged_t kModule_string = 0x5099;
  static constexpr Tagged_t kmonth_string = 0x50ad;
  static constexpr Tagged_t kmonthDayFromFields_string = 0x50c1;
  static constexpr Tagged_t kmonths_string = 0x50e1;
  static constexpr Tagged_t kmonthsInYear_string = 0x50f5;
  static constexpr Tagged_t kmonthCode_string = 0x510d;
  static constexpr Tagged_t kmultiline_string = 0x5125;
  static constexpr Tagged_t kNaN_string = 0x513d;
  static constexpr Tagged_t knanosecond_string = 0x514d;
  static constexpr Tagged_t knanoseconds_string = 0x5165;
  static constexpr Tagged_t knarrow_string = 0x517d;
  static constexpr Tagged_t knative_string = 0x5191;
  static constexpr Tagged_t kNFC_string = 0x51a5;
  static constexpr Tagged_t kNFD_string = 0x51b5;
  static constexpr Tagged_t kNFKC_string = 0x51c5;
  static constexpr Tagged_t kNFKD_string = 0x51d5;
  static constexpr Tagged_t knot_equal_string = 0x51e5;
  static constexpr Tagged_t knull_string = 0x51fd;
  static constexpr Tagged_t knull_to_string = 0x520d;
  static constexpr Tagged_t kNumber_string = 0x5229;
  static constexpr Tagged_t knumber_string = 0x523d;
  static constexpr Tagged_t knumber_to_string = 0x5251;
  static constexpr Tagged_t kObject_string = 0x526d;
  static constexpr Tagged_t kobject_string = 0x5281;
  static constexpr Tagged_t kobject_to_string = 0x5295;
  static constexpr Tagged_t kObject_prototype_string = 0x52b1;
  static constexpr Tagged_t kof_string = 0x52cd;
  static constexpr Tagged_t koffset_string = 0x52dd;
  static constexpr Tagged_t koffsetNanoseconds_string = 0x52f1;
  static constexpr Tagged_t kok_string = 0x5311;
  static constexpr Tagged_t kother_string = 0x5321;
  static constexpr Tagged_t koverflow_string = 0x5335;
  static constexpr Tagged_t kownKeys_string = 0x5349;
  static constexpr Tagged_t kpercent_string = 0x535d;
  static constexpr Tagged_t kplainDate_string = 0x5371;
  static constexpr Tagged_t kplainTime_string = 0x5389;
  static constexpr Tagged_t kposition_string = 0x53a1;
  static constexpr Tagged_t kpreventExtensions_string = 0x53b5;
  static constexpr Tagged_t kprivate_constructor_string = 0x53d5;
  static constexpr Tagged_t kPromise_string = 0x53ed;
  static constexpr Tagged_t kpromise_string = 0x5401;
  static constexpr Tagged_t kproto_string = 0x5415;
  static constexpr Tagged_t kproxy_string = 0x542d;
  static constexpr Tagged_t kProxy_string = 0x5441;
  static constexpr Tagged_t kquery_colon_string = 0x5455;
  static constexpr Tagged_t kRangeError_string = 0x5465;
  static constexpr Tagged_t kraw_json_string = 0x547d;
  static constexpr Tagged_t kraw_string = 0x5491;
  static constexpr Tagged_t kReferenceError_string = 0x54a1;
  static constexpr Tagged_t kReflectGet_string = 0x54bd;
  static constexpr Tagged_t kReflectHas_string = 0x54d5;
  static constexpr Tagged_t kRegExp_string = 0x54ed;
  static constexpr Tagged_t kregexp_to_string = 0x5501;
  static constexpr Tagged_t kreject_string = 0x551d;
  static constexpr Tagged_t krelativeTo_string = 0x5531;
  static constexpr Tagged_t kresizable_string = 0x5549;
  static constexpr Tagged_t kResizableArrayBuffer_string = 0x5561;
  static constexpr Tagged_t kreturn_string = 0x5581;
  static constexpr Tagged_t krevoke_string = 0x5595;
  static constexpr Tagged_t kroundingIncrement_string = 0x55a9;
  static constexpr Tagged_t kRuntimeError_string = 0x55c9;
  static constexpr Tagged_t kWebAssemblyException_string = 0x55e1;
  static constexpr Tagged_t kScript_string = 0x5605;
  static constexpr Tagged_t kscript_string = 0x5619;
  static constexpr Tagged_t ksecond_string = 0x562d;
  static constexpr Tagged_t kseconds_string = 0x5641;
  static constexpr Tagged_t kshort_string = 0x5655;
  static constexpr Tagged_t kSet_string = 0x5669;
  static constexpr Tagged_t ksentence_string = 0x5679;
  static constexpr Tagged_t kset_space_string = 0x568d;
  static constexpr Tagged_t kset_string = 0x569d;
  static constexpr Tagged_t kSetIterator_string = 0x56ad;
  static constexpr Tagged_t ksetPrototypeOf_string = 0x56c5;
  static constexpr Tagged_t kShadowRealm_string = 0x56e1;
  static constexpr Tagged_t kSharedArray_string = 0x56f9;
  static constexpr Tagged_t kSharedArrayBuffer_string = 0x5711;
  static constexpr Tagged_t kSharedStruct_string = 0x5731;
  static constexpr Tagged_t ksign_string = 0x5749;
  static constexpr Tagged_t ksize_string = 0x5759;
  static constexpr Tagged_t ksmallestUnit_string = 0x5769;
  static constexpr Tagged_t ksource_string = 0x5781;
  static constexpr Tagged_t ksourceText_string = 0x5795;
  static constexpr Tagged_t kstack_string = 0x57ad;
  static constexpr Tagged_t kstackTraceLimit_string = 0x57c1;
  static constexpr Tagged_t kstatic_initializer_string = 0x57dd;
  static constexpr Tagged_t ksticky_string = 0x57fd;
  static constexpr Tagged_t kString_string = 0x5811;
  static constexpr Tagged_t kstring_string = 0x5825;
  static constexpr Tagged_t kstring_to_string = 0x5839;
  static constexpr Tagged_t ksuppressed_string = 0x5855;
  static constexpr Tagged_t kSuppressedError_string = 0x586d;
  static constexpr Tagged_t kSymbol_iterator_string = 0x5889;
  static constexpr Tagged_t kSymbol_match_all_string = 0x58a5;
  static constexpr Tagged_t kSymbol_replace_string = 0x58c1;
  static constexpr Tagged_t ksymbol_species_string = 0x58dd;
  static constexpr Tagged_t kSymbol_species_string = 0x58f9;
  static constexpr Tagged_t kSymbol_split_string = 0x5915;
  static constexpr Tagged_t kSymbol_string = 0x592d;
  static constexpr Tagged_t ksymbol_string = 0x5941;
  static constexpr Tagged_t kSyntaxError_string = 0x5955;
  static constexpr Tagged_t ktarget_string = 0x596d;
  static constexpr Tagged_t kthis_function_string = 0x5981;
  static constexpr Tagged_t kthis_string = 0x599d;
  static constexpr Tagged_t kthrow_string = 0x59ad;
  static constexpr Tagged_t ktimed_out_string = 0x59c1;
  static constexpr Tagged_t ktimeZone_string = 0x59d9;
  static constexpr Tagged_t ktoJSON_string = 0x59ed;
  static constexpr Tagged_t ktoString_string = 0x5a01;
  static constexpr Tagged_t ktrue_string = 0x5a15;
  static constexpr Tagged_t ktotal_string = 0x5a25;
  static constexpr Tagged_t kTypeError_string = 0x5a39;
  static constexpr Tagged_t kUint16Array_string = 0x5a51;
  static constexpr Tagged_t kUint32Array_string = 0x5a69;
  static constexpr Tagged_t kUint8Array_string = 0x5a81;
  static constexpr Tagged_t kUint8ClampedArray_string = 0x5a99;
  static constexpr Tagged_t kundefined_string = 0x5ab9;
  static constexpr Tagged_t kundefined_to_string = 0x5ad1;
  static constexpr Tagged_t kunicode_string = 0x5af1;
  static constexpr Tagged_t kunicodeSets_string = 0x5b05;
  static constexpr Tagged_t kunit_string = 0x5b1d;
  static constexpr Tagged_t kURIError_string = 0x5b2d;
  static constexpr Tagged_t kUTC_string = 0x5b41;
  static constexpr Tagged_t kWeakMap_string = 0x5b51;
  static constexpr Tagged_t kWeakRef_string = 0x5b65;
  static constexpr Tagged_t kWeakSet_string = 0x5b79;
  static constexpr Tagged_t kweek_string = 0x5b8d;
  static constexpr Tagged_t kweeks_string = 0x5b9d;
  static constexpr Tagged_t kweekOfYear_string = 0x5bb1;
  static constexpr Tagged_t kwith_string = 0x5bc9;
  static constexpr Tagged_t kword_string = 0x5bd9;
  static constexpr Tagged_t kyearMonthFromFields_string = 0x5be9;
  static constexpr Tagged_t kyear_string = 0x5c09;
  static constexpr Tagged_t kyears_string = 0x5c19;
  static constexpr Tagged_t kPropertyCellHoleValue = 0x5c2d;
  static constexpr Tagged_t kHashTableHoleValue = 0x5c39;
  static constexpr Tagged_t kPromiseHoleValue = 0x5c45;
  static constexpr Tagged_t kUninitializedValue = 0x5c51;
  static constexpr Tagged_t kArgumentsMarker = 0x5c5d;
  static constexpr Tagged_t kTerminationException = 0x5c69;
  static constexpr Tagged_t kException = 0x5c75;
  static constexpr Tagged_t kOptimizedOut = 0x5c81;
  static constexpr Tagged_t kStaleRegister = 0x5c8d;
  static constexpr Tagged_t kSelfReferenceMarker = 0x5c99;
  static constexpr Tagged_t kBasicBlockCountersMarker = 0x5ca5;
  static constexpr Tagged_t karray_buffer_wasm_memory_symbol = 0x5cb1;
  static constexpr Tagged_t kcall_site_info_symbol = 0x5cc1;
  static constexpr Tagged_t kconsole_context_id_symbol = 0x5cd1;
  static constexpr Tagged_t kconsole_context_name_symbol = 0x5ce1;
  static constexpr Tagged_t kclass_fields_symbol = 0x5cf1;
  static constexpr Tagged_t kclass_positions_symbol = 0x5d01;
  static constexpr Tagged_t kerror_end_pos_symbol = 0x5d11;
  static constexpr Tagged_t kerror_script_symbol = 0x5d21;
  static constexpr Tagged_t kerror_stack_symbol = 0x5d31;
  static constexpr Tagged_t kerror_start_pos_symbol = 0x5d41;
  static constexpr Tagged_t kfrozen_symbol = 0x5d51;
  static constexpr Tagged_t kinterpreter_trampoline_symbol = 0x5d61;
  static constexpr Tagged_t knative_context_index_symbol = 0x5d71;
  static constexpr Tagged_t knonextensible_symbol = 0x5d81;
  static constexpr Tagged_t kpromise_debug_message_symbol = 0x5d91;
  static constexpr Tagged_t kpromise_forwarding_handler_symbol = 0x5da1;
  static constexpr Tagged_t kpromise_handled_by_symbol = 0x5db1;
  static constexpr Tagged_t kpromise_awaited_by_symbol = 0x5dc1;
  static constexpr Tagged_t kregexp_result_names_symbol = 0x5dd1;
  static constexpr Tagged_t kregexp_result_regexp_input_symbol = 0x5de1;
  static constexpr Tagged_t kregexp_result_regexp_last_index_symbol = 0x5df1;
  static constexpr Tagged_t ksealed_symbol = 0x5e01;
  static constexpr Tagged_t kshared_struct_map_elements_template_symbol =
      0x5e11;
  static constexpr Tagged_t kshared_struct_map_registry_key_symbol = 0x5e21;
  static constexpr Tagged_t kstrict_function_transition_symbol = 0x5e31;
  static constexpr Tagged_t ktemplate_literal_function_literal_id_symbol =
      0x5e41;
  static constexpr Tagged_t ktemplate_literal_slot_id_symbol = 0x5e51;
  static constexpr Tagged_t kwasm_exception_tag_symbol = 0x5e61;
  static constexpr Tagged_t kwasm_exception_values_symbol = 0x5e71;
  static constexpr Tagged_t kwasm_uncatchable_symbol = 0x5e81;
  static constexpr Tagged_t kwasm_wrapped_object_symbol = 0x5e91;
  static constexpr Tagged_t kwasm_debug_proxy_cache_symbol = 0x5ea1;
  static constexpr Tagged_t kwasm_debug_proxy_names_symbol = 0x5eb1;
  static constexpr Tagged_t kasync_iterator_symbol = 0x5ec1;
  static constexpr Tagged_t kintl_fallback_symbol = 0x5ef1;
  static constexpr Tagged_t kmatch_symbol = 0x5f29;
  static constexpr Tagged_t ksearch_symbol = 0x5f51;
  static constexpr Tagged_t kunscopables_symbol = 0x5f7d;
  static constexpr Tagged_t khas_instance_symbol = 0x5fad;
  static constexpr Tagged_t kto_string_tag_symbol = 0x5fdd;
  static constexpr Tagged_t kconstructor_string = 0x6055;
  static constexpr Tagged_t knext_string = 0x606d;
  static constexpr Tagged_t kresolve_string = 0x607d;
  static constexpr Tagged_t kthen_string = 0x6091;
  static constexpr Tagged_t kvalueOf_string = 0x60a1;
  static constexpr Tagged_t kiterator_symbol = 0x60b5;
  static constexpr Tagged_t kmatch_all_symbol = 0x60c5;
  static constexpr Tagged_t kreplace_symbol = 0x60d5;
  static constexpr Tagged_t kspecies_symbol = 0x60e5;
  static constexpr Tagged_t ksplit_symbol = 0x60f5;
  static constexpr Tagged_t kto_primitive_symbol = 0x6105;
  static constexpr Tagged_t kis_concat_spreadable_symbol = 0x6115;
  static constexpr Tagged_t kEmptySlowElementDictionary = 0x6125;
  static constexpr Tagged_t kEmptySymbolTable = 0x6149;
  static constexpr Tagged_t kEmptyOrderedHashMap = 0x6165;
  static constexpr Tagged_t kEmptyOrderedHashSet = 0x6179;
  static constexpr Tagged_t kEmptyFeedbackMetadata = 0x618d;
  static constexpr Tagged_t kGlobalThisBindingScopeInfo = 0x6199;
  static constexpr Tagged_t kEmptyFunctionScopeInfo = 0x61b9;
  static constexpr Tagged_t kNativeScopeInfo = 0x61dd;
  static constexpr Tagged_t kShadowRealmScopeInfo = 0x61f5;
  static constexpr Tagged_t kEmptyExternalPointerArray = 0x620d;
  static constexpr Tagged_t kWasmNullPadding = 0x6215;
  static constexpr Tagged_t kWasmNull = 0xfffd;
  static constexpr Tagged_t kJSSharedArrayMap = 0x20001;
  static constexpr Tagged_t kJSAtomicsMutexMap = 0x20045;
  static constexpr Tagged_t kJSAtomicsConditionMap = 0x2006d;
};

static constexpr std::array<Tagged_t, 760> StaticReadOnlyRootsPointerTable = {
    StaticReadOnlyRoot::kFreeSpaceMap,
    StaticReadOnlyRoot::kOnePointerFillerMap,
    StaticReadOnlyRoot::kTwoPointerFillerMap,
    StaticReadOnlyRoot::kUninitializedValue,
    StaticReadOnlyRoot::kUndefinedValue,
    StaticReadOnlyRoot::kTheHoleValue,
    StaticReadOnlyRoot::kNullValue,
    StaticReadOnlyRoot::kTrueValue,
    StaticReadOnlyRoot::kFalseValue,
    StaticReadOnlyRoot::kempty_string,
    StaticReadOnlyRoot::kMetaMap,
    StaticReadOnlyRoot::kByteArrayMap,
    StaticReadOnlyRoot::kFixedArrayMap,
    StaticReadOnlyRoot::kFixedCOWArrayMap,
    StaticReadOnlyRoot::kFixedDoubleArrayMap,
    StaticReadOnlyRoot::kHashTableMap,
    StaticReadOnlyRoot::kSymbolMap,
    StaticReadOnlyRoot::kSeqOneByteStringMap,
    StaticReadOnlyRoot::kInternalizedOneByteStringMap,
    StaticReadOnlyRoot::kScopeInfoMap,
    StaticReadOnlyRoot::kSharedFunctionInfoMap,
    StaticReadOnlyRoot::kInstructionStreamMap,
    StaticReadOnlyRoot::kCellMap,
    StaticReadOnlyRoot::kGlobalPropertyCellMap,
    StaticReadOnlyRoot::kForeignMap,
    StaticReadOnlyRoot::kHeapNumberMap,
    StaticReadOnlyRoot::kTransitionArrayMap,
    StaticReadOnlyRoot::kFeedbackVectorMap,
    StaticReadOnlyRoot::kEmptyScopeInfo,
    StaticReadOnlyRoot::kEmptyFixedArray,
    StaticReadOnlyRoot::kEmptyDescriptorArray,
    StaticReadOnlyRoot::kArgumentsMarker,
    StaticReadOnlyRoot::kException,
    StaticReadOnlyRoot::kTerminationException,
    StaticReadOnlyRoot::kOptimizedOut,
    StaticReadOnlyRoot::kStaleRegister,
    StaticReadOnlyRoot::kPropertyCellHoleValue,
    StaticReadOnlyRoot::kHashTableHoleValue,
    StaticReadOnlyRoot::kPromiseHoleValue,
    StaticReadOnlyRoot::kScriptContextTableMap,
    StaticReadOnlyRoot::kClosureFeedbackCellArrayMap,
    StaticReadOnlyRoot::kFeedbackMetadataArrayMap,
    StaticReadOnlyRoot::kArrayListMap,
    StaticReadOnlyRoot::kBigIntMap,
    StaticReadOnlyRoot::kObjectBoilerplateDescriptionMap,
    StaticReadOnlyRoot::kBytecodeArrayMap,
    StaticReadOnlyRoot::kCodeMap,
    StaticReadOnlyRoot::kCoverageInfoMap,
    StaticReadOnlyRoot::kDictionaryTemplateInfoMap,
    StaticReadOnlyRoot::kGlobalDictionaryMap,
    StaticReadOnlyRoot::kGlobalConstTrackingLetCellMap,
    StaticReadOnlyRoot::kManyClosuresCellMap,
    StaticReadOnlyRoot::kMegaDomHandlerMap,
    StaticReadOnlyRoot::kModuleInfoMap,
    StaticReadOnlyRoot::kNameDictionaryMap,
    StaticReadOnlyRoot::kNoClosuresCellMap,
    StaticReadOnlyRoot::kNumberDictionaryMap,
    StaticReadOnlyRoot::kOneClosureCellMap,
    StaticReadOnlyRoot::kOrderedHashMapMap,
    StaticReadOnlyRoot::kOrderedHashSetMap,
    StaticReadOnlyRoot::kNameToIndexHashTableMap,
    StaticReadOnlyRoot::kRegisteredSymbolTableMap,
    StaticReadOnlyRoot::kOrderedNameDictionaryMap,
    StaticReadOnlyRoot::kPreparseDataMap,
    StaticReadOnlyRoot::kPropertyArrayMap,
    StaticReadOnlyRoot::kAccessorInfoMap,
    StaticReadOnlyRoot::kRegExpMatchInfoMap,
    StaticReadOnlyRoot::kSimpleNumberDictionaryMap,
    StaticReadOnlyRoot::kSmallOrderedHashMapMap,
    StaticReadOnlyRoot::kSmallOrderedHashSetMap,
    StaticReadOnlyRoot::kSmallOrderedNameDictionaryMap,
    StaticReadOnlyRoot::kSourceTextModuleMap,
    StaticReadOnlyRoot::kSwissNameDictionaryMap,
    StaticReadOnlyRoot::kSyntheticModuleMap,
    StaticReadOnlyRoot::kWasmApiFunctionRefMap,
    StaticReadOnlyRoot::kWasmCapiFunctionDataMap,
    StaticReadOnlyRoot::kWasmContinuationObjectMap,
    StaticReadOnlyRoot::kWasmDispatchTableMap,
    StaticReadOnlyRoot::kWasmExportedFunctionDataMap,
    StaticReadOnlyRoot::kWasmInternalFunctionMap,
    StaticReadOnlyRoot::kWasmFuncRefMap,
    StaticReadOnlyRoot::kWasmJSFunctionDataMap,
    StaticReadOnlyRoot::kWasmNullMap,
    StaticReadOnlyRoot::kWasmResumeDataMap,
    StaticReadOnlyRoot::kWasmTrustedInstanceDataMap,
    StaticReadOnlyRoot::kWasmTypeInfoMap,
    StaticReadOnlyRoot::kWeakFixedArrayMap,
    StaticReadOnlyRoot::kWeakArrayListMap,
    StaticReadOnlyRoot::kEphemeronHashTableMap,
    StaticReadOnlyRoot::kEmbedderDataArrayMap,
    StaticReadOnlyRoot::kWeakCellMap,
    StaticReadOnlyRoot::kExternalPointerArrayMap,
    StaticReadOnlyRoot::kTrustedFixedArrayMap,
    StaticReadOnlyRoot::kTrustedByteArrayMap,
    StaticReadOnlyRoot::kProtectedFixedArrayMap,
    StaticReadOnlyRoot::kInterpreterDataMap,
    StaticReadOnlyRoot::kSeqTwoByteStringMap,
    StaticReadOnlyRoot::kConsTwoByteStringMap,
    StaticReadOnlyRoot::kConsOneByteStringMap,
    StaticReadOnlyRoot::kThinTwoByteStringMap,
    StaticReadOnlyRoot::kThinOneByteStringMap,
    StaticReadOnlyRoot::kSlicedTwoByteStringMap,
    StaticReadOnlyRoot::kSlicedOneByteStringMap,
    StaticReadOnlyRoot::kExternalTwoByteStringMap,
    StaticReadOnlyRoot::kExternalOneByteStringMap,
    StaticReadOnlyRoot::kInternalizedTwoByteStringMap,
    StaticReadOnlyRoot::kExternalInternalizedTwoByteStringMap,
    StaticReadOnlyRoot::kExternalInternalizedOneByteStringMap,
    StaticReadOnlyRoot::kUncachedExternalInternalizedTwoByteStringMap,
    StaticReadOnlyRoot::kUncachedExternalInternalizedOneByteStringMap,
    StaticReadOnlyRoot::kUncachedExternalTwoByteStringMap,
    StaticReadOnlyRoot::kUncachedExternalOneByteStringMap,
    StaticReadOnlyRoot::kSharedSeqOneByteStringMap,
    StaticReadOnlyRoot::kSharedSeqTwoByteStringMap,
    StaticReadOnlyRoot::kSharedExternalOneByteStringMap,
    StaticReadOnlyRoot::kSharedExternalTwoByteStringMap,
    StaticReadOnlyRoot::kSharedUncachedExternalOneByteStringMap,
    StaticReadOnlyRoot::kSharedUncachedExternalTwoByteStringMap,
    StaticReadOnlyRoot::kUndefinedMap,
    StaticReadOnlyRoot::kNullMap,
    StaticReadOnlyRoot::kBooleanMap,
    StaticReadOnlyRoot::kHoleMap,
    StaticReadOnlyRoot::kJSSharedArrayMap,
    StaticReadOnlyRoot::kJSAtomicsMutexMap,
    StaticReadOnlyRoot::kJSAtomicsConditionMap,
    StaticReadOnlyRoot::kEmptyEnumCache,
    StaticReadOnlyRoot::kEmptyPropertyArray,
    StaticReadOnlyRoot::kEmptyByteArray,
    StaticReadOnlyRoot::kEmptyExternalPointerArray,
    StaticReadOnlyRoot::kEmptyObjectBoilerplateDescription,
    StaticReadOnlyRoot::kEmptyArrayBoilerplateDescription,
    StaticReadOnlyRoot::kEmptyClosureFeedbackCellArray,
    StaticReadOnlyRoot::kEmptySlowElementDictionary,
    StaticReadOnlyRoot::kEmptyOrderedHashMap,
    StaticReadOnlyRoot::kEmptyOrderedHashSet,
    StaticReadOnlyRoot::kEmptyFeedbackMetadata,
    StaticReadOnlyRoot::kEmptyPropertyDictionary,
    StaticReadOnlyRoot::kEmptyOrderedPropertyDictionary,
    StaticReadOnlyRoot::kEmptySwissPropertyDictionary,
    StaticReadOnlyRoot::kNoOpInterceptorInfo,
    StaticReadOnlyRoot::kEmptyArrayList,
    StaticReadOnlyRoot::kEmptyWeakFixedArray,
    StaticReadOnlyRoot::kEmptyWeakArrayList,
    StaticReadOnlyRoot::kInvalidPrototypeValidityCell,
    StaticReadOnlyRoot::kNanValue,
    StaticReadOnlyRoot::kHoleNanValue,
    StaticReadOnlyRoot::kInfinityValue,
    StaticReadOnlyRoot::kMinusZeroValue,
    StaticReadOnlyRoot::kMinusInfinityValue,
    StaticReadOnlyRoot::kMaxSafeInteger,
    StaticReadOnlyRoot::kMaxUInt32,
    StaticReadOnlyRoot::kSmiMinValue,
    StaticReadOnlyRoot::kSmiMaxValuePlusOne,
    StaticReadOnlyRoot::kSingleCharacterStringTable,
    StaticReadOnlyRoot::kSelfReferenceMarker,
    StaticReadOnlyRoot::kBasicBlockCountersMarker,
    StaticReadOnlyRoot::kGlobalThisBindingScopeInfo,
    StaticReadOnlyRoot::kEmptyFunctionScopeInfo,
    StaticReadOnlyRoot::kNativeScopeInfo,
    StaticReadOnlyRoot::kShadowRealmScopeInfo,
    StaticReadOnlyRoot::kEmptySymbolTable,
    StaticReadOnlyRoot::kHashSeed,
    StaticReadOnlyRoot::kWasmNullPadding,
    StaticReadOnlyRoot::kWasmNull,
    StaticReadOnlyRoot::klength_string,
    StaticReadOnlyRoot::kprototype_string,
    StaticReadOnlyRoot::kname_string,
    StaticReadOnlyRoot::kenumerable_string,
    StaticReadOnlyRoot::kconfigurable_string,
    StaticReadOnlyRoot::kvalue_string,
    StaticReadOnlyRoot::kwritable_string,
    StaticReadOnlyRoot::kadoptText_string,
    StaticReadOnlyRoot::kapproximatelySign_string,
    StaticReadOnlyRoot::kbaseName_string,
    StaticReadOnlyRoot::kaccounting_string,
    StaticReadOnlyRoot::kbreakType_string,
    StaticReadOnlyRoot::kcalendars_string,
    StaticReadOnlyRoot::kcardinal_string,
    StaticReadOnlyRoot::kcaseFirst_string,
    StaticReadOnlyRoot::kceil_string,
    StaticReadOnlyRoot::kcompare_string,
    StaticReadOnlyRoot::kcollation_string,
    StaticReadOnlyRoot::kcollations_string,
    StaticReadOnlyRoot::kcompact_string,
    StaticReadOnlyRoot::kcompactDisplay_string,
    StaticReadOnlyRoot::kcurrency_string,
    StaticReadOnlyRoot::kcurrencyDisplay_string,
    StaticReadOnlyRoot::kcurrencySign_string,
    StaticReadOnlyRoot::kdateStyle_string,
    StaticReadOnlyRoot::kdateTimeField_string,
    StaticReadOnlyRoot::kdayPeriod_string,
    StaticReadOnlyRoot::kdaysDisplay_string,
    StaticReadOnlyRoot::kdecimal_string,
    StaticReadOnlyRoot::kdialect_string,
    StaticReadOnlyRoot::kdigital_string,
    StaticReadOnlyRoot::kdirection_string,
    StaticReadOnlyRoot::kendRange_string,
    StaticReadOnlyRoot::kengineering_string,
    StaticReadOnlyRoot::kexceptZero_string,
    StaticReadOnlyRoot::kexpand_string,
    StaticReadOnlyRoot::kexponentInteger_string,
    StaticReadOnlyRoot::kexponentMinusSign_string,
    StaticReadOnlyRoot::kexponentSeparator_string,
    StaticReadOnlyRoot::kfallback_string,
    StaticReadOnlyRoot::kfirst_string,
    StaticReadOnlyRoot::kfirstDay_string,
    StaticReadOnlyRoot::kfloor_string,
    StaticReadOnlyRoot::kformat_string,
    StaticReadOnlyRoot::kfraction_string,
    StaticReadOnlyRoot::kfractionalDigits_string,
    StaticReadOnlyRoot::kfractionalSecond_string,
    StaticReadOnlyRoot::kfull_string,
    StaticReadOnlyRoot::kgranularity_string,
    StaticReadOnlyRoot::kgrapheme_string,
    StaticReadOnlyRoot::kgroup_string,
    StaticReadOnlyRoot::kh11_string,
    StaticReadOnlyRoot::kh12_string,
    StaticReadOnlyRoot::kh23_string,
    StaticReadOnlyRoot::kh24_string,
    StaticReadOnlyRoot::khalfCeil_string,
    StaticReadOnlyRoot::khalfEven_string,
    StaticReadOnlyRoot::khalfExpand_string,
    StaticReadOnlyRoot::khalfFloor_string,
    StaticReadOnlyRoot::khalfTrunc_string,
    StaticReadOnlyRoot::khour12_string,
    StaticReadOnlyRoot::khourCycle_string,
    StaticReadOnlyRoot::khourCycles_string,
    StaticReadOnlyRoot::khoursDisplay_string,
    StaticReadOnlyRoot::kideo_string,
    StaticReadOnlyRoot::kignorePunctuation_string,
    StaticReadOnlyRoot::kInvalid_Date_string,
    StaticReadOnlyRoot::kinteger_string,
    StaticReadOnlyRoot::kisWordLike_string,
    StaticReadOnlyRoot::kkana_string,
    StaticReadOnlyRoot::klanguage_string,
    StaticReadOnlyRoot::klanguageDisplay_string,
    StaticReadOnlyRoot::klessPrecision_string,
    StaticReadOnlyRoot::kletter_string,
    StaticReadOnlyRoot::klist_string,
    StaticReadOnlyRoot::kliteral_string,
    StaticReadOnlyRoot::klocale_string,
    StaticReadOnlyRoot::kloose_string,
    StaticReadOnlyRoot::klower_string,
    StaticReadOnlyRoot::kltr_string,
    StaticReadOnlyRoot::kmaximumFractionDigits_string,
    StaticReadOnlyRoot::kmaximumSignificantDigits_string,
    StaticReadOnlyRoot::kmicrosecondsDisplay_string,
    StaticReadOnlyRoot::kmillisecondsDisplay_string,
    StaticReadOnlyRoot::kmin2_string,
    StaticReadOnlyRoot::kminimalDays_string,
    StaticReadOnlyRoot::kminimumFractionDigits_string,
    StaticReadOnlyRoot::kminimumIntegerDigits_string,
    StaticReadOnlyRoot::kminimumSignificantDigits_string,
    StaticReadOnlyRoot::kminus_0,
    StaticReadOnlyRoot::kminusSign_string,
    StaticReadOnlyRoot::kminutesDisplay_string,
    StaticReadOnlyRoot::kmonthsDisplay_string,
    StaticReadOnlyRoot::kmorePrecision_string,
    StaticReadOnlyRoot::knan_string,
    StaticReadOnlyRoot::knanosecondsDisplay_string,
    StaticReadOnlyRoot::knarrowSymbol_string,
    StaticReadOnlyRoot::knegative_string,
    StaticReadOnlyRoot::knever_string,
    StaticReadOnlyRoot::knone_string,
    StaticReadOnlyRoot::knotation_string,
    StaticReadOnlyRoot::knormal_string,
    StaticReadOnlyRoot::knumberingSystem_string,
    StaticReadOnlyRoot::knumberingSystems_string,
    StaticReadOnlyRoot::knumeric_string,
    StaticReadOnlyRoot::kordinal_string,
    StaticReadOnlyRoot::kpercentSign_string,
    StaticReadOnlyRoot::kplusSign_string,
    StaticReadOnlyRoot::kquarter_string,
    StaticReadOnlyRoot::kregion_string,
    StaticReadOnlyRoot::krelatedYear_string,
    StaticReadOnlyRoot::kroundingMode_string,
    StaticReadOnlyRoot::kroundingPriority_string,
    StaticReadOnlyRoot::krtl_string,
    StaticReadOnlyRoot::kscientific_string,
    StaticReadOnlyRoot::ksecondsDisplay_string,
    StaticReadOnlyRoot::ksegment_string,
    StaticReadOnlyRoot::kSegmentIterator_string,
    StaticReadOnlyRoot::kSegments_string,
    StaticReadOnlyRoot::ksensitivity_string,
    StaticReadOnlyRoot::ksep_string,
    StaticReadOnlyRoot::kshared_string,
    StaticReadOnlyRoot::ksignDisplay_string,
    StaticReadOnlyRoot::kstandard_string,
    StaticReadOnlyRoot::kstartRange_string,
    StaticReadOnlyRoot::kstrict_string,
    StaticReadOnlyRoot::kstripIfInteger_string,
    StaticReadOnlyRoot::kstyle_string,
    StaticReadOnlyRoot::kterm_string,
    StaticReadOnlyRoot::ktextInfo_string,
    StaticReadOnlyRoot::ktimeStyle_string,
    StaticReadOnlyRoot::ktimeZones_string,
    StaticReadOnlyRoot::ktimeZoneName_string,
    StaticReadOnlyRoot::ktrailingZeroDisplay_string,
    StaticReadOnlyRoot::ktrunc_string,
    StaticReadOnlyRoot::ktwo_digit_string,
    StaticReadOnlyRoot::ktype_string,
    StaticReadOnlyRoot::kunknown_string,
    StaticReadOnlyRoot::kupper_string,
    StaticReadOnlyRoot::kusage_string,
    StaticReadOnlyRoot::kuseGrouping_string,
    StaticReadOnlyRoot::kunitDisplay_string,
    StaticReadOnlyRoot::kweekday_string,
    StaticReadOnlyRoot::kweekend_string,
    StaticReadOnlyRoot::kweeksDisplay_string,
    StaticReadOnlyRoot::kweekInfo_string,
    StaticReadOnlyRoot::kyearName_string,
    StaticReadOnlyRoot::kyearsDisplay_string,
    StaticReadOnlyRoot::kadd_string,
    StaticReadOnlyRoot::kAggregateError_string,
    StaticReadOnlyRoot::kalways_string,
    StaticReadOnlyRoot::kanonymous_function_string,
    StaticReadOnlyRoot::kanonymous_string,
    StaticReadOnlyRoot::kapply_string,
    StaticReadOnlyRoot::kArguments_string,
    StaticReadOnlyRoot::karguments_string,
    StaticReadOnlyRoot::karguments_to_string,
    StaticReadOnlyRoot::kArray_string,
    StaticReadOnlyRoot::karray_to_string,
    StaticReadOnlyRoot::kArrayBuffer_string,
    StaticReadOnlyRoot::kArrayIterator_string,
    StaticReadOnlyRoot::kas_string,
    StaticReadOnlyRoot::kassert_string,
    StaticReadOnlyRoot::kasync_string,
    StaticReadOnlyRoot::kAtomicsCondition_string,
    StaticReadOnlyRoot::kAtomicsMutex_string,
    StaticReadOnlyRoot::kauto_string,
    StaticReadOnlyRoot::kawait_string,
    StaticReadOnlyRoot::kBigInt_string,
    StaticReadOnlyRoot::kbigint_string,
    StaticReadOnlyRoot::kBigInt64Array_string,
    StaticReadOnlyRoot::kBigUint64Array_string,
    StaticReadOnlyRoot::kbind_string,
    StaticReadOnlyRoot::kblank_string,
    StaticReadOnlyRoot::kBoolean_string,
    StaticReadOnlyRoot::kboolean_string,
    StaticReadOnlyRoot::kboolean_to_string,
    StaticReadOnlyRoot::kbound__string,
    StaticReadOnlyRoot::kbuffer_string,
    StaticReadOnlyRoot::kbyte_length_string,
    StaticReadOnlyRoot::kbyte_offset_string,
    StaticReadOnlyRoot::kCompileError_string,
    StaticReadOnlyRoot::kcalendar_string,
    StaticReadOnlyRoot::kcallee_string,
    StaticReadOnlyRoot::kcaller_string,
    StaticReadOnlyRoot::kcause_string,
    StaticReadOnlyRoot::kcharacter_string,
    StaticReadOnlyRoot::kcode_string,
    StaticReadOnlyRoot::kcolumn_string,
    StaticReadOnlyRoot::kcomputed_string,
    StaticReadOnlyRoot::kconjunction_string,
    StaticReadOnlyRoot::kconsole_string,
    StaticReadOnlyRoot::kconstrain_string,
    StaticReadOnlyRoot::kconstruct_string,
    StaticReadOnlyRoot::kcurrent_string,
    StaticReadOnlyRoot::kDate_string,
    StaticReadOnlyRoot::kdate_to_string,
    StaticReadOnlyRoot::kdateAdd_string,
    StaticReadOnlyRoot::kdateFromFields_string,
    StaticReadOnlyRoot::kdateUntil_string,
    StaticReadOnlyRoot::kday_string,
    StaticReadOnlyRoot::kdayOfWeek_string,
    StaticReadOnlyRoot::kdayOfYear_string,
    StaticReadOnlyRoot::kdays_string,
    StaticReadOnlyRoot::kdaysInMonth_string,
    StaticReadOnlyRoot::kdaysInWeek_string,
    StaticReadOnlyRoot::kdaysInYear_string,
    StaticReadOnlyRoot::kdefault_string,
    StaticReadOnlyRoot::kdefineProperty_string,
    StaticReadOnlyRoot::kdeleteProperty_string,
    StaticReadOnlyRoot::kdetached_string,
    StaticReadOnlyRoot::kdisjunction_string,
    StaticReadOnlyRoot::kdone_string,
    StaticReadOnlyRoot::kdot_brand_string,
    StaticReadOnlyRoot::kdot_catch_string,
    StaticReadOnlyRoot::kdot_default_string,
    StaticReadOnlyRoot::kdot_for_string,
    StaticReadOnlyRoot::kdot_generator_object_string,
    StaticReadOnlyRoot::kdot_home_object_string,
    StaticReadOnlyRoot::kdot_new_target_string,
    StaticReadOnlyRoot::kdot_result_string,
    StaticReadOnlyRoot::kdot_repl_result_string,
    StaticReadOnlyRoot::kdot_static_home_object_string,
    StaticReadOnlyRoot::kdot_string,
    StaticReadOnlyRoot::kdot_switch_tag_string,
    StaticReadOnlyRoot::kdotAll_string,
    StaticReadOnlyRoot::kError_string,
    StaticReadOnlyRoot::kEvalError_string,
    StaticReadOnlyRoot::kelement_string,
    StaticReadOnlyRoot::kepochMicroseconds_string,
    StaticReadOnlyRoot::kepochMilliseconds_string,
    StaticReadOnlyRoot::kepochNanoseconds_string,
    StaticReadOnlyRoot::kepochSeconds_string,
    StaticReadOnlyRoot::kera_string,
    StaticReadOnlyRoot::keraYear_string,
    StaticReadOnlyRoot::kerror_string,
    StaticReadOnlyRoot::kerrors_string,
    StaticReadOnlyRoot::kerror_to_string,
    StaticReadOnlyRoot::keval_string,
    StaticReadOnlyRoot::kexception_string,
    StaticReadOnlyRoot::kexec_string,
    StaticReadOnlyRoot::kfalse_string,
    StaticReadOnlyRoot::kfields_string,
    StaticReadOnlyRoot::kFinalizationRegistry_string,
    StaticReadOnlyRoot::kflags_string,
    StaticReadOnlyRoot::kFloat16Array_string,
    StaticReadOnlyRoot::kFloat32Array_string,
    StaticReadOnlyRoot::kFloat64Array_string,
    StaticReadOnlyRoot::kfractionalSecondDigits_string,
    StaticReadOnlyRoot::kfrom_string,
    StaticReadOnlyRoot::kFunction_string,
    StaticReadOnlyRoot::kfunction_native_code_string,
    StaticReadOnlyRoot::kfunction_string,
    StaticReadOnlyRoot::kfunction_to_string,
    StaticReadOnlyRoot::kGenerator_string,
    StaticReadOnlyRoot::kget_space_string,
    StaticReadOnlyRoot::kget_string,
    StaticReadOnlyRoot::kgetOffsetNanosecondsFor_string,
    StaticReadOnlyRoot::kgetOwnPropertyDescriptor_string,
    StaticReadOnlyRoot::kgetPossibleInstantsFor_string,
    StaticReadOnlyRoot::kgetPrototypeOf_string,
    StaticReadOnlyRoot::kglobal_string,
    StaticReadOnlyRoot::kglobalThis_string,
    StaticReadOnlyRoot::kgroups_string,
    StaticReadOnlyRoot::kgrowable_string,
    StaticReadOnlyRoot::khas_string,
    StaticReadOnlyRoot::khasIndices_string,
    StaticReadOnlyRoot::khour_string,
    StaticReadOnlyRoot::khours_string,
    StaticReadOnlyRoot::khoursInDay_string,
    StaticReadOnlyRoot::kignoreCase_string,
    StaticReadOnlyRoot::kid_string,
    StaticReadOnlyRoot::killegal_access_string,
    StaticReadOnlyRoot::killegal_argument_string,
    StaticReadOnlyRoot::kinLeapYear_string,
    StaticReadOnlyRoot::kindex_string,
    StaticReadOnlyRoot::kindices_string,
    StaticReadOnlyRoot::kInfinity_string,
    StaticReadOnlyRoot::kinfinity_string,
    StaticReadOnlyRoot::kinput_string,
    StaticReadOnlyRoot::kinstance_members_initializer_string,
    StaticReadOnlyRoot::kInt16Array_string,
    StaticReadOnlyRoot::kInt32Array_string,
    StaticReadOnlyRoot::kInt8Array_string,
    StaticReadOnlyRoot::kisExtensible_string,
    StaticReadOnlyRoot::kiso8601_string,
    StaticReadOnlyRoot::kisoDay_string,
    StaticReadOnlyRoot::kisoHour_string,
    StaticReadOnlyRoot::kisoMicrosecond_string,
    StaticReadOnlyRoot::kisoMillisecond_string,
    StaticReadOnlyRoot::kisoMinute_string,
    StaticReadOnlyRoot::kisoMonth_string,
    StaticReadOnlyRoot::kisoNanosecond_string,
    StaticReadOnlyRoot::kisoSecond_string,
    StaticReadOnlyRoot::kisoYear_string,
    StaticReadOnlyRoot::kIterator_string,
    StaticReadOnlyRoot::kjsMemoryEstimate_string,
    StaticReadOnlyRoot::kjsMemoryRange_string,
    StaticReadOnlyRoot::kkeys_string,
    StaticReadOnlyRoot::klargestUnit_string,
    StaticReadOnlyRoot::klastIndex_string,
    StaticReadOnlyRoot::klet_string,
    StaticReadOnlyRoot::kline_string,
    StaticReadOnlyRoot::klinear_string,
    StaticReadOnlyRoot::kLinkError_string,
    StaticReadOnlyRoot::klong_string,
    StaticReadOnlyRoot::kMap_string,
    StaticReadOnlyRoot::kMapIterator_string,
    StaticReadOnlyRoot::kmax_byte_length_string,
    StaticReadOnlyRoot::kmedium_string,
    StaticReadOnlyRoot::kmergeFields_string,
    StaticReadOnlyRoot::kmessage_string,
    StaticReadOnlyRoot::kmeta_string,
    StaticReadOnlyRoot::kminus_Infinity_string,
    StaticReadOnlyRoot::kmicrosecond_string,
    StaticReadOnlyRoot::kmicroseconds_string,
    StaticReadOnlyRoot::kmillisecond_string,
    StaticReadOnlyRoot::kmilliseconds_string,
    StaticReadOnlyRoot::kminute_string,
    StaticReadOnlyRoot::kminutes_string,
    StaticReadOnlyRoot::kModule_string,
    StaticReadOnlyRoot::kmonth_string,
    StaticReadOnlyRoot::kmonthDayFromFields_string,
    StaticReadOnlyRoot::kmonths_string,
    StaticReadOnlyRoot::kmonthsInYear_string,
    StaticReadOnlyRoot::kmonthCode_string,
    StaticReadOnlyRoot::kmultiline_string,
    StaticReadOnlyRoot::kNaN_string,
    StaticReadOnlyRoot::knanosecond_string,
    StaticReadOnlyRoot::knanoseconds_string,
    StaticReadOnlyRoot::knarrow_string,
    StaticReadOnlyRoot::knative_string,
    StaticReadOnlyRoot::knew_target_string,
    StaticReadOnlyRoot::kNFC_string,
    StaticReadOnlyRoot::kNFD_string,
    StaticReadOnlyRoot::kNFKC_string,
    StaticReadOnlyRoot::kNFKD_string,
    StaticReadOnlyRoot::knot_equal_string,
    StaticReadOnlyRoot::knull_string,
    StaticReadOnlyRoot::knull_to_string,
    StaticReadOnlyRoot::kNumber_string,
    StaticReadOnlyRoot::knumber_string,
    StaticReadOnlyRoot::knumber_to_string,
    StaticReadOnlyRoot::kObject_string,
    StaticReadOnlyRoot::kobject_string,
    StaticReadOnlyRoot::kobject_to_string,
    StaticReadOnlyRoot::kObject_prototype_string,
    StaticReadOnlyRoot::kof_string,
    StaticReadOnlyRoot::koffset_string,
    StaticReadOnlyRoot::koffsetNanoseconds_string,
    StaticReadOnlyRoot::kok_string,
    StaticReadOnlyRoot::kone_string,
    StaticReadOnlyRoot::kother_string,
    StaticReadOnlyRoot::koverflow_string,
    StaticReadOnlyRoot::kownKeys_string,
    StaticReadOnlyRoot::kpercent_string,
    StaticReadOnlyRoot::kplainDate_string,
    StaticReadOnlyRoot::kplainTime_string,
    StaticReadOnlyRoot::kposition_string,
    StaticReadOnlyRoot::kpreventExtensions_string,
    StaticReadOnlyRoot::kprivate_constructor_string,
    StaticReadOnlyRoot::kPromise_string,
    StaticReadOnlyRoot::kpromise_string,
    StaticReadOnlyRoot::kproto_string,
    StaticReadOnlyRoot::kproxy_string,
    StaticReadOnlyRoot::kProxy_string,
    StaticReadOnlyRoot::kquery_colon_string,
    StaticReadOnlyRoot::kRangeError_string,
    StaticReadOnlyRoot::kraw_json_string,
    StaticReadOnlyRoot::kraw_string,
    StaticReadOnlyRoot::kReferenceError_string,
    StaticReadOnlyRoot::kReflectGet_string,
    StaticReadOnlyRoot::kReflectHas_string,
    StaticReadOnlyRoot::kRegExp_string,
    StaticReadOnlyRoot::kregexp_to_string,
    StaticReadOnlyRoot::kreject_string,
    StaticReadOnlyRoot::krelativeTo_string,
    StaticReadOnlyRoot::kresizable_string,
    StaticReadOnlyRoot::kResizableArrayBuffer_string,
    StaticReadOnlyRoot::kreturn_string,
    StaticReadOnlyRoot::krevoke_string,
    StaticReadOnlyRoot::kroundingIncrement_string,
    StaticReadOnlyRoot::kRuntimeError_string,
    StaticReadOnlyRoot::kWebAssemblyException_string,
    StaticReadOnlyRoot::kScript_string,
    StaticReadOnlyRoot::kscript_string,
    StaticReadOnlyRoot::ksecond_string,
    StaticReadOnlyRoot::kseconds_string,
    StaticReadOnlyRoot::kshort_string,
    StaticReadOnlyRoot::kSet_string,
    StaticReadOnlyRoot::ksentence_string,
    StaticReadOnlyRoot::kset_space_string,
    StaticReadOnlyRoot::kset_string,
    StaticReadOnlyRoot::kSetIterator_string,
    StaticReadOnlyRoot::ksetPrototypeOf_string,
    StaticReadOnlyRoot::kShadowRealm_string,
    StaticReadOnlyRoot::kSharedArray_string,
    StaticReadOnlyRoot::kSharedArrayBuffer_string,
    StaticReadOnlyRoot::kSharedStruct_string,
    StaticReadOnlyRoot::ksign_string,
    StaticReadOnlyRoot::ksize_string,
    StaticReadOnlyRoot::ksmallestUnit_string,
    StaticReadOnlyRoot::ksource_string,
    StaticReadOnlyRoot::ksourceText_string,
    StaticReadOnlyRoot::kstack_string,
    StaticReadOnlyRoot::kstackTraceLimit_string,
    StaticReadOnlyRoot::kstatic_initializer_string,
    StaticReadOnlyRoot::ksticky_string,
    StaticReadOnlyRoot::kString_string,
    StaticReadOnlyRoot::kstring_string,
    StaticReadOnlyRoot::kstring_to_string,
    StaticReadOnlyRoot::ksuppressed_string,
    StaticReadOnlyRoot::kSuppressedError_string,
    StaticReadOnlyRoot::kSymbol_iterator_string,
    StaticReadOnlyRoot::kSymbol_match_all_string,
    StaticReadOnlyRoot::kSymbol_replace_string,
    StaticReadOnlyRoot::ksymbol_species_string,
    StaticReadOnlyRoot::kSymbol_species_string,
    StaticReadOnlyRoot::kSymbol_split_string,
    StaticReadOnlyRoot::kSymbol_string,
    StaticReadOnlyRoot::ksymbol_string,
    StaticReadOnlyRoot::kSyntaxError_string,
    StaticReadOnlyRoot::ktarget_string,
    StaticReadOnlyRoot::kthis_function_string,
    StaticReadOnlyRoot::kthis_string,
    StaticReadOnlyRoot::kthrow_string,
    StaticReadOnlyRoot::ktimed_out_string,
    StaticReadOnlyRoot::ktimeZone_string,
    StaticReadOnlyRoot::ktoJSON_string,
    StaticReadOnlyRoot::ktoString_string,
    StaticReadOnlyRoot::ktrue_string,
    StaticReadOnlyRoot::ktotal_string,
    StaticReadOnlyRoot::kTypeError_string,
    StaticReadOnlyRoot::kUint16Array_string,
    StaticReadOnlyRoot::kUint32Array_string,
    StaticReadOnlyRoot::kUint8Array_string,
    StaticReadOnlyRoot::kUint8ClampedArray_string,
    StaticReadOnlyRoot::kundefined_string,
    StaticReadOnlyRoot::kundefined_to_string,
    StaticReadOnlyRoot::kunicode_string,
    StaticReadOnlyRoot::kunicodeSets_string,
    StaticReadOnlyRoot::kunit_string,
    StaticReadOnlyRoot::kURIError_string,
    StaticReadOnlyRoot::kUTC_string,
    StaticReadOnlyRoot::kWeakMap_string,
    StaticReadOnlyRoot::kWeakRef_string,
    StaticReadOnlyRoot::kWeakSet_string,
    StaticReadOnlyRoot::kweek_string,
    StaticReadOnlyRoot::kweeks_string,
    StaticReadOnlyRoot::kweekOfYear_string,
    StaticReadOnlyRoot::kwith_string,
    StaticReadOnlyRoot::kword_string,
    StaticReadOnlyRoot::kyearMonthFromFields_string,
    StaticReadOnlyRoot::kyear_string,
    StaticReadOnlyRoot::kyears_string,
    StaticReadOnlyRoot::kzero_string,
    StaticReadOnlyRoot::knot_mapped_symbol,
    StaticReadOnlyRoot::kuninitialized_symbol,
    StaticReadOnlyRoot::kmegamorphic_symbol,
    StaticReadOnlyRoot::kelements_transition_symbol,
    StaticReadOnlyRoot::kmega_dom_symbol,
    StaticReadOnlyRoot::karray_buffer_wasm_memory_symbol,
    StaticReadOnlyRoot::kcall_site_info_symbol,
    StaticReadOnlyRoot::kconsole_context_id_symbol,
    StaticReadOnlyRoot::kconsole_context_name_symbol,
    StaticReadOnlyRoot::kclass_fields_symbol,
    StaticReadOnlyRoot::kclass_positions_symbol,
    StaticReadOnlyRoot::kerror_end_pos_symbol,
    StaticReadOnlyRoot::kerror_script_symbol,
    StaticReadOnlyRoot::kerror_stack_symbol,
    StaticReadOnlyRoot::kerror_start_pos_symbol,
    StaticReadOnlyRoot::kfrozen_symbol,
    StaticReadOnlyRoot::kinterpreter_trampoline_symbol,
    StaticReadOnlyRoot::knative_context_index_symbol,
    StaticReadOnlyRoot::knonextensible_symbol,
    StaticReadOnlyRoot::kpromise_debug_message_symbol,
    StaticReadOnlyRoot::kpromise_forwarding_handler_symbol,
    StaticReadOnlyRoot::kpromise_handled_by_symbol,
    StaticReadOnlyRoot::kpromise_awaited_by_symbol,
    StaticReadOnlyRoot::kregexp_result_names_symbol,
    StaticReadOnlyRoot::kregexp_result_regexp_input_symbol,
    StaticReadOnlyRoot::kregexp_result_regexp_last_index_symbol,
    StaticReadOnlyRoot::ksealed_symbol,
    StaticReadOnlyRoot::kshared_struct_map_elements_template_symbol,
    StaticReadOnlyRoot::kshared_struct_map_registry_key_symbol,
    StaticReadOnlyRoot::kstrict_function_transition_symbol,
    StaticReadOnlyRoot::ktemplate_literal_function_literal_id_symbol,
    StaticReadOnlyRoot::ktemplate_literal_slot_id_symbol,
    StaticReadOnlyRoot::kwasm_exception_tag_symbol,
    StaticReadOnlyRoot::kwasm_exception_values_symbol,
    StaticReadOnlyRoot::kwasm_uncatchable_symbol,
    StaticReadOnlyRoot::kwasm_wrapped_object_symbol,
    StaticReadOnlyRoot::kwasm_debug_proxy_cache_symbol,
    StaticReadOnlyRoot::kwasm_debug_proxy_names_symbol,
    StaticReadOnlyRoot::kasync_iterator_symbol,
    StaticReadOnlyRoot::kintl_fallback_symbol,
    StaticReadOnlyRoot::kmatch_symbol,
    StaticReadOnlyRoot::ksearch_symbol,
    StaticReadOnlyRoot::kunscopables_symbol,
    StaticReadOnlyRoot::khas_instance_symbol,
    StaticReadOnlyRoot::kto_string_tag_symbol,
    StaticReadOnlyRoot::kPromiseFulfillReactionJobTaskMap,
    StaticReadOnlyRoot::kPromiseRejectReactionJobTaskMap,
    StaticReadOnlyRoot::kCallableTaskMap,
    StaticReadOnlyRoot::kCallbackTaskMap,
    StaticReadOnlyRoot::kPromiseResolveThenableJobTaskMap,
    StaticReadOnlyRoot::kAccessCheckInfoMap,
    StaticReadOnlyRoot::kAccessorPairMap,
    StaticReadOnlyRoot::kAliasedArgumentsEntryMap,
    StaticReadOnlyRoot::kAllocationMementoMap,
    StaticReadOnlyRoot::kArrayBoilerplateDescriptionMap,
    StaticReadOnlyRoot::kAsmWasmDataMap,
    StaticReadOnlyRoot::kAsyncGeneratorRequestMap,
    StaticReadOnlyRoot::kBreakPointMap,
    StaticReadOnlyRoot::kBreakPointInfoMap,
    StaticReadOnlyRoot::kBytecodeWrapperMap,
    StaticReadOnlyRoot::kCallSiteInfoMap,
    StaticReadOnlyRoot::kClassBoilerplateMap,
    StaticReadOnlyRoot::kClassPositionsMap,
    StaticReadOnlyRoot::kCodeWrapperMap,
    StaticReadOnlyRoot::kDebugInfoMap,
    StaticReadOnlyRoot::kEnumCacheMap,
    StaticReadOnlyRoot::kErrorStackDataMap,
    StaticReadOnlyRoot::kFunctionTemplateRareDataMap,
    StaticReadOnlyRoot::kInterceptorInfoMap,
    StaticReadOnlyRoot::kModuleRequestMap,
    StaticReadOnlyRoot::kPromiseCapabilityMap,
    StaticReadOnlyRoot::kPromiseOnStackMap,
    StaticReadOnlyRoot::kPromiseReactionMap,
    StaticReadOnlyRoot::kPropertyDescriptorObjectMap,
    StaticReadOnlyRoot::kPrototypeInfoMap,
    StaticReadOnlyRoot::kRegExpBoilerplateDescriptionMap,
    StaticReadOnlyRoot::kScriptMap,
    StaticReadOnlyRoot::kScriptOrModuleMap,
    StaticReadOnlyRoot::kSourceTextModuleInfoEntryMap,
    StaticReadOnlyRoot::kStackFrameInfoMap,
    StaticReadOnlyRoot::kTemplateObjectDescriptionMap,
    StaticReadOnlyRoot::kTuple2Map,
    StaticReadOnlyRoot::kWasmExceptionTagMap,
    StaticReadOnlyRoot::kSloppyArgumentsElementsMap,
    StaticReadOnlyRoot::kDescriptorArrayMap,
    StaticReadOnlyRoot::kStrongDescriptorArrayMap,
    StaticReadOnlyRoot::kUncompiledDataWithoutPreparseDataMap,
    StaticReadOnlyRoot::kUncompiledDataWithPreparseDataMap,
    StaticReadOnlyRoot::kUncompiledDataWithoutPreparseDataWithJobMap,
    StaticReadOnlyRoot::kUncompiledDataWithPreparseDataAndJobMap,
    StaticReadOnlyRoot::kOnHeapBasicBlockProfilerDataMap,
    StaticReadOnlyRoot::kFunctionTemplateInfoMap,
    StaticReadOnlyRoot::kObjectTemplateInfoMap,
    StaticReadOnlyRoot::kTurbofanBitsetTypeMap,
    StaticReadOnlyRoot::kTurbofanUnionTypeMap,
    StaticReadOnlyRoot::kTurbofanRangeTypeMap,
    StaticReadOnlyRoot::kTurbofanHeapConstantTypeMap,
    StaticReadOnlyRoot::kTurbofanOtherNumberConstantTypeMap,
    StaticReadOnlyRoot::kTurboshaftWord32TypeMap,
    StaticReadOnlyRoot::kTurboshaftWord32RangeTypeMap,
    StaticReadOnlyRoot::kTurboshaftWord32SetTypeMap,
    StaticReadOnlyRoot::kTurboshaftWord64TypeMap,
    StaticReadOnlyRoot::kTurboshaftWord64RangeTypeMap,
    StaticReadOnlyRoot::kTurboshaftWord64SetTypeMap,
    StaticReadOnlyRoot::kTurboshaftFloat64TypeMap,
    StaticReadOnlyRoot::kTurboshaftFloat64RangeTypeMap,
    StaticReadOnlyRoot::kTurboshaftFloat64SetTypeMap,
    StaticReadOnlyRoot::kInternalClassMap,
    StaticReadOnlyRoot::kSmiPairMap,
    StaticReadOnlyRoot::kSmiBoxMap,
    StaticReadOnlyRoot::kExportedSubClassBaseMap,
    StaticReadOnlyRoot::kExportedSubClassMap,
    StaticReadOnlyRoot::kAbstractInternalClassSubclass1Map,
    StaticReadOnlyRoot::kAbstractInternalClassSubclass2Map,
    StaticReadOnlyRoot::kInternalClassWithStructElementsMap,
    StaticReadOnlyRoot::kExportedSubClass2Map,
    StaticReadOnlyRoot::kSortStateMap,
    StaticReadOnlyRoot::kWasmFastApiCallDataMap,
    StaticReadOnlyRoot::kWasmStringViewIterMap,
    StaticReadOnlyRoot::kAllocationSiteWithWeakNextMap,
    StaticReadOnlyRoot::kAllocationSiteWithoutWeakNextMap,
    StaticReadOnlyRoot::kconstructor_string,
    StaticReadOnlyRoot::knext_string,
    StaticReadOnlyRoot::kresolve_string,
    StaticReadOnlyRoot::kthen_string,
    StaticReadOnlyRoot::kvalueOf_string,
    StaticReadOnlyRoot::kiterator_symbol,
    StaticReadOnlyRoot::kmatch_all_symbol,
    StaticReadOnlyRoot::kreplace_symbol,
    StaticReadOnlyRoot::kspecies_symbol,
    StaticReadOnlyRoot::ksplit_symbol,
    StaticReadOnlyRoot::kto_primitive_symbol,
    StaticReadOnlyRoot::kis_concat_spreadable_symbol,
    StaticReadOnlyRoot::kLoadHandler1Map,
    StaticReadOnlyRoot::kLoadHandler2Map,
    StaticReadOnlyRoot::kLoadHandler3Map,
    StaticReadOnlyRoot::kStoreHandler0Map,
    StaticReadOnlyRoot::kStoreHandler1Map,
    StaticReadOnlyRoot::kStoreHandler2Map,
    StaticReadOnlyRoot::kStoreHandler3Map,
};

}  // namespace internal
}  // namespace v8
#endif  // V8_STATIC_ROOTS_BOOL
#endif  // V8_ROOTS_STATIC_ROOTS_H_
