function(SDL_DetectCMakePlatform)
  set(sdl_cmake_platform )
  if(WIN32)
    set(sdl_cmake_platform Windows)
  elseif(PSP)
    set(sdl_cmake_platform psp)
  elseif(APPLE)
    if(CMAKE_SYSTEM_NAME MATCHES ".*(Darwin|MacOS).*")
      set(sdl_cmake_platform macOS)
    elseif(CMAKE_SYSTEM_NAME MATCHES ".*tvOS.*")
      set(sdl_cmake_platform tvOS)
    elseif(CMAKE_SYSTEM_NAME MATCHES ".*iOS.*")
      set(sdl_cmake_platform iOS)
    elseif(CMAKE_SYSTEM_NAME MATCHES ".*watchOS.*")
      set(sdl_cmake_platform watchOS)
    elseif (CMAKE_SYSTEM_NAME MATCHES "visionOS")
      set(sdl_cmake_platform visionOS)
    else()
      message(WARNING "Unknown Apple platform: \"${CMAKE_SYSTEM_NAME}\"")
    endif()
  elseif(CMAKE_SYSTEM_NAME MATCHES "Haiku.*")
    set(sdl_cmake_platform Haiku)
  elseif(NINTENDO_3DS)
    set(sdl_cmake_platform n3ds)
  elseif(NGAGESDK)
    set(sdl_cmake_platform ngage)
  elseif(PS2)
    set(sdl_cmake_platform ps2)
  elseif(RISCOS)
    set(sdl_cmake_platform RISCOS)
  elseif(VITA)
    set(sdl_cmake_platform Vita)
  elseif(CMAKE_SYSTEM_NAME MATCHES ".*Linux")
    set(sdl_cmake_platform Linux)
  elseif(CMAKE_SYSTEM_NAME MATCHES "kFreeBSD.*")
    set(sdl_cmake_platform FreeBSD)
  elseif(CMAKE_SYSTEM_NAME MATCHES "kNetBSD.*|NetBSD.*")
    set(sdl_cmake_platform NetBSD)
  elseif(CMAKE_SYSTEM_NAME MATCHES "kOpenBSD.*|OpenBSD.*")
    set(sdl_cmake_platform OpenBSD)
  elseif(CMAKE_SYSTEM_NAME STREQUAL "GNU")
    # GNU/Hurd must be checked AFTER RISCOS
    set(sdl_cmake_platform Hurd)
  elseif(CMAKE_SYSTEM_NAME MATCHES ".*BSDI.*")
    set(sdl_cmake_platform BSDi)
  elseif(CMAKE_SYSTEM_NAME MATCHES "DragonFly.*|FreeBSD")
    set(sdl_cmake_platform FreeBSD)
  elseif(CMAKE_SYSTEM_NAME MATCHES "SYSV5.*")
    set(sdl_cmake_platform SYSV5)
  elseif(CMAKE_SYSTEM_NAME MATCHES "Solaris.*|SunOS.*")
    set(sdl_cmake_platform Solaris)
  elseif(CMAKE_SYSTEM_NAME MATCHES "HP-UX.*")
    set(sdl_cmake_platform HPUX)
  elseif(CMAKE_SYSTEM_NAME MATCHES "AIX.*")
    set(sdl_cmake_platform AIX)
  elseif(CMAKE_SYSTEM_NAME MATCHES "Minix.*")
    set(sdl_cmake_platform Minix)
  elseif(CMAKE_SYSTEM_NAME MATCHES "Android.*")
    set(sdl_cmake_platform Android)
  elseif(CMAKE_SYSTEM_NAME MATCHES "Emscripten.*")
    set(sdl_cmake_platform Emscripten)
  elseif(CMAKE_SYSTEM_NAME MATCHES "QNX.*")
    set(sdl_cmake_platform QNX)
  elseif(CMAKE_SYSTEM_NAME MATCHES "BeOS.*")
    message(FATAL_ERROR "BeOS support has been removed as of SDL 2.0.2.")
  endif()

  if(sdl_cmake_platform)
    string(TOUPPER "${sdl_cmake_platform}" _upper_platform)
    set("${_upper_platform}" TRUE PARENT_SCOPE)
  else()
    set(sdl_cmake_platform "unknown")
  endif()
  set(SDL_CMAKE_PLATFORM "${sdl_cmake_platform}" PARENT_SCOPE)
endfunction()
