# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.


### Localization for about:webrtc, a troubleshooting and diagnostic page
### for WebRTC calls. See https://developer.mozilla.org/en-US/docs/Web/API/WebRTC_API.

# The text "WebRTC" is a proper noun and should not be translated.
about-webrtc-document-title = WebRTC ᱤᱱᱴᱚᱨᱱᱟᱞᱥ
# "about:webrtc" is a internal browser URL and should not be
# translated. This string is used as a title for a file save dialog box.
about-webrtc-save-page-dialog-title = ᱞᱮᱠᱷ about:webrtc ᱥᱟᱺᱪᱟᱣ

## These labels are for a disclosure which contains the information for closed PeerConnection sections

about-webrtc-closed-peerconnection-disclosure-show-msg = ᱵᱚᱸᱫ ᱠᱟᱱ PeerConnections ᱫᱮᱠᱷᱟᱣ ᱢᱮ
about-webrtc-closed-peerconnection-disclosure-hide-msg = ᱵᱚᱸᱫ ᱠᱟᱱ PeerConnections ᱩᱠᱩᱭ ᱢᱮ

## AEC is an abbreviation for Acoustic Echo Cancellation.

about-webrtc-aec-logging-msg-label = AEC ᱞᱚᱜᱤᱝ
about-webrtc-aec-logging-off-state-label = AEC ᱞᱚᱜᱤᱝᱮ ᱮᱛᱦᱚᱵ ᱢᱮ
about-webrtc-aec-logging-on-state-label = AEC ᱞᱚᱜᱤᱝ ᱵᱚᱸᱫᱚᱭ ᱢᱮ
about-webrtc-aec-logging-on-state-msg = AEC ᱵᱚᱞᱚ ᱫᱚ ᱪᱚᱴᱠᱟᱨ ᱜᱮᱭᱟ (ᱠᱚᱞᱚᱨ ᱥᱟᱶ ᱛᱤᱱᱟᱹᱜ ᱜᱟᱱ ᱚᱠᱚᱛ ᱨᱚᱲ ᱢᱮ ᱟᱨ ᱚᱱᱟ ᱛᱟᱭᱚᱢ ᱠᱮᱯᱪᱚᱨ ᱵᱚᱸᱫᱚᱭ ᱢᱮ)
about-webrtc-aec-logging-toggled-on-state-msg = AEC ᱵᱚᱞᱚ ᱫᱚ ᱪᱚᱴᱠᱟᱨ ᱜᱮᱭᱟ (ᱠᱚᱞᱚᱨ ᱥᱟᱶ ᱛᱤᱱᱟᱹᱜ ᱜᱟᱱ ᱚᱠᱚᱛ ᱨᱚᱲ ᱢᱮ ᱟᱨ ᱚᱱᱟ ᱛᱟᱭᱚᱢ ᱠᱮᱯᱪᱚᱨ ᱵᱚᱸᱫᱚᱭ ᱢᱮ)
about-webrtc-aec-logging-unavailable-sandbox = ᱮᱱᱵᱷᱟᱭᱨᱚᱱᱢᱮᱱᱴ ᱵᱷᱮᱨᱤᱭᱮᱵᱚᱞ MOZ_DISABLE_CONTENT_SANDBOX=1 ᱫᱚ AEC ᱞᱚᱜᱽᱠᱚ ᱵᱷᱮᱡᱟ ᱞᱟᱹᱠᱛᱤ ᱠᱟᱱᱟ ᱾ ᱡᱩᱫᱤ ᱟᱢ ᱱᱚᱶᱟ ᱨᱤᱥᱠ ᱠᱚ ᱵᱟᱵᱚᱛ ᱴᱷᱟᱹᱣᱠᱟᱹ ᱥᱟᱹᱦᱤᱡ ᱵᱟᱲᱟᱭ ᱠᱷᱟᱱ ᱱᱚᱶᱟ ᱵᱷᱮᱨᱤᱭᱮᱵᱚᱞ ᱥᱮᱴ ᱢᱮ ᱾
# Variables:
#  $path (String) - The path to which the aec log file is saved.
about-webrtc-aec-logging-toggled-off-state-msg = ᱨᱮ ᱦᱟᱛᱟᱣ ᱠᱟᱱ ᱞᱚᱜᱽ ᱨᱮᱫᱽᱠᱚ ᱧᱟᱢᱚᱜᱼᱟ : { $path }

##

# The autorefresh checkbox causes a stats section to autorefresh its content when checked
about-webrtc-auto-refresh-label = ᱟᱡ ᱛᱮ ᱟᱹᱨᱩ
# A button which forces a refresh of displayed statistics
about-webrtc-force-refresh-button = ᱱᱟᱶᱟ ᱟᱹᱨᱩ
# "PeerConnection" is a proper noun associated with the WebRTC module. "ID" is
# an abbreviation for Identifier. This string should not normally be translated
# and is used as a data label.
about-webrtc-peerconnection-id-label = PeerConnection ID:
# The number of DataChannels that a PeerConnection has opened
about-webrtc-data-channels-opened-label = ᱰᱟᱴᱟ ᱪᱮᱱᱮᱞ ᱠᱷᱩᱞᱟᱹ ᱮᱱᱟ :
# The number of once open DataChannels that a PeerConnection has closed
about-webrtc-data-channels-closed-label = ᱰᱟᱴᱟ ᱪᱮᱱᱮᱞ ᱵᱚᱸᱫ ᱮᱱᱟ :

## "SDP" is an abbreviation for Session Description Protocol, an IETF standard.
## See http://wikipedia.org/wiki/Session_Description_Protocol

about-webrtc-sdp-heading = SDP
about-webrtc-local-sdp-heading = ᱞᱚᱠᱟᱞ SDP
about-webrtc-local-sdp-heading-offer = ᱞᱚᱠᱟᱞ SDP (ᱚᱯᱷᱚᱨ)
about-webrtc-local-sdp-heading-answer = ᱞᱚᱠᱟᱞ SDP (ᱛᱮᱞᱟ)
about-webrtc-remote-sdp-heading = ᱨᱤᱢᱚᱴ SDP
about-webrtc-remote-sdp-heading-offer = ᱨᱚᱢᱤᱪ SDP (ᱚᱯᱷᱚᱨ)
about-webrtc-remote-sdp-heading-answer = ᱨᱚᱢᱤᱪ SDP (ᱛᱮᱞᱟ)
about-webrtc-sdp-history-heading = SDP ᱱᱟᱜᱟᱢ
about-webrtc-sdp-parsing-errors-heading = SDP ᱯᱟᱨᱥᱤᱝ ᱵᱷᱩᱞ

##

# "RTP" is an abbreviation for the Real-time Transport Protocol, an IETF
# specification, and should not normally be translated. "Stats" is an
# abbreviation for Statistics.
about-webrtc-rtp-stats-heading = RTP ᱟᱸᱠᱲᱟ

## "ICE" is an abbreviation for Interactive Connectivity Establishment, which
## is an IETF protocol, and should not normally be translated.

about-webrtc-ice-state = ICE ᱫᱚᱥᱟ
# "Stats" is an abbreviation for Statistics.
about-webrtc-ice-stats-heading = ICE ᱫᱚᱥᱟ
about-webrtc-ice-restart-count-label = ICE ᱫᱩᱦᱲᱟᱹ ᱮᱛᱦᱚᱵᱟᱭ :
about-webrtc-ice-rollback-count-label = ICE ᱨᱚᱞᱵᱮᱠᱥ:
about-webrtc-ice-pair-bytes-sent = Bytes ᱵᱷᱮᱡᱟ ᱠᱟᱱᱟ:
about-webrtc-ice-pair-bytes-received = ᱵᱟᱤᱴᱥ ᱦᱟᱛᱟᱣᱮᱱᱟ ᱺ
about-webrtc-ice-component-id = ᱦᱟᱹᱴᱤᱧ ID

## These adjectives are used to label a line of statistics collected for a peer
## connection. The data represents either the local or remote end of the
## connection.

about-webrtc-type-local = ᱥᱩᱯᱩᱨ
about-webrtc-type-remote = ᱨᱤᱢᱳᱴ

##

# This adjective is used to label a table column. Cells in this column contain
# the localized javascript string representation of "true" or are left blank.
about-webrtc-nominated = ᱢᱚᱱᱚᱛᱤᱛ ᱠᱟᱱᱟᱭ
# This adjective is used to label a table column. Cells in this column contain
# the localized javascript string representation of "true" or are left blank.
# This represents an attribute of an ICE candidate.
about-webrtc-selected = ᱵᱟᱪᱷᱟᱣᱮᱱᱟ
about-webrtc-save-page-label = ᱥᱟᱦᱴᱟ ᱥᱟᱸᱪᱟᱣ ᱢᱮ
about-webrtc-debug-mode-msg-label = ᱰᱮᱵᱩᱜᱽ ᱢᱳᱰ
about-webrtc-debug-mode-off-state-label = ᱰᱮᱵᱩᱜᱽ ᱢᱳᱰ ᱮᱛᱦᱚᱵ ᱢᱮ
about-webrtc-debug-mode-on-state-label = ᱰᱮᱵᱩᱜᱽ ᱢᱳᱰ ᱵᱚᱸᱫ ᱢᱮ
about-webrtc-stats-heading = ᱠᱟᱹᱢᱤᱦᱚᱨᱟ ᱟᱸᱠᱲᱟ
about-webrtc-enable-logging-label = WebRTC ᱞᱚᱜᱽ ᱯᱨᱮᱡᱚᱱᱴ ᱮᱢ ᱪᱷᱚᱭ ᱢᱮ
about-webrtc-stats-clear = ᱦᱤᱛᱟᱹᱞ ᱯᱷᱟᱨᱪᱟᱭ ᱢᱮ
about-webrtc-log-heading = ᱡᱚᱲᱟᱣ ᱞᱚᱜᱽ
about-webrtc-log-clear = ᱞᱚᱜᱽ ᱯᱷᱟᱨᱪᱟᱭ ᱢᱮ
about-webrtc-log-show-msg = ᱞᱚᱜᱽ ᱫᱮᱠᱷᱟᱣ ᱢᱮ
    .title = ᱱᱚᱶᱟ ᱛᱟᱞᱢᱟ ᱯᱟᱥᱱᱟᱣ ᱞᱟᱹᱜᱤᱫ ᱚᱛᱟᱭ ᱢᱮ
about-webrtc-log-hide-msg = ᱩᱠᱩ ᱞᱚᱜᱽ
    .title = ᱱᱚᱶᱟ ᱛᱟᱞᱢᱟᱸ ᱦᱩᱰᱤᱧ ᱪᱷᱚ ᱞᱟᱹᱜᱤᱫ ᱚᱛᱟᱭ ᱢᱮ
about-webrtc-log-section-show-msg = ᱞᱚᱜᱽ ᱫᱮᱠᱷᱟᱣ ᱢᱮ
    .title = ᱱᱚᱶᱟ ᱛᱟᱞᱢᱟ ᱯᱟᱥᱱᱟᱣ ᱞᱟᱹᱜᱤᱫ ᱚᱛᱟᱭ ᱢᱮ
about-webrtc-log-section-hide-msg = ᱩᱠᱩ ᱞᱚᱜᱽ
    .title = ᱱᱚᱶᱟ ᱛᱟᱞᱢᱟᱸ ᱦᱩᱰᱤᱧ ᱪᱷᱚ ᱞᱟᱹᱜᱤᱫ ᱚᱛᱟᱭ ᱢᱮ
about-webrtc-copy-report-button = ᱠᱷᱚᱵᱚᱨ ᱱᱚᱠᱚᱞ ᱮᱱᱟ
about-webrtc-copy-report-history-button = ᱠᱷᱚᱵᱚᱨ ᱱᱟᱜᱟᱢ ᱱᱚᱠᱚᱞ ᱢᱮ

## These are used to display a header for a PeerConnection.
## Variables:
##  $browser-id (Number) - A numeric id identifying the browser tab for the PeerConnection.
##  $id (String) - A globally unique identifier for the PeerConnection.
##  $url (String) - The url of the site which opened the PeerConnection.
##  $now (Date) - The JavaScript timestamp at the time the report was generated.

about-webrtc-connection-open = [ { $browser-id } | { $id } ] { $url } { $now }
about-webrtc-connection-closed = [ { $browser-id } | { $id } ] { $url } (ᱵᱚᱱᱫᱚ ᱟᱠᱟᱱᱟ) { $now }

## These are used to indicate what direction media is flowing.
## Variables:
##  $codecs - a list of media codecs

about-webrtc-short-send-receive-direction = ᱵᱷᱮᱡᱟ / ᱧᱟᱢ : { $codecs }
about-webrtc-short-send-direction = ᱵᱷᱮᱡᱟ : { $codecs }
about-webrtc-short-receive-direction = ᱧᱟᱢ : { $codecs }

##

about-webrtc-local-candidate = ᱥᱩᱯᱩᱨ ᱠᱮᱱᱰᱤᱰᱮᱴ
about-webrtc-remote-candidate = ᱡᱷᱟᱹᱞ ᱠᱮᱱᱰᱤᱰᱮᱴ
about-webrtc-raw-candidates-heading = ᱡᱷᱚᱛᱚ ᱵᱮᱨᱮᱞ ᱠᱮᱱᱰᱤᱰᱮᱴᱠᱚ
about-webrtc-raw-local-candidate = ᱵᱮᱨᱮᱞ ᱥᱩᱯᱩᱨ ᱠᱮᱱᱰᱤᱰᱮᱴ
about-webrtc-raw-remote-candidate = ᱡᱷᱟᱹᱞ ᱵᱮᱨᱮᱞ ᱠᱮᱱᱰᱤᱰᱮᱴ
about-webrtc-raw-cand-show-msg = ᱵᱮᱨᱮᱞ ᱠᱮᱱᱰᱤᱰᱮᱴᱠᱚ ᱫᱮᱠᱷᱟᱣ ᱠᱚᱢ
    .title = ᱱᱚᱶᱟ ᱛᱟᱞᱢᱟ ᱯᱟᱥᱱᱟᱣ ᱞᱟᱹᱜᱤᱫ ᱚᱛᱟᱭ ᱢᱮ
about-webrtc-raw-cand-hide-msg = ᱵᱮᱨᱮᱞ ᱠᱮᱱᱰᱤᱰᱮᱴᱠᱚ ᱩᱠᱩᱠᱚᱢ
    .title = ᱱᱚᱶᱟ ᱛᱟᱞᱢᱟᱸ ᱦᱩᱰᱤᱧ ᱪᱷᱚ ᱞᱟᱹᱜᱤᱫ ᱚᱛᱟᱭ ᱢᱮ
about-webrtc-raw-cand-section-show-msg = ᱵᱮᱨᱮᱞ ᱠᱮᱱᱰᱤᱰᱮᱴᱠᱚ ᱫᱮᱠᱷᱟᱣ ᱠᱚᱢ
    .title = ᱱᱚᱶᱟ ᱛᱟᱞᱢᱟ ᱯᱟᱥᱱᱟᱣ ᱞᱟᱹᱜᱤᱫ ᱚᱛᱟᱭ ᱢᱮ
about-webrtc-raw-cand-section-hide-msg = ᱵᱮᱨᱮᱞ ᱠᱮᱱᱰᱤᱰᱮᱴᱠᱚ ᱩᱠᱩᱠᱚᱢ
    .title = ᱱᱚᱶᱟ ᱛᱟᱞᱢᱟᱸ ᱦᱩᱰᱤᱧ ᱪᱷᱚ ᱞᱟᱹᱜᱤᱫ ᱚᱛᱟᱭ ᱢᱮ
about-webrtc-priority = ᱢᱚᱦᱚᱛ
about-webrtc-fold-show-msg = ᱵᱤᱵᱨᱚᱬ ᱫᱮᱠᱷᱟᱣ ᱢᱮ
    .title = ᱱᱚᱶᱟ ᱛᱟᱞᱢᱟᱸ ᱡᱷᱟᱹᱞ ᱪᱷᱚ ᱞᱟᱹᱜᱤᱫ ᱚᱛᱟᱭ ᱢᱮ
about-webrtc-fold-hide-msg = ᱵᱤᱵᱨᱟᱬ ᱩᱠᱩᱭ ᱢᱮ
    .title = ᱱᱚᱶᱟ ᱛᱟᱞᱢᱟᱸ ᱡᱷᱟᱹᱞ ᱪᱷᱚ ᱞᱟᱹᱜᱤᱫ ᱚᱛᱟᱭ ᱢᱮ
about-webrtc-fold-default-show-msg = ᱵᱤᱵᱨᱚᱬ ᱫᱮᱠᱷᱟᱣ ᱢᱮ
    .title = ᱱᱚᱶᱟ ᱛᱟᱞᱢᱟᱸ ᱡᱷᱟᱹᱞ ᱪᱷᱚ ᱞᱟᱹᱜᱤᱫ ᱚᱛᱟᱭ ᱢᱮ
about-webrtc-fold-default-hide-msg = ᱵᱤᱵᱨᱟᱬ ᱩᱠᱩᱭ ᱢᱮ
    .title = ᱱᱚᱶᱟ ᱛᱟᱞᱢᱟᱸ ᱡᱷᱟᱹᱞ ᱪᱷᱚ ᱞᱟᱹᱜᱤᱫ ᱚᱛᱟᱭ ᱢᱮ
about-webrtc-dropped-frames-label = ᱟᱲᱟᱜ ᱜᱤᱰᱤ ᱯᱷᱨᱮᱢᱠᱚ :
about-webrtc-discarded-packets-label = ᱚᱪᱚᱜ ᱠᱟᱱ ᱯᱮᱠᱮᱴᱠᱚ :
about-webrtc-decoder-label = ᱰᱤᱠᱳᱰᱟᱹᱨ
about-webrtc-encoder-label = ᱮᱱᱠᱳᱰᱚᱨ
about-webrtc-show-tab-label = ᱴᱮᱵᱽ ᱠᱚ ᱫᱮᱠᱷᱟᱣ ᱢᱮ
about-webrtc-current-framerate-label = ᱯᱷᱨᱮᱢᱫᱚᱨ
about-webrtc-width-px = ᱚᱥᱟᱨ (px)
about-webrtc-height-px = ᱩᱥᱩᱞ (px)
about-webrtc-consecutive-frames = ᱤᱱᱟᱹᱛᱟᱭᱚᱢᱤᱱᱟᱹ ᱯᱷᱨᱮᱢᱠᱚ
about-webrtc-time-elapsed = ᱪᱟᱞᱟᱣ ᱠᱟᱱ ᱚᱠᱛᱚ (s)
about-webrtc-estimated-framerate = ᱵᱟᱹᱭᱥᱟᱹᱣᱠᱟᱱ ᱯᱷᱨᱮᱢᱫᱚᱨ
about-webrtc-rotation-degrees = ᱟᱹᱪᱩᱨ (ᱰᱤᱜᱽᱨᱤ)
about-webrtc-first-frame-timestamp = ᱯᱩᱭᱞᱩ ᱯᱷᱨᱮᱢ ᱨᱤᱥᱮᱯᱥᱚᱱ ᱚᱠᱛᱚᱪᱷᱟᱯᱟ
about-webrtc-last-frame-timestamp = ᱢᱩᱪᱟᱹᱫ ᱯᱷᱨᱮᱢ ᱨᱤᱥᱮᱯᱥᱚᱱ ᱚᱠᱛᱚᱪᱷᱟᱯᱟ

## SSRCs are identifiers that represent endpoints in an RTP stream

# This is an SSRC on the local side of the connection that is receiving RTP
about-webrtc-local-receive-ssrc = ᱥᱩᱯᱩᱨ ᱫᱚ SSRC ᱧᱟᱢᱮᱫᱟᱭ
# This is an SSRC on the remote side of the connection that is sending RTP
about-webrtc-remote-send-ssrc = ᱡᱷᱟᱹᱞ ᱛᱮ ᱵᱷᱮᱡᱟᱮᱫ SSRC

## These are displayed on the button that shows or hides the
## PeerConnection configuration disclosure

about-webrtc-pc-configuration-show-msg = ᱠᱚᱱᱯᱷᱤᱜᱩᱨᱮᱥᱚᱱ ᱫᱮᱠᱷᱟᱣᱢᱮ
about-webrtc-pc-configuration-hide-msg = ᱠᱚᱱᱯᱷᱤᱜᱩᱨᱮᱥᱚᱱ ᱩᱠᱩᱭᱢᱮ

##

# An option whose value will not be displayed but instead noted as having been
# provided
about-webrtc-configuration-element-provided = ᱮᱢ ᱠᱟᱱᱟ
# An option whose value will not be displayed but instead noted as having not
# been provided
about-webrtc-configuration-element-not-provided = ᱵᱟᱝ ᱮᱢ ᱠᱟᱱᱟ
# The options set by the user in about:config that could impact a WebRTC call
about-webrtc-custom-webrtc-configuration-heading = ᱵᱮᱵᱷᱟᱨᱤᱭᱟᱹ ᱫᱚ WebRTC ᱠᱩᱥᱤᱠᱚ ᱥᱮᱴ ᱠᱟᱫᱟᱭ

##

# Section header for estimated bandwidths of WebRTC media flows
about-webrtc-bandwidth-stats-heading = ᱚᱱᱩᱢᱟᱱ ᱠᱚᱱ ᱵᱮᱱᱰᱣᱤᱰᱛᱷ
# The ID of the MediaStreamTrack
about-webrtc-track-identifier = ᱪᱤᱱᱦᱟᱹᱣᱤᱭᱟᱹ ᱯᱟᱧᱡᱟ
# The estimated bandwidth available for sending WebRTC media in bytes per second
about-webrtc-send-bandwidth-bytes-sec = ᱵᱮᱱᱰᱣᱤᱰᱛᱷ ᱵᱷᱮᱡᱟᱭ ᱢᱮ (bytes/sec)
# The estimated bandwidth available for receiving WebRTC media in bytes per second
about-webrtc-receive-bandwidth-bytes-sec = ᱵᱮᱱᱰᱣᱤᱰᱛᱷ ᱧᱮᱢ ᱢᱮ (bytes/sec)
# Maximum number of bytes per second that will be padding zeros at the ends of packets
about-webrtc-max-padding-bytes-sec = ᱡᱷᱚᱛᱚ ᱠᱷᱚᱱ ᱰᱷᱮᱨ ᱯᱮᱰᱤᱝ (bytes/sec)
# The amount of time inserted between packets to keep them spaced out
about-webrtc-pacer-delay-ms = ᱯᱮᱥᱚᱨ ᱵᱤᱞᱚᱢ ms
# The amount of time it takes for a packet to travel from the local machine to the remote machine,
# and then have a packet return
about-webrtc-round-trip-time-ms = RTT ms
# This is a section heading for video frame statistics for a MediaStreamTrack.
# see https://developer.mozilla.org/en-US/docs/Web/API/MediaStreamTrack.
# Variables:
#   $track-identifier (String) - The unique identifier for the MediaStreamTrack.
about-webrtc-frame-stats-heading = ᱵᱷᱤᱰᱤᱭᱚ ᱯᱷᱮᱢ ᱟᱸᱠᱲᱟ - MediaStreamTrack ID: { $track-identifier }

##

about-webrtc-save-page-msg = ᱛᱮ ᱥᱟᱦᱴᱟ ᱥᱟᱺᱪᱟᱣ ᱮᱱᱟ: { $path }
about-webrtc-debug-mode-off-state-msg = ᱨᱮ ᱯᱟᱧᱡᱟ ᱞᱚᱜᱽ ᱧᱟᱢᱚᱜᱼᱟ : { $path }
about-webrtc-debug-mode-on-state-msg = ᱰᱮᱵᱩᱜ ᱢᱳᱰ ᱪᱚᱴᱠᱟᱨ ᱜᱮᱭᱟ, ᱯᱟᱧᱡᱟ ᱞᱚᱜᱽ : { $path }
about-webrtc-aec-logging-off-state-msg = ᱨᱮ ᱦᱟᱛᱟᱣ ᱠᱟᱱ ᱞᱚᱜᱽ ᱨᱮᱫᱽᱠᱚ ᱧᱟᱢᱚᱜᱼᱟ : { $path }
# This path is used for saving the about:webrtc page so it can be attached to
# bug reports.
# Variables:
#  $path (String) - The path to which the file is saved.
about-webrtc-save-page-complete-msg = ᱛᱮ ᱥᱟᱦᱴᱟ ᱥᱟᱺᱪᱟᱣ ᱮᱱᱟ: { $path }
# This is the total number of frames encoded or decoded over an RTP stream.
# Variables:
#  $frames (Number) - The number of frames encoded or decoded.
about-webrtc-frames =
    { $frames ->
        [one] { $frames } ᱯᱷᱨᱮᱢ
        [two] { $frames } ᱯᱷᱨᱮᱢᱠᱤᱱ
       *[other] { $frames } ᱯᱷᱨᱮᱢᱠᱚ
    }
# This is the number of audio channels encoded or decoded over an RTP stream.
# Variables:
#  $channels (Number) - The number of channels encoded or decoded.
about-webrtc-channels =
    { $channels ->
        [one] { $channels } ᱪᱟᱱᱮᱞ
        [two] { $channels } ᱪᱟᱱᱮᱞᱠᱤᱱ
       *[other] { $channels } ᱪᱟᱱᱮᱞᱠᱚ
    }
# This is the total number of packets received on the PeerConnection.
# Variables:
#  $packets (Number) - The number of packets received.
about-webrtc-received-label =
    { $packets ->
        [one] { $packets } ᱯᱮᱠᱮᱴ ᱧᱟᱢ ᱮᱱᱟ
        [two] { $packets } ᱯᱮᱠᱮᱴᱠᱤᱱ ᱧᱟᱢ ᱮᱱᱟ
       *[other] { $packets } ᱯᱮᱠᱮᱴᱠᱚ ᱧᱟᱢ ᱮᱱᱟ
    }
# This is the total number of packets lost by the PeerConnection.
# Variables:
#  $packets (Number) - The number of packets lost.
about-webrtc-lost-label =
    { $packets ->
        [one] { $packets } ᱯᱮᱠᱮᱴ ᱟᱫ ᱮᱱᱟ
        [two] { $packets } ᱯᱮᱠᱮᱴᱠᱤᱱ ᱟᱫ ᱮᱱᱟ
       *[other] { $packets } ᱯᱮᱠᱮᱴᱠᱚ ᱟᱫ ᱮᱱᱟ
    }
# This is the total number of packets sent by the PeerConnection.
# Variables:
#  $packets (Number) - The number of packets sent.
about-webrtc-sent-label =
    { $packets ->
        [one] { $packets } ᱯᱮᱠᱮᱴ ᱵᱷᱮᱡᱟ ᱮᱱᱟ
        [two] { $packets } ᱯᱮᱠᱮᱴᱠᱤᱱ ᱵᱷᱮᱡᱟ ᱮᱱᱟ
       *[other] { $packets } ᱯᱮᱠᱮᱴᱠᱚ ᱵᱷᱮᱡᱟ ᱮᱱᱟ
    }
# Jitter is the variance in the arrival time of packets.
# See: https://w3c.github.io/webrtc-stats/#dom-rtcreceivedrtpstreamstats-jitter
# Variables:
#   $jitter (Number) - The jitter.
about-webrtc-jitter-label = ᱡᱤᱴᱚᱨ { $jitter }
# ICE candidates arriving after the remote answer arrives are considered trickled
# (an attribute of an ICE candidate). These are highlighted in the ICE stats
# table with light blue background.
about-webrtc-trickle-caption-msg = ᱛᱨᱤᱠᱚᱞ ᱠᱮᱱᱰᱤᱰᱮᱴ (ᱛᱮᱞᱟ ᱦᱮᱡ ᱠᱟᱛᱮ ᱦᱟᱹᱡᱩᱜᱼᱟ) ᱠᱚ ᱫᱚ ᱞᱤᱞ ᱨᱮ ᱪᱤᱱᱦᱟᱹ ᱠᱟᱱᱟ

## "SDP" is an abbreviation for Session Description Protocol, an IETF standard.
## See http://wikipedia.org/wiki/Session_Description_Protocol

# This is used as a header for local SDP.
# Variables:
#  $timestamp (Number) - The Unix Epoch time at which the SDP was set.
about-webrtc-sdp-set-at-timestamp-local = ᱚᱠᱛᱚ ᱪᱷᱟᱯᱟ ᱨᱮ ᱞᱚᱠᱟᱞ SDP ᱥᱟᱴ ᱢᱮ { NUMBER($timestamp, useGrouping: "false") }
# This is used as a header for remote SDP.
# Variables:
#  $timestamp (Number) - The Unix Epoch time at which the SDP was set.
about-webrtc-sdp-set-at-timestamp-remote = ᱚᱠᱛᱚ ᱪᱷᱟᱯᱟ ᱨᱮ ᱡᱷᱟᱹᱞ SDP ᱥᱟᱴ ᱢᱮ { NUMBER($timestamp, useGrouping: "false") }
# This is used as a header for an SDP section contained in two columns allowing for side-by-side comparisons.
# Variables:
#  $timestamp (Number) - The Unix Epoch time at which the SDP was set.
#  $relative-timestamp (Number) - The timestamp relative to the timestamp of the earliest received SDP.
about-webrtc-sdp-set-timestamp = ᱚᱠᱛᱚᱪᱷᱟᱯᱟ { NUMBER($timestamp, useGrouping: "false") } (+ { $relative-timestamp } ms)

## These are displayed on the button that shows or hides the SDP information disclosure

about-webrtc-show-msg-sdp = SDP ᱫᱮᱠᱷᱟᱣ
about-webrtc-hide-msg-sdp = SDP ᱩᱠᱩ

## These are displayed on the button that shows or hides the Media Context information disclosure.
## The Media Context is the set of preferences and detected capabilities that informs
## the negotiated CODEC settings.

about-webrtc-media-context-show-msg = ᱢᱤᱰᱤᱭᱟ ᱵᱟᱵᱚᱛ ᱫᱮᱠᱷᱟᱣ ᱢᱮ
about-webrtc-media-context-hide-msg = ᱢᱤᱰᱤᱭᱟ ᱵᱟᱵᱚᱛ ᱩᱠᱩᱭ ᱢᱮ
about-webrtc-media-context-heading = ᱢᱤᱰᱤᱭᱟ ᱵᱟᱵᱚᱛ
