#!/bin/sh
# beeps.sh
# *********************************************************
# Generate two 1 second sinewave beep WAVE files using the
# data from the example in the scicalc Manual.
# Original design (C)2020, B.Walker, G0LCU.
# Issued as Public Domain, CC0. You may do with it as you
# please.
# *********************************************************

# Create two blank files in the current directory.
: > 1KHz.wav
: > 125Hz.wav

# Data required for 1KHz sinewave generation.
data='Op~pO. .'
# Create the file 1KHz.wav WAVE header only, mono, 8 bit depth unsigned, 8000Hz sample rate.
printf "\x52\x49\x46\x46\x24\x20\x00\x00\x57\x41\x56\x45\x66\x6D\x74\x20\x10\x00\x00\x00\x01\x00\x01\x00\x40\x1F\x00\x00\x40\x1F\x00\x00\x01\x00\x08\x00\x64\x61\x74\x61\x00\x20\x00\x00" >> 1KHz.wav
# Now create the 8192 byte approximately 1 second 1KHz burst.
for sinewave in $( seq 0 1 9 )
do
        data=$data$data
done
# Append this data to the WAVE header and you have a universal 1KHz sinewave beep that can be played on almost any device.
printf "$data" >> 1KHz.wav

# Data required for 125Hz sinewave generation.
data='OTX]aeimpsvxz|}~~~}|zxvspmiea]XTOJFA=951.+(&$"!   !"$&(+.159=AFJ'
# Create the file 125Hz.wav WAVE header only, mono, 8 bit depth unsigned, 8000Hz sample rate.
printf "\x52\x49\x46\x46\x24\x20\x00\x00\x57\x41\x56\x45\x66\x6D\x74\x20\x10\x00\x00\x00\x01\x00\x01\x00\x40\x1F\x00\x00\x40\x1F\x00\x00\x01\x00\x08\x00\x64\x61\x74\x61\x00\x20\x00\x00" >> 125Hz.wav
# Now create the 8192 byte approximately 1 second 125Hz burst.
for sinewave in $( seq 0 1 6 )
do
        data=$data$data
done
# Append this data to the WAVE header and you have a universal 125Hz sinewave beep that can be played on almost any device.
printf "$data" >> 125Hz.wav

# Edit the two lines below to suit your WAVE player that should reside in the /bin drawer.
PlayWave 1KHz.wav
PlayWave 125Hz.wav
# PlayWave end...

exit 0
